/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.handlers;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.completion.api.serialization.SerializableInsertHandler;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.completion.handlers.SmartCompletionTailOffsetProvider;
import org.jetbrains.kotlin.idea.completion.handlers.WithTailInsertHandler$;

@Serializable
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 62\u00020\u0001:\u000267B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nBE\b\u0010\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\t\u0010\u000fJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0018\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\fH\u0002J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0005H\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003J\t\u0010'\u001a\u00020\u0005H\u00c6\u0003J\t\u0010(\u001a\u00020\u0005H\u00c6\u0003J;\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010*\u001a\u00020\u00052\b\u0010+\u001a\u0004\u0018\u00010,H\u00d6\u0083\u0004J\n\u0010-\u001a\u00020\fH\u00d6\u0081\u0004J\n\u0010.\u001a\u00020\u0003H\u00d6\u0081\u0004J%\u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0001\u00a2\u0006\u0002\b5R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0013R\u0011\u0010\u001c\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/WithTailInsertHandler;", "Lorg/jetbrains/kotlin/idea/completion/api/serialization/SerializableInsertHandler;", "tailText", "", "spaceBefore", "", "spaceAfter", "overwriteText", "isPostInsertHandler", "<init>", "(Ljava/lang/String;ZZZZ)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;ZZZZLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getTailText", "()Ljava/lang/String;", "getSpaceBefore", "()Z", "getSpaceAfter", "getOverwriteText", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "asPostInsertHandler", "getAsPostInsertHandler", "()Lorg/jetbrains/kotlin/idea/completion/api/serialization/SerializableInsertHandler;", "postHandleInsert", "shouldOverwriteChar", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "toString", "write$Self", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$kotlin_completion_impl_shared", "Companion", "$serializer", "kotlin.completion.impl.shared"})
@SourceDebugExtension(value={"SMAP\nWithTailInsertHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WithTailInsertHandler.kt\norg/jetbrains/kotlin/idea/completion/handlers/WithTailInsertHandler\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,104:1\n50#2:105\n*S KotlinDebug\n*F\n+ 1 WithTailInsertHandler.kt\norg/jetbrains/kotlin/idea/completion/handlers/WithTailInsertHandler\n*L\n48#1:105\n*E\n"})
public final class WithTailInsertHandler
implements SerializableInsertHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tailText;
    private final boolean spaceBefore;
    private final boolean spaceAfter;
    private final boolean overwriteText;
    private final boolean isPostInsertHandler;
    @NotNull
    private static final WithTailInsertHandler COMMA = new WithTailInsertHandler(",", false, true, false, false, 24, null);
    @NotNull
    private static final WithTailInsertHandler RPARENTH = new WithTailInsertHandler(")", false, false, false, false, 24, null);
    @NotNull
    private static final WithTailInsertHandler RBRACKET = new WithTailInsertHandler("]", false, false, false, false, 24, null);
    @NotNull
    private static final WithTailInsertHandler RBRACE = new WithTailInsertHandler("}", true, false, false, false, 24, null);
    @NotNull
    private static final WithTailInsertHandler ELSE = new WithTailInsertHandler("else", true, true, false, false, 24, null);
    @NotNull
    private static final WithTailInsertHandler EQ = new WithTailInsertHandler("=", true, true, false, false, 24, null);
    @NotNull
    private static final WithTailInsertHandler SPACE = new WithTailInsertHandler(" ", false, false, true, false, 16, null);

    public WithTailInsertHandler(@NotNull String tailText, boolean spaceBefore, boolean spaceAfter, boolean overwriteText, boolean isPostInsertHandler) {
        Intrinsics.checkNotNullParameter((Object)tailText, (String)"tailText");
        this.tailText = tailText;
        this.spaceBefore = spaceBefore;
        this.spaceAfter = spaceAfter;
        this.overwriteText = overwriteText;
        this.isPostInsertHandler = isPostInsertHandler;
    }

    public /* synthetic */ WithTailInsertHandler(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl3 = true;
        }
        if ((n & 0x10) != 0) {
            bl4 = false;
        }
        this(string, bl, bl2, bl3, bl4);
    }

    @NotNull
    public final String getTailText() {
        return this.tailText;
    }

    public final boolean getSpaceBefore() {
        return this.spaceBefore;
    }

    public final boolean getSpaceAfter() {
        return this.spaceAfter;
    }

    public final boolean getOverwriteText() {
        return this.overwriteText;
    }

    public final boolean isPostInsertHandler() {
        return this.isPostInsertHandler;
    }

    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (!this.isPostInsertHandler) {
            item.handleInsert(context2);
        }
        this.postHandleInsert(context2, item);
    }

    @NotNull
    public final SerializableInsertHandler getAsPostInsertHandler() {
        return WithTailInsertHandler.copy$default(this, null, false, false, false, true, 15, null);
    }

    public final void postHandleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        block11: {
            char completionChar;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Character c = StringsKt.singleOrNull((CharSequence)this.tailText);
            if (c != null && (completionChar = context2.getCompletionChar()) == c.charValue() || this.spaceAfter && completionChar == ' ') {
                context2.setAddCompletionChar(false);
            }
            Document document = context2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            PsiDocumentManager.getInstance((Project)context2.getProject()).doPostponedOperationsAndUnblockDocument(document2);
            boolean $i$f$serviceOrNull = false;
            Application application = ApplicationManager.getApplication();
            SmartCompletionTailOffsetProvider smartCompletionTailOffsetProvider = (SmartCompletionTailOffsetProvider)(application != null ? application.getService(SmartCompletionTailOffsetProvider.class) : null);
            int tailOffset = smartCompletionTailOffsetProvider != null ? smartCompletionTailOffsetProvider.getTailOffset(context2, item) : context2.getTailOffset();
            boolean moveCaret = context2.getEditor().getCaretModel().getOffset() == tailOffset;
            boolean insert = true;
            if (this.overwriteText) {
                int offset = tailOffset;
                if (!Intrinsics.areEqual((Object)this.tailText, (Object)" ")) {
                    CharSequence charSequence = document2.getCharsSequence();
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
                    offset = HandlerUtilsKt.skipSpacesAndLineBreaks(charSequence, offset);
                }
                if (this.shouldOverwriteChar(document2, offset)) {
                    insert = false;
                    tailOffset = offset += this.tailText.length();
                    if (this.spaceAfter) {
                        CharSequence charSequence = document2.getCharsSequence();
                        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
                        if (HandlerUtilsKt.isCharAt(charSequence, offset, ' ')) {
                            document2.deleteString(offset, offset + 1);
                        }
                    }
                }
            }
            Object textToInsert = "";
            if (insert) {
                textToInsert = this.tailText;
                if (this.spaceBefore) {
                    textToInsert = " " + (String)textToInsert;
                }
            }
            if (this.spaceAfter) {
                textToInsert = (String)textToInsert + " ";
            }
            document2.insertString(tailOffset, (CharSequence)textToInsert);
            if (!moveCaret) break block11;
            context2.getEditor().getCaretModel().moveToOffset(tailOffset + ((String)textToInsert).length());
            if (Intrinsics.areEqual((Object)this.tailText, (Object)",")) {
                AutoPopupController autoPopupController = AutoPopupController.getInstance((Project)context2.getProject());
                if (autoPopupController != null) {
                    autoPopupController.autoPopupParameterInfo(context2.getEditor(), null);
                }
            }
        }
    }

    private final boolean shouldOverwriteChar(Document document, int offset) {
        if (!HandlerUtilsKt.isTextAt(document, offset, this.tailText)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.tailText, (Object)" ")) {
            CharSequence charSequence = document.getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
            if (HandlerUtilsKt.isCharAt(charSequence, offset + 1, '}')) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public final String component1() {
        return this.tailText;
    }

    public final boolean component2() {
        return this.spaceBefore;
    }

    public final boolean component3() {
        return this.spaceAfter;
    }

    public final boolean component4() {
        return this.overwriteText;
    }

    public final boolean component5() {
        return this.isPostInsertHandler;
    }

    @NotNull
    public final WithTailInsertHandler copy(@NotNull String tailText, boolean spaceBefore, boolean spaceAfter, boolean overwriteText, boolean isPostInsertHandler) {
        Intrinsics.checkNotNullParameter((Object)tailText, (String)"tailText");
        return new WithTailInsertHandler(tailText, spaceBefore, spaceAfter, overwriteText, isPostInsertHandler);
    }

    public static /* synthetic */ WithTailInsertHandler copy$default(WithTailInsertHandler withTailInsertHandler, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
        if ((n & 1) != 0) {
            string = withTailInsertHandler.tailText;
        }
        if ((n & 2) != 0) {
            bl = withTailInsertHandler.spaceBefore;
        }
        if ((n & 4) != 0) {
            bl2 = withTailInsertHandler.spaceAfter;
        }
        if ((n & 8) != 0) {
            bl3 = withTailInsertHandler.overwriteText;
        }
        if ((n & 0x10) != 0) {
            bl4 = withTailInsertHandler.isPostInsertHandler;
        }
        return withTailInsertHandler.copy(string, bl, bl2, bl3, bl4);
    }

    @NotNull
    public String toString() {
        return "WithTailInsertHandler(tailText=" + this.tailText + ", spaceBefore=" + this.spaceBefore + ", spaceAfter=" + this.spaceAfter + ", overwriteText=" + this.overwriteText + ", isPostInsertHandler=" + this.isPostInsertHandler + ")";
    }

    public int hashCode() {
        int result2 = this.tailText.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.spaceBefore);
        result2 = result2 * 31 + Boolean.hashCode(this.spaceAfter);
        result2 = result2 * 31 + Boolean.hashCode(this.overwriteText);
        result2 = result2 * 31 + Boolean.hashCode(this.isPostInsertHandler);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WithTailInsertHandler)) {
            return false;
        }
        WithTailInsertHandler withTailInsertHandler = (WithTailInsertHandler)other;
        if (!Intrinsics.areEqual((Object)this.tailText, (Object)withTailInsertHandler.tailText)) {
            return false;
        }
        if (this.spaceBefore != withTailInsertHandler.spaceBefore) {
            return false;
        }
        if (this.spaceAfter != withTailInsertHandler.spaceAfter) {
            return false;
        }
        if (this.overwriteText != withTailInsertHandler.overwriteText) {
            return false;
        }
        return this.isPostInsertHandler == withTailInsertHandler.isPostInsertHandler;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$kotlin_completion_impl_shared(WithTailInsertHandler self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeStringElement(serialDesc, 0, self.tailText);
        output.encodeBooleanElement(serialDesc, 1, self.spaceBefore);
        output.encodeBooleanElement(serialDesc, 2, self.spaceAfter);
        if (output.shouldEncodeElementDefault(serialDesc, 3) ? true : !self.overwriteText) {
            output.encodeBooleanElement(serialDesc, 3, self.overwriteText);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : self.isPostInsertHandler) {
            output.encodeBooleanElement(serialDesc, 4, self.isPostInsertHandler);
        }
    }

    public /* synthetic */ WithTailInsertHandler(int seen0, String tailText, boolean spaceBefore, boolean spaceAfter, boolean overwriteText, boolean isPostInsertHandler, SerializationConstructorMarker serializationConstructorMarker) {
        if (7 != (7 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.tailText = tailText;
        this.spaceBefore = spaceBefore;
        this.spaceAfter = spaceAfter;
        this.overwriteText = (seen0 & 8) == 0 ? true : overwriteText;
        this.isPostInsertHandler = (seen0 & 0x10) == 0 ? false : isPostInsertHandler;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/completion/handlers/WithTailInsertHandler$Companion;", "", "<init>", "()V", "COMMA", "Lorg/jetbrains/kotlin/idea/completion/handlers/WithTailInsertHandler;", "getCOMMA", "()Lorg/jetbrains/kotlin/idea/completion/handlers/WithTailInsertHandler;", "RPARENTH", "getRPARENTH", "RBRACKET", "getRBRACKET", "RBRACE", "getRBRACE", "ELSE", "getELSE", "EQ", "getEQ", "SPACE", "getSPACE", "serializer", "Lkotlinx/serialization/KSerializer;", "kotlin.completion.impl.shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WithTailInsertHandler getCOMMA() {
            return COMMA;
        }

        @NotNull
        public final WithTailInsertHandler getRPARENTH() {
            return RPARENTH;
        }

        @NotNull
        public final WithTailInsertHandler getRBRACKET() {
            return RBRACKET;
        }

        @NotNull
        public final WithTailInsertHandler getRBRACE() {
            return RBRACE;
        }

        @NotNull
        public final WithTailInsertHandler getELSE() {
            return ELSE;
        }

        @NotNull
        public final WithTailInsertHandler getEQ() {
            return EQ;
        }

        @NotNull
        public final WithTailInsertHandler getSPACE() {
            return SPACE;
        }

        @NotNull
        public final KSerializer<WithTailInsertHandler> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

