/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.impl.k2;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.PriorityQueue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.completion.impl.k2.SharedPriorityQueue;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u00042\u00020\u0002:\u0001\u0012B/\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u0010\u001a\u00120\u0011R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00028\u00000\fj\b\u0012\u0004\u0012\u00028\u0000`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/completion/impl/k2/SharedPriorityQueue;", "P", "", "C", "", "initialElements", "", "comparatorSelector", "Lkotlin/Function1;", "<init>", "(Ljava/util/Collection;Lkotlin/jvm/functions/Function1;)V", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "globalQueue", "Ljava/util/ArrayDeque;", "createLocalInstance", "Lorg/jetbrains/kotlin/idea/completion/impl/k2/SharedPriorityQueue$LocalInstance;", "LocalInstance", "intellij.kotlin.completion.impl"})
final class SharedPriorityQueue<P, C extends Comparable<? super C>> {
    @NotNull
    private final Comparator<P> comparator;
    @NotNull
    private final ArrayDeque<P> globalQueue;

    public SharedPriorityQueue(@NotNull Collection<? extends P> initialElements, @NotNull Function1<? super P, ? extends Comparable<? super C>> comparatorSelector) {
        Intrinsics.checkNotNullParameter(initialElements, (String)"initialElements");
        Intrinsics.checkNotNullParameter(comparatorSelector, (String)"comparatorSelector");
        this.comparator = new Comparator(comparatorSelector){
            final /* synthetic */ Function1 $selector;
            {
                this.$selector = $selector;
            }

            public final int compare(T a, T b) {
                Function1 function1 = this.$selector;
                return ComparisonsKt.compareValues((Comparable)((Comparable)function1.invoke(a)), (Comparable)((Comparable)function1.invoke(b)));
            }
        };
        this.globalQueue = new ArrayDeque(CollectionsKt.sortedWith((Iterable)initialElements, this.comparator));
    }

    @NotNull
    public final LocalInstance createLocalInstance() {
        return new LocalInstance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\n\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0006\u001a\u001c\u0012\u0018\u0012\u00160\bR\u00120\u0000R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/completion/impl/k2/SharedPriorityQueue$LocalInstance;", "", "<init>", "(Lorg/jetbrains/kotlin/idea/completion/impl/k2/SharedPriorityQueue;)V", "insertionCounter", "", "localQueue", "Ljava/util/PriorityQueue;", "Lorg/jetbrains/kotlin/idea/completion/impl/k2/SharedPriorityQueue$LocalInstance$LocalQueueEntry;", "Lorg/jetbrains/kotlin/idea/completion/impl/k2/SharedPriorityQueue;", "popFirst", "()Ljava/lang/Object;", "addLocal", "", "element", "(Ljava/lang/Object;)V", "LocalQueueEntry", "intellij.kotlin.completion.impl"})
    public final class LocalInstance {
        private int insertionCounter;
        @NotNull
        private final PriorityQueue<org.jetbrains.kotlin.idea.completion.impl.k2.SharedPriorityQueue$LocalInstance.LocalQueueEntry> localQueue = new PriorityQueue();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final P popFirst() {
            ArrayDeque arrayDeque = SharedPriorityQueue.this.globalQueue;
            SharedPriorityQueue sharedPriorityQueue = SharedPriorityQueue.this;
            ArrayDeque arrayDeque2 = arrayDeque;
            synchronized (arrayDeque2) {
                Object localFirst;
                block6: {
                    Object globalFirst;
                    block5: {
                        boolean bl = false;
                        LocalQueueEntry localQueueEntry = (LocalQueueEntry)this.localQueue.peek();
                        localFirst = localQueueEntry != null ? localQueueEntry.getElement() : null;
                        globalFirst = sharedPriorityQueue.globalQueue.peek();
                        if (localFirst != null || globalFirst != null) break block5;
                        Object p = null;
                        return p;
                    }
                    if (globalFirst == null || localFirst != null && sharedPriorityQueue.comparator.compare(globalFirst, localFirst) >= 0) break block6;
                    sharedPriorityQueue.globalQueue.pop();
                    Object e = globalFirst;
                    return e;
                }
                this.localQueue.remove();
                Object p = localFirst;
                return p;
            }
        }

        public final void addLocal(@NotNull P element) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            int n = this.insertionCounter;
            this.insertionCounter = n + 1;
            this.localQueue.add((org.jetbrains.kotlin.idea.completion.impl.k2.SharedPriorityQueue$LocalInstance.LocalQueueEntry)new LocalQueueEntry(element, n));
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\b\u0082\u0004\u0018\u00002\u001c\u0012\u0018\u0012\u00160\u0000R\u00120\u0002R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ&\u0010\u000e\u001a\u00020\u00062\u001a\u0010\u000f\u001a\u00160\u0000R\u00120\u0002R\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003H\u0096\u0082\u0004R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/completion/impl/k2/SharedPriorityQueue$LocalInstance$LocalQueueEntry;", "", "Lorg/jetbrains/kotlin/idea/completion/impl/k2/SharedPriorityQueue$LocalInstance;", "Lorg/jetbrains/kotlin/idea/completion/impl/k2/SharedPriorityQueue;", "element", "insertionOrder", "", "<init>", "(Lorg/jetbrains/kotlin/idea/completion/impl/k2/SharedPriorityQueue$LocalInstance;Ljava/lang/Object;I)V", "getElement", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getInsertionOrder", "()I", "compareTo", "other", "intellij.kotlin.completion.impl"})
        private final class LocalQueueEntry
        implements Comparable<org.jetbrains.kotlin.idea.completion.impl.k2.SharedPriorityQueue$LocalInstance.LocalQueueEntry> {
            @NotNull
            private final P element;
            private final int insertionOrder;

            public LocalQueueEntry(P element, int insertionOrder) {
                Intrinsics.checkNotNullParameter(element, (String)"element");
                this.element = element;
                this.insertionOrder = insertionOrder;
            }

            @NotNull
            public final P getElement() {
                return this.element;
            }

            public final int getInsertionOrder() {
                return this.insertionOrder;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            @Override
            public int compareTo(@NotNull LocalQueueEntry other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                int compareValue = SharedPriorityQueue.this.comparator.compare(this.element, other.element);
                if (compareValue != 0) {
                    return compareValue;
                }
                return this.insertionOrder - other.insertionOrder;
            }
        }
    }
}

