/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.impl.k2.contributors.commands;

import com.intellij.codeInsight.completion.command.CommandCompletionFactory;
import com.intellij.codeInsight.completion.command.commands.IntentionCommandOffsetProvider;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.LightVirtualFile;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.projectStructure.ContextModuleKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.DanglingFilesKt;
import org.jetbrains.kotlin.idea.base.codeInsight.handlers.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.base.projectStructure.ApiKt;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000e\u001a\u00020\u0006H\u0016J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\fH\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/completion/impl/k2/contributors/commands/KotlinCommandCompletionFactory;", "Lcom/intellij/codeInsight/completion/command/CommandCompletionFactory;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "isApplicable", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "offset", "", "isInsideStringLiteral", "Lorg/jetbrains/kotlin/psi/KtFile;", "isInsideFor", "supportFiltersWithDoublePrefix", "createFile", "originalFile", "text", "", "createCopyOfScript", "newFile", "KotlinIntentionCommandOffsetProvider", "intellij.kotlin.completion.impl"})
@SourceDebugExtension(value={"SMAP\nKotlinCommandCompletionFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCommandCompletionFactory.kt\norg/jetbrains/kotlin/idea/completion/impl/k2/contributors/commands/KotlinCommandCompletionFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n*L\n1#1,108:1\n1#2:109\n21#3:110\n*S KotlinDebug\n*F\n+ 1 KotlinCommandCompletionFactory.kt\norg/jetbrains/kotlin/idea/completion/impl/k2/contributors/commands/KotlinCommandCompletionFactory\n*L\n80#1:110\n*E\n"})
public final class KotlinCommandCompletionFactory
implements CommandCompletionFactory,
DumbAware {
    public boolean isApplicable(@NotNull PsiFile psiFile, int offset) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        if (InjectedLanguageManager.getInstance((Project)psiFile.getProject()).isInjectedFragment(psiFile)) {
            return false;
        }
        if (offset < 1) {
            return false;
        }
        if (!(psiFile instanceof KtFile)) {
            return false;
        }
        if (this.isInsideFor((KtFile)psiFile, offset)) {
            return false;
        }
        return !this.isInsideStringLiteral((KtFile)psiFile, offset);
    }

    private final boolean isInsideStringLiteral(KtFile psiFile, int offset) {
        PsiElement element = psiFile.findElementAt(offset);
        if (element == null) {
            return false;
        }
        Class[] classArray = new Class[]{KtStringTemplateExpression.class, KtStringTemplateEntryWithExpression.class};
        KtElementImplStub templateExpression2 = (KtElementImplStub)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])classArray);
        return templateExpression2 instanceof KtStringTemplateExpression;
    }

    private final boolean isInsideFor(KtFile psiFile, int offset) {
        block4: {
            PsiElement psiElement;
            PsiElement parent;
            PsiElement element;
            block6: {
                block5: {
                    PsiElement psiElement2 = element = psiFile.findElementAt(offset - 1);
                    Object object = parent = psiElement2 != null ? psiElement2.getParent() : null;
                    if (!(parent instanceof KtForExpression) && !(parent instanceof KtNamedFunction)) {
                        return false;
                    }
                    if (!(parent instanceof KtForExpression)) break block4;
                    psiElement = element.getPrevSibling();
                    if (psiElement == null) break block5;
                    PsiElement it = psiElement;
                    boolean bl = false;
                    PsiElement psiElement3 = it instanceof KtContainerNode ? ((KtContainerNode)it).getFirstChild() : it;
                    psiElement = psiElement3;
                    if (psiElement3 != null) break block6;
                }
                return false;
            }
            element = psiElement;
            return PsiUtilsKt.isAncestor$default((PsiElement)((PsiElement)((KtForExpression)parent).getLoopRange()), (PsiElement)element, (boolean)false, (int)2, null);
        }
        return false;
    }

    public boolean supportFiltersWithDoublePrefix() {
        return false;
    }

    @NotNull
    public PsiFile createFile(@NotNull PsiFile originalFile, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Project project = originalFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project2, false, true);
        String string = originalFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        KtFile newFile = ktPsiFactory.createFile(string, text);
        PsiElement psiElement = (PsiElement)originalFile;
        Project project3 = originalFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        DanglingFilesKt.setContextModule(newFile, ApiKt.getKaModule(psiElement, project3, null));
        String string2 = originalFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)string2, (String)".kts", (boolean)false, (int)2, null) && (project2 = this.createCopyOfScript(originalFile, newFile)) != null) {
            Project it = project2;
            boolean bl = false;
            return (PsiFile)it;
        }
        VirtualFile virtualFile = newFile.getVirtualFile();
        VirtualFile originalVirtualFile = originalFile.getVirtualFile();
        if (virtualFile instanceof LightVirtualFile && originalVirtualFile != null) {
            PsiElement psiElement2 = (PsiElement)originalFile;
            Project project4 = originalFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
            ContextModuleKt.setAnalysisContextModule(virtualFile, ApiKt.getKaModule(psiElement2, project4, null));
            ((LightVirtualFile)virtualFile).setOriginalFile(originalVirtualFile);
            ((LightVirtualFile)virtualFile).setFileType(originalVirtualFile.getFileType());
        }
        return (PsiFile)newFile;
    }

    private final KtFile createCopyOfScript(PsiFile originalFile, KtFile newFile) {
        PsiElement $this$copied$iv = (PsiElement)originalFile;
        boolean $i$f$copied = false;
        PsiElement psiElement = $this$copied$iv.copy();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiFile");
        }
        PsiElement psiElement2 = (PsiElement)((PsiFile)psiElement);
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        KtFile newFileCopy = (KtFile)psiElement2;
        KtScript ktScript = newFileCopy.getScript();
        if (ktScript == null || (ktScript = ktScript.getBlockExpression()) == null) {
            return null;
        }
        KtScript copyOfOriginalBlockExpression = ktScript;
        KtScript ktScript2 = newFile.getScript();
        if (ktScript2 == null || (ktScript2 = ktScript2.getBlockExpression()) == null) {
            return null;
        }
        KtScript copiedNewBlockExpression = ktScript2;
        copyOfOriginalBlockExpression.replace(copiedNewBlockExpression.copy());
        return newFileCopy;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/completion/impl/k2/contributors/commands/KotlinCommandCompletionFactory$KotlinIntentionCommandOffsetProvider;", "Lcom/intellij/codeInsight/completion/command/commands/IntentionCommandOffsetProvider;", "<init>", "()V", "findOffsets", "", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "offset", "intellij.kotlin.completion.impl"})
    public static final class KotlinIntentionCommandOffsetProvider
    implements IntentionCommandOffsetProvider {
        @NotNull
        public List<Integer> findOffsets(@NotNull PsiFile psiFile, int offset) {
            PsiElement previousElement;
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            List offsets = new ArrayList();
            offsets.add(offset);
            if (offset == 0) {
                return offsets;
            }
            PsiElement psiElement = previousElement = psiFile.findElementAt(offset - 1);
            if ((psiElement != null ? psiElement.getParent() : null) instanceof PsiLanguageInjectionHost) {
                String string = previousElement.getParent().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                int delta = StringsKt.endsWith$default((String)string, (String)"\"\"\"", (boolean)false, (int)2, null) ? 3 : 1;
                PsiElement psiElement2 = previousElement.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getParent(...)");
                offsets.add(FixersUtilKt.getRange((PsiElement)psiElement2).getEndOffset() - delta);
            }
            return offsets;
        }
    }
}

