/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.impl.k2.contributors.commands;

import com.intellij.codeInsight.completion.command.CommandCompletionProviderContext;
import com.intellij.codeInsight.completion.command.CommandProvider;
import com.intellij.codeInsight.completion.command.CompletionCommand;
import com.intellij.codeInsight.completion.command.CompletionCommandKt;
import com.intellij.codeInsight.completion.command.HighlightInfoLookup;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.completion.impl.k2.contributors.commands.KotlinDeleteCompletionCommand;
import org.jetbrains.kotlin.idea.completion.impl.k2.contributors.commands.KotlinDeleteCompletionCommandKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/completion/impl/k2/contributors/commands/KotlinDeleteCompletionCommandProvider;", "Lcom/intellij/codeInsight/completion/command/CommandProvider;", "<init>", "()V", "getCommands", "", "Lcom/intellij/codeInsight/completion/command/CompletionCommand;", "context", "Lcom/intellij/codeInsight/completion/command/CommandCompletionProviderContext;", "createCommand", "highlightInfo", "Lcom/intellij/codeInsight/completion/command/HighlightInfoLookup;", "psiElement", "Lcom/intellij/psi/PsiElement;", "intellij.kotlin.completion.impl"})
public final class KotlinDeleteCompletionCommandProvider
implements CommandProvider {
    @NotNull
    public List<CompletionCommand> getCommands(@NotNull CommandCompletionProviderContext context2) {
        boolean hasTheSameOffset;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        PsiElement psiElement = CompletionCommandKt.getCommandContext((int)context2.getOffset(), (PsiFile)context2.getPsiFile());
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement element = psiElement;
        Class[] classArray = new Class[]{KtExpression.class, KtNamedDeclaration.class};
        KtExpression ktExpression = (KtExpression)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])classArray);
        if (ktExpression == null) {
            return CollectionsKt.emptyList();
        }
        KtExpression psiElement2 = ktExpression;
        boolean bl = hasTheSameOffset = psiElement2.getTextRange().getEndOffset() == context2.getOffset();
        if (!hasTheSameOffset) {
            return CollectionsKt.emptyList();
        }
        psiElement2 = KotlinDeleteCompletionCommandKt.access$getTopWithTheSameOffset(psiElement2, context2.getOffset());
        TextRange textRange = psiElement2.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        TextAttributesKey textAttributesKey = EditorColors.SEARCH_RESULT_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"SEARCH_RESULT_ATTRIBUTES");
        HighlightInfoLookup highlightInfo = new HighlightInfoLookup(textRange, textAttributesKey, 0);
        CompletionCommand completionCommand = this.createCommand(highlightInfo, (PsiElement)psiElement2);
        if (completionCommand == null) {
            return CollectionsKt.emptyList();
        }
        CompletionCommand command2 = completionCommand;
        return CollectionsKt.listOf((Object)command2);
    }

    private final CompletionCommand createCommand(HighlightInfoLookup highlightInfo, PsiElement psiElement) {
        PsiElement psiElement2 = psiElement.getContainingFile().copy();
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type com.intellij.psi.PsiFile");
        PsiFile copy = (PsiFile)psiElement2;
        String previewBefore = copy.getText();
        PsiElement elementToDelete = PsiTreeUtil.findSameElementInCopy((PsiElement)psiElement, (PsiFile)copy);
        if (elementToDelete instanceof KtClassOrObject) {
            PsiFile psiFile = ((KtClassOrObject)elementToDelete).getContainingFile();
            KtFile ktFile2 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
            if (ktFile2 == null) {
                return null;
            }
            KtFile file = ktFile2;
            if (((KtClassOrObject)elementToDelete).isTopLevel() && file.getDeclarations().size() <= 1) {
                return null;
            }
        }
        elementToDelete.delete();
        String previewAfter = copy.getText();
        IntentionPreviewInfo preview = (IntentionPreviewInfo)new IntentionPreviewInfo.CustomDiff((FileType)KotlinFileType.INSTANCE, null, previewBefore, previewAfter, true);
        return new KotlinDeleteCompletionCommand(highlightInfo, preview);
    }
}

