/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion.lookups.factories;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.lang.annotation.Annotation;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.internal.ObjectSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.analysis.RootPrefixUtils;
import org.jetbrains.kotlin.idea.base.analysis.api.utils.ShortenUtilsKt;
import org.jetbrains.kotlin.idea.completion.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.idea.completion.lookups.ImportStrategy;
import org.jetbrains.kotlin.idea.completion.lookups.ImportStrategyKt;
import org.jetbrains.kotlin.idea.completion.lookups.QuotedNamesAwareInsertionHandler;
import org.jetbrains.kotlin.idea.completion.lookups.UtilsKt;
import org.jetbrains.kotlin.idea.completion.lookups.factories.FunctionCallLookupObject;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.renderer.RenderingUtilsKt;

@Serializable
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00000\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/completion/lookups/factories/FunctionInsertionHandler;", "Lorg/jetbrains/kotlin/idea/completion/lookups/QuotedNamesAwareInsertionHandler;", "<init>", "()V", "addArguments", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "offsetElement", "Lcom/intellij/psi/PsiElement;", "lookupObject", "Lorg/jetbrains/kotlin/idea/completion/lookups/factories/FunctionCallLookupObject;", "shouldPlaceCaretInBrackets", "", "completionChar", "", "handleInsert", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "serializer", "Lkotlinx/serialization/KSerializer;", "intellij.kotlin.completion.impl"})
@SourceDebugExtension(value={"SMAP\nFunctionLookupElementFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionLookupElementFactory.kt\norg/jetbrains/kotlin/idea/completion/lookups/factories/FunctionInsertionHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,502:1\n1#2:503\n*E\n"})
public final class FunctionInsertionHandler
extends QuotedNamesAwareInsertionHandler {
    @NotNull
    public static final FunctionInsertionHandler INSTANCE = new FunctionInsertionHandler();
    private static final /* synthetic */ Lazy<KSerializer<Object>> $cachedSerializer$delegate;

    private FunctionInsertionHandler() {
    }

    private final void addArguments(InsertionContext context2, PsiElement offsetElement, FunctionCallLookupObject lookupObject) {
        Integer n;
        char completionChar = context2.getCompletionChar();
        if (completionChar == '(') {
            context2.setAddCompletionChar(false);
        }
        int offset = context2.getTailOffset();
        Document document = context2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        Editor editor = context2.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        Project project = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        CharSequence charSequence = document2.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence chars = charSequence;
        boolean isSmartEnterCompletion = completionChar == '\r';
        boolean isReplaceCompletion = completionChar == '\t';
        boolean isNormalCompletion = completionChar == '\n';
        boolean insertTypeArguments = lookupObject.getInputTypeArgumentsAreRequired() && (isNormalCompletion || isReplaceCompletion || isSmartEnterCompletion);
        boolean preferParentheses = completionChar == '(' || isReplaceCompletion && HandlerUtilsKt.isCharAt(chars, offset, '(');
        boolean insertLambda = !preferParentheses && lookupObject.getInputTrailingLambdaIsRequired();
        Pair pair = insertLambda ? TuplesKt.to((Object)Character.valueOf('{'), (Object)Character.valueOf('}')) : TuplesKt.to((Object)Character.valueOf('('), (Object)Character.valueOf(')'));
        char openingBracket = ((Character)pair.component1()).charValue();
        char closingBracket = ((Character)pair.component2()).charValue();
        int offset1 = UtilsKt.skipSpaces(chars, offset);
        boolean skipParentheses = false;
        if (offset1 < chars.length() && chars.charAt(offset1) == '<') {
            PsiElement parent;
            PsiElement psiElement = context2.getFile().findElementAt(offset1);
            Intrinsics.checkNotNull((Object)psiElement);
            PsiElement token = psiElement;
            if (Intrinsics.areEqual((Object)token.getNode().getElementType(), (Object)KtTokens.LT) && (parent = token.getParent()) instanceof KtTypeArgumentList) {
                String string = ((KtTypeArgumentList)parent).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (StringsKt.indexOf$default((CharSequence)string, (char)'\n', (int)0, (boolean)false, (int)6, null) < 0) {
                    if (isReplaceCompletion) {
                        offset = PsiTreeUtilKt.getEndOffset((PsiElement)parent);
                    } else {
                        offset = offset1;
                        skipParentheses = true;
                    }
                    insertTypeArguments = false;
                }
            }
        }
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        CaretModel caretModel2 = caretModel;
        if (insertTypeArguments) {
            document2.insertString(offset, (CharSequence)"<>");
            caretModel2.moveToOffset(offset + 1);
            offset += 2;
        }
        Integer openingBracketOffset = null;
        Integer n2 = openingBracketOffset = UtilsKt.indexOfSkippingSpace(chars, openingBracket, offset);
        if (n2 != null) {
            int it = ((Number)n2).intValue();
            boolean bl = false;
            n = UtilsKt.indexOfSkippingSpace(chars, closingBracket, it + 1);
        } else {
            n = null;
        }
        Integer closeBracketOffset = n;
        boolean inBracketsShift = false;
        if (openingBracketOffset == null) {
            String string;
            if (insertLambda) {
                switch (completionChar) {
                    case ' ': 
                    case '{': {
                        context2.setAddCompletionChar(false);
                    }
                }
                inBracketsShift = true;
                string = " {  }";
            } else {
                string = !skipParentheses ? (isSmartEnterCompletion ? "(" : "()") : "";
            }
            String text = string;
            document2.insertString(offset, (CharSequence)text);
            context2.commitDocument();
            CharSequence charSequence2 = document2.getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getCharsSequence(...)");
            Integer n3 = openingBracketOffset = UtilsKt.indexOfSkippingSpace(charSequence2, openingBracket, offset);
            if (n3 != null) {
                int it = ((Number)n3).intValue();
                boolean bl = false;
                CharSequence charSequence3 = document2.getCharsSequence();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence3, (String)"getCharsSequence(...)");
                v13 = UtilsKt.indexOfSkippingSpace(charSequence3, closingBracket, ((Number)openingBracketOffset).intValue() + 1);
            } else {
                v13 = closeBracketOffset = null;
            }
        }
        if (!insertTypeArguments) {
            if (this.shouldPlaceCaretInBrackets(completionChar, lookupObject) || closeBracketOffset == null) {
                int additionalOffset;
                int n4 = additionalOffset = insertLambda ? 2 : 1;
                if (openingBracketOffset != null) {
                    caretModel2.moveToOffset(((Number)openingBracketOffset).intValue() + additionalOffset);
                }
                context2.setLaterRunnable(insertLambda ? () -> FunctionInsertionHandler.addArguments$lambda$2(project2, editor2) : () -> FunctionInsertionHandler.addArguments$lambda$3(project2, editor2, offsetElement));
            } else {
                caretModel2.moveToOffset(closeBracketOffset + 1);
            }
        }
    }

    private final boolean shouldPlaceCaretInBrackets(char completionChar, FunctionCallLookupObject lookupObject) {
        switch (completionChar) {
            case ',': 
            case '.': 
            case '=': {
                return false;
            }
        }
        if (completionChar == '(') {
            return true;
        }
        return lookupObject.getInputValueArgumentsAreRequired() || lookupObject.getInputTrailingLambdaIsRequired();
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        PsiFile psiFile = context2.getFile();
        KtFile ktFile2 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile2 == null) {
            return;
        }
        KtFile targetFile = ktFile2;
        Object object = item.getObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.completion.lookups.factories.FunctionCallLookupObject");
        FunctionCallLookupObject lookupObject = (FunctionCallLookupObject)object;
        super.handleInsert(context2, item);
        int startOffset = context2.getStartOffset();
        PsiElement psiElement = context2.getFile().findElementAt(startOffset);
        if (psiElement == null) {
            return;
        }
        PsiElement element = psiElement;
        ImportStrategy importStrategy = lookupObject.getOptions().getImportingStrategy();
        if (importStrategy instanceof ImportStrategy.InsertFqNameAndShorten) {
            context2.getDocument().replaceString(context2.getStartOffset(), context2.getTailOffset(), (CharSequence)RenderingUtilsKt.render((FqName)RootPrefixUtils.withRootPrefixIfNeeded$default(((ImportStrategy.InsertFqNameAndShorten)importStrategy).getFqName(), null, 1, null)));
            context2.commitDocument();
            this.addArguments(context2, element, lookupObject);
            context2.commitDocument();
            ShortenUtilsKt.shortenReferencesInRange$default(targetFile, new TextRange(context2.getStartOffset(), context2.getTailOffset()), null, null, null, 28, null);
        } else {
            this.addArguments(context2, element, lookupObject);
            context2.commitDocument();
            if (importStrategy instanceof ImportStrategy.AddImport) {
                ImportStrategyKt.addImportIfRequired(context2, ((ImportStrategy.AddImport)importStrategy).getNameToImport());
            }
        }
    }

    @NotNull
    public final KSerializer<FunctionInsertionHandler> serializer() {
        return this.get$cachedSerializer();
    }

    private final /* synthetic */ KSerializer get$cachedSerializer() {
        return (KSerializer)$cachedSerializer$delegate.getValue();
    }

    private static final void addArguments$lambda$2(Project $project, Editor $editor) {
        AutoPopupController.getInstance((Project)$project).scheduleAutoPopup($editor);
    }

    private static final void addArguments$lambda$3(Project $project, Editor $editor, PsiElement $offsetElement) {
        AutoPopupController.getInstance((Project)$project).autoPopupParameterInfo($editor, $offsetElement);
    }

    static {
        $cachedSerializer$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ObjectSerializer("org.jetbrains.kotlin.idea.completion.lookups.factories.FunctionInsertionHandler", (Object)INSTANCE, new Annotation[0]));
    }
}

