/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.DummyLibraryProperties;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJavaScriptLibraryKind;
import org.jetbrains.kotlin.idea.base.platforms.KotlinJavaScriptStdlibDetectorFacility;
import org.jetbrains.kotlin.idea.base.platforms.StdlibDetectorFacility;
import org.jetbrains.kotlin.idea.base.platforms.library.JSLibraryType;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinWithLibraryConfigurator;
import org.jetbrains.kotlin.idea.configuration.NotificationMessageCollector;
import org.jetbrains.kotlin.idea.projectConfiguration.JSLibraryStdDescription;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationBundle;
import org.jetbrains.kotlin.idea.projectConfiguration.LibraryJarDescriptor;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.js.JsPlatforms;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 ,2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001,B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010*\u001a\u00020+H\u0014R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0014\u0010\u0013\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\bR\u0014\u0010\u0015\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\bR\u0014\u0010\u0017\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\bR\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinWithLibraryConfigurator;", "Lcom/intellij/openapi/roots/libraries/DummyLibraryProperties;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "targetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "presentableText", "getPresentableText", "isConfigured", "", "module", "Lcom/intellij/openapi/module/Module;", "libraryName", "getLibraryName", "dialogTitle", "getDialogTitle", "messageForOverrideDialog", "getMessageForOverrideDialog", "libraryJarDescriptor", "Lorg/jetbrains/kotlin/idea/projectConfiguration/LibraryJarDescriptor;", "getLibraryJarDescriptor", "()Lorg/jetbrains/kotlin/idea/projectConfiguration/LibraryJarDescriptor;", "libraryType", "Lcom/intellij/openapi/roots/libraries/LibraryType;", "getLibraryType", "()Lcom/intellij/openapi/roots/libraries/LibraryType;", "libraryProperties", "getLibraryProperties", "()Lcom/intellij/openapi/roots/libraries/DummyLibraryProperties;", "stdlibDetector", "Lorg/jetbrains/kotlin/idea/base/platforms/StdlibDetectorFacility;", "getStdlibDetector", "()Lorg/jetbrains/kotlin/idea/base/platforms/StdlibDetectorFacility;", "findAndFixBrokenKotlinLibrary", "Lcom/intellij/openapi/roots/libraries/Library;", "collector", "Lorg/jetbrains/kotlin/idea/configuration/NotificationMessageCollector;", "Companion", "intellij.kotlin.projectConfiguration"})
@SourceDebugExtension(value={"SMAP\nKotlinJsModuleConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinJsModuleConfigurator.kt\norg/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n777#2:87\n873#2,2:88\n*S KotlinDebug\n*F\n+ 1 KotlinJsModuleConfigurator.kt\norg/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator\n*L\n74#1:87\n74#1:88,2\n*E\n"})
public class KotlinJsModuleConfigurator
extends KotlinWithLibraryConfigurator<DummyLibraryProperties> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "js";

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public TargetPlatform getTargetPlatform() {
        return JsPlatforms.INSTANCE.getDefaultJsPlatform();
    }

    @Override
    @NotNull
    public String getPresentableText() {
        return KotlinProjectConfigurationBundle.message("language.name.javascript", new Object[0]);
    }

    @Override
    public boolean isConfigured(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return ConfigureKotlinInProjectUtilsKt.hasKotlinJsLegacyRuntimeInScope(module);
    }

    @Override
    @NotNull
    protected String getLibraryName() {
        return "KotlinJavaScript";
    }

    @Override
    @NotNull
    protected String getDialogTitle() {
        return JSLibraryStdDescription.Companion.getDIALOG_TITLE();
    }

    @Override
    @NotNull
    protected String getMessageForOverrideDialog() {
        return JSLibraryStdDescription.Companion.getJAVA_SCRIPT_LIBRARY_CREATION();
    }

    @Override
    @NotNull
    public LibraryJarDescriptor getLibraryJarDescriptor() {
        return LibraryJarDescriptor.JS_STDLIB_JAR;
    }

    @Override
    @NotNull
    public LibraryType<DummyLibraryProperties> getLibraryType() {
        return JSLibraryType.Companion.getInstance();
    }

    @Override
    @NotNull
    public DummyLibraryProperties getLibraryProperties() {
        DummyLibraryProperties dummyLibraryProperties = DummyLibraryProperties.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)dummyLibraryProperties, (String)"INSTANCE");
        return dummyLibraryProperties;
    }

    @Override
    @NotNull
    public StdlibDetectorFacility getStdlibDetector() {
        return KotlinJavaScriptStdlibDetectorFacility.INSTANCE;
    }

    @Override
    @Nullable
    protected Library findAndFixBrokenKotlinLibrary(@NotNull Module module, @NotNull NotificationMessageCollector collector2) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        List allLibraries = new ArrayList();
        Library brokenStdlib = null;
        OrderEntry[] orderEntryArray = ModuleRootManager.getInstance((Module)module).getOrderEntries();
        Intrinsics.checkNotNullExpressionValue((Object)orderEntryArray, (String)"getOrderEntries(...)");
        for (OrderEntry orderEntry : orderEntryArray) {
            LibraryEx library;
            LibraryOrderEntry libraryOrderEntry = orderEntry instanceof LibraryOrderEntry ? (LibraryOrderEntry)orderEntry : null;
            Object object = libraryOrderEntry != null ? libraryOrderEntry.getLibrary() : null;
            if ((object instanceof LibraryEx ? (LibraryEx)object : null) == null) continue;
            library = library;
            allLibraries.add(library);
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (!KotlinJavaScriptStdlibDetectorFacility.INSTANCE.isStdlib(project, (Library)library, true) || library.getKind() != null) continue;
            brokenStdlib = (Library)library;
        }
        if (brokenStdlib != null) {
            ActionsKt.runWriteAction(() -> KotlinJsModuleConfigurator.findAndFixBrokenKotlinLibrary$lambda$0(allLibraries));
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)module.getName(), (String)"getName(...)");
            collector2.addMessage(KotlinProjectConfigurationBundle.message("updated.javascript.libraries.in.module.0", objectArray));
        }
        return brokenStdlib;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit findAndFixBrokenKotlinLibrary$lambda$0(List $allLibraries) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $allLibraries;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LibraryEx it = (LibraryEx)element$iv$iv;
            boolean bl = false;
            if (!(it.getKind() == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (LibraryEx library : (List)destination$iv$iv) {
            LibraryEx.ModifiableModelEx modifiableModelEx;
            LibraryEx.ModifiableModelEx $this$findAndFixBrokenKotlinLibrary_u24lambda_u240_u241 = modifiableModelEx = library.getModifiableModel();
            boolean bl = false;
            $this$findAndFixBrokenKotlinLibrary_u24lambda_u240_u241.setKind((PersistentLibraryKind)KotlinJavaScriptLibraryKind.INSTANCE);
            $this$findAndFixBrokenKotlinLibrary_u24lambda_u240_u241.commit();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinJsModuleConfigurator$Companion;", "", "<init>", "()V", "NAME", "", "intellij.kotlin.projectConfiguration"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

