/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ui.configuration.SdkPopupBuilder;
import com.intellij.openapi.roots.ui.configuration.SdkPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.workspace.jps.entities.LibraryDependency;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryId;
import com.intellij.platform.workspace.jps.entities.LibraryRoot;
import com.intellij.platform.workspace.jps.entities.LibraryRootTypeId;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.IncompleteModelUtil;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridges;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.ModuleSourceRootGroupUtils;
import org.jetbrains.kotlin.idea.base.util.UiUtils;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinNotificationManagerKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurationService;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinSetupEnvironmentNotificationProvider;
import org.jetbrains.kotlin.idea.configuration.ui.KotlinConfigurationCheckerService;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinNotConfiguredSuppressedModulesState;
import org.jetbrains.kotlin.idea.projectConfiguration.KotlinProjectConfigurationBundle;
import org.jetbrains.kotlin.idea.statistics.KotlinJ2KOnboardingFUSCollector;
import org.jetbrains.kotlin.idea.util.FileUtils;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinSetupEnvironmentNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileIsUnderKotlinSourceRoot", "", "kotlinStdlibExistsOnDiskForJPS", "module", "Lcom/intellij/openapi/module/Module;", "dependencyFilesExistOnDisk", "dependency", "Lcom/intellij/platform/workspace/jps/entities/LibraryDependency;", "Companion", "intellij.kotlin.projectConfiguration"})
@SourceDebugExtension(value={"SMAP\nKotlinSetupEnvironmentNotificationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSetupEnvironmentNotificationProvider.kt\norg/jetbrains/kotlin/idea/configuration/KotlinSetupEnvironmentNotificationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,205:1\n812#2,12:206\n777#2:218\n873#2,2:219\n1786#2,3:221\n777#2:224\n873#2,2:225\n1786#2,3:227\n*S KotlinDebug\n*F\n+ 1 KotlinSetupEnvironmentNotificationProvider.kt\norg/jetbrains/kotlin/idea/configuration/KotlinSetupEnvironmentNotificationProvider\n*L\n109#1:206,12\n109#1:218\n109#1:219,2\n111#1:221,3\n121#1:224\n121#1:225,2\n122#1:227,3\n*E\n"})
public final class KotlinSetupEnvironmentNotificationProvider
implements EditorNotificationProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Registry.Companion.is("kotlin.not.configured.show.notification")) {
            return null;
        }
        if (!FileUtils.isKotlinFileType(file)) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        KtFile ktFile2 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile2 == null) {
            return null;
        }
        KtFile psiFile2 = ktFile2;
        if (psiFile2.getLanguage() != KotlinLanguage.INSTANCE) {
            return null;
        }
        if (IncompleteModelUtil.isIncompleteModel((PsiElement)((PsiElement)psiFile2))) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiFile2));
        if (module == null) {
            return null;
        }
        Module module2 = module;
        if (BuildSystemTypeKt.getBuildSystemType(module2) == BuildSystemType.JPS && !this.kotlinStdlibExistsOnDiskForJPS(module2, project)) {
            return null;
        }
        if (!KotlinProjectConfigurationService.Companion.getInstance(project).shouldShowNotConfiguredDialog(module2)) {
            return null;
        }
        if (!ModuleRootManager.getInstance((Module)module2).getFileIndex().isInSourceContent(file) && !this.fileIsUnderKotlinSourceRoot(file)) {
            return null;
        }
        if (ModuleRootManager.getInstance((Module)module2).getSdk() == null && JvmPlatformKt.isJvm((TargetPlatform)TargetPlatformDetectorUtils.getPlatform((KtElement)psiFile2))) {
            return KotlinSetupEnvironmentNotificationProvider.Companion.createSetupSdkPanel(project, (PsiFile)psiFile2);
        }
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KotlinConfigurationCheckerService configurationChecker = KotlinConfigurationCheckerService.Companion.getInstance(project2);
        if (!configurationChecker.isSyncing() && ConfigureKotlinInProjectUtilsKt.isNotConfiguredNotificationRequired(ModuleSourceRootGroupUtils.toModuleGroup(module2)) && !ConfigureKotlinInProjectUtilsKt.hasKotlinPluginEnabled(module2) && !ConfigureKotlinInProjectUtilsKt.isStdlibModule(module2) && KotlinRuntimeLibraryUtilKt.getLibraryRootsWithIncompatibleAbi(module2).isEmpty()) {
            return KotlinSetupEnvironmentNotificationProvider.Companion.createKotlinNotConfiguredPanel(module2, CollectionsKt.toList((Iterable)ConfigureKotlinInProjectUtilsKt.getAbleToRunConfigurators(module2)));
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean fileIsUnderKotlinSourceRoot(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"src/main/kotlin/", (boolean)false, (int)2, null)) return true;
        String string2 = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"src/test/kotlin/", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean kotlinStdlibExistsOnDiskForJPS(Module module, Project project) {
        boolean bl;
        block7: {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Object object = ModuleBridges.findModuleEntity((Module)module);
            if (object == null || (object = object.getDependencies()) == null) {
                return false;
            }
            Object moduleDependencies = object;
            Iterable $this$filterIsInstance$iv = (Iterable)moduleDependencies;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof LibraryDependency)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                LibraryDependency it = (LibraryDependency)element$iv$iv;
                boolean bl2 = false;
                if (!StringsKt.contains$default((CharSequence)it.getLibrary().getName(), (CharSequence)"kotlin-stdlib", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List kotlinStdlibDependencies = (List)destination$iv$iv;
            if (kotlinStdlibDependencies.isEmpty()) {
                return false;
            }
            Iterable $this$all$iv = kotlinStdlibDependencies;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    LibraryDependency it = (LibraryDependency)element$iv;
                    boolean bl3 = false;
                    if (this.dependencyFilesExistOnDisk(it, project)) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean dependencyFilesExistOnDisk(LibraryDependency dependency, Project project) {
        boolean bl;
        block6: {
            void $this$filterTo$iv$iv;
            LibraryId libraryId = dependency.getLibrary();
            LibraryEntity libraryEntity = (LibraryEntity)WorkspaceModelKt.getWorkspaceModel((Project)project).getCurrentSnapshot().resolve((SymbolicEntityId)libraryId);
            Object object = libraryEntity;
            if (object == null || (object = object.getRoots()) == null) {
                return false;
            }
            Object libraryRoots = object;
            if (libraryRoots.isEmpty()) {
                return false;
            }
            Iterable $this$filter$iv = (Iterable)libraryRoots;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                LibraryRoot it = (LibraryRoot)element$iv$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)LibraryRootTypeId.Companion.getCOMPILED())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List jarsWithClasses = (List)destination$iv$iv;
            Iterable $this$all$iv = jarsWithClasses;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    LibraryRoot jar = (LibraryRoot)element$iv;
                    boolean bl3 = false;
                    VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(jar.getUrl().getUrl());
                    if (virtualFile != null ? virtualFile.exists() : false) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u0014\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J0\u0010\f\u001a\u0014\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00070\u00052\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0002J2\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00130\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinSetupEnvironmentNotificationProvider$Companion;", "", "<init>", "()V", "createSetupSdkPanel", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "createKotlinNotConfiguredPanel", "module", "Lcom/intellij/openapi/module/Module;", "configurators", "", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "apply", "", "createConfiguratorsPopup", "Lcom/intellij/openapi/ui/popup/ListPopup;", "onConfiguratorApplied", "Lkotlin/Function1;", "intellij.kotlin.projectConfiguration"})
    public static final class Companion {
        private Companion() {
        }

        private final Function<? super FileEditor, ? extends JComponent> createSetupSdkPanel(Project project, PsiFile file) {
            return arg_0 -> Companion.createSetupSdkPanel$lambda$0(project, file, arg_0);
        }

        private final Function<? super FileEditor, ? extends JComponent> createKotlinNotConfiguredPanel(Module module, List<? extends KotlinProjectConfigurator> configurators) {
            return arg_0 -> Companion.createKotlinNotConfiguredPanel$lambda$0(module, configurators, arg_0);
        }

        private final void apply(KotlinProjectConfigurator $this$apply, Project project) {
            $this$apply.configure(project, CollectionsKt.emptyList());
            EditorNotifications.getInstance((Project)project).updateAllNotifications();
            ConfigureKotlinNotificationManagerKt.checkHideNonConfiguredNotifications(project);
        }

        @NotNull
        public final ListPopup createConfiguratorsPopup(@NotNull Project project, @NotNull List<? extends KotlinProjectConfigurator> configurators, @NotNull Function1<? super KotlinProjectConfigurator, Unit> onConfiguratorApplied) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(configurators, (String)"configurators");
            Intrinsics.checkNotNullParameter(onConfiguratorApplied, (String)"onConfiguratorApplied");
            String string = KotlinProjectConfigurationBundle.message("title.choose.configurator", new Object[0]);
            BaseListPopupStep<KotlinProjectConfigurator> step2 = new BaseListPopupStep<KotlinProjectConfigurator>(configurators, project, onConfiguratorApplied, string){
                final /* synthetic */ Project $project;
                final /* synthetic */ Function1<KotlinProjectConfigurator, Unit> $onConfiguratorApplied;
                {
                    this.$project = $project;
                    this.$onConfiguratorApplied = $onConfiguratorApplied;
                    super($super_call_param$1, $configurators);
                }

                public String getTextFor(KotlinProjectConfigurator value) {
                    Object object = value;
                    if (object == null || (object = object.getPresentableText()) == null) {
                        object = "<none>";
                    }
                    return object;
                }

                public PopupStep<?> onChosen(KotlinProjectConfigurator selectedValue, boolean finalChoice) {
                    return this.doFinalStep(() -> createConfiguratorsPopup.step.1.onChosen$lambda$0(selectedValue, this.$project, this.$onConfiguratorApplied));
                }

                private static final void onChosen$lambda$0(KotlinProjectConfigurator $selectedValue, Project $project, Function1 $onConfiguratorApplied) {
                    if ($selectedValue == null) {
                        return;
                    }
                    org.jetbrains.kotlin.idea.configuration.KotlinSetupEnvironmentNotificationProvider$Companion.access$apply(KotlinSetupEnvironmentNotificationProvider.Companion, $selectedValue, $project);
                    $onConfiguratorApplied.invoke((Object)$selectedValue);
                }
            };
            ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2);
            Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createListPopup(...)");
            return listPopup;
        }

        public static /* synthetic */ ListPopup createConfiguratorsPopup$default(Companion companion, Project project, List list2, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                function1 = Companion::createConfiguratorsPopup$lambda$0;
            }
            return companion.createConfiguratorsPopup(project, list2, (Function1<? super KotlinProjectConfigurator, Unit>)function1);
        }

        private static final Unit createSetupSdkPanel$lambda$0$0$0$0$0(PsiFile $file) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)$file));
            if (module != null) {
                ModuleRootModificationUtil.setSdkInherited((Module)module);
            }
            return Unit.INSTANCE;
        }

        private static final void createSetupSdkPanel$lambda$0$0$0$0(PsiFile $file, Sdk it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ActionsKt.runWriteAction(() -> Companion.createSetupSdkPanel$lambda$0$0$0$0$0($file));
        }

        private static final Unit createSetupSdkPanel$lambda$0$0$0(Project $project, PsiFile $file, HyperlinkLabel label2) {
            Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
            SdkPopupBuilder sdkPopupBuilder = SdkPopupFactory.Companion.newBuilder().withProject($project);
            JavaSdk javaSdk = JavaSdk.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)javaSdk, (String)"getInstance(...)");
            sdkPopupBuilder.withSdkType((SdkTypeId)javaSdk).updateProjectSdkFromSelection().onSdkSelected(arg_0 -> Companion.createSetupSdkPanel$lambda$0$0$0$0($file, arg_0)).buildPopup().showUnderneathOf((Component)label2);
            return Unit.INSTANCE;
        }

        private static final EditorNotificationPanel createSetupSdkPanel$lambda$0(Project $project, PsiFile $file, FileEditor fileEditor) {
            EditorNotificationPanel editorNotificationPanel;
            Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
            EditorNotificationPanel $this$createSetupSdkPanel_u24lambda_u240_u240 = editorNotificationPanel = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
            boolean bl = false;
            $this$createSetupSdkPanel_u24lambda_u240_u240.setText(JavaUiBundle.message((String)"project.sdk.not.defined", (Object[])new Object[0]));
            String string = ProjectBundle.message((String)"project.sdk.setup", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            UiUtils.createComponentActionLabel($this$createSetupSdkPanel_u24lambda_u240_u240, string, (Function1<? super HyperlinkLabel, Unit>)((Function1)arg_0 -> Companion.createSetupSdkPanel$lambda$0$0$0($project, $file, arg_0)));
            return editorNotificationPanel;
        }

        private static final Unit createKotlinNotConfiguredPanel$lambda$0$0$0(List $configurators, Project $project, HyperlinkLabel label2) {
            Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
            KotlinProjectConfigurator singleConfigurator = (KotlinProjectConfigurator)CollectionsKt.singleOrNull((List)$configurators);
            if (singleConfigurator != null) {
                Companion.apply(singleConfigurator, $project);
            } else {
                ListPopup configuratorsPopup = org.jetbrains.kotlin.idea.configuration.KotlinSetupEnvironmentNotificationProvider$Companion.createConfiguratorsPopup$default(Companion, $project, $configurators, null, 4, null);
                configuratorsPopup.showUnderneathOf((Component)label2);
            }
            KotlinJ2KOnboardingFUSCollector.INSTANCE.logClickConfigureKtNotification($project);
            return Unit.INSTANCE;
        }

        private static final void createKotlinNotConfiguredPanel$lambda$0$0$1(Module $module, Project $project) {
            KotlinNotConfiguredSuppressedModulesState.Companion.suppressConfiguration$intellij_kotlin_projectConfiguration($module);
            EditorNotifications.getInstance((Project)$project).updateAllNotifications();
        }

        private static final EditorNotificationPanel createKotlinNotConfiguredPanel$lambda$0(Module $module, List $configurators, FileEditor fileEditor) {
            EditorNotificationPanel editorNotificationPanel;
            Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
            Project project = $module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KotlinJ2KOnboardingFUSCollector.INSTANCE.logShowConfigureKtPanel(project);
            EditorNotificationPanel $this$createKotlinNotConfiguredPanel_u24lambda_u240_u240 = editorNotificationPanel = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
            boolean bl = false;
            $this$createKotlinNotConfiguredPanel_u24lambda_u240_u240.setText(KotlinProjectConfigurationBundle.message("kotlin.not.configured", new Object[0]));
            if (!((Collection)$configurators).isEmpty()) {
                Project project2 = $module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                Project project3 = project2;
                UiUtils.createComponentActionLabel($this$createKotlinNotConfiguredPanel_u24lambda_u240_u240, KotlinProjectConfigurationBundle.message("action.text.configure", new Object[0]), (Function1<? super HyperlinkLabel, Unit>)((Function1)arg_0 -> Companion.createKotlinNotConfiguredPanel$lambda$0$0$0($configurators, project3, arg_0)));
                $this$createKotlinNotConfiguredPanel_u24lambda_u240_u240.createActionLabel(KotlinProjectConfigurationBundle.message("action.text.ignore", new Object[0]), () -> Companion.createKotlinNotConfiguredPanel$lambda$0$0$1($module, project3));
            }
            return editorNotificationPanel;
        }

        private static final Unit createConfiguratorsPopup$lambda$0(KotlinProjectConfigurator it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ void access$apply(Companion $this, KotlinProjectConfigurator $receiver, Project project) {
            $this.apply($receiver, project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

