/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.overrideImplement;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.codeInsight.generation.MemberChooserObjectBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.overrideImplement.BodyType;
import org.jetbrains.kotlin.idea.core.overrideImplement.KaClassOrObjectSymbolChooserObject;
import org.jetbrains.kotlin.idea.core.overrideImplement.KtClassMemberInfo;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J'\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0014\u0010\u001a\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0083\u0004J\n\u0010\u001d\u001a\u00020\u0015H\u00d6\u0081\u0004J\n\u0010\u001e\u001a\u00020\u001fH\u00d6\u0081\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/core/overrideImplement/KtClassMember;", "Lcom/intellij/codeInsight/generation/MemberChooserObjectBase;", "Lcom/intellij/codeInsight/generation/ClassMember;", "memberInfo", "Lorg/jetbrains/kotlin/idea/core/overrideImplement/KtClassMemberInfo;", "bodyType", "Lorg/jetbrains/kotlin/idea/core/overrideImplement/BodyType;", "preferConstructorParameter", "", "<init>", "(Lorg/jetbrains/kotlin/idea/core/overrideImplement/KtClassMemberInfo;Lorg/jetbrains/kotlin/idea/core/overrideImplement/BodyType;Z)V", "getMemberInfo", "()Lorg/jetbrains/kotlin/idea/core/overrideImplement/KtClassMemberInfo;", "getBodyType", "()Lorg/jetbrains/kotlin/idea/core/overrideImplement/BodyType;", "getPreferConstructorParameter", "()Z", "isDeprecated", "getParentNodeDelegate", "Lcom/intellij/codeInsight/generation/MemberChooserObject;", "getTextStyle", "", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "toString", "", "intellij.kotlin.codeInsight.overrideImplement"})
@ApiStatus.Internal
public final class KtClassMember
extends MemberChooserObjectBase
implements ClassMember {
    @NotNull
    private final KtClassMemberInfo memberInfo;
    @NotNull
    private final BodyType bodyType;
    private final boolean preferConstructorParameter;
    private final boolean isDeprecated;

    public KtClassMember(@NotNull KtClassMemberInfo memberInfo, @NotNull BodyType bodyType, boolean preferConstructorParameter) {
        Intrinsics.checkNotNullParameter((Object)memberInfo, (String)"memberInfo");
        Intrinsics.checkNotNullParameter((Object)bodyType, (String)"bodyType");
        super(memberInfo.getMemberText(), memberInfo.getMemberIcon());
        this.memberInfo = memberInfo;
        this.bodyType = bodyType;
        this.preferConstructorParameter = preferConstructorParameter;
        this.isDeprecated = this.memberInfo.isDeprecated();
    }

    @NotNull
    public final KtClassMemberInfo getMemberInfo() {
        return this.memberInfo;
    }

    @NotNull
    public final BodyType getBodyType() {
        return this.bodyType;
    }

    public final boolean getPreferConstructorParameter() {
        return this.preferConstructorParameter;
    }

    @Nullable
    public MemberChooserObject getParentNodeDelegate() {
        KaClassOrObjectSymbolChooserObject kaClassOrObjectSymbolChooserObject;
        String string = this.memberInfo.getContainingSymbolText();
        if (string != null) {
            String it = string;
            boolean bl = false;
            kaClassOrObjectSymbolChooserObject = new KaClassOrObjectSymbolChooserObject(this.memberInfo.getContainingSymbolText(), this.memberInfo.getContainingSymbolIcon());
        } else {
            kaClassOrObjectSymbolChooserObject = null;
        }
        return (MemberChooserObject)kaClassOrObjectSymbolChooserObject;
    }

    public int getTextStyle() {
        return this.isDeprecated ? 4 : 0;
    }

    @NotNull
    public final KtClassMemberInfo component1() {
        return this.memberInfo;
    }

    @NotNull
    public final BodyType component2() {
        return this.bodyType;
    }

    public final boolean component3() {
        return this.preferConstructorParameter;
    }

    @NotNull
    public final KtClassMember copy(@NotNull KtClassMemberInfo memberInfo, @NotNull BodyType bodyType, boolean preferConstructorParameter) {
        Intrinsics.checkNotNullParameter((Object)memberInfo, (String)"memberInfo");
        Intrinsics.checkNotNullParameter((Object)bodyType, (String)"bodyType");
        return new KtClassMember(memberInfo, bodyType, preferConstructorParameter);
    }

    public static /* synthetic */ KtClassMember copy$default(KtClassMember ktClassMember, KtClassMemberInfo ktClassMemberInfo, BodyType bodyType, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            ktClassMemberInfo = ktClassMember.memberInfo;
        }
        if ((n & 2) != 0) {
            bodyType = ktClassMember.bodyType;
        }
        if ((n & 4) != 0) {
            bl = ktClassMember.preferConstructorParameter;
        }
        return ktClassMember.copy(ktClassMemberInfo, bodyType, bl);
    }

    @NotNull
    public String toString() {
        return "KtClassMember(memberInfo=" + this.memberInfo + ", bodyType=" + this.bodyType + ", preferConstructorParameter=" + this.preferConstructorParameter + ")";
    }

    public int hashCode() {
        int result2 = this.memberInfo.hashCode();
        result2 = result2 * 31 + this.bodyType.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.preferConstructorParameter);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KtClassMember)) {
            return false;
        }
        KtClassMember ktClassMember = (KtClassMember)((Object)other);
        if (!Intrinsics.areEqual((Object)this.memberInfo, (Object)ktClassMember.memberInfo)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.bodyType, (Object)ktClassMember.bodyType)) {
            return false;
        }
        return this.preferConstructorParameter == ktClassMember.preferConstructorParameter;
    }
}

