/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.k1;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.shared.AbstractScriptDependencySourceNavigationPolicyForJavaClasses;
import org.jetbrains.kotlin.idea.core.script.v1.ScriptDependencyAware;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/k1/ScriptDependencySourceNavigationPolicyForJavaClasses;", "Lorg/jetbrains/kotlin/idea/core/script/shared/AbstractScriptDependencySourceNavigationPolicyForJavaClasses;", "<init>", "()V", "getNavigationElement", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/impl/compiled/ClsFileImpl;", "kotlin.base.scripting.k1"})
@SourceDebugExtension(value={"SMAP\nScriptDependencySourceNavigationPolicyForJavaClasses.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptDependencySourceNavigationPolicyForJavaClasses.kt\norg/jetbrains/kotlin/idea/core/script/k1/ScriptDependencySourceNavigationPolicyForJavaClasses\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,38:1\n13225#2,2:39\n*S KotlinDebug\n*F\n+ 1 ScriptDependencySourceNavigationPolicyForJavaClasses.kt\norg/jetbrains/kotlin/idea/core/script/k1/ScriptDependencySourceNavigationPolicyForJavaClasses\n*L\n30#1:39,2\n*E\n"})
public final class ScriptDependencySourceNavigationPolicyForJavaClasses
extends AbstractScriptDependencySourceNavigationPolicyForJavaClasses {
    @Nullable
    public PsiElement getNavigationElement(@NotNull ClsFileImpl file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        if (!ScriptDependencyAware.Companion.getInstance(project2).getAllScriptsDependenciesClassFilesScope().contains(file.getVirtualFile())) {
            return null;
        }
        PsiClass[] psiClassArray = file.getClasses();
        Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"getClasses(...)");
        Iterator iterator2 = ArraysKt.firstOrNull((Object[])psiClassArray);
        ClsClassImpl clsClassImpl = iterator2 instanceof ClsClassImpl ? (ClsClassImpl)iterator2 : null;
        if (clsClassImpl == null) {
            return null;
        }
        ClsClassImpl psiClass = clsClassImpl;
        Collection collection = FilenameIndex.getVirtualFilesByName((String)psiClass.getSourceFileName(), (GlobalSearchScope)ScriptDependencyAware.Companion.getInstance(project2).getAllScriptDependenciesSourcesScope());
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getVirtualFilesByName(...)");
        Collection candidates2 = collection;
        for (VirtualFile virtualFile : candidates2) {
            boolean bl;
            PsiFile sourceFile;
            block4: {
                if (!virtualFile.isValid()) continue;
                Intrinsics.checkNotNull((Object)virtualFile);
                sourceFile = PhysicalFileSystemUtilsKt.toPsiFile(virtualFile, project2);
                if (sourceFile == null || !sourceFile.isValid() || !(sourceFile instanceof PsiClassOwner)) continue;
                PsiClass[] psiClassArray2 = ((PsiClassOwner)sourceFile).getClasses();
                Intrinsics.checkNotNullExpressionValue((Object)psiClassArray2, (String)"getClasses(...)");
                Object[] $this$any$iv = psiClassArray2;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    PsiClass it = (PsiClass)element$iv;
                    boolean bl2 = false;
                    if (!it.isEquivalentTo((PsiElement)psiClass)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (!bl) continue;
            return (PsiElement)sourceFile;
        }
        return null;
    }
}

