/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.k1.configuration.loader;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.ErrorHandlingKt;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptDiagnostic;
import kotlin.script.experimental.api.SourceCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.k1.configuration.cache.ScriptConfigurationSnapshot;
import org.jetbrains.kotlin.idea.core.script.k1.configuration.loader.ScriptConfigurationLoader;
import org.jetbrains.kotlin.idea.core.script.k1.configuration.loader.ScriptConfigurationLoadingContext;
import org.jetbrains.kotlin.idea.core.script.shared.CachedConfigurationInputs;
import org.jetbrains.kotlin.idea.core.script.v1.ScriptingLoggerKt;
import org.jetbrains.kotlin.idea.core.script.v1.settings.KotlinScriptingSettings;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.ScriptCompilationConfigurationFromDefinitionKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.resolve.KtFileScriptSource;
import org.jetbrains.kotlin.scripting.resolve.RefineCompilationConfigurationKt;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0004J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u000fH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/k1/configuration/loader/DefaultScriptConfigurationLoader;", "Lorg/jetbrains/kotlin/idea/core/script/k1/configuration/loader/ScriptConfigurationLoader;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "shouldRunInBackground", "", "scriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "loadDependencies", "isFirstLoad", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "context", "Lorg/jetbrains/kotlin/idea/core/script/k1/configuration/loader/ScriptConfigurationLoadingContext;", "getConfigurationThroughScriptingApi", "Lorg/jetbrains/kotlin/idea/core/script/k1/configuration/cache/ScriptConfigurationSnapshot;", "file", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "logScriptingConfigurationErrors", "", "snapshot", "getInputsStamp", "Lorg/jetbrains/kotlin/idea/core/script/shared/CachedConfigurationInputs;", "virtualFile", "kotlin.base.scripting.k1"})
public class DefaultScriptConfigurationLoader
implements ScriptConfigurationLoader {
    @NotNull
    private final Project project;

    public DefaultScriptConfigurationLoader(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public boolean shouldRunInBackground(@NotNull ScriptDefinition scriptDefinition) {
        Intrinsics.checkNotNullParameter((Object)((Object)scriptDefinition), (String)"scriptDefinition");
        Boolean bl = scriptDefinition.getCompilationConfiguration().get(ScriptCompilationConfigurationFromDefinitionKt.getAsyncDependenciesResolver(ScriptCompilationConfiguration.Companion));
        return bl != null ? bl : false;
    }

    @Override
    public boolean loadDependencies(boolean isFirstLoad, @NotNull KtFile ktFile2, @NotNull ScriptDefinition scriptDefinition, @NotNull ScriptConfigurationLoadingContext context2) {
        Intrinsics.checkNotNullParameter((Object)ktFile2, (String)"ktFile");
        Intrinsics.checkNotNullParameter((Object)((Object)scriptDefinition), (String)"scriptDefinition");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.project.isDisposed()) {
            return false;
        }
        VirtualFile virtualFile = ktFile2.getOriginalFile().getVirtualFile();
        Intrinsics.checkNotNull((Object)virtualFile);
        ScriptConfigurationSnapshot result2 = this.getConfigurationThroughScriptingApi(ktFile2, virtualFile, scriptDefinition);
        if (KotlinScriptingSettings.Companion.getInstance(this.project).autoReloadConfigurations(scriptDefinition)) {
            context2.saveNewConfiguration(virtualFile, result2);
        } else {
            context2.suggestNewConfiguration(virtualFile, result2);
        }
        return true;
    }

    @NotNull
    protected final ScriptConfigurationSnapshot getConfigurationThroughScriptingApi(@NotNull KtFile file, @NotNull VirtualFile vFile, @NotNull ScriptDefinition scriptDefinition) {
        ResultWithDiagnostics resultWithDiagnostics;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        Intrinsics.checkNotNullParameter((Object)((Object)scriptDefinition), (String)"scriptDefinition");
        ScriptingLoggerKt.scriptingDebugLog(file, (Function0<String>)((Function0)DefaultScriptConfigurationLoader::getConfigurationThroughScriptingApi$lambda$0));
        CachedConfigurationInputs inputs = this.getInputsStamp(vFile, file);
        try {
            SourceCode sourceCode = new KtFileScriptSource(file, null, 2, null);
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            resultWithDiagnostics = RefineCompilationConfigurationKt.refineScriptCompilationConfiguration$default(sourceCode, scriptDefinition, project, null, 8, null);
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            resultWithDiagnostics = new ResultWithDiagnostics.Failure(CollectionsKt.listOf((Object)ErrorHandlingKt.asDiagnostics$default(e, 0, null, null, null, null, 31, null)));
        }
        ResultWithDiagnostics scriptingApiResult = resultWithDiagnostics;
        ScriptConfigurationSnapshot result2 = new ScriptConfigurationSnapshot(inputs, scriptingApiResult.getReports(), (ScriptCompilationConfigurationWrapper)ErrorHandlingKt.valueOrNull(scriptingApiResult));
        ScriptingLoggerKt.scriptingDebugLog(file, (Function0<String>)((Function0)DefaultScriptConfigurationLoader::getConfigurationThroughScriptingApi$lambda$1));
        this.logScriptingConfigurationErrors(vFile, result2);
        return result2;
    }

    private final void logScriptingConfigurationErrors(VirtualFile file, ScriptConfigurationSnapshot snapshot) {
        if (snapshot.getConfiguration() == null) {
            ScriptingLoggerKt.scriptingWarnLog("Script configuration for file " + file + " was not loaded");
            for (ScriptDiagnostic report : snapshot.getReports()) {
                if (report.getSeverity().compareTo((Enum)ScriptDiagnostic.Severity.WARNING) < 0) continue;
                ScriptingLoggerKt.scriptingWarnLog(report.getMessage(), report.getException());
            }
        }
    }

    @NotNull
    protected CachedConfigurationInputs getInputsStamp(@NotNull VirtualFile virtualFile, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return CachedConfigurationInputs.PsiModificationStamp.Companion.get(this.project, virtualFile, file);
    }

    private static final String getConfigurationThroughScriptingApi$lambda$0() {
        return "start dependencies loading";
    }

    private static final String getConfigurationThroughScriptingApi$lambda$1() {
        return "finish dependencies loading";
    }
}

