/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.k1.ucache;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.k1.configuration.utils.ScriptClassRootsStorage;
import org.jetbrains.kotlin.idea.core.script.k1.ucache.DirectScriptInfo;
import org.jetbrains.kotlin.idea.core.script.k1.ucache.ScriptClassRootsCache;
import org.jetbrains.kotlin.idea.core.script.k1.ucache.ScriptSdksBuilder;
import org.jetbrains.kotlin.idea.core.script.shared.LightScriptInfo;
import org.jetbrains.kotlin.idea.core.script.v1.ScriptingLoggerKt;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 42\u00020\u0001:\u00014BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000b\u0010\u000eJ\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0016J\u001e\u0010 \u001a\u00020\u001d2\u0016\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0018\u00010\tJ\u0016\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%J2\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u00062\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060)2\u0006\u0010+\u001a\u00020\nJ\u0014\u0010,\u001a\u00020\u001d2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00060)J\u0014\u0010.\u001a\u00020\u001d2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00060)J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u0000H\u0007J\u000e\u00101\u001a\u00020\u001d2\u0006\u00102\u001a\u000203R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/k1/ucache/ScriptClassRootsBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "classes", "", "", "sources", "scripts", "", "Lorg/jetbrains/kotlin/idea/core/script/shared/LightScriptInfo;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;Ljava/util/Set;Ljava/util/Map;)V", "builder", "(Lorg/jetbrains/kotlin/idea/core/script/k1/ucache/ScriptClassRootsBuilder;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "sdks", "Lorg/jetbrains/kotlin/idea/core/script/k1/ucache/ScriptSdksBuilder;", "getSdks", "()Lorg/jetbrains/kotlin/idea/core/script/k1/ucache/ScriptSdksBuilder;", "customDefinitionsUsed", "", "shouldWarnAboutDependenciesExistence", "classpathVfsHint", "Lcom/intellij/openapi/vfs/VirtualFile;", "build", "Lorg/jetbrains/kotlin/idea/core/script/k1/ucache/ScriptClassRootsCache;", "useCustomScriptDefinition", "", "warnAboutDependenciesExistence", "enabled", "withClasspathVfsHint", "hint", "add", "vFile", "configuration", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "addCustom", "path", "scriptClassesRoots", "", "sourceSourcesRoots", "info", "addTemplateClassesRoots", "classesRoots", "addSources", "sourcesRoots", "other", "toStorage", "storage", "Lorg/jetbrains/kotlin/idea/core/script/k1/configuration/utils/ScriptClassRootsStorage;", "Companion", "kotlin.base.scripting.k1"})
@SourceDebugExtension(value={"SMAP\nScriptClassRootsBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptClassRootsBuilder.kt\norg/jetbrains/kotlin/idea/core/script/k1/ucache/ScriptClassRootsBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1915#2,2:127\n1915#2,2:129\n*S KotlinDebug\n*F\n+ 1 ScriptClassRootsBuilder.kt\norg/jetbrains/kotlin/idea/core/script/k1/ucache/ScriptClassRootsBuilder\n*L\n59#1:127,2\n69#1:129,2\n*E\n"})
public final class ScriptClassRootsBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Set<String> classes;
    @NotNull
    private final Set<String> sources;
    @NotNull
    private final Map<String, LightScriptInfo> scripts;
    @NotNull
    private final ScriptSdksBuilder sdks;
    private boolean customDefinitionsUsed;
    private boolean shouldWarnAboutDependenciesExistence;
    @Nullable
    private Map<String, VirtualFile> classpathVfsHint;

    public ScriptClassRootsBuilder(@NotNull Project project, @NotNull Set<String> classes, @NotNull Set<String> sources, @NotNull Map<String, LightScriptInfo> scripts) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Intrinsics.checkNotNullParameter(scripts, (String)"scripts");
        this.project = project;
        this.classes = classes;
        this.sources = sources;
        this.scripts = scripts;
        this.sdks = new ScriptSdksBuilder(this.project, null, null, 6, null);
        this.shouldWarnAboutDependenciesExistence = true;
    }

    public /* synthetic */ ScriptClassRootsBuilder(Project project, Set set, Set set2, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            set = new LinkedHashSet();
        }
        if ((n & 4) != 0) {
            set2 = new LinkedHashSet();
        }
        if ((n & 8) != 0) {
            map2 = new LinkedHashMap();
        }
        this(project, set, set2, map2);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ScriptSdksBuilder getSdks() {
        return this.sdks;
    }

    public ScriptClassRootsBuilder(@NotNull ScriptClassRootsBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        this(builder2.project, CollectionsKt.toMutableSet((Iterable)builder2.classes), CollectionsKt.toMutableSet((Iterable)builder2.sources), MapsKt.toMutableMap(builder2.scripts));
        this.sdks.getSdks().putAll(builder2.sdks.getSdks());
    }

    @NotNull
    public final ScriptClassRootsCache build() {
        return new ScriptClassRootsCache(this.scripts, this.classes, this.sources, this.customDefinitionsUsed, this.sdks.build(), this.classpathVfsHint);
    }

    public final void useCustomScriptDefinition() {
        this.customDefinitionsUsed = true;
    }

    public final void warnAboutDependenciesExistence(boolean enabled) {
        this.shouldWarnAboutDependenciesExistence = enabled;
    }

    public final void withClasspathVfsHint(@Nullable Map<String, VirtualFile> hint2) {
        this.classpathVfsHint = hint2;
    }

    public final void add(@NotNull VirtualFile vFile, @NotNull ScriptCompilationConfigurationWrapper configuration2) {
        String absolutePath;
        Path path2;
        File file;
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        File file2 = configuration2.getJavaHome();
        this.sdks.addSdk(file2 != null ? file2.toPath() : null);
        Iterable $this$forEach$iv = configuration2.getDependenciesClassPath();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            file = (File)element$iv;
            boolean bl = false;
            path2 = file.toPath();
            Intrinsics.checkNotNull((Object)path2);
            absolutePath = ((Object)path2.toAbsolutePath()).toString();
            if (this.shouldWarnAboutDependenciesExistence) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.notExists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    ScriptingLoggerKt.getLogger().warn("configuration dependency classpath " + absolutePath + " does not exist");
                }
            }
            this.classes.add(absolutePath);
        }
        $this$forEach$iv = configuration2.getDependenciesSources();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            file = (File)element$iv;
            boolean bl = false;
            path2 = file.toPath();
            Intrinsics.checkNotNull((Object)path2);
            absolutePath = ((Object)path2.toAbsolutePath()).toString();
            if (this.shouldWarnAboutDependenciesExistence) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.notExists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    ScriptingLoggerKt.getLogger().warn("configuration dependency sources " + absolutePath + " does not exist");
                }
            }
            this.sources.add(absolutePath);
        }
        this.scripts.put(vFile.getPath(), new DirectScriptInfo(configuration2));
        this.useCustomScriptDefinition();
    }

    public final void addCustom(@NotNull String path2, @NotNull Collection<String> scriptClassesRoots, @NotNull Collection<String> sourceSourcesRoots, @NotNull LightScriptInfo info2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter(scriptClassesRoots, (String)"scriptClassesRoots");
        Intrinsics.checkNotNullParameter(sourceSourcesRoots, (String)"sourceSourcesRoots");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        this.classes.addAll(scriptClassesRoots);
        this.sources.addAll(sourceSourcesRoots);
        this.scripts.put(path2, info2);
    }

    public final void addTemplateClassesRoots(@NotNull Collection<String> classesRoots) {
        Intrinsics.checkNotNullParameter(classesRoots, (String)"classesRoots");
        this.classes.addAll(classesRoots);
    }

    public final void addSources(@NotNull Collection<String> sourcesRoots) {
        Intrinsics.checkNotNullParameter(sourcesRoots, (String)"sourcesRoots");
        this.sources.addAll(sourcesRoots);
    }

    @Deprecated(message="Don't use, used only from DefaultScriptingSupport for saving to storage")
    public final void add(@NotNull ScriptClassRootsBuilder other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.classes.addAll((Collection<String>)other.classes);
        this.sources.addAll((Collection<String>)other.sources);
        this.sdks.addAll(other.sdks);
        this.scripts.putAll(other.scripts);
    }

    public final void toStorage(@NotNull ScriptClassRootsStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        storage.setClasspath(this.classes);
        storage.setSources(this.sources);
        this.sdks.toStorage(storage);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/k1/ucache/ScriptClassRootsBuilder$Companion;", "", "<init>", "()V", "fromStorage", "Lorg/jetbrains/kotlin/idea/core/script/k1/ucache/ScriptClassRootsBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "storage", "Lorg/jetbrains/kotlin/idea/core/script/k1/configuration/utils/ScriptClassRootsStorage;", "kotlin.base.scripting.k1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ScriptClassRootsBuilder fromStorage(@NotNull Project project, @NotNull ScriptClassRootsStorage storage) {
            ScriptClassRootsBuilder scriptClassRootsBuilder;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
            ScriptClassRootsBuilder it = scriptClassRootsBuilder = new ScriptClassRootsBuilder(project, CollectionsKt.toMutableSet((Iterable)storage.getClasspath()), CollectionsKt.toMutableSet((Iterable)storage.getSources()), null, 8, null);
            boolean bl = false;
            it.getSdks().fromStorage(storage);
            return scriptClassRootsBuilder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

