/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.k2.definitions;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.SourceCode;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.caches.project.CacheUtilsKt;
import org.jetbrains.kotlin.idea.core.script.k2.definitions.BundledScriptDefinitionSourceKt;
import org.jetbrains.kotlin.idea.core.script.k2.definitions.ScriptDefinitionsModificationTracker;
import org.jetbrains.kotlin.idea.core.script.k2.settings.ScriptDefinitionSettingsPersistentStateComponent;
import org.jetbrains.kotlin.idea.core.script.shared.ScriptDefinitionSourcesKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionsSource;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\tH\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/k2/definitions/ScriptDefinitionProviderImpl;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinitionProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "currentDefinitions", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "getCurrentDefinitions", "()Lkotlin/sequences/Sequence;", "definitionsFromSources", "", "getDefinitionsFromSources", "()Ljava/util/List;", "isScript", "", "script", "Lkotlin/script/experimental/api/SourceCode;", "getKnownFilenameExtensions", "", "findDefinition", "getDefaultDefinition", "Companion", "intellij.kotlin.base.scripting"})
@SourceDebugExtension(value={"SMAP\nScriptDefinitionProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptDefinitionProviderImpl.kt\norg/jetbrains/kotlin/idea/core/script/k2/definitions/ScriptDefinitionProviderImpl\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n614#2:68\n184#2,2:72\n1807#3,3:69\n*S KotlinDebug\n*F\n+ 1 ScriptDefinitionProviderImpl.kt\norg/jetbrains/kotlin/idea/core/script/k2/definitions/ScriptDefinitionProviderImpl\n*L\n33#1:68\n48#1:72,2\n46#1:69,3\n*E\n"})
public final class ScriptDefinitionProviderImpl
implements ScriptDefinitionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Set<String> nonScriptFilenameSuffixes;

    public ScriptDefinitionProviderImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public Sequence<ScriptDefinition> getCurrentDefinitions() {
        ScriptDefinitionSettingsPersistentStateComponent settingsProvider = ScriptDefinitionSettingsPersistentStateComponent.Companion.getInstance(this.project);
        Sequence $this$sortedBy$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getDefinitionsFromSources()), arg_0 -> ScriptDefinitionProviderImpl._get_currentDefinitions_$lambda$0(settingsProvider, arg_0));
        boolean $i$f$sortedBy = false;
        return SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(settingsProvider){
            final /* synthetic */ ScriptDefinitionSettingsPersistentStateComponent $settingsProvider$inlined;
            {
                this.$settingsProvider$inlined = scriptDefinitionSettingsPersistentStateComponent;
            }

            public final int compare(T a, T b) {
                ScriptDefinition it = (ScriptDefinition)((Object)a);
                boolean bl = false;
                Comparable comparable = Integer.valueOf(this.$settingsProvider$inlined.getScriptDefinitionOrder(it));
                it = (ScriptDefinition)((Object)b);
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(this.$settingsProvider$inlined.getScriptDefinitionOrder(it)));
            }
        });
    }

    @NotNull
    public final List<ScriptDefinition> getDefinitionsFromSources() {
        return ScriptDefinitionProviderImpl.Companion.computeOrGetDefinitions(this.project);
    }

    @Override
    public boolean isScript(@NotNull SourceCode script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return this.findDefinition(script) != null;
    }

    @Override
    @NotNull
    public Sequence<String> getKnownFilenameExtensions() {
        return SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)SequencesKt.plus(this.getCurrentDefinitions(), (Object)((Object)this.getDefaultDefinition())), ScriptDefinitionProviderImpl::getKnownFilenameExtensions$lambda$0));
    }

    @Override
    @Nullable
    public ScriptDefinition findDefinition(@NotNull SourceCode script) {
        Object v2;
        block7: {
            Object it;
            boolean bl;
            block6: {
                Intrinsics.checkNotNullParameter((Object)script, (String)"script");
                String string = script.getLocationId();
                if (string == null) {
                    return null;
                }
                String locationId = string;
                Iterable $this$any$iv = nonScriptFilenameSuffixes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.endsWith((String)locationId, (String)it, (boolean)true)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return null;
            }
            Sequence<ScriptDefinition> $this$firstOrNull$iv = this.getCurrentDefinitions();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (ScriptDefinition)((Object)element$iv);
                boolean bl3 = false;
                if (!((ScriptDefinition)((Object)it)).isScript(script)) continue;
                v2 = element$iv;
                break block7;
            }
            v2 = null;
        }
        return v2;
    }

    @Override
    @NotNull
    public ScriptDefinition getDefaultDefinition() {
        return BundledScriptDefinitionSourceKt.getDefaultDefinition(this.project);
    }

    private static final boolean _get_currentDefinitions_$lambda$0(ScriptDefinitionSettingsPersistentStateComponent $settingsProvider, ScriptDefinition it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return $settingsProvider.isScriptDefinitionEnabled(it);
    }

    private static final String getKnownFilenameExtensions$lambda$0(ScriptDefinition it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it.getFileExtension();
    }

    static {
        Object[] objectArray = new String[]{".kt", ".java"};
        nonScriptFilenameSuffixes = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/k2/definitions/ScriptDefinitionProviderImpl$Companion;", "", "<init>", "()V", "computeOrGetDefinitions", "", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "project", "Lcom/intellij/openapi/project/Project;", "nonScriptFilenameSuffixes", "", "", "getInstance", "Lorg/jetbrains/kotlin/idea/core/script/k2/definitions/ScriptDefinitionProviderImpl;", "intellij.kotlin.base.scripting"})
    @SourceDebugExtension(value={"SMAP\nScriptDefinitionProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptDefinitionProviderImpl.kt\norg/jetbrains/kotlin/idea/core/script/k2/definitions/ScriptDefinitionProviderImpl$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n30#2,2:68\n1404#3:70\n1496#3,5:71\n*S KotlinDebug\n*F\n+ 1 ScriptDefinitionProviderImpl.kt\norg/jetbrains/kotlin/idea/core/script/k2/definitions/ScriptDefinitionProviderImpl$Companion\n*L\n64#1:68,2\n58#1:70\n58#1:71,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final List<ScriptDefinition> computeOrGetDefinitions(Project project) {
            Object[] objectArray = new Object[]{ScriptDefinitionsModificationTracker.Companion.getInstance(project)};
            return (List)CacheUtilsKt.cacheByClass(project, ScriptDefinitionProviderImpl.class, objectArray, () -> Companion.computeOrGetDefinitions$lambda$0(project));
        }

        @NotNull
        public final ScriptDefinitionProviderImpl getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ScriptDefinitionProvider> serviceClass$iv = ScriptDefinitionProvider.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.core.script.k2.definitions.ScriptDefinitionProviderImpl");
            return (ScriptDefinitionProviderImpl)object;
        }

        /*
         * WARNING - void declaration
         */
        private static final List computeOrGetDefinitions$lambda$0(Project $project) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = ScriptDefinitionSourcesKt.getSCRIPT_DEFINITIONS_SOURCES().getExtensions((AreaInstance)$project);
            boolean $i$f$flatMapSequence = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapSequenceTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                ScriptDefinitionsSource it = (ScriptDefinitionsSource)element$iv$iv;
                boolean bl = false;
                Sequence<ScriptDefinition> list$iv$iv = it.getDefinitions();
                CollectionsKt.addAll((Collection)destination$iv$iv, list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

