/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.k2.highlighting;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.script.experimental.api.ScriptDiagnostic;
import kotlin.script.experimental.api.SourceCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.shared.ScriptDiagnosticFixProvider;
import org.jetbrains.kotlin.idea.core.script.shared.ScriptDiagnosticsKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0001H\u0016J$\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0014\u0010\u001f\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001c\u0010 \u001a\u00020\u001a*\u00020\u001c2\u0006\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u001aH\u0002J\u000e\u0010#\u001a\u0004\u0018\u00010$*\u00020%H\u0002J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010\r\u001a\u00020)H\u0002R\"\u0010\u0004\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/k2/highlighting/KotlinScriptHighlightingVisitor;", "Lcom/intellij/codeInsight/daemon/impl/HighlightVisitor;", "<init>", "()V", "diagnosticRanges", "", "Lcom/intellij/openapi/util/TextRange;", "", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo$Builder;", "holder", "Lcom/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder;", "suitableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "visit", "", "element", "Lcom/intellij/psi/PsiElement;", "analyze", "updateWholeFile", "action", "Ljava/lang/Runnable;", "clone", "computeOffsets", "Lkotlin/Pair;", "", "document", "Lcom/intellij/openapi/editor/Document;", "position", "Lkotlin/script/experimental/api/SourceCode$Location;", "coerceLineIn", "offsetBy", "line", "col", "convertSeverity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "Lkotlin/script/experimental/api/ScriptDiagnostic$Severity;", "drainScriptReports", "", "Lkotlin/script/experimental/api/ScriptDiagnostic;", "Lorg/jetbrains/kotlin/psi/KtFile;", "intellij.kotlin.base.scripting"})
@SourceDebugExtension(value={"SMAP\nKotlinScriptHighlightingVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinScriptHighlightingVisitor.kt\norg/jetbrains/kotlin/idea/core/script/k2/highlighting/KotlinScriptHighlightingVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,145:1\n1642#2,10:146\n1915#2:156\n1915#2,2:157\n1916#2:160\n1652#2:161\n1#3:159\n81#4:162\n*S KotlinDebug\n*F\n+ 1 KotlinScriptHighlightingVisitor.kt\norg/jetbrains/kotlin/idea/core/script/k2/highlighting/KotlinScriptHighlightingVisitor\n*L\n58#1:146,10\n58#1:156\n80#1:157,2\n58#1:160\n58#1:161\n58#1:159\n134#1:162\n*E\n"})
public final class KotlinScriptHighlightingVisitor
implements HighlightVisitor {
    @Nullable
    private Map<TextRange, List<HighlightInfo.Builder>> diagnosticRanges;
    @Nullable
    private HighlightInfoHolder holder;

    public boolean suitableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof KtFile && ((KtFile)file).isScript();
    }

    public void visit(@NotNull PsiElement element) {
        Map<TextRange, List<HighlightInfo.Builder>> iterator2;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TextRange elementRange = element.getTextRange();
        Map<TextRange, List<HighlightInfo.Builder>> map2 = this.diagnosticRanges;
        if (map2 == null || (map2 = map2.entrySet().iterator()) == null) {
            return;
        }
        Map<TextRange, List<HighlightInfo.Builder>> map3 = iterator2 = map2;
        while (map3.hasNext()) {
            Map.Entry entry = (Map.Entry)map3.next();
            if (!elementRange.contains((TextRange)entry.getKey())) continue;
            List diagnostics = (List)entry.getValue();
            for (HighlightInfo.Builder builder2 : diagnostics) {
                HighlightInfoHolder highlightInfoHolder = this.holder;
                Intrinsics.checkNotNull((Object)highlightInfoHolder);
                highlightInfoHolder.add(builder2.create());
            }
            iterator2.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean analyze(@NotNull PsiFile file, boolean updateWholeFile, @NotNull HighlightInfoHolder holder2, @NotNull Runnable action2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        this.holder = holder2;
        try {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            KtFile ktFile2 = (KtFile)file;
            List<ScriptDiagnostic> reports = this.drainScriptReports((KtFile)file);
            Iterable iterable = reports;
            KotlinScriptHighlightingVisitor kotlinScriptHighlightingVisitor = this;
            boolean $i$f$mapNotNull = false;
            void var9_12 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Pair pair;
                Throwable exception;
                Pair<Integer, Integer> pair2;
                ScriptDiagnostic scriptDiagnostic;
                block17: {
                    block16: {
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        scriptDiagnostic = (ScriptDiagnostic)element$iv$iv;
                        boolean bl2 = false;
                        pair2 = scriptDiagnostic.getLocation();
                        if (pair2 == null) break block16;
                        Pair<Integer, Integer> it = pair2;
                        boolean bl3 = false;
                        Document document = ktFile2.getFileDocument();
                        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
                        Pair<Integer, Integer> pair3 = this.computeOffsets(document, (SourceCode.Location)it);
                        pair2 = pair3;
                        if (pair3 != null) break block17;
                    }
                    pair2 = TuplesKt.to((Object)0, (Object)0);
                }
                Pair<Integer, Integer> pair4 = pair2;
                int startOffset = ((Number)pair4.component1()).intValue();
                int endOffset = ((Number)pair4.component2()).intValue();
                Throwable throwable = exception = scriptDiagnostic.getException();
                Object exceptionMessage = throwable != null ? " (" + throwable + ")" : "";
                String message2 = scriptDiagnostic.getMessage() + (String)exceptionMessage;
                if (this.convertSeverity(scriptDiagnostic.getSeverity()) == null) {
                    pair = null;
                } else {
                    HighlightInfo.Builder annotation;
                    HighlightSeverity severity;
                    Intrinsics.checkNotNullExpressionValue((Object)HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfo.convertSeverity((HighlightSeverity)severity)).range(startOffset, endOffset).descriptionAndTooltip(message2), (String)"descriptionAndTooltip(...)");
                    if (startOffset == endOffset) {
                        annotation.fileLevelAnnotation();
                    }
                    for (ScriptDiagnosticFixProvider provider2 : ScriptDiagnosticFixProvider.Companion.getEP_NAME().getExtensionList()) {
                        Iterable $this$forEach$iv = provider2.provideFixes(scriptDiagnostic);
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv : $this$forEach$iv) {
                            IntentionAction it = (IntentionAction)element$iv;
                            boolean bl = false;
                            annotation.registerFix(it, null, null, null, null);
                        }
                    }
                    Object[] objectArray = new HighlightInfo.Builder[]{annotation};
                    pair = TuplesKt.to((Object)new TextRange(startOffset, endOffset), (Object)CollectionsKt.mutableListOf((Object[])objectArray));
                }
                if (pair == null) continue;
                Pair it$iv$iv = pair;
                boolean bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            kotlinScriptHighlightingVisitor.diagnosticRanges = MapsKt.toMutableMap((Map)MapsKt.toMap((Iterable)((List)destination$iv$iv)));
            action2.run();
        }
        catch (Throwable e) {
            if (Logger.shouldRethrow((Throwable)e)) {
                throw e;
            }
            throw e;
        }
        finally {
            this.diagnosticRanges = null;
            this.holder = null;
        }
        return true;
    }

    @NotNull
    public HighlightVisitor clone() {
        return new KotlinScriptHighlightingVisitor();
    }

    private final Pair<Integer, Integer> computeOffsets(Document document, SourceCode.Location position) {
        int n;
        int n2;
        Integer n3 = position.getStart().getAbsolutePos();
        if (n3 != null) {
            n2 = n3;
        } else {
            KotlinScriptHighlightingVisitor $this$computeOffsets_u24lambda_u240 = this;
            boolean bl = false;
            int startLine = $this$computeOffsets_u24lambda_u240.coerceLineIn(position.getStart().getLine(), document);
            n2 = $this$computeOffsets_u24lambda_u240.offsetBy(document, startLine, position.getStart().getCol());
        }
        int startOffset = n2;
        Serializable serializable = position.getEnd();
        if (serializable != null && (serializable = ((SourceCode.Position)serializable).getAbsolutePos()) != null) {
            n = (Integer)serializable;
        } else {
            int n4;
            KotlinScriptHighlightingVisitor $this$computeOffsets_u24lambda_u241 = this;
            boolean bl = false;
            int startLine = $this$computeOffsets_u24lambda_u241.coerceLineIn(position.getStart().getLine(), document);
            SourceCode.Position position2 = position.getEnd();
            if (position2 != null) {
                int n5 = RangesKt.coerceAtLeast((int)position2.getLine(), (int)startLine);
                n4 = $this$computeOffsets_u24lambda_u241.coerceLineIn(n5, document);
            } else {
                n4 = startLine;
            }
            int endLine = n4;
            SourceCode.Position position3 = position.getEnd();
            n = RangesKt.coerceAtLeast((int)$this$computeOffsets_u24lambda_u241.offsetBy(document, endLine, position3 != null ? position3.getCol() : document.getLineEndOffset(endLine)), (int)startOffset);
        }
        int endOffset = n;
        return TuplesKt.to((Object)startOffset, (Object)endOffset);
    }

    private final int coerceLineIn(int $this$coerceLineIn, Document document) {
        return RangesKt.coerceIn((int)$this$coerceLineIn, (int)0, (int)(document.getLineCount() - 1));
    }

    private final int offsetBy(Document $this$offsetBy, int line, int col) {
        return RangesKt.coerceIn((int)($this$offsetBy.getLineStartOffset(line) + col), (int)$this$offsetBy.getLineStartOffset(line), (int)$this$offsetBy.getLineEndOffset(line));
    }

    private final HighlightSeverity convertSeverity(ScriptDiagnostic.Severity $this$convertSeverity) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$convertSeverity.ordinal()]) {
            case 1 -> HighlightSeverity.ERROR;
            case 2 -> HighlightSeverity.ERROR;
            case 3 -> HighlightSeverity.WARNING;
            case 4 -> HighlightSeverity.INFORMATION;
            case 5 -> {
                boolean $i$f$isApplicationInternalMode = false;
                if (ApplicationManager.getApplication().isInternal()) {
                    yield HighlightSeverity.INFORMATION;
                }
                yield null;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final List<ScriptDiagnostic> drainScriptReports(KtFile file) {
        VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
        Object object = virtualFile;
        if (object == null || (object = ScriptDiagnosticsKt.getScriptDiagnostics(object)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object diagnostics = object;
        Intrinsics.checkNotNull((Object)virtualFile);
        ScriptDiagnosticsKt.setScriptDiagnostics(virtualFile, CollectionsKt.emptyList());
        return diagnostics;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScriptDiagnostic.Severity.values().length];
            try {
                nArray[ScriptDiagnostic.Severity.FATAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.INFO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.DEBUG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

