/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.shared;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.v1.ScriptingLoggerKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/shared/ScriptClassPathUtil;", "", "<init>", "()V", "Companion", "intellij.kotlin.base.scripting.shared"})
public final class ScriptClassPathUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u0004\u0018\u00010\u0005*\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/shared/ScriptClassPathUtil$Companion;", "", "<init>", "()V", "findVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "pathString", "", "refreshIfNeededAndFindFileByPath", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "path", "intellij.kotlin.base.scripting.shared"})
    @SourceDebugExtension(value={"SMAP\nScriptClassPathUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptClassPathUtil.kt\norg/jetbrains/kotlin/idea/core/script/shared/ScriptClassPathUtil$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final VirtualFile findVirtualFile(@NotNull String pathString) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)pathString, (String)"pathString");
            Path path2 = NioPathUtil.toNioPathOrNull((String)pathString);
            if (path2 == null) {
                ScriptingLoggerKt.scriptingWarnLog("Invalid classpath entry '" + pathString + "'");
                object = null;
            } else {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.notExists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    ScriptingLoggerKt.scriptingWarnLog("Invalid classpath entry '" + pathString + "', notExists=true");
                    object = null;
                } else {
                    LinkOption[] linkOptionArray2 = new LinkOption[]{};
                    if (Files.isDirectory(path2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                        VirtualFileSystem virtualFileSystem = StandardFileSystems.local();
                        object = virtualFileSystem != null ? this.refreshIfNeededAndFindFileByPath(virtualFileSystem, ((Object)path2).toString()) : null;
                    } else {
                        LinkOption[] linkOptionArray3 = new LinkOption[]{};
                        if (Files.isRegularFile(path2, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
                            VirtualFileSystem virtualFileSystem = StandardFileSystems.jar();
                            object = virtualFileSystem != null ? this.refreshIfNeededAndFindFileByPath(virtualFileSystem, ((Object)path2).toString() + "!/") : null;
                        } else {
                            ScriptingLoggerKt.scriptingWarnLog("Invalid classpath entry '" + pathString + "'");
                            object = null;
                        }
                    }
                }
            }
            return object;
        }

        private final VirtualFile refreshIfNeededAndFindFileByPath(VirtualFileSystem $this$refreshIfNeededAndFindFileByPath, String path2) {
            Application application = ApplicationManager.getApplication();
            VirtualFile virtualFile = $this$refreshIfNeededAndFindFileByPath.findFileByPath(path2);
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                return it;
            }
            if (application.isDispatchThread() || !application.isReadAccessAllowed()) {
                return $this$refreshIfNeededAndFindFileByPath.refreshAndFindFileByPath(path2);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

