/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u001a\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\n2\u0006\u0010\u0004\u001a\u00020\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"COMPOSABLE_SINGLETONS_PREFIX", "", "ANDROIDX_COMPOSE_PACKAGE_NAME", "computeComposableSingletonsClassName", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isInsideProjectWithCompose", "", "Lcom/intellij/debugger/SourcePosition;", "getComposableSingletonsClasses", "", "Lcom/sun/jdi/ReferenceType;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "getClassPrepareRequestPatternsForComposableSingletons", "intellij.kotlin.jvm.debugger.core"})
@SourceDebugExtension(value={"SMAP\ncomposeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 composeUtils.kt\norg/jetbrains/kotlin/idea/debugger/core/ComposeUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1391#2:66\n1480#2,5:67\n*S KotlinDebug\n*F\n+ 1 composeUtils.kt\norg/jetbrains/kotlin/idea/debugger/core/ComposeUtilsKt\n*L\n52#1:66\n52#1:67,5\n*E\n"})
public final class ComposeUtilsKt {
    @NotNull
    private static final String COMPOSABLE_SINGLETONS_PREFIX = "ComposableSingletons";
    @NotNull
    private static final String ANDROIDX_COMPOSE_PACKAGE_NAME = "androidx.compose";

    @NotNull
    public static final String computeComposableSingletonsClassName(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object object = file.getVirtualFile();
        if (object == null || (object = object.getPath()) == null) {
            String string = file.getName();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        }
        Object filePath = object;
        char[] cArray = new char[]{'/'};
        String fileName = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)((CharSequence)filePath), (char[])cArray, (boolean)false, (int)0, (int)6, null));
        String shortName = PackagePartClassUtils.getFilePartShortName((String)fileName);
        FqName fileClassFqName = ((JvmFileClassInfo)ActionsKt.runReadAction(() -> ComposeUtilsKt.computeComposableSingletonsClassName$lambda$0(file))).getFacadeClassFqName();
        String classNameSuffix = "ComposableSingletons$" + shortName;
        FqName filePackageName = fileClassFqName.parent();
        if (filePackageName.isRoot()) {
            return classNameSuffix;
        }
        return filePackageName.asString() + "." + classNameSuffix;
    }

    public static final boolean isInsideProjectWithCompose(@NotNull SourcePosition $this$isInsideProjectWithCompose) {
        Intrinsics.checkNotNullParameter((Object)$this$isInsideProjectWithCompose, (String)"<this>");
        Object object = ReadAction.nonBlocking(() -> ComposeUtilsKt.isInsideProjectWithCompose$lambda$0($this$isInsideProjectWithCompose)).executeSynchronously();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executeSynchronously(...)");
        return (Boolean)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ReferenceType> getComposableSingletonsClasses(@NotNull DebugProcess debugProcess, @NotNull KtFile file) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualMachineProxy vm = debugProcess.getVirtualMachineProxy();
        String composableSingletonsClassName = ComposeUtilsKt.computeComposableSingletonsClassName(file);
        List list2 = vm.classesByName(composableSingletonsClassName);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"classesByName(...)");
        Iterable $this$flatMap$iv = list2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ReferenceType referenceType = (ReferenceType)element$iv$iv;
            boolean bl = false;
            List list3 = referenceType.isPrepared() ? vm.nestedTypes(referenceType) : CollectionsKt.emptyList();
            Intrinsics.checkNotNull((Object)list3);
            Iterable list$iv$iv = list3;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<String> getClassPrepareRequestPatternsForComposableSingletons(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String composableSingletonsClassName = ComposeUtilsKt.computeComposableSingletonsClassName(file);
        Object[] objectArray = new String[]{composableSingletonsClassName, composableSingletonsClassName + "$*"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final JvmFileClassInfo computeComposableSingletonsClassName$lambda$0(KtFile $file) {
        return JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)$file);
    }

    private static final Boolean isInsideProjectWithCompose$lambda$0(SourcePosition $this_isInsideProjectWithCompose) {
        return JavaPsiFacade.getInstance((Project)$this_isInsideProjectWithCompose.getFile().getProject()).findPackage(ANDROIDX_COMPOSE_PACKAGE_NAME) != null;
    }
}

