/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DexDebugFacility;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.classFilter.ClassFilter;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedFunctionSymbol;
import org.jetbrains.kotlin.codegen.inline.InlineScopeUtilsKt;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.AnalyseUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.CoroutineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.InlineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.JvmNameUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.ClassNameProvider;
import org.jetbrains.kotlin.idea.debugger.core.CoroutineStateMachineVisitor;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.core.MockStackFrame;
import org.jetbrains.kotlin.idea.debugger.core.StackFrameUtilsKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0096\u0001\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0003\u001a\u0010\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005*\u00020\u0003\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0003\u001a\u0010\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005*\u00020\u0003\u001a\u001e\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0080@\u00a2\u0006\u0002\u0010\f\u001a\u001e\u0010\r\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0080@\u00a2\u0006\u0002\u0010\f\u001a$\u0010\r\u001a\u00020\u00012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\t\u001a\u00020\nH\u0082@\u00a2\u0006\u0002\u0010\u0011\u001a\u0018\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u001a1\u0010\u0016\u001a\u0004\u0018\u0001H\u0017\"\b\b\u0000\u0010\u0017*\u00020\u0018*\u00020\u00192\u0014\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u0001H\u00170\u001b\u00a2\u0006\u0002\u0010\u001d\u001a\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002\u001a\u0012\u0010\"\u001a\u0004\u0018\u00010\u00142\u0006\u0010#\u001a\u00020\nH\u0002\u001a\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u00022\u0006\u0010%\u001a\u00020&H\u0002\u001a\u0010\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u0014H\u0002\u001a\u0010\u0010)\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u0014H\u0002\u001a\n\u0010,\u001a\u00020\u0001*\u00020-\u001a\u000e\u0010.\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0002\u001a\u000e\u0010/\u001a\u00020\u00012\u0006\u00100\u001a\u000201\u001a\u0012\u00102\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0002\u001a\u000e\u00103\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0002\u001a\u0010\u00104\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0002H\u0002\u001a.\u00105\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00022\b\u0010(\u001a\u0004\u0018\u00010\u00142\b\u00106\u001a\u0004\u0018\u00010\u00142\b\u00107\u001a\u0004\u0018\u00010\u0014H\u0002\u001a\u0012\u00108\u001a\u0004\u0018\u00010\u00022\b\u00109\u001a\u0004\u0018\u00010\u0002\u001a\u0012\u0010:\u001a\u0004\u0018\u00010\u00022\b\u0010;\u001a\u0004\u0018\u00010\u0002\u001a\u0012\u0010<\u001a\u00020\u00012\b\u00100\u001a\u0004\u0018\u000101H\u0000\u001a\u0018\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u001f\u001a\u000e\u0010B\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0002\u001a\u001c\u0010C\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020E0D*\u000201\u001a\u0010\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00100G*\u000201\u001a\u0016\u0010N\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010O\u001a\u00020P\"\u000e\u0010*\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010+\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010H\u001a\u00020\u0001*\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\bI\u0010J\"\u0015\u0010K\u001a\u00020\u0001*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\bK\u0010L\"\u0015\u0010M\u001a\u00020\u0001*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\bM\u0010L\u00a8\u0006Q"}, d2={"isInKotlinSources", "", "Lcom/sun/jdi/Location;", "Lcom/sun/jdi/ReferenceType;", "isInKotlinSourcesAsync", "Ljava/util/concurrent/CompletableFuture;", "containsKotlinStrata", "containsKotlinStrataAsync", "isInsideInlineArgument", "inlineArgument", "Lorg/jetbrains/kotlin/psi/KtExpression;", "location", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lcom/sun/jdi/Location;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isInlinedArgument", "localVariables", "", "Lcom/sun/jdi/LocalVariable;", "(Ljava/util/List;Lorg/jetbrains/kotlin/psi/KtExpression;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "nameMatchesUpToDollar", "methodName", "", "targetMethodName", "invokeInManagerThread", "T", "", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "f", "Lkotlin/Function1;", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "(Lcom/intellij/debugger/engine/DebugProcessImpl;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "lambdaOrdinalByArgument", "", "elementAt", "Lorg/jetbrains/kotlin/psi/KtFunction;", "functionNameByArgument", "argument", "visibleVariables", "virtualMachine", "Lcom/sun/jdi/VirtualMachine;", "lambdaOrdinalByLocalVariable", "name", "functionNameByLocalVariable", "INVOKE_SUSPEND_SIGNATURE", "CONTINUATION_VARIABLE_NAME", "isOnSuspensionPoint", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "isInSuspendMethod", "isInvokeSuspendMethod", "method", "Lcom/sun/jdi/Method;", "getFirstMethodLocation", "isOnSuspendReturnOrReenter", "doesMethodHaveSwitcher", "checkContinuationLabelField", "descriptor", "owner", "getLocationOfCoroutineSuspendReturn", "resumedLocation", "getLocationOfNextInstructionAfterResume", "resumeLocation", "hasUserCodeOnFirstLine", "findElementAtLine", "Lcom/intellij/psi/PsiElement;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "line", "isKotlinFakeLineNumber", "getInlineFunctionAndArgumentVariablesToBordersMap", "", "Lkotlin/ranges/ClosedRange;", "getInlineFunctionOrArgumentVariables", "Lkotlin/sequences/Sequence;", "canRunEvaluation", "getCanRunEvaluation", "(Lcom/intellij/debugger/engine/DebugProcessImpl;)Z", "isInlineFunctionMarkerVariableName", "(Ljava/lang/String;)Z", "isInlineLambdaMarkerVariableName", "isLocationFiltered", "positionManager", "Lcom/intellij/debugger/PositionManager;", "intellij.kotlin.jvm.debugger.core"})
@JvmName(name="DebuggerUtil")
@SourceDebugExtension(value={"SMAP\ndebuggerUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 debuggerUtil.kt\norg/jetbrains/kotlin/idea/debugger/core/DebuggerUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,611:1\n1586#2:612\n1661#2,3:613\n777#2:616\n873#2,2:617\n1807#2,3:619\n1586#2:622\n1661#2,3:623\n231#2,2:626\n777#2:628\n873#2,2:629\n1786#2,3:631\n975#2,7:634\n1834#2,3:641\n1807#2,3:644\n1837#2:647\n1807#2,3:648\n1586#2:652\n1661#2,3:653\n1807#2,2:656\n1807#2,3:658\n1809#2:661\n1586#2:662\n1661#2,3:663\n1#3:651\n*S KotlinDebug\n*F\n+ 1 debuggerUtil.kt\norg/jetbrains/kotlin/idea/debugger/core/DebuggerUtil\n*L\n92#1:612\n92#1:613,3\n93#1:616\n93#1:617,2\n269#1:619,3\n500#1:622\n500#1:623,3\n500#1:626,2\n515#1:628\n515#1:629,2\n519#1:631,3\n520#1:634,7\n525#1:641,3\n525#1:644,3\n525#1:647\n609#1:648,3\n101#1:652\n101#1:653,3\n102#1:656,2\n105#1:658,3\n102#1:661\n606#1:662\n606#1:663,3\n*E\n"})
public final class DebuggerUtil {
    @NotNull
    private static final String INVOKE_SUSPEND_SIGNATURE = "(Ljava/lang/Object;)Ljava/lang/Object;";
    @NotNull
    private static final String CONTINUATION_VARIABLE_NAME = "$continuation";

    public static final boolean isInKotlinSources(@NotNull Location $this$isInKotlinSources) {
        Intrinsics.checkNotNullParameter((Object)$this$isInKotlinSources, (String)"<this>");
        ReferenceType referenceType = $this$isInKotlinSources.declaringType();
        Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"declaringType(...)");
        return DebuggerUtil.isInKotlinSources(referenceType);
    }

    public static final boolean isInKotlinSources(@NotNull ReferenceType $this$isInKotlinSources) {
        String string;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$isInKotlinSources, (String)"<this>");
                string = SafeUtilKt.safeSourceName($this$isInKotlinSources);
                if (string == null || (string = StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null)) == null) break block2;
                String string2 = string;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                string = string3;
                if (string3 != null) break block3;
            }
            string = "";
        }
        String fileExtension = string;
        return ProjectStructureUtils.getKOTLIN_FILE_EXTENSIONS().contains(fileExtension) || DebuggerUtil.containsKotlinStrata($this$isInKotlinSources);
    }

    @NotNull
    public static final CompletableFuture<Boolean> isInKotlinSourcesAsync(@NotNull ReferenceType $this$isInKotlinSourcesAsync) {
        Intrinsics.checkNotNullParameter((Object)$this$isInKotlinSourcesAsync, (String)"<this>");
        CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)DebuggerUtilsAsync.sourceName((ReferenceType)$this$isInKotlinSourcesAsync).thenApply(arg_0 -> DebuggerUtil.isInKotlinSourcesAsync$lambda$1(DebuggerUtil::isInKotlinSourcesAsync$lambda$0, arg_0))).exceptionally(DebuggerUtil::isInKotlinSourcesAsync$lambda$2)).thenCombine(DebuggerUtil.containsKotlinStrataAsync($this$isInKotlinSourcesAsync), (arg_0, arg_1) -> DebuggerUtil.isInKotlinSourcesAsync$lambda$4(DebuggerUtil::isInKotlinSourcesAsync$lambda$3, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenCombine(...)");
        return completionStage;
    }

    public static final boolean containsKotlinStrata(@NotNull ReferenceType $this$containsKotlinStrata) {
        Intrinsics.checkNotNullParameter((Object)$this$containsKotlinStrata, (String)"<this>");
        return $this$containsKotlinStrata.availableStrata().contains("Kotlin");
    }

    @NotNull
    public static final CompletableFuture<Boolean> containsKotlinStrataAsync(@NotNull ReferenceType $this$containsKotlinStrataAsync) {
        Intrinsics.checkNotNullParameter((Object)$this$containsKotlinStrataAsync, (String)"<this>");
        CompletionStage completionStage = DebuggerUtilsAsync.availableStrata((ReferenceType)$this$containsKotlinStrataAsync).thenApply(arg_0 -> DebuggerUtil.containsKotlinStrataAsync$lambda$1(DebuggerUtil::containsKotlinStrataAsync$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenApply(...)");
        return completionStage;
    }

    @Nullable
    public static final Object isInsideInlineArgument(@NotNull KtExpression inlineArgument, @NotNull Location location, @NotNull Continuation<? super Boolean> $completion) {
        VirtualMachine virtualMachine = location.virtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"virtualMachine(...)");
        return DebuggerUtil.isInlinedArgument(DebuggerUtil.visibleVariables(location, virtualMachine), inlineArgument, $completion);
    }

    @Nullable
    public static final Object isInlinedArgument(@NotNull KtExpression inlineArgument, @NotNull Location location, @NotNull Continuation<? super Boolean> $completion) {
        Method method = location.method();
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method(...)");
        List list2 = SafeUtilKt.safeVariables(method);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return DebuggerUtil.isInlinedArgument(list2, inlineArgument, $completion);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object isInlinedArgument(List<? extends LocalVariable> localVariables, KtExpression inlineArgument, Continuation<? super Boolean> $completion) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        if (!(inlineArgument instanceof KtFunction) && !(inlineArgument instanceof KtCallableReferenceExpression)) {
            return Boxing.boxBoolean((boolean)false);
        }
        Iterable iterable = localVariables;
        boolean $i$f$map = false;
        void var6_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            LocalVariable localVariable = (LocalVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.name());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!StringsKt.startsWith$default((String)it, (String)"$i$a$", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List markerLocalVariables = (List)destination$iv$iv;
        if (markerLocalVariables.isEmpty()) {
            return Boxing.boxBoolean((boolean)false);
        }
        return CoroutinesKt.readAction(() -> DebuggerUtil.isInlinedArgument$lambda$2(inlineArgument, markerLocalVariables), $completion);
    }

    public static final boolean nameMatchesUpToDollar(@NotNull String methodName, @NotNull String targetMethodName) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)targetMethodName, (String)"targetMethodName");
        return StringsKt.startsWith$default((String)methodName, (String)(targetMethodName + "$"), (boolean)false, (int)2, null);
    }

    @Nullable
    public static final <T> T invokeInManagerThread(@NotNull DebugProcessImpl $this$invokeInManagerThread, @NotNull Function1<? super DebuggerContextImpl, ? extends T> f) {
        Intrinsics.checkNotNullParameter((Object)$this$invokeInManagerThread, (String)"<this>");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        if (DebuggerManagerThreadImpl.Companion.isManagerThread()) {
            DebuggerContextImpl debuggerContextImpl = $this$invokeInManagerThread.getDebuggerContext();
            Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl, (String)"getDebuggerContext(...)");
            return (T)f.invoke((Object)debuggerContextImpl);
        }
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        DebuggerManagerThreadImpl debuggerManagerThreadImpl = $this$invokeInManagerThread.getDebuggerContext().getManagerThread();
        if (debuggerManagerThreadImpl == null) {
            DebuggerManagerThreadImpl debuggerManagerThreadImpl2 = $this$invokeInManagerThread.getManagerThread();
            debuggerManagerThreadImpl = debuggerManagerThreadImpl2;
            Intrinsics.checkNotNullExpressionValue((Object)debuggerManagerThreadImpl2, (String)"getManagerThread(...)");
        }
        DebuggerManagerThreadImpl managerThread = debuggerManagerThreadImpl;
        DebuggerContextImpl debuggerContextImpl = $this$invokeInManagerThread.getDebuggerContext();
        managerThread.invokeAndWait((DebuggerCommandImpl)new DebuggerContextCommandImpl(result2, f, debuggerContextImpl){
            final /* synthetic */ Ref.ObjectRef<T> $result;
            final /* synthetic */ Function1<DebuggerContextImpl, T> $f;
            {
                this.$result = $result;
                this.$f = $f;
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($super_call_param$1, null, 2, null);
            }

            public void threadAction(SuspendContextImpl suspendContext) {
                Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                this.$result.element = this.$f.invoke((Object)this.getDebuggerContext());
            }
        });
        return (T)result2.element;
    }

    private static final int lambdaOrdinalByArgument(KtFunction elementAt) {
        String string = (String)CollectionsKt.firstOrNull(new ClassNameProvider(ClassNameProvider.Configuration.Companion.getSTOP_AT_LAMBDA()).getCandidatesForElement((PsiElement)elementAt));
        if (string == null) {
            return 0;
        }
        String className = string;
        Integer n = StringsKt.toIntOrNull((String)StringsKt.substringAfterLast$default((String)className, (String)"$", null, (int)2, null));
        return n != null ? n : 0;
    }

    private static final String functionNameByArgument(KtExpression argument2) {
        return AnalyseUtilsKt.runDumbAnalyze((KtElement)argument2, null, arg_0 -> DebuggerUtil.functionNameByArgument$lambda$0(argument2, arg_0));
    }

    private static final List<LocalVariable> visibleVariables(Location $this$visibleVariables, VirtualMachine virtualMachine) {
        MockStackFrame stackFrame = new MockStackFrame($this$visibleVariables, virtualMachine);
        return stackFrame.visibleVariables();
    }

    private static final int lambdaOrdinalByLocalVariable(String name2) {
        int n;
        try {
            String nameWithoutPrefix = StringsKt.removePrefix((String)name2, (CharSequence)"$i$a$");
            n = Integer.parseInt(StringsKt.substringBefore((String)nameWithoutPrefix, (String)"$", (String)nameWithoutPrefix));
        }
        catch (NumberFormatException e) {
            n = 0;
        }
        return n;
    }

    private static final String functionNameByLocalVariable(String name2) {
        String nameWithoutPrefix = StringsKt.removePrefix((String)name2, (CharSequence)"$i$a$");
        return StringsKt.substringAfterLast((String)nameWithoutPrefix, (String)"$", (String)"unknown");
    }

    public static final boolean isOnSuspensionPoint(@NotNull StackFrameProxyImpl $this$isOnSuspensionPoint) {
        Intrinsics.checkNotNullParameter((Object)$this$isOnSuspensionPoint, (String)"<this>");
        Location location = SafeUtilKt.safeLocation((StackFrameProxy)$this$isOnSuspensionPoint);
        if (location == null) {
            return false;
        }
        Location location2 = location;
        if (DebuggerUtil.isInSuspendMethod(location2)) {
            Location location3 = DebuggerUtil.getFirstMethodLocation(location2);
            if (location3 == null) {
                return false;
            }
            Location firstLocation = location3;
            return firstLocation.codeIndex() != location2.codeIndex() && DebuggerUtil.isOnSuspendReturnOrReenter(location2);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInSuspendMethod(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Method method = location.method();
        String signature = method.signature();
        Intrinsics.checkNotNull((Object)signature);
        CharSequence charSequence = signature;
        String string = CoroutineUtilsKt.getCONTINUATION_TYPE().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) return true;
        Intrinsics.checkNotNull((Object)method);
        if (!DebuggerUtil.isInvokeSuspendMethod(method)) return false;
        return true;
    }

    public static final boolean isInvokeSuspendMethod(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return Intrinsics.areEqual((Object)method.name(), (Object)"invokeSuspend") && Intrinsics.areEqual((Object)method.signature(), (Object)INVOKE_SUSPEND_SIGNATURE);
    }

    private static final Location getFirstMethodLocation(Location location) {
        Mirror mirror = SafeUtilKt.safeMethod(location);
        if (mirror == null || (mirror = mirror.location()) == null) {
            return null;
        }
        Mirror firstLocation = mirror;
        if (SafeUtilKt.safeLineNumber((Location)firstLocation) < 0) {
            return null;
        }
        return firstLocation;
    }

    public static final boolean isOnSuspendReturnOrReenter(@NotNull Location location) {
        boolean isAtFirstLine;
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Location location2 = DebuggerUtil.getFirstMethodLocation(location);
        if (location2 == null) {
            return false;
        }
        Location firstLocation = location2;
        boolean bl = isAtFirstLine = SafeUtilKt.safeLineNumber(firstLocation) == SafeUtilKt.safeLineNumber(location);
        if (isAtFirstLine) {
            return DebuggerUtil.doesMethodHaveSwitcher(location);
        }
        return false;
    }

    private static final boolean doesMethodHaveSwitcher(Location location) {
        VirtualMachine virtualMachine = location.virtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"virtualMachine(...)");
        if (DexDebugFacility.INSTANCE.isDex(virtualMachine)) {
            boolean bl;
            block7: {
                Method method = SafeUtilKt.safeMethod(location);
                if (method == null) {
                    return false;
                }
                Method method2 = method;
                if (DebuggerUtil.isInvokeSuspendMethod(method2)) {
                    return true;
                }
                List<LocalVariable> list2 = SafeUtilKt.safeVariables(method2);
                if (list2 == null) {
                    return false;
                }
                List<LocalVariable> variables = list2;
                Iterable $this$any$iv = variables;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        LocalVariable it = (LocalVariable)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.name(), (Object)CONTINUATION_VARIABLE_NAME)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        MethodBytecodeUtil.visit((Method)location.method(), (MethodVisitor)new MethodVisitor(result2, location){
            final /* synthetic */ Ref.BooleanRef $result;
            final /* synthetic */ Location $location;
            {
                this.$result = $result;
                this.$location = $location;
                super(589824);
            }

            public void visitFieldInsn(int opcode, String owner, String name2, String descriptor2) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                if (!this.$result.element && DebuggerUtil.access$checkContinuationLabelField(this.$location, name2, descriptor2, owner)) {
                    this.$result.element = true;
                }
            }
        }, (boolean)false);
        return result2.element;
    }

    private static final boolean checkContinuationLabelField(Location location, String name2, String descriptor2, String owner) {
        if (name2 == null || descriptor2 == null || owner == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)name2, (Object)"label") && Intrinsics.areEqual((Object)descriptor2, (Object)"I")) {
            String className = Type.getObjectType((String)owner).getClassName();
            String methodClassName = location.method().declaringType().name();
            if (DebuggerUtil.isInSuspendMethod(location)) {
                Intrinsics.checkNotNull((Object)className);
                Intrinsics.checkNotNull((Object)methodClassName);
                if (StringsKt.startsWith$default((String)className, (String)methodClassName, (boolean)false, (int)2, null)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public static final Location getLocationOfCoroutineSuspendReturn(@Nullable Location resumedLocation) {
        Comparable<Location> comparable = resumedLocation;
        if (comparable == null || (comparable = SafeUtilKt.safeMethod((Location)comparable)) == null) {
            return null;
        }
        Comparable<Location> resumedMethod = comparable;
        VirtualMachine virtualMachine = resumedMethod.virtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"virtualMachine(...)");
        if (DexDebugFacility.INSTANCE.isDex(virtualMachine)) {
            return null;
        }
        CoroutineStateMachineVisitor visitor2 = new CoroutineStateMachineVisitor((Method)resumedMethod, resumedLocation);
        MethodBytecodeUtil.visit(resumedMethod, (MethodVisitor)((MethodVisitor)visitor2), (boolean)true);
        return resumedMethod.locationOfCodeIndex(visitor2.getFirstReturnAfterSuspensionOffset());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Location getLocationOfNextInstructionAfterResume(@Nullable Location resumeLocation) {
        Comparable<Location> comparable = resumeLocation;
        if (comparable == null || (comparable = SafeUtilKt.safeMethod((Location)comparable)) == null) {
            return null;
        }
        Comparable<Location> resumedMethod = comparable;
        VirtualMachine virtualMachine = resumedMethod.virtualMachine();
        Intrinsics.checkNotNullExpressionValue((Object)virtualMachine, (String)"virtualMachine(...)");
        if (DexDebugFacility.INSTANCE.isDex(virtualMachine)) {
            return null;
        }
        CoroutineStateMachineVisitor visitor2 = new CoroutineStateMachineVisitor((Method)resumedMethod, resumeLocation);
        MethodBytecodeUtil.visit(resumedMethod, (MethodVisitor)((MethodVisitor)visitor2), (boolean)true);
        Location nextCallLocation = resumedMethod.locationOfCodeIndex(visitor2.getNextCallOffset());
        if (visitor2.getNextCallOffset() == -1) {
            StackFrameUtilsKt.getLOG().debug("[coroutine-debug] Failed to find nextCallOffset in resumeMethod " + resumedMethod);
            return null;
        }
        Intrinsics.checkNotNull((Object)nextCallLocation);
        int n = SafeUtilKt.safeLineNumber(nextCallLocation);
        List<Location> list2 = resumedMethod.allLineLocations();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"allLineLocations(...)");
        if (n == ((Location)CollectionsKt.first(list2)).lineNumber()) {
            Object element$iv2;
            block7: {
                void $this$first$iv;
                void $this$mapTo$iv$iv;
                List<Location> list3 = resumedMethod.allLineLocations();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"allLineLocations(...)");
                Iterable $this$map$iv = list3;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Location location = (Location)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.codeIndex());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    long it = ((Number)element$iv2).longValue();
                    boolean bl = false;
                    if (!(it > (long)visitor2.getNextCallOffset())) continue;
                    break block7;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            long nextOffset = ((Number)element$iv2).longValue();
            StackFrameUtilsKt.getLOG().debug("[coroutine-debug] nextCallOffset = " + visitor2.getNextCallOffset() + " points to the first line of resumeMethod " + resumedMethod + ".");
            if (nextOffset != -1L) {
                Location nextLocation = resumedMethod.locationOfCodeIndex(nextOffset);
                StackFrameUtilsKt.getLOG().debug("[coroutine-debug] Trying to stop at the next location at line " + nextLocation + ".");
                return nextLocation;
            }
        }
        return resumedMethod.locationOfCodeIndex(visitor2.getNextCallOffset());
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean hasUserCodeOnFirstLine(@Nullable Method method) {
        int n;
        void $this$count$iv;
        List firstLineLocations;
        boolean bl;
        int firstLine;
        List nonFakeLocations;
        Location it;
        block17: {
            void $this$filterTo$iv$iv;
            if (method == null) {
                return false;
            }
            List<Location> allLineLocations = SafeUtilKt.safeAllLineLocations(method);
            if (allLineLocations.isEmpty()) {
                return false;
            }
            Iterable $this$filter$iv = allLineLocations;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Location)element$iv$iv;
                boolean bl2 = false;
                if (!(!DebuggerUtil.isKotlinFakeLineNumber(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            nonFakeLocations = (List)destination$iv$iv;
            Location location = (Location)CollectionsKt.firstOrNull((List)nonFakeLocations);
            if (location == null) {
                return false;
            }
            firstLine = location.lineNumber();
            if (firstLine < 0) {
                return false;
            }
            Iterable $this$all$iv = nonFakeLocations;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Location it2 = (Location)element$iv;
                    boolean bl3 = false;
                    if (it2.lineNumber() == firstLine) continue;
                    bl = false;
                    break block17;
                }
                bl = true;
            }
        }
        if (bl) {
            return true;
        }
        Iterable $this$takeWhile$iv = nonFakeLocations;
        boolean $i$f$takeWhile = false;
        Iterable list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            it = (Location)item$iv;
            boolean bl4 = false;
            if (!(it.lineNumber() == firstLine)) break;
            ((ArrayList)list$iv).add(item$iv);
        }
        if ((firstLineLocations = (List)list$iv).isEmpty()) {
            return false;
        }
        Collection<ClosedRange<Location>> inlineFunctionBorders = DebuggerUtil.getInlineFunctionAndArgumentVariablesToBordersMap(method).values();
        list$iv = firstLineLocations;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                boolean bl5;
                block18: {
                    Location loc = (Location)element$iv;
                    boolean bl6 = false;
                    Iterable $this$any$iv = inlineFunctionBorders;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl5 = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            ClosedRange it3 = (ClosedRange)element$iv2;
                            boolean bl7 = false;
                            if (!it3.contains((Comparable)loc)) continue;
                            bl5 = true;
                            break block18;
                        }
                        bl5 = false;
                    }
                }
                if (!(!bl5) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int validLocations = n;
        return validLocations > 1;
    }

    @Nullable
    public static final PsiElement findElementAtLine(@NotNull KtFile file, int line) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Integer n = PsiLinesUtilsKt.getLineStartOffset((PsiFile)file, line);
        if (n == null) {
            return null;
        }
        int lineStartOffset = n;
        Integer n2 = PsiLinesUtilsKt.getLineEndOffset((PsiFile)file, line);
        if (n2 == null) {
            return null;
        }
        int lineEndOffset = n2;
        return (PsiElement)ActionsKt.runReadAction(() -> DebuggerUtil.findElementAtLine$lambda$0(lineStartOffset, lineEndOffset, file));
    }

    public static final boolean isKotlinFakeLineNumber(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        try {
            if (location.lineNumber("Kotlin") == 1 && Intrinsics.areEqual((Object)location.sourceName("Kotlin"), (Object)"fake.kt") && Intrinsics.areEqual((Object)Path.of(location.sourcePath("Kotlin"), new String[0]), (Object)Path.of("kotlin/jvm/internal/FakeKt", new String[0]))) {
                return true;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return false;
    }

    @NotNull
    public static final Map<LocalVariable, ClosedRange<Location>> getInlineFunctionAndArgumentVariablesToBordersMap(@NotNull Method $this$getInlineFunctionAndArgumentVariablesToBordersMap) {
        Intrinsics.checkNotNullParameter((Object)$this$getInlineFunctionAndArgumentVariablesToBordersMap, (String)"<this>");
        return MapsKt.toMap((Sequence)SequencesKt.mapNotNull(DebuggerUtil.getInlineFunctionOrArgumentVariables($this$getInlineFunctionAndArgumentVariablesToBordersMap), DebuggerUtil::getInlineFunctionAndArgumentVariablesToBordersMap$lambda$0));
    }

    @NotNull
    public static final Sequence<LocalVariable> getInlineFunctionOrArgumentVariables(@NotNull Method $this$getInlineFunctionOrArgumentVariables) {
        Intrinsics.checkNotNullParameter((Object)$this$getInlineFunctionOrArgumentVariables, (String)"<this>");
        List<LocalVariable> list2 = SafeUtilKt.safeVariables($this$getInlineFunctionOrArgumentVariables);
        if (list2 == null) {
            return SequencesKt.emptySequence();
        }
        List<LocalVariable> localVariables = list2;
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)localVariables), DebuggerUtil::getInlineFunctionOrArgumentVariables$lambda$0);
    }

    public static final boolean getCanRunEvaluation(@NotNull DebugProcessImpl $this$canRunEvaluation) {
        Intrinsics.checkNotNullParameter((Object)$this$canRunEvaluation, (String)"<this>");
        return $this$canRunEvaluation.getSuspendManager().getPausedContext() != null;
    }

    public static final boolean isInlineFunctionMarkerVariableName(@NotNull String $this$isInlineFunctionMarkerVariableName) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineFunctionMarkerVariableName, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$isInlineFunctionMarkerVariableName, (String)"$i$f$", (boolean)false, (int)2, null);
    }

    public static final boolean isInlineLambdaMarkerVariableName(@NotNull String $this$isInlineLambdaMarkerVariableName) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineLambdaMarkerVariableName, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$isInlineLambdaMarkerVariableName, (String)"$i$a$", (boolean)false, (int)2, null);
    }

    public static final boolean isLocationFiltered(@NotNull Location location, @NotNull PositionManager positionManager) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)positionManager, (String)"positionManager");
            SourcePosition sourcePosition = SafeUtilKt.safeGetSourcePosition(positionManager, location);
            if (sourcePosition == null) {
                return false;
            }
            SourcePosition sourcePosition2 = sourcePosition;
            DebuggerSettings settings2 = DebuggerSettings.getInstance();
            if (!settings2.TRACING_FILTERS_ENABLED) {
                return false;
            }
            List classNames = (List)ActionsKt.runReadAction(() -> DebuggerUtil.isLocationFiltered$lambda$0(sourcePosition2));
            Iterable $this$any$iv = classNames;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!DebuggerUtilsEx.isFiltered((String)it, (ClassFilter[])settings2.getSteppingFilters())) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final Boolean isInKotlinSourcesAsync$lambda$0(String it) {
        String string;
        block3: {
            block2: {
                string = it;
                if (string == null || (string = StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null)) == null) break block2;
                String string2 = string;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                string = string3;
                if (string3 != null) break block3;
            }
            string = "";
        }
        String fileExtension = string;
        return ProjectStructureUtils.getKOTLIN_FILE_EXTENSIONS().contains(fileExtension);
    }

    private static final Boolean isInKotlinSourcesAsync$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Boolean isInKotlinSourcesAsync$lambda$2(Throwable it) {
        if (!(DebuggerUtilsAsync.unwrap((Throwable)it) instanceof AbsentInformationException)) {
            Intrinsics.checkNotNull((Object)it);
            throw it;
        }
        return false;
    }

    private static final Boolean isInKotlinSourcesAsync$lambda$3(Boolean kotlinExt, Boolean kotlinStrata) {
        return kotlinExt != false || kotlinStrata != false;
    }

    private static final Boolean isInKotlinSourcesAsync$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        return (Boolean)$tmp0.invoke(p0, p1);
    }

    private static final Boolean containsKotlinStrataAsync$lambda$0(List it) {
        return it.contains("Kotlin");
    }

    private static final Boolean containsKotlinStrataAsync$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isInlinedArgument$lambda$2(KtExpression $inlineArgument, List $markerLocalVariables) {
        boolean bl;
        block13: {
            void $this$any$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            String string;
            Integer lambdaOrdinal;
            KtFunction ktFunction = $inlineArgument instanceof KtFunction ? (KtFunction)$inlineArgument : null;
            if (ktFunction != null) {
                KtFunction it = ktFunction;
                boolean bl2 = false;
                v1 = DebuggerUtil.lambdaOrdinalByArgument(it);
            } else {
                v1 = lambdaOrdinal = null;
            }
            if ((string = DebuggerUtil.functionNameByArgument($inlineArgument)) == null) {
                string = "unknown";
            }
            String functionName = string;
            Iterable iterable = $markerLocalVariables;
            boolean $i$f$map = false;
            void bl2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(StringsKt.drop((String)it, (int)5));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl4;
                    block12: {
                        String variableName = (String)element$iv;
                        boolean bl5 = false;
                        if (StringsKt.startsWith$default((String)variableName, (String)"-", (boolean)false, (int)2, null)) {
                            String cleanedVarName = StringsKt.removePrefix((String)InlineScopeUtilsKt.dropInlineScopeInfo((String)InlineUtilsKt.dropInlineSuffix(variableName)), (CharSequence)"-");
                            Iterable $this$any$iv2 = new ClassNameProvider(ClassNameProvider.Configuration.Companion.getSTOP_AT_LAMBDA()).getCandidatesForElement((PsiElement)$inlineArgument);
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl4 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv2) {
                                    String candidateMethodName;
                                    String lambdaClassNameCandidate = (String)element$iv2;
                                    boolean bl6 = false;
                                    String lambdaClassName = StringsKt.substringAfterLast$default((String)lambdaClassNameCandidate, (char)'.', null, (int)2, null);
                                    if (!(!StringsKt.endsWith$default((String)cleanedVarName, (String)("-" + lambdaClassName), (boolean)false, (int)2, null) ? false : Intrinsics.areEqual((Object)(candidateMethodName = StringsKt.removeSuffix((String)cleanedVarName, (CharSequence)("-" + lambdaClassName))), (Object)functionName) || DebuggerUtil.nameMatchesUpToDollar(candidateMethodName, functionName))) continue;
                                    bl4 = true;
                                    break block12;
                                }
                                bl4 = false;
                            }
                        } else {
                            Integer n = lambdaOrdinal;
                            bl4 = n != null && DebuggerUtil.lambdaOrdinalByLocalVariable(variableName) == n && Intrinsics.areEqual((Object)DebuggerUtil.functionNameByLocalVariable(variableName), (Object)functionName);
                        }
                    }
                    if (!bl4) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final String functionNameByArgument$lambda$0(KtExpression $argument, KaSession $this$f) {
        Intrinsics.checkNotNullParameter((Object)$this$f, (String)"$this$f");
        KaFunctionSymbol kaFunctionSymbol = org.jetbrains.kotlin.idea.codeinsight.utils.InlineUtilsKt.getFunctionSymbol($this$f, $argument);
        KaNamedFunctionSymbol kaNamedFunctionSymbol = kaFunctionSymbol instanceof KaNamedFunctionSymbol ? (KaNamedFunctionSymbol)kaFunctionSymbol : null;
        if (kaNamedFunctionSymbol == null) {
            return null;
        }
        KaNamedFunctionSymbol function = kaNamedFunctionSymbol;
        return function.getName().asString();
    }

    private static final PsiElement findElementAtLine$lambda$0(int $lineStartOffset, int $lineEndOffset, KtFile $file) {
        PsiElement topMostElement = null;
        PsiElement elementAt = null;
        for (int offset = $lineStartOffset; !(offset >= $lineEndOffset || (elementAt = $file.findElementAt(offset)) != null && (topMostElement = KotlinPsiUtils.getTopmostElementAtOffset(elementAt, offset)) instanceof KtElement); ++offset) {
        }
        return topMostElement;
    }

    private static final Pair getInlineFunctionAndArgumentVariablesToBordersMap$lambda$0(LocalVariable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ClosedRange<Location> borders = DebuggerUtils.INSTANCE.getBorders(it);
        return borders == null ? null : TuplesKt.to((Object)it, borders);
    }

    private static final boolean getInlineFunctionOrArgumentVariables$lambda$0(LocalVariable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        return JvmAbi.isFakeLocalVariableForInline((String)string);
    }

    /*
     * WARNING - void declaration
     */
    private static final List isLocationFiltered$lambda$0(SourcePosition $sourcePosition) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = new ClassNameProvider(null, 1, null).getCandidates($sourcePosition);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JvmNameUtilsKt.internalNameToFqn((String)it));
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ boolean access$checkContinuationLabelField(Location location, String name2, String descriptor2, String owner) {
        return DebuggerUtil.checkContinuationLabelField(location, name2, descriptor2, owner);
    }

    public static final /* synthetic */ Object access$isInlinedArgument(List localVariables, KtExpression inlineArgument, Continuation $completion) {
        return DebuggerUtil.isInlinedArgument(localVariables, inlineArgument, (Continuation<? super Boolean>)$completion);
    }
}

