/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsAsync;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.jdi.LocalVariableImpl;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.asJava.finder.JavaElementFinder;
import org.jetbrains.kotlin.codegen.inline.FileMapping;
import org.jetbrains.kotlin.codegen.inline.RangeMapping;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.indices.KotlinPackageIndexUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.AnalyseUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.JvmNameUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.KotlinSourceMapCache;
import org.jetbrains.kotlin.idea.debugger.core.ClassNameProvider;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils$isInCrossInlineArgument$;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.FileApplicabilityChecker;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerLegacyFacade;
import org.jetbrains.kotlin.idea.stubindex.KotlinFileFacadeFqNameIndex;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016JB\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0080@\u00a2\u0006\u0004\b\u001c\u0010\u001dJM\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00192\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u001f\u001a\u00020\u00052\b\b\u0002\u0010 \u001a\u00020\u0005H\u0001\u00a2\u0006\u0002\b!J*\u0010\"\u001a\u0004\u0018\u00010\u000e2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0080@\u00a2\u0006\u0004\b$\u0010%J.\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00192\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u0012H\u0002J9\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019H\u0000\u00a2\u0006\u0002\b*J\u0018\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010-\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016J\n\u0010.\u001a\u00020\u0016*\u00020\u0016J\n\u0010/\u001a\u00020\u0005*\u00020\u0016J\n\u00100\u001a\u00020\u0005*\u00020\u0016J\u0012\u00101\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u000102*\u000203J&\u00104\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u0012H\u0007J\u0010\u0010:\u001a\u00020\u00052\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010=\u001a\u00020\u00052\u0006\u0010>\u001a\u00020?H\u0002J>\u0010@\u001a\b\u0012\u0004\u0012\u00020A0\u00192\u0006\u0010B\u001a\u00020A2\u0006\u0010C\u001a\u00020\u00162\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00109\u001a\u00020\u0012H\u0002R\u001c\u0010\u0004\u001a\u00020\u0005@\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/DebuggerUtils;", "", "<init>", "()V", "forceRanking", "", "getForceRanking", "()Z", "setForceRanking", "(Z)V", "IR_BACKEND_LAMBDA_REGEX", "Lkotlin/text/Regex;", "IR_BACKEND_NEW_LAMBDA_REGEX", "findSourceFileForClassIncludeLibrarySources", "Lorg/jetbrains/kotlin/psi/KtFile;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "className", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "fileName", "", "findSourceFileForClass", "scopes", "", "location", "Lcom/sun/jdi/Location;", "findSourceFileForClass$intellij_kotlin_jvm_debugger_core", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;Ljava/lang/String;Lcom/sun/jdi/Location;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findSourceFilesForClass", "hasLocation", "classNameResolvesInline", "findSourceFilesForClass$intellij_kotlin_jvm_debugger_core", "chooseApplicableFile", "files", "chooseApplicableFile$intellij_kotlin_jvm_debugger_core", "(Ljava/util/List;Lcom/sun/jdi/Location;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findFilesByNameInPackage", "searchScope", "tryFindFileByClassNameAndFileName", "sourceName", "tryFindFileByClassNameAndFileName$intellij_kotlin_jvm_debugger_core", "isApplicable", "file", "isKotlinSourceFile", "trimMethodNameMangling", "isGeneratedIrBackendLambdaMethodName", "isGeneratedNewIrBackendLambdaMethodName", "getBorders", "Lkotlin/ranges/ClosedRange;", "Lcom/sun/jdi/LocalVariable;", "getLocationsOfInlinedLine", "type", "Lcom/sun/jdi/ReferenceType;", "position", "Lcom/intellij/debugger/SourcePosition;", "sourceSearchScope", "isInCrossInlineArgument", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "isCrossInlineArgument", "argumentExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "inlinedLinesNumbers", "", "inlineLineNumber", "inlineFileName", "destinationTypeFqName", "Lorg/jetbrains/kotlin/name/FqName;", "destinationFileName", "intellij.kotlin.jvm.debugger.core"})
@SourceDebugExtension(value={"SMAP\nDebuggerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebuggerUtils.kt\norg/jetbrains/kotlin/idea/debugger/core/DebuggerUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,313:1\n777#2:314\n873#2,2:315\n777#2:318\n873#2,2:319\n672#2,11:321\n777#2:332\n873#2,2:333\n1586#2:335\n1661#2,3:336\n1391#2:343\n1480#2,5:344\n777#2:350\n873#2,2:351\n1391#2:353\n1480#2,5:354\n1#3:317\n18#4,2:339\n1276#5,2:341\n479#5:349\n*S KotlinDebug\n*F\n+ 1 DebuggerUtils.kt\norg/jetbrains/kotlin/idea/debugger/core/DebuggerUtils\n*L\n112#1:314\n112#1:315,2\n113#1:318\n113#1:319,2\n132#1:321,11\n162#1:332\n162#1:333,2\n196#1:335\n196#1:336,3\n245#1:343\n245#1:344,5\n294#1:350\n294#1:351,2\n295#1:353\n295#1:354,5\n231#1:339,2\n233#1:341,2\n249#1:349\n*E\n"})
public final class DebuggerUtils {
    @NotNull
    public static final DebuggerUtils INSTANCE = new DebuggerUtils();
    private static boolean forceRanking;
    @NotNull
    private static final Regex IR_BACKEND_LAMBDA_REGEX;
    @NotNull
    private static final Regex IR_BACKEND_NEW_LAMBDA_REGEX;

    private DebuggerUtils() {
    }

    public final boolean getForceRanking() {
        return forceRanking;
    }

    @TestOnly
    public final void setForceRanking(boolean bl) {
        forceRanking = bl;
    }

    @Nullable
    public final KtFile findSourceFileForClassIncludeLibrarySources(@NotNull Project project, @NotNull GlobalSearchScope scope, @NotNull JvmClassName className, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return (KtFile)ReadAction.nonBlocking(() -> DebuggerUtils.findSourceFileForClassIncludeLibrarySources$lambda$0(scope, project, className, fileName)).executeSynchronously();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object findSourceFileForClass$intellij_kotlin_jvm_debugger_core(@NotNull Project project, @NotNull List<? extends GlobalSearchScope> scopes, @NotNull JvmClassName className, @NotNull String fileName, @Nullable Location location, @NotNull Continuation<? super KtFile> $completion) {
        if (!($completion instanceof findSourceFileForClass.1)) ** GOTO lbl-1000
        var9_7 = $completion;
        if ((var9_7.label & -2147483648) != 0) {
            var9_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                /* synthetic */ Object result;
                final /* synthetic */ DebuggerUtils this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.findSourceFileForClass$intellij_kotlin_jvm_debugger_core(null, null, null, null, null, (Continuation<? super KtFile>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable(scopes);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)className);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)fileName);
                $continuation.L$4 = location;
                $continuation.label = 1;
                v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, findSourceFileForClass$lambda$0(com.intellij.openapi.project.Project java.util.List org.jetbrains.kotlin.resolve.jvm.JvmClassName java.lang.String com.sun.jdi.Location ), ()Ljava/util/List;)((Project)project, scopes, (JvmClassName)className, (String)fileName, (Location)location), (Continuation)$continuation);
                if (v0 == var10_9) {
                    return var10_9;
                }
                ** GOTO lbl30
            }
            case 1: {
                location = (Location)$continuation.L$4;
                fileName = (String)$continuation.L$3;
                className = (JvmClassName)$continuation.L$2;
                scopes = (List)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                files = (List)v0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)scopes);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)className);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)fileName);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)location);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)files);
                $continuation.label = 2;
                v1 = this.chooseApplicableFile$intellij_kotlin_jvm_debugger_core(files, location, (Continuation<? super KtFile>)$continuation);
                if (v1 == var10_9) {
                    return var10_9;
                }
                ** GOTO lbl51
            }
            case 2: {
                files = (List)$continuation.L$5;
                location = (Location)$continuation.L$4;
                fileName = (String)$continuation.L$3;
                className = (JvmClassName)$continuation.L$2;
                scopes = (List)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl51:
                // 2 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @NotNull
    public final List<KtFile> findSourceFilesForClass$intellij_kotlin_jvm_debugger_core(@NotNull Project project, @NotNull List<? extends GlobalSearchScope> scopes, @NotNull JvmClassName className, @NotNull String fileName, boolean hasLocation, boolean classNameResolvesInline) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (!this.isKotlinSourceFile(fileName)) {
            return CollectionsKt.emptyList();
        }
        if (DumbService.Companion.isDumb(project) && FileBasedIndex.getInstance().getCurrentDumbModeAccessType() != DumbModeAccessType.RELIABLE_DATA_ONLY) {
            return CollectionsKt.emptyList();
        }
        FqName fqName2 = className.getFqNameForClassNameWithoutDollars();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"getFqNameForClassNameWithoutDollars(...)");
        FqName partFqName = fqName2;
        for (GlobalSearchScope globalSearchScope : scopes) {
            Object v4;
            List files;
            block15: {
                List list2;
                Iterable $this$filter$iv;
                void $this$filterTo$iv$iv;
                void $this$filter$iv2;
                Iterable iterable = this.findFilesByNameInPackage(className, fileName, project, globalSearchScope);
                boolean $i$f$filter = false;
                void var13_15 = $this$filter$iv2;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    KtFile it = (KtFile)element$iv$iv;
                    boolean bl = false;
                    if (!(JvmPlatformKt.isJvm((TargetPlatform)TargetPlatformDetectorUtils.getPlatform((KtElement)it)) || TargetPlatformKt.isCommon((TargetPlatform)TargetPlatformDetectorUtils.getPlatform((KtElement)it)))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List $this$findSourceFilesForClass_u24lambda_u241 = (List)destination$iv$iv;
                boolean bl = false;
                if (classNameResolvesInline) {
                    Object $this$filterTo$iv$iv2;
                    $this$filter$iv = $this$findSourceFilesForClass_u24lambda_u241;
                    boolean $i$f$filter2 = false;
                    Iterable iterable2 = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo2 = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                        KtFile it = (KtFile)element$iv$iv;
                        boolean bl2 = false;
                        if (!INSTANCE.isApplicable(it, className)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    list2 = (List)destination$iv$iv2;
                } else {
                    list2 = $this$findSourceFilesForClass_u24lambda_u241;
                }
                if ((files = list2).isEmpty()) continue;
                if (!hasLocation || files.size() == 1 && !forceRanking) {
                    if (files.size() > 1) {
                        Object v3;
                        block14: {
                            PsiManager psiManager = PsiManager.getInstance((Project)project);
                            Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
                            PsiManager psiManager2 = psiManager;
                            $this$filter$iv = files;
                            for (Object $this$filterTo$iv$iv2 : $this$filter$iv) {
                                KtFile it = (KtFile)$this$filterTo$iv$iv2;
                                boolean bl3 = false;
                                if (!psiManager2.isInProject((PsiElement)it)) continue;
                                v3 = $this$filterTo$iv$iv2;
                                break block14;
                            }
                            v3 = null;
                        }
                        KtFile fromProject = v3;
                        if (fromProject != null) {
                            return CollectionsKt.listOf((Object)fromProject);
                        }
                    }
                    return CollectionsKt.listOf((Object)CollectionsKt.first((List)files));
                }
                Collection matchingFiles = KotlinFileFacadeFqNameIndex.Helper.get(partFqName.asString(), project, globalSearchScope);
                Iterable $this$singleOrNull$iv = PackagePartClassUtils.getFilesWithCallables(matchingFiles);
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    KtFile it = (KtFile)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)fileName)) continue;
                    if (found$iv) {
                        v4 = null;
                        break block15;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v4 = !found$iv ? null : single$iv;
            }
            KtFile singleFile = v4;
            if (singleFile != null) {
                return CollectionsKt.listOf((Object)singleFile);
            }
            return files;
        }
        return CollectionsKt.emptyList();
    }

    public static /* synthetic */ List findSourceFilesForClass$intellij_kotlin_jvm_debugger_core$default(DebuggerUtils debuggerUtils, Project project, List list2, JvmClassName jvmClassName, String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        return debuggerUtils.findSourceFilesForClass$intellij_kotlin_jvm_debugger_core(project, list2, jvmClassName, string, bl, bl2);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object chooseApplicableFile$intellij_kotlin_jvm_debugger_core(@NotNull List<? extends KtFile> files, @Nullable Location location, @NotNull Continuation<? super KtFile> $completion) {
        if (!($completion instanceof chooseApplicableFile.1)) ** GOTO lbl-1000
        var5_4 = $completion;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ DebuggerUtils this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.chooseApplicableFile$intellij_kotlin_jvm_debugger_core(null, null, (Continuation<? super KtFile>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (files.isEmpty()) {
                    return null;
                }
                if (location == null || files.size() == 1 && !DebuggerUtils.forceRanking) {
                    return CollectionsKt.first((List)files);
                }
                DebuggerManagerThreadImpl.Companion.assertIsManagerThread();
                if (!Registry.Companion.is("kotlin.debugger.analysis.api.file.applicability.checker")) break;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)files);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)location);
                $continuation.label = 1;
                v0 = FileApplicabilityChecker.INSTANCE.chooseMostApplicableFile(files, location, (Continuation<? super KtFile>)$continuation);
                if (v0 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl30
            }
            case 1: {
                location = (Location)$continuation.L$1;
                files = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                v1 = (KtFile)v0;
                ** GOTO lbl60
            }
        }
        v1 = KotlinDebuggerLegacyFacade.Companion.getInstance();
        if (v1 == null || (v1 = v1.getFileSelector()) == null) ** GOTO lbl47
        $continuation.L$0 = files;
        $continuation.L$1 = location;
        $continuation.label = 2;
        v2 = v1.chooseMostApplicableFile(files, location, (Continuation<? super KtFile>)$continuation);
        if (v2 == var6_6) {
            return var6_6;
        }
        ** GOTO lbl46
        {
            case 2: {
                location = (Location)$continuation.L$1;
                files = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl46:
                // 2 sources

                if ((v1 = (KtFile)v2) != null) ** GOTO lbl60
lbl47:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)files);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)location);
                $continuation.label = 3;
                v3 = FileApplicabilityChecker.INSTANCE.chooseMostApplicableFile(files, location, (Continuation<? super KtFile>)$continuation);
                if (v3 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl59
            }
            case 3: {
                location = (Location)$continuation.L$1;
                files = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl59:
                // 2 sources

                v1 = (KtFile)v3;
lbl60:
                // 3 sources

                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtFile> findFilesByNameInPackage(JvmClassName className, String fileName, Project project, GlobalSearchScope searchScope) {
        void $this$filterTo$iv$iv;
        FqName fqName2 = className.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"getPackageFqName(...)");
        Iterable $this$filter$iv = KotlinPackageIndexUtils.INSTANCE.findFilesWithExactPackage(fqName2, searchScope, project);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)fileName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List files = (List)destination$iv$iv;
        return CollectionsKt.sortedWith((Iterable)files, (Comparator)JavaElementFinder.Companion.byClasspathComparator(searchScope));
    }

    @NotNull
    public final List<KtFile> tryFindFileByClassNameAndFileName$intellij_kotlin_jvm_debugger_core(@NotNull Project project, @NotNull JvmClassName className, @NotNull String sourceName, @NotNull List<? extends GlobalSearchScope> scopes) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)sourceName, (String)"sourceName");
        Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
        String fqn = className.getFqNameForClassNameWithoutDollars().asString();
        for (GlobalSearchScope globalSearchScope : scopes) {
            KtFile file;
            PsiClass psiClass;
            if (PositionManagerImpl.findClass((Project)project, (String)fqn, (GlobalSearchScope)globalSearchScope, (boolean)false) == null) continue;
            PsiFile psiFile = psiClass.getContainingFile();
            KtFile ktFile2 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
            if (ktFile2 == null || !Intrinsics.areEqual((Object)(file = ktFile2).getName(), (Object)sourceName)) continue;
            return CollectionsKt.listOf((Object)file);
        }
        for (GlobalSearchScope globalSearchScope : scopes) {
            PsiFile[] files;
            Intrinsics.checkNotNullExpressionValue((Object)FilenameIndex.getFilesByName((Project)project, (String)sourceName, (GlobalSearchScope)globalSearchScope), (String)"getFilesByName(...)");
            if (files.length == 0) continue;
            List collectedFiles = new ArrayList();
            int n = files.length;
            for (int j = 0; j < n; ++j) {
                PsiFile psiFile = files[j];
                Intrinsics.checkNotNull((Object)psiFile);
                PsiFile file = psiFile;
                if (!(file instanceof KtFile) || !this.isApplicable((KtFile)file, className)) continue;
                collectedFiles.add(file);
            }
            if (!(!((Collection)collectedFiles).isEmpty())) continue;
            return collectedFiles;
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isApplicable(KtFile file, JvmClassName className) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = new ClassNameProvider(null, 1, null).getTopLevelNames(file);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(JvmNameUtilsKt.fqnToInternalName((String)it));
        }
        List classNames = (List)destination$iv$iv;
        String string = className.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInternalName(...)");
        return DebuggerUtilsKt.isInnerClassOfAny(string, classNames);
    }

    public final boolean isKotlinSourceFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String string = FileUtilRt.getExtension((String)fileName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExtension(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String extension = string3;
        return ProjectStructureUtils.getKOTLIN_FILE_EXTENSIONS().contains(extension);
    }

    @NotNull
    public final String trimMethodNameMangling(@NotNull String $this$trimMethodNameMangling) {
        Intrinsics.checkNotNullParameter((Object)$this$trimMethodNameMangling, (String)"<this>");
        return StringsKt.substringBefore$default((String)$this$trimMethodNameMangling, (char)'-', null, (int)2, null);
    }

    public final boolean isGeneratedIrBackendLambdaMethodName(@NotNull String $this$isGeneratedIrBackendLambdaMethodName) {
        Intrinsics.checkNotNullParameter((Object)$this$isGeneratedIrBackendLambdaMethodName, (String)"<this>");
        CharSequence charSequence = $this$isGeneratedIrBackendLambdaMethodName;
        return IR_BACKEND_LAMBDA_REGEX.matches(charSequence) || IR_BACKEND_NEW_LAMBDA_REGEX.matches(charSequence = (CharSequence)$this$isGeneratedIrBackendLambdaMethodName);
    }

    public final boolean isGeneratedNewIrBackendLambdaMethodName(@NotNull String $this$isGeneratedNewIrBackendLambdaMethodName) {
        Intrinsics.checkNotNullParameter((Object)$this$isGeneratedNewIrBackendLambdaMethodName, (String)"<this>");
        CharSequence charSequence = $this$isGeneratedNewIrBackendLambdaMethodName;
        return IR_BACKEND_NEW_LAMBDA_REGEX.matches(charSequence);
    }

    @Nullable
    public final ClosedRange<Location> getBorders(@NotNull LocalVariable $this$getBorders) {
        Intrinsics.checkNotNullParameter((Object)$this$getBorders, (String)"<this>");
        LocalVariableImpl localVariableImpl = $this$getBorders instanceof LocalVariableImpl ? (LocalVariableImpl)$this$getBorders : null;
        if (localVariableImpl == null) {
            return null;
        }
        LocalVariableImpl localVariableImpl2 = localVariableImpl;
        Comparable comparable = localVariableImpl2.getScopeStart();
        Location location = localVariableImpl2.getScopeEnd();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getScopeEnd(...)");
        return RangesKt.rangeTo((Comparable)comparable, (Comparable)location);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @ApiStatus.Internal
    @NotNull
    public final List<Location> getLocationsOfInlinedLine(@NotNull ReferenceType type2, @NotNull SourcePosition position, @NotNull GlobalSearchScope sourceSearchScope) {
        void $this$flatMapTo$iv$iv;
        boolean isInCrossInlineArgument;
        boolean isInInline;
        KtElement ktElement;
        Object element$iv2;
        Project project;
        int line;
        block8: {
            boolean bl;
            Object v4;
            PsiElement element;
            block7: {
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                Intrinsics.checkNotNullParameter((Object)position, (String)"position");
                Intrinsics.checkNotNullParameter((Object)sourceSearchScope, (String)"sourceSearchScope");
                line = position.getLine();
                PsiFile psiFile = position.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
                PsiFile file = psiFile;
                Project project2 = position.getFile().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                project = project2;
                Integer n = PsiLinesUtilsKt.getLineStartOffset(file, line);
                if (n == null) {
                    return CollectionsKt.emptyList();
                }
                int lineStartOffset = n;
                PsiElement psiElement = file.findElementAt(lineStartOffset);
                if (psiElement == null) {
                    return CollectionsKt.emptyList();
                }
                element = psiElement;
                Sequence $this$firstIsInstanceOrNull$iv = PsiUtilsKt.getParents((PsiElement)element);
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv2 : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv2 instanceof KtElement)) continue;
                    v4 = element$iv2;
                    break block7;
                }
                v4 = null;
            }
            KtElement ktElement2 = v4;
            if (ktElement2 == null) {
                return CollectionsKt.emptyList();
            }
            ktElement = ktElement2;
            Sequence $this$any$iv = PsiUtilsKt.getParents((PsiElement)element);
            boolean $i$f$any = false;
            for (Object element$iv2 : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv2;
                boolean bl2 = false;
                if (!(it instanceof KtFunction && ((KtFunction)it).hasModifier(KtTokens.INLINE_KEYWORD))) continue;
                bl = true;
                break block8;
            }
            bl = isInInline = false;
        }
        if (!isInInline && !(isInCrossInlineArgument = this.isInCrossInlineArgument(ktElement))) {
            return CollectionsKt.emptyList();
        }
        String string = position.getFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String string2 = type2.name();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name(...)");
        FqName fqName2 = new FqName(string2);
        String string3 = type2.sourceName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sourceName(...)");
        List<Integer> lines = this.inlinedLinesNumbers(line + 1, string, fqName2, string3, project, sourceSearchScope);
        Iterable $this$flatMap$iv = lines;
        boolean $i$f$flatMap = false;
        element$iv2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            List list2 = DebuggerUtilsAsync.locationsOfLineSync((ReferenceType)type2, (int)it);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"locationsOfLineSync(...)");
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final boolean isInCrossInlineArgument(KtElement ktElement) {
        Sequence $this$filterIsInstance$iv = PsiUtilsKt.getParents((PsiElement)((PsiElement)ktElement));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)isInCrossInlineArgument$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        for (KtFunction function : sequence) {
            KtFunction ktFunction = function;
            if (ktFunction instanceof KtFunctionLiteral) {
                KtLambdaExpression lambdaExpression;
                PsiElement argumentExpression;
                PsiElement psiElement = ((KtFunctionLiteral)function).getParent();
                KtLambdaExpression ktLambdaExpression = psiElement instanceof KtLambdaExpression ? (KtLambdaExpression)psiElement : null;
                if (ktLambdaExpression == null || !((argumentExpression = (lambdaExpression = ktLambdaExpression).getParent()) instanceof KtValueArgument) || !this.isCrossInlineArgument((KtExpression)lambdaExpression)) continue;
                return true;
            }
            if (!(ktFunction instanceof KtNamedFunction) || !(((KtNamedFunction)function).getParent() instanceof KtValueArgument) || !this.isCrossInlineArgument((KtExpression)function)) continue;
            return true;
        }
        return false;
    }

    private final boolean isCrossInlineArgument(KtExpression argumentExpression) {
        KtExpression ktExpression = KtPsiUtil.getParentCallIfPresent((KtExpression)argumentExpression);
        if (ktExpression == null) {
            return false;
        }
        KtExpression callExpression = ktExpression;
        return AnalyseUtilsKt.runDumbAnalyze((KtElement)callExpression, false, arg_0 -> DebuggerUtils.isCrossInlineArgument$lambda$0(callExpression, argumentExpression, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> inlinedLinesNumbers(int inlineLineNumber, String inlineFileName, FqName destinationTypeFqName, String destinationFileName, Project project, GlobalSearchScope sourceSearchScope) {
        void $this$flatMapTo$iv$iv;
        void $this$filterTo$iv$iv;
        String internalName = JvmNameUtilsKt.fqnToInternalName(destinationTypeFqName.asString());
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)internalName);
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byInternalName(...)");
        JvmClassName jvmClassName2 = jvmClassName;
        KtFile ktFile2 = this.findSourceFileForClassIncludeLibrarySources(project, sourceSearchScope, jvmClassName2, destinationFileName);
        if (ktFile2 == null) {
            return CollectionsKt.emptyList();
        }
        KtFile file = ktFile2;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile2 = virtualFile;
        SMAP sMAP = KotlinSourceMapCache.Companion.getInstance(project).getSourceMap(virtualFile2, jvmClassName2);
        if (sMAP == null) {
            return CollectionsKt.emptyList();
        }
        SMAP sourceMap = sMAP;
        Iterable $this$filter$iv = sourceMap.getFileMappings();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FileMapping it = (FileMapping)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)inlineFileName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List mappingsToInlinedFile = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = mappingsToInlinedFile;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            FileMapping it = (FileMapping)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getLineMappings();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List mappingIntervals = (List)destination$iv$iv2;
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)mappingIntervals), arg_0 -> DebuggerUtils.inlinedLinesNumbers$lambda$2(inlineLineNumber, arg_0)), arg_0 -> DebuggerUtils.inlinedLinesNumbers$lambda$3(inlineLineNumber, arg_0)), DebuggerUtils::inlinedLinesNumbers$lambda$4));
    }

    private static final KtFile findSourceFileForClassIncludeLibrarySources$lambda$0(GlobalSearchScope $scope, Project $project, JvmClassName $className, String $fileName) {
        Object[] objectArray = new GlobalSearchScope[2];
        objectArray[0] = $scope;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)$project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        objectArray[1] = KotlinSourceFilterScope.Companion.librarySources(globalSearchScope, $project);
        List scopes = CollectionsKt.listOf((Object[])objectArray);
        List<KtFile> files = INSTANCE.findSourceFilesForClass$intellij_kotlin_jvm_debugger_core($project, scopes, $className, $fileName, false, false);
        return (KtFile)CollectionsKt.firstOrNull(files);
    }

    private static final List findSourceFileForClass$lambda$0(Project $project, List $scopes, JvmClassName $className, String $fileName, Location $location) {
        return INSTANCE.findSourceFilesForClass$intellij_kotlin_jvm_debugger_core($project, $scopes, $className, $fileName, $location != null, false);
    }

    private static final boolean isCrossInlineArgument$lambda$0(KtExpression $callExpression, KtExpression $argumentExpression, KaSession $this$f) {
        Intrinsics.checkNotNullParameter((Object)$this$f, (String)"$this$f");
        KaLifetimeOwner kaLifetimeOwner = $this$f.resolveToCall((KtElement)$callExpression);
        if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.successfulFunctionCallOrNull((KaCallInfo)kaLifetimeOwner)) == null) {
            return false;
        }
        KaLifetimeOwner call = kaLifetimeOwner;
        KaLifetimeOwner kaLifetimeOwner2 = call.getArgumentMapping().get($argumentExpression);
        if (kaLifetimeOwner2 == null || (kaLifetimeOwner2 = (KaValueParameterSymbol)kaLifetimeOwner2.getSymbol()) == null) {
            return false;
        }
        KaLifetimeOwner parameter = kaLifetimeOwner2;
        return ((KaValueParameterSymbol)parameter).isCrossinline();
    }

    private static final boolean inlinedLinesNumbers$lambda$2(int $inlineLineNumber, RangeMapping rangeMapping) {
        Intrinsics.checkNotNullParameter((Object)rangeMapping, (String)"rangeMapping");
        return rangeMapping.hasMappingForSource($inlineLineNumber);
    }

    private static final int inlinedLinesNumbers$lambda$3(int $inlineLineNumber, RangeMapping rangeMapping) {
        Intrinsics.checkNotNullParameter((Object)rangeMapping, (String)"rangeMapping");
        return rangeMapping.mapSourceToDest($inlineLineNumber);
    }

    private static final boolean inlinedLinesNumbers$lambda$4(int line) {
        return line != -1;
    }

    static {
        IR_BACKEND_LAMBDA_REGEX = new Regex(".+\\$lambda[$-]\\d+");
        IR_BACKEND_NEW_LAMBDA_REGEX = new Regex(".+\\$lambda([$-]\\d+)+");
    }
}

