/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.annotations.KaAnnotation;
import org.jetbrains.kotlin.analysis.api.annotations.KaAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KaNamedAnnotationValue;
import org.jetbrains.kotlin.analysis.api.base.KaConstantValue;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFileSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaPropertyAccessorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaPropertyGetterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaPropertySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolLocationKt;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtClsFile;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.idea.debugger.base.util.JvmNameUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0006H\u0007\u001a\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\u0003\u001a\u0004\u0018\u00010\tH\u0007\u001a\u0016\u0010\n\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0007\u001a\u0016\u0010\r\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u000eH\u0007\u001a\u000e\u0010\u000f\u001a\u0004\u0018\u00010\u0001*\u00020\u0010H\u0007\u001a\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u0010*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u000eH\u0007\u00a8\u0006\u0012"}, d2={"methodName", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaFunctionSymbol;", "getByteCodeMethodName", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaNamedFunctionSymbol;", "isInlineClass", "", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;", "getClassName", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getJvmInternalClassName", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaCallableSymbol;", "getJvmInternalName", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaClassSymbol;", "getContainingClassOrObjectSymbol", "intellij.kotlin.jvm.debugger.core"})
@SourceDebugExtension(value={"SMAP\njvmNameUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 jvmNameUtil.kt\norg/jetbrains/kotlin/idea/debugger/core/JvmNameUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,93:1\n1586#2:94\n1661#2,3:95\n777#2:98\n873#2,2:99\n672#2,11:101\n19#3:112\n19#3:113\n*S KotlinDebug\n*F\n+ 1 jvmNameUtil.kt\norg/jetbrains/kotlin/idea/debugger/core/JvmNameUtilKt\n*L\n38#1:94\n38#1:95,3\n43#1:98\n43#1:99,2\n45#1:101,11\n46#1:112\n47#1:113\n*E\n"})
public final class JvmNameUtilKt {
    @ApiStatus.Internal
    @Nullable
    public static final String methodName(@NotNull KaSession $this$methodName, @NotNull KaFunctionSymbol symbol) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$methodName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        KaFunctionSymbol kaFunctionSymbol = symbol;
        if (kaFunctionSymbol instanceof KaNamedFunctionSymbol) {
            string = JvmNameUtilKt.getByteCodeMethodName($this$methodName, (KaNamedFunctionSymbol)symbol);
        } else if (kaFunctionSymbol instanceof KaConstructorSymbol) {
            string = "<init>";
        } else if (kaFunctionSymbol instanceof KaPropertyAccessorSymbol) {
            Name name2;
            KaPropertySymbol propertySymbol;
            KaSymbol kaSymbol = $this$methodName.getContainingSymbol(symbol);
            KaPropertySymbol kaPropertySymbol = propertySymbol = kaSymbol instanceof KaPropertySymbol ? (KaPropertySymbol)kaSymbol : null;
            if (symbol instanceof KaPropertyGetterSymbol) {
                KaPropertySymbol kaPropertySymbol2 = propertySymbol;
                name2 = kaPropertySymbol2 != null ? $this$methodName.getJavaGetterName(kaPropertySymbol2) : null;
            } else {
                KaPropertySymbol kaPropertySymbol3 = propertySymbol;
                name2 = kaPropertySymbol3 != null ? $this$methodName.getJavaSetterName(kaPropertySymbol3) : null;
            }
            string = name2 != null ? name2.asString() : null;
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @ApiStatus.Internal
    @NotNull
    public static final String getByteCodeMethodName(@NotNull KaSession $this$getByteCodeMethodName, @NotNull KaNamedFunctionSymbol symbol) {
        String jvmName;
        String string;
        String string2;
        String localFunPrefix;
        block14: {
            String string3;
            String string4;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            String string5;
            Collection destination$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$getByteCodeMethodName, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            if (KaSymbolLocationKt.isLocal(symbol)) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = SequencesKt.toList((Sequence)SequencesKt.drop((Sequence)SequencesKt.generateSequence((Object)symbol, arg_0 -> JvmNameUtilKt.getByteCodeMethodName$lambda$0($this$getByteCodeMethodName, arg_0)), (int)1));
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object t : $this$mapTo$iv$iv) {
                    KaNamedFunctionSymbol kaNamedFunctionSymbol = (KaNamedFunctionSymbol)t;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(kaNamedFunctionSymbol.getName().asString());
                }
                string5 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)((List)destination$iv$iv)), (CharSequence)"$", null, (CharSequence)"$", (int)0, null, null, (int)58, null);
            } else {
                string5 = "";
            }
            localFunPrefix = string5;
            Iterable $i$f$map = symbol.getAnnotations();
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object t : $this$filterTo$iv$iv) {
                KaAnnotation it = (KaAnnotation)t;
                boolean bl = false;
                ClassId classId = it.getClassId();
                if (!Intrinsics.areEqual((Object)(classId != null ? classId.asFqNameString() : null), (Object)"kotlin.jvm.JvmName")) continue;
                destination$iv$iv2.add(t);
            }
            Iterator iterator2 = ((Iterable)((List)destination$iv$iv2)).iterator();
            do {
                KaAnnotationValue kaAnnotationValue;
                Object object;
                block15: {
                    void var10_25;
                    if (!iterator2.hasNext()) {
                        string2 = null;
                        break block14;
                    }
                    KaAnnotation it = (KaAnnotation)iterator2.next();
                    boolean bl = false;
                    Iterable $this$singleOrNull$iv = it.getArguments();
                    boolean bl2 = false;
                    Object var10_24 = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        KaNamedAnnotationValue a = (KaNamedAnnotationValue)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)a.getName().asString(), (Object)"name")) continue;
                        if (found$iv) {
                            object = null;
                            break block15;
                        }
                        Object t = element$iv;
                        found$iv = true;
                    }
                    object = !found$iv ? null : var10_25;
                }
                KaNamedAnnotationValue kaNamedAnnotationValue = (KaNamedAnnotationValue)object;
                if (kaNamedAnnotationValue != null && (kaAnnotationValue = kaNamedAnnotationValue.getExpression()) != null) {
                    KaConstantValue kaConstantValue;
                    KaAnnotationValue.ConstantValue constantValue;
                    KaAnnotationValue kaAnnotationValue2 = kaAnnotationValue;
                    boolean $i$f$asSafely = false;
                    KaAnnotationValue kaAnnotationValue3 = kaAnnotationValue2;
                    if (!(kaAnnotationValue3 instanceof KaAnnotationValue.ConstantValue)) {
                        kaAnnotationValue3 = null;
                    }
                    if ((constantValue = (KaAnnotationValue.ConstantValue)kaAnnotationValue3) != null && (kaConstantValue = constantValue.getValue()) != null) {
                        KaConstantValue.StringValue stringValue;
                        void $this$asSafely$iv;
                        KaConstantValue bl = kaConstantValue;
                        boolean $i$f$asSafely2 = false;
                        Object v5 = $this$asSafely$iv;
                        if (!(v5 instanceof KaConstantValue.StringValue)) {
                            v5 = null;
                        }
                        if ((stringValue = (KaConstantValue.StringValue)v5) != null) {
                            string3 = stringValue.getValue();
                            continue;
                        }
                    }
                }
                string3 = null;
            } while ((string4 = string3) == null);
            string2 = string4;
        }
        if ((string = (jvmName = string2)) == null) {
            String string6 = symbol.getName().asString();
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"asString(...)");
        }
        String actualName = string;
        return localFunPrefix + actualName;
    }

    @ApiStatus.Internal
    public static final boolean isInlineClass(@Nullable KaDeclarationSymbol symbol) {
        return symbol instanceof KaNamedClassSymbol && ((KaNamedClassSymbol)symbol).isInline();
    }

    @ApiStatus.Internal
    @Nullable
    public static final String getClassName(@NotNull KaSession $this$getClassName, @NotNull KtDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)$this$getClassName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        KaDeclarationSymbol kaDeclarationSymbol = $this$getClassName.getSymbol(declaration);
        KaFunctionSymbol kaFunctionSymbol = kaDeclarationSymbol instanceof KaFunctionSymbol ? (KaFunctionSymbol)kaDeclarationSymbol : null;
        if (kaFunctionSymbol == null) {
            return null;
        }
        KaFunctionSymbol symbol = kaFunctionSymbol;
        String string = JvmNameUtilKt.getJvmInternalClassName($this$getClassName, symbol);
        return string != null ? JvmNameUtilsKt.internalNameToFqn(string) : null;
    }

    @ApiStatus.Internal
    @Nullable
    public static final String getJvmInternalClassName(@NotNull KaSession $this$getJvmInternalClassName, @NotNull KaCallableSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)$this$getJvmInternalClassName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        KaClassSymbol classOrObject = JvmNameUtilKt.getContainingClassOrObjectSymbol($this$getJvmInternalClassName, symbol);
        if (classOrObject != null) {
            return JvmNameUtilKt.getJvmInternalName(classOrObject);
        }
        KaFileSymbol kaFileSymbol = $this$getJvmInternalClassName.getContainingFile(symbol);
        if (kaFileSymbol == null) {
            return null;
        }
        KaFileSymbol fileSymbol = kaFileSymbol;
        PsiElement psiElement = fileSymbol.getPsi();
        KtFile ktFile2 = psiElement instanceof KtFile ? (KtFile)psiElement : null;
        if (ktFile2 == null) {
            return null;
        }
        KtFile file = ktFile2;
        if (file instanceof KtClsFile) {
            return JvmNameUtilsKt.fqnToInternalName(JvmFileClassUtilKt.getJavaFileFacadeFqName((KtFile)file).asString());
        }
        return JvmNameUtilsKt.fqnToInternalName(JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)file).getFacadeClassFqName().asString());
    }

    @ApiStatus.Internal
    @Nullable
    public static final String getJvmInternalName(@NotNull KaClassSymbol $this$getJvmInternalName) {
        Intrinsics.checkNotNullParameter((Object)$this$getJvmInternalName, (String)"<this>");
        ClassId classId = $this$getJvmInternalName.getClassId();
        if (classId == null) {
            return null;
        }
        ClassId classId2 = classId;
        String string = JvmClassName.internalNameByClassId((ClassId)classId2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"internalNameByClassId(...)");
        String internalName = string;
        if (Intrinsics.areEqual((Object)internalName, (Object)"kotlin/Any")) {
            return "java/lang/Object";
        }
        return internalName;
    }

    @ApiStatus.Internal
    @Nullable
    public static final KaClassSymbol getContainingClassOrObjectSymbol(@NotNull KaSession $this$getContainingClassOrObjectSymbol, @NotNull KaCallableSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)$this$getContainingClassOrObjectSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        KaSymbol containerSymbol = $this$getContainingClassOrObjectSymbol.getContainingSymbol(symbol);
        while (containerSymbol != null) {
            if (containerSymbol instanceof KaClassSymbol) {
                return (KaClassSymbol)containerSymbol;
            }
            containerSymbol = $this$getContainingClassOrObjectSymbol.getContainingDeclaration(containerSymbol);
        }
        return null;
    }

    private static final KaNamedFunctionSymbol getByteCodeMethodName$lambda$0(KaSession $this_getByteCodeMethodName, KaNamedFunctionSymbol it) {
        KaSymbol kaSymbol;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return KaSymbolLocationKt.isLocal(it) ? ((kaSymbol = $this_getByteCodeMethodName.getContainingSymbol(it)) instanceof KaNamedFunctionSymbol ? (KaNamedFunctionSymbol)kaSymbol : null) : null;
    }
}

