/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.rt.debugger.JsonUtils;
import com.intellij.rt.debugger.MetadataDebugHelper;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.metadata.jvm.KotlinClassMetadata;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ$\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J(\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\rH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/KotlinMetadataCache;", "", "<init>", "()V", "cache", "", "Lcom/sun/jdi/ReferenceType;", "Lkotlin/metadata/jvm/KotlinClassMetadata;", "fetchKotlinMetadata", "refType", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "fetchKotlinMetadataList", "", "refTypes", "", "parseMetadataFromJson", "metadataAsJson", "", "callMethodFromHelper", "methodName", "args", "Lcom/sun/jdi/Value;", "MetadataAdapter", "intellij.kotlin.jvm.debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinMetadataCacheService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMetadataCacheService.kt\norg/jetbrains/kotlin/idea/debugger/core/KotlinMetadataCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KotlinMetadataCacheService.kt\norg/jetbrains/kotlin/idea/debugger/core/KotlinMetadataCacheServiceKt\n+ 5 safeUtil.kt\norg/jetbrains/kotlin/idea/debugger/base/util/SafeUtilKt\n*L\n1#1,143:1\n1#2:144\n1586#3:145\n1661#3,3:146\n137#4,4:149\n169#5,4:153\n161#5,4:157\n*S KotlinDebug\n*F\n+ 1 KotlinMetadataCacheService.kt\norg/jetbrains/kotlin/idea/debugger/core/KotlinMetadataCache\n*L\n94#1:145\n94#1:146,3\n112#1:149,4\n115#1:153,4\n122#1:157,4\n*E\n"})
final class KotlinMetadataCache {
    @NotNull
    private final Map<ReferenceType, KotlinClassMetadata> cache = new LinkedHashMap();

    @Nullable
    public final KotlinClassMetadata fetchKotlinMetadata(@NotNull ReferenceType refType, @NotNull EvaluationContext context2) {
        Intrinsics.checkNotNullParameter((Object)refType, (String)"refType");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        KotlinClassMetadata kotlinClassMetadata = this.cache.get(refType);
        if (kotlinClassMetadata != null) {
            KotlinClassMetadata it = kotlinClassMetadata;
            boolean bl = false;
            return it;
        }
        String string = this.callMethodFromHelper(context2, "getDebugMetadataAsJson", CollectionsKt.listOf((Object)refType.classObject()));
        if (string == null) {
            return null;
        }
        String metadataAsJson = string;
        KotlinClassMetadata kotlinClassMetadata2 = this.parseMetadataFromJson(metadataAsJson);
        if (kotlinClassMetadata2 == null) {
            return null;
        }
        KotlinClassMetadata metadata = kotlinClassMetadata2;
        this.cache.put(refType, metadata);
        return metadata;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<KotlinClassMetadata> fetchKotlinMetadataList(@NotNull Collection<? extends ReferenceType> refTypes, @NotNull EvaluationContext context2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(refTypes, (String)"refTypes");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        List result2 = new ArrayList();
        List toFetch = new ArrayList();
        for (ReferenceType referenceType : refTypes) {
            KotlinClassMetadata metadata = this.cache.get(referenceType);
            boolean bl = metadata != null ? result2.add(metadata) : toFetch.add(referenceType);
        }
        if (toFetch.isEmpty()) {
            return result2;
        }
        String[] stringArray = (String[])toFetch;
        boolean $i$f$map = false;
        Object object = stringArray;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)stringArray, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ReferenceType referenceType = (ReferenceType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.classObject());
        }
        List classObjects = (List)destination$iv$iv;
        String string = this.callMethodFromHelper(context2, "getDebugMetadataListAsJson", classObjects);
        if (string == null) {
            return null;
        }
        String string2 = string;
        object = new String[]{"\n"};
        List splitJsonMetadatas = StringsKt.split$default((CharSequence)string2, (String[])object, (boolean)false, (int)0, (int)6, null);
        if (splitJsonMetadatas.size() != toFetch.size()) {
            return null;
        }
        for (Pair pair : CollectionsKt.zip((Iterable)splitJsonMetadatas, (Iterable)toFetch)) {
            KotlinClassMetadata metadata;
            String metadataAsJson = (String)pair.component1();
            ReferenceType refType = (ReferenceType)pair.component2();
            if (this.parseMetadataFromJson(metadataAsJson) == null) {
                return null;
            }
            this.cache.put(refType, metadata);
            result2.add(metadata);
        }
        return result2;
    }

    private final KotlinClassMetadata parseMetadataFromJson(String metadataAsJson) {
        KotlinClassMetadata kotlinClassMetadata;
        Metadata metadata;
        boolean $i$f$wrapJsonSyntaxException = false;
        try {
            boolean bl = false;
            metadata = ((MetadataAdapter)new Gson().fromJson(metadataAsJson, MetadataAdapter.class)).toMetadata();
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            metadata = null;
        }
        Metadata metadata2 = metadata;
        if (metadata2 == null) {
            return null;
        }
        Metadata metadata3 = metadata2;
        boolean $i$f$wrapIllegalArgumentException = false;
        try {
            boolean bl = false;
            kotlinClassMetadata = KotlinClassMetadata.Companion.readStrict(metadata3);
        }
        catch (IllegalArgumentException e$iv) {
            kotlinClassMetadata = null;
        }
        KotlinClassMetadata kotlinClassMetadata2 = kotlinClassMetadata;
        if (kotlinClassMetadata2 == null) {
            return null;
        }
        KotlinClassMetadata parsedMetadata = kotlinClassMetadata2;
        return parsedMetadata;
    }

    private final String callMethodFromHelper(EvaluationContext context2, String methodName, List<? extends Value> args) {
        String string;
        boolean $i$f$wrapEvaluateException = false;
        try {
            boolean bl = false;
            Intrinsics.checkNotNull((Object)context2, (String)"null cannot be cast to non-null type com.intellij.debugger.engine.evaluation.EvaluationContextImpl");
            String[] stringArray = new String[]{JsonUtils.class.getName()};
            Value value = DebuggerUtilsImpl.invokeHelperMethod((EvaluationContextImpl)((EvaluationContextImpl)context2), MetadataDebugHelper.class, (String)methodName, args, (boolean)true, (String[])stringArray);
            StringReference stringReference = value instanceof StringReference ? (StringReference)value : null;
            string = stringReference != null ? stringReference.value() : null;
        }
        catch (EvaluateException e$iv) {
            string = null;
        }
        return string;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u001b\u001a\u00020\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/KotlinMetadataCache$MetadataAdapter;", "", "kind", "", "metadataVersion", "", "data1", "", "data2", "extraString", "packageName", "extraInt", "<init>", "(I[Ljava/lang/Integer;[Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V", "getKind", "()I", "getMetadataVersion", "()[Ljava/lang/Integer;", "[Ljava/lang/Integer;", "getData1", "()[Ljava/lang/String;", "[Ljava/lang/String;", "getData2", "getExtraString", "()Ljava/lang/String;", "getPackageName", "getExtraInt", "toMetadata", "Lkotlin/Metadata;", "intellij.kotlin.jvm.debugger.core"})
    @SourceDebugExtension(value={"SMAP\nKotlinMetadataCacheService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMetadataCacheService.kt\norg/jetbrains/kotlin/idea/debugger/core/KotlinMetadataCache$MetadataAdapter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,143:1\n11705#2:144\n12052#2,3:145\n37#3,2:148\n*S KotlinDebug\n*F\n+ 1 KotlinMetadataCacheService.kt\norg/jetbrains/kotlin/idea/debugger/core/KotlinMetadataCache$MetadataAdapter\n*L\n57#1:144\n57#1:145,3\n57#1:148,2\n*E\n"})
    private static final class MetadataAdapter {
        private final int kind;
        @NotNull
        private final Integer[] metadataVersion;
        @NotNull
        private final String[] data1;
        @NotNull
        private final String[] data2;
        @NotNull
        private final String extraString;
        @NotNull
        private final String packageName;
        private final int extraInt;

        public MetadataAdapter(int kind2, @NotNull Integer[] metadataVersion, @NotNull String[] data1, @NotNull String[] data2, @NotNull String extraString, @NotNull String packageName, int extraInt) {
            Intrinsics.checkNotNullParameter((Object)metadataVersion, (String)"metadataVersion");
            Intrinsics.checkNotNullParameter((Object)data1, (String)"data1");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data2");
            Intrinsics.checkNotNullParameter((Object)extraString, (String)"extraString");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            this.kind = kind2;
            this.metadataVersion = metadataVersion;
            this.data1 = data1;
            this.data2 = data2;
            this.extraString = extraString;
            this.packageName = packageName;
            this.extraInt = extraInt;
        }

        public final int getKind() {
            return this.kind;
        }

        @NotNull
        public final Integer[] getMetadataVersion() {
            return this.metadataVersion;
        }

        @NotNull
        public final String[] getData1() {
            return this.data1;
        }

        @NotNull
        public final String[] getData2() {
            return this.data2;
        }

        @NotNull
        public final String getExtraString() {
            return this.extraString;
        }

        @NotNull
        public final String getPackageName() {
            return this.packageName;
        }

        public final int getExtraInt() {
            return this.extraInt;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Metadata toMetadata() {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String[] stringArray = this.data1;
            int[] nArray = null;
            int[] nArray2 = ArraysKt.toIntArray((Integer[])this.metadataVersion);
            int n = this.kind;
            boolean $i$f$map = false;
            void var3_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n2 = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n2; ++j) {
                void it;
                void item$iv$iv;
                void var9_12 = item$iv$iv = $this$mapTo$iv$iv[j];
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new String(Base64.decode$default((Base64)((Base64)Base64.Default), (CharSequence)((CharSequence)it), (int)0, (int)0, (int)6, null), Charsets.UTF_8));
            }
            collection = (List)destination$iv$iv;
            Collection $this$toTypedArray$iv = collection;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n3 = 4;
            int n4 = this.extraInt;
            String string = this.packageName;
            String string2 = this.extraString;
            String[] stringArray2 = this.data2;
            String[] stringArray3 = thisCollection$iv.toArray(new String[0]);
            int[] nArray3 = nArray;
            int[] nArray4 = nArray2;
            int n5 = n;
            return new Metadata(n5, nArray4, nArray3, stringArray3, stringArray2, string2, string, n4, n3, defaultConstructorMarker){
                private final /* synthetic */ int kind;
                private final /* synthetic */ int[] metadataVersion;
                private final /* synthetic */ int[] bytecodeVersion;
                private final /* synthetic */ String[] data1;
                private final /* synthetic */ String[] data2;
                private final /* synthetic */ String extraString;
                private final /* synthetic */ String packageName;
                private final /* synthetic */ int extraInt;
                {
                    Intrinsics.checkNotNullParameter((Object)metadataVersion, (String)"metadataVersion");
                    Intrinsics.checkNotNullParameter((Object)bytecodeVersion, (String)"bytecodeVersion");
                    Intrinsics.checkNotNullParameter((Object)data1, (String)"data1");
                    Intrinsics.checkNotNullParameter((Object)data2, (String)"data2");
                    Intrinsics.checkNotNullParameter((Object)extraString, (String)"extraString");
                    Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
                    this.kind = kind2;
                    this.metadataVersion = metadataVersion;
                    this.bytecodeVersion = bytecodeVersion;
                    this.data1 = data1;
                    this.data2 = data2;
                    this.extraString = extraString;
                    this.packageName = packageName;
                    this.extraInt = extraInt;
                }
                {
                    if ((n3 & 1) != 0) {
                        n = 1;
                    }
                    if ((n3 & 2) != 0) {
                        nArray = new int[]{};
                    }
                    if ((n3 & 4) != 0) {
                        int[] nArray3 = new int[]{1, 0, 3};
                        nArray2 = nArray3;
                    }
                    if ((n3 & 8) != 0) {
                        stringArray = new String[]{};
                    }
                    if ((n3 & 0x10) != 0) {
                        stringArray2 = new String[]{};
                    }
                    if ((n3 & 0x20) != 0) {
                        string = "";
                    }
                    if ((n3 & 0x40) != 0) {
                        string2 = "";
                    }
                    if ((n3 & 0x80) != 0) {
                        n2 = 0;
                    }
                    this(n, nArray, nArray2, stringArray, stringArray2, string, string2, n2);
                }

                public final /* synthetic */ int kind() {
                    return this.kind;
                }

                public final /* synthetic */ int[] metadataVersion() {
                    return this.metadataVersion;
                }

                public final /* synthetic */ int[] bytecodeVersion() {
                    return this.bytecodeVersion;
                }

                public final /* synthetic */ String[] data1() {
                    return this.data1;
                }

                public final /* synthetic */ String[] data2() {
                    return this.data2;
                }

                public final /* synthetic */ String extraString() {
                    return this.extraString;
                }

                public final /* synthetic */ String packageName() {
                    return this.packageName;
                }

                public final /* synthetic */ int extraInt() {
                    return this.extraInt;
                }

                public final boolean equals(@Nullable Object other) {
                    if (!(other instanceof Metadata)) {
                        return false;
                    }
                    Metadata metadata = (Metadata)other;
                    if (((Metadata)this).k() != metadata.k()) {
                        return false;
                    }
                    if (!Arrays.equals(((Metadata)this).mv(), metadata.mv())) {
                        return false;
                    }
                    if (!Arrays.equals(((Metadata)this).bv(), metadata.bv())) {
                        return false;
                    }
                    if (!Arrays.equals(((Metadata)this).d1(), metadata.d1())) {
                        return false;
                    }
                    if (!Arrays.equals(((Metadata)this).d2(), metadata.d2())) {
                        return false;
                    }
                    if (!Intrinsics.areEqual((Object)((Metadata)this).xs(), (Object)metadata.xs())) {
                        return false;
                    }
                    if (!Intrinsics.areEqual((Object)((Metadata)this).pn(), (Object)metadata.pn())) {
                        return false;
                    }
                    return ((Metadata)this).xi() == metadata.xi();
                }

                public final int hashCode() {
                    int result2 = "kind".hashCode() * 127 ^ Integer.hashCode(this.kind);
                    result2 += "metadataVersion".hashCode() * 127 ^ Arrays.hashCode(this.metadataVersion);
                    result2 += "bytecodeVersion".hashCode() * 127 ^ Arrays.hashCode(this.bytecodeVersion);
                    result2 += "data1".hashCode() * 127 ^ Arrays.hashCode(this.data1);
                    result2 += "data2".hashCode() * 127 ^ Arrays.hashCode(this.data2);
                    result2 += "extraString".hashCode() * 127 ^ this.extraString.hashCode();
                    result2 += "packageName".hashCode() * 127 ^ this.packageName.hashCode();
                    return result2 += "extraInt".hashCode() * 127 ^ Integer.hashCode(this.extraInt);
                }

                @NotNull
                public final String toString() {
                    return "@kotlin.Metadata(kind=" + this.kind + ", metadataVersion=" + Arrays.toString(this.metadataVersion) + ", bytecodeVersion=" + Arrays.toString(this.bytecodeVersion) + ", data1=" + Arrays.toString(this.data1) + ", data2=" + Arrays.toString(this.data2) + ", extraString=" + this.extraString + ", packageName=" + this.packageName + ", extraInt=" + this.extraInt + ")";
                }

                public final /* synthetic */ Class annotationType() {
                    return Metadata.class;
                }
            };
        }
    }
}

