/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.RangeMapping;
import org.jetbrains.kotlin.codegen.inline.SMAP;
import org.jetbrains.kotlin.codegen.inline.SourcePosition;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.core.SourceLineKind;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a<\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"mapStacktraceLineToSource", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtFile;", "", "smapData", "Lorg/jetbrains/kotlin/codegen/inline/SMAP;", "line", "project", "Lcom/intellij/openapi/project/Project;", "lineKind", "Lorg/jetbrains/kotlin/idea/debugger/core/SourceLineKind;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "intellij.kotlin.jvm.debugger.core"})
public final class SmapUtilKt {
    @Nullable
    public static final Pair<KtFile, Integer> mapStacktraceLineToSource(@NotNull SMAP smapData, int line, @NotNull Project project, @NotNull SourceLineKind lineKind, @NotNull GlobalSearchScope searchScope) {
        Intrinsics.checkNotNullParameter((Object)smapData, (String)"smapData");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)lineKind), (String)"lineKind");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        RangeMapping rangeMapping = smapData.findRange(line);
        if (rangeMapping == null) {
            return null;
        }
        RangeMapping interval = rangeMapping;
        SourcePosition sourcePosition = switch (WhenMappings.$EnumSwitchMapping$0[lineKind.ordinal()]) {
            case 1 -> interval.getCallSite();
            case 2 -> interval.mapDestToSource(line);
            default -> throw new NoWhenBranchMatchedException();
        };
        if (sourcePosition == null) {
            return null;
        }
        SourcePosition location = sourcePosition;
        JvmClassName jvmClassName = JvmClassName.byInternalName((String)location.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byInternalName(...)");
        JvmClassName jvmName = jvmClassName;
        KtFile ktFile2 = DebuggerUtils.INSTANCE.findSourceFileForClassIncludeLibrarySources(project, searchScope, jvmName, location.getFile());
        if (ktFile2 == null) {
            return null;
        }
        KtFile sourceFile = ktFile2;
        return TuplesKt.to((Object)sourceFile, (Object)(location.getLine() - 1));
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SourceLineKind.values().length];
            try {
                nArray[SourceLineKind.CALL_LINE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SourceLineKind.EXECUTED_LINE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

