/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.breakpoints;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.psi.PsiElement;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.BreakpointChecker;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/InspectBreakpointApplicabilityAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "getData", "Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/InspectBreakpointApplicabilityAction$ActionData;", "BreakpointsGutterProvider", "ActionData", "intellij.kotlin.jvm.debugger.core"})
@SourceDebugExtension(value={"SMAP\nInspectBreakpointApplicabilityAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectBreakpointApplicabilityAction.kt\norg/jetbrains/kotlin/idea/debugger/core/breakpoints/InspectBreakpointApplicabilityAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,65:1\n1586#2:66\n1661#2,3:67\n81#3:70\n*S KotlinDebug\n*F\n+ 1 InspectBreakpointApplicabilityAction.kt\norg/jetbrains/kotlin/idea/debugger/core/breakpoints/InspectBreakpointApplicabilityAction\n*L\n30#1:66\n30#1:67,3\n53#1:70\n*E\n"})
public final class InspectBreakpointApplicabilityAction
extends AnAction {
    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ActionData actionData = this.getData(e);
        if (actionData == null) {
            return;
        }
        ActionData data = actionData;
        if (data.getEditor().getGutter().isAnnotationsShown()) {
            data.getEditor().getGutter().closeAllAnnotations();
        }
        BreakpointChecker checker = new BreakpointChecker();
        int lineCount = PsiLinesUtilsKt.getLineCount((PsiElement)data.getFile());
        Iterable $this$map$iv = (Iterable)new IntRange(0, lineCount);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void line;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(checker.check(data.getFile(), (int)line));
        }
        List breakpoints = (List)destination$iv$iv;
        BreakpointsGutterProvider gutterProvider = new BreakpointsGutterProvider(breakpoints);
        data.getEditor().getGutter().registerTextAnnotation((TextAnnotationGutterProvider)gutterProvider);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean $i$f$isApplicationInternalMode = false;
        e.getPresentation().setVisible(ApplicationManager.getApplication().isInternal());
        e.getPresentation().setEnabled(this.getData(e) != null);
    }

    private final ActionData getData(AnActionEvent $this$getData) {
        Editor editor = (Editor)$this$getData.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        Object object = $this$getData.getData(CommonDataKeys.PSI_FILE);
        KtFile ktFile2 = object instanceof KtFile ? (KtFile)object : null;
        if (ktFile2 == null) {
            return null;
        }
        KtFile file = ktFile2;
        return new ActionData(editor2, file);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/InspectBreakpointApplicabilityAction$ActionData;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtFile;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "intellij.kotlin.jvm.debugger.core"})
    public static final class ActionData {
        @NotNull
        private final Editor editor;
        @NotNull
        private final KtFile file;

        public ActionData(@NotNull Editor editor, @NotNull KtFile file) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.editor = editor;
            this.file = file;
        }

        @NotNull
        public final Editor getEditor() {
            return this.editor;
        }

        @NotNull
        public final KtFile getFile() {
            return this.file;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001c\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00032\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/InspectBreakpointApplicabilityAction$BreakpointsGutterProvider;", "Lcom/intellij/openapi/editor/TextAnnotationGutterProvider;", "breakpoints", "", "Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/BreakpointChecker$BreakpointType;", "<init>", "(Ljava/util/List;)V", "getLineText", "", "line", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "getToolTip", "getStyle", "Lcom/intellij/openapi/editor/colors/EditorFontType;", "getPopupActions", "Lcom/intellij/openapi/actionSystem/AnAction;", "getColor", "Lcom/intellij/openapi/editor/colors/ColorKey;", "getBgColor", "Ljava/awt/Color;", "gutterClosed", "", "intellij.kotlin.jvm.debugger.core"})
    private static final class BreakpointsGutterProvider
    implements TextAnnotationGutterProvider {
        @NotNull
        private final List<List<BreakpointChecker.BreakpointType>> breakpoints;

        public BreakpointsGutterProvider(@NotNull List<? extends List<? extends BreakpointChecker.BreakpointType>> breakpoints) {
            Intrinsics.checkNotNullParameter(breakpoints, (String)"breakpoints");
            this.breakpoints = breakpoints;
        }

        @Nullable
        public String getLineText(int line, @Nullable Editor editor) {
            List list2 = (List)CollectionsKt.getOrNull(this.breakpoints, (int)line);
            if (list2 == null) {
                return null;
            }
            List breakpoints = list2;
            return CollectionsKt.joinToString$default((Iterable)breakpoints, null, null, null, (int)0, null, BreakpointsGutterProvider::getLineText$lambda$0, (int)31, null);
        }

        @Nullable
        public String getToolTip(int line, @Nullable Editor editor) {
            return null;
        }

        @NotNull
        public EditorFontType getStyle(int line, @Nullable Editor editor) {
            return EditorFontType.PLAIN;
        }

        @NotNull
        public List<AnAction> getPopupActions(int line, @Nullable Editor editor) {
            return CollectionsKt.emptyList();
        }

        @Nullable
        public ColorKey getColor(int line, @Nullable Editor editor) {
            return null;
        }

        @Nullable
        public Color getBgColor(int line, @Nullable Editor editor) {
            return null;
        }

        public void gutterClosed() {
        }

        private static final CharSequence getLineText$lambda$0(BreakpointChecker.BreakpointType it) {
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            return it.getPrefix();
        }
    }
}

