/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ApplicationKt;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.debugger.core.ClassNameProvider;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinFunctionBreakpointKt;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.SourcePositionRefiner;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\r\u001a\u00020\fH\u0014J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinFunctionBreakpoint;", "Lcom/intellij/debugger/ui/breakpoints/MethodBreakpoint;", "Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/SourcePositionRefiner;", "project", "Lcom/intellij/openapi/project/Project;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/breakpoints/XBreakpoint;)V", "getPsiClass", "Lcom/intellij/psi/PsiClass;", "refineSourcePosition", "Lcom/intellij/debugger/SourcePosition;", "sourcePosition", "computeMethodDescriptor", "Lcom/intellij/debugger/ui/breakpoints/MethodBreakpoint$MethodDescriptor;", "computeClassPattern", "", "getKtClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "intellij.kotlin.jvm.debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinFunctionBreakpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinFunctionBreakpoint.kt\norg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinFunctionBreakpoint\n+ 2 analyseUtils.kt\norg/jetbrains/kotlin/idea/debugger/base/util/AnalyseUtilsKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,136:1\n65#2,8:137\n46#2,9:145\n67#3:154\n*S KotlinDebug\n*F\n+ 1 KotlinFunctionBreakpoint.kt\norg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinFunctionBreakpoint\n*L\n45#1:137,8\n45#1:145,9\n51#1:154\n*E\n"})
public class KotlinFunctionBreakpoint
extends MethodBreakpoint
implements SourcePositionRefiner {
    public KotlinFunctionBreakpoint(@NotNull Project project, @NotNull XBreakpoint<?> breakpoint2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        super(project, breakpoint2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public PsiClass getPsiClass() {
        Object object;
        KtClassOrObject ktClassOrObject = this.getKtClass();
        if (ktClassOrObject == null) {
            return null;
        }
        KtClassOrObject declaration = ktClassOrObject;
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        Project project2 = project;
        KtLightClass default$iv = null;
        boolean $i$f$runSmartReadActionIfUnderProgressElseDumb = false;
        boolean isCancellableSection$iv = DebuggerManagerThreadImpl.Companion.hasNonDefaultProgressIndicator();
        if (isCancellableSection$iv && !ApplicationKt.getApplication().isReadAccessAllowed()) {
            object = ReadAction.nonBlocking((Callable)new Callable(declaration){
                final /* synthetic */ KtClassOrObject $declaration$inlined;
                {
                    this.$declaration$inlined = ktClassOrObject;
                }

                public final KtLightClass call() {
                    boolean bl = false;
                    return LightClassUtilsKt.toLightClass((KtClassOrObject)this.$declaration$inlined);
                }
            }).inSmartMode((Project)project$iv).executeSynchronously();
        } else {
            void project$iv$iv;
            void var6_6 = project$iv;
            KtLightClass fallback$iv$iv = default$iv;
            boolean $i$f$runDumbAction = false;
            KtLightClass fallback$iv$iv$iv = fallback$iv$iv;
            boolean $i$f$internalDumbAction = false;
            boolean bl = false;
            if (((Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>((Project)project$iv$iv){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                }

                public final Boolean invoke() {
                    return DumbService.Companion.isDumb(this.$project);
                }
            }))).booleanValue()) {
                object = fallback$iv$iv$iv;
            } else {
                KtLightClass ktLightClass;
                try {
                    boolean bl2 = false;
                    ktLightClass = LightClassUtilsKt.toLightClass((KtClassOrObject)declaration);
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    ktLightClass = fallback$iv$iv$iv;
                }
                object = ktLightClass;
            }
        }
        return (PsiClass)object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SourcePosition refineSourcePosition(@NotNull SourcePosition sourcePosition) {
        PsiElement psiElement;
        block7: {
            block6: {
                void $this$parentOfType$iv;
                Intrinsics.checkNotNullParameter((Object)sourcePosition, (String)"sourcePosition");
                psiElement = sourcePosition.getElementAt();
                if (psiElement == null) break block6;
                PsiElement psiElement2 = psiElement;
                boolean withSelf$iv = true;
                boolean $i$f$parentOfType = false;
                psiElement = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtDeclaration.class, (boolean)false);
                if (psiElement != null) break block7;
            }
            return sourcePosition;
        }
        PsiElement declaration = psiElement;
        if (KtPsiUtilKt.isExpectDeclaration((KtDeclaration)declaration)) {
            KtDeclaration ktDeclaration = KotlinFunctionBreakpointKt.access$getActualJvmDeclaration((KtDeclaration)declaration);
            if (ktDeclaration == null) {
                return sourcePosition;
            }
            KtDeclaration actualDeclaration = ktDeclaration;
            SourcePosition sourcePosition2 = SourcePosition.createFromElement((PsiElement)((PsiElement)actualDeclaration));
            if (sourcePosition2 == null) {
                sourcePosition2 = sourcePosition;
            }
            return sourcePosition2;
        }
        return sourcePosition;
    }

    @Nullable
    protected MethodBreakpoint.MethodDescriptor computeMethodDescriptor(@NotNull SourcePosition sourcePosition) {
        Intrinsics.checkNotNullParameter((Object)sourcePosition, (String)"sourcePosition");
        ProgressManager.checkCanceled();
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        return KotlinFunctionBreakpointKt.getMethodDescriptor(sourcePosition, project);
    }

    @Nullable
    protected String computeClassPattern() {
        KtClassOrObject ktClassOrObject = this.getKtClass();
        if (ktClassOrObject == null) {
            return null;
        }
        KtClassOrObject declaration = ktClassOrObject;
        String pattern2 = (String)CollectionsKt.firstOrNull(new ClassNameProvider(null, 1, null).getCandidatesForElement((PsiElement)declaration));
        if (pattern2 != null) {
            return pattern2;
        }
        PsiClass psiClass = this.getPsiClass();
        return psiClass != null ? psiClass.getQualifiedName() : null;
    }

    private final KtClassOrObject getKtClass() {
        SourcePosition sourcePosition = this.getSourcePosition();
        return (KtClassOrObject)PositionUtil.getPsiElementAt((Project)this.myProject, KtClassOrObject.class, (SourcePosition)sourcePosition);
    }
}

