/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.LightOrRealThreadInfo;
import com.intellij.debugger.engine.StepIntoMethodBreakpoint;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.debugger.ui.breakpoints.SteppingBreakpoint;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.StackFrameInterceptor;
import org.jetbrains.kotlin.idea.debugger.core.stepping.AdditionalProbeBreakpoint;
import org.jetbrains.kotlin.idea.debugger.core.stepping.ClearSteppingBreakpoint;
import org.jetbrains.kotlin.idea.debugger.core.stepping.CoroutineBreakpointFacility;
import org.jetbrains.kotlin.idea.debugger.core.stepping.CoroutineBreakpointFacilityKt;
import org.jetbrains.kotlin.idea.debugger.core.stepping.DebuggerSteppingHelper;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u0007H\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u0007H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineBreakpointFacility;", "", "<init>", "()V", "installResumeBreakpointInCurrentMethod", "", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "installResumeBreakpointInCallerMethod", "installCoroutineResumedBreakpoint", "context", "resumedLocation", "Lcom/sun/jdi/Location;", "nextLocationAfterResume", "installBreakpointToRemoveSteppingInCurrentThread", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/ClearSteppingBreakpoint;", "installAdditionalBreakpoint", "", "probeMethod", "Lcom/sun/jdi/Method;", "additionalRequestor", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/AdditionalProbeBreakpoint;", "intellij.kotlin.jvm.debugger.core"})
@SourceDebugExtension(value={"SMAP\nCoroutineBreakpointFacility.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineBreakpointFacility.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineBreakpointFacility\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,220:1\n23#2:221\n60#2,5:222\n23#2:227\n60#2,5:228\n23#2:233\n23#2:234\n23#2:235\n60#2,5:236\n672#3,11:241\n672#3,11:252\n*S KotlinDebug\n*F\n+ 1 CoroutineBreakpointFacility.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineBreakpointFacility\n*L\n36#1:221\n36#1:222,5\n47#1:227\n47#1:228,5\n59#1:233\n67#1:234\n112#1:235\n112#1:236,5\n126#1:241,11\n127#1:252,11\n*E\n"})
public final class CoroutineBreakpointFacility {
    @NotNull
    public static final CoroutineBreakpointFacility INSTANCE = new CoroutineBreakpointFacility();

    private CoroutineBreakpointFacility() {
    }

    /*
     * WARNING - void declaration
     */
    public final boolean installResumeBreakpointInCurrentMethod(@NotNull SuspendContextImpl suspendContext) {
        void $this$debug_u24default$iv;
        Location location;
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Location location2 = suspendContext.getLocation();
        if (location2 == null) {
            return false;
        }
        Location currentLocation = location2;
        List<Location> methodLineLocations = currentLocation.method().allLineLocations();
        if (methodLineLocations.size() > 2 && Intrinsics.areEqual((Object)methodLineLocations.get(methodLineLocations.size() - 2), (Object)currentLocation)) {
            StackFrameInterceptor stackFrameInterceptor = StackFrameInterceptor.Companion.getInstance();
            location = stackFrameInterceptor != null ? stackFrameInterceptor.callerLocation(suspendContext) : null;
        } else {
            location = currentLocation;
        }
        if (location == null) {
            return false;
        }
        Location resumeLocation = location;
        Location nextLocationAfterResume = DebuggerUtil.getLocationOfNextInstructionAfterResume(resumeLocation);
        CoroutineBreakpointFacility $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(CoroutineBreakpointFacility.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        $this$thisLogger$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            void var10_10 = $this$debug_u24default$iv;
            boolean bl = false;
            Location location3 = nextLocationAfterResume;
            var10_10.debug("Trying to set a resume breakpoint in the current method: resumeMethod: " + SafeUtilKt.safeMethod(resumeLocation) + ", nextCallLocationLine = " + (location3 != null ? Integer.valueOf(location3.lineNumber()) : null), t$iv);
        }
        return this.installCoroutineResumedBreakpoint(suspendContext, resumeLocation, nextLocationAfterResume);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean installResumeBreakpointInCallerMethod(@NotNull SuspendContextImpl suspendContext) {
        void $this$debug_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Object object = StackFrameInterceptor.Companion.getInstance();
        if (object == null || (object = object.callerLocation(suspendContext)) == null) {
            return false;
        }
        Object resumeLocation = object;
        Location nextLocationAfterResume = DebuggerUtil.getLocationOfNextInstructionAfterResume((Location)resumeLocation);
        CoroutineBreakpointFacility $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(CoroutineBreakpointFacility.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        $this$thisLogger$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            void var8_8 = $this$debug_u24default$iv;
            boolean bl = false;
            Location location = nextLocationAfterResume;
            var8_8.debug("Trying to set a resume breakpoint in the caller method: resumeMethod: " + SafeUtilKt.safeMethod((Location)resumeLocation) + ", nextCallLocationLine = " + (location != null ? Integer.valueOf(location.lineNumber()) : null), t$iv);
        }
        return this.installCoroutineResumedBreakpoint(suspendContext, (Location)resumeLocation, nextLocationAfterResume);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean installCoroutineResumedBreakpoint(SuspendContextImpl context2, Location resumedLocation, Location nextLocationAfterResume) {
        void $this$debug_u24default$iv;
        DebugProcessImpl debugProcess = context2.getDebugProcess();
        debugProcess.cancelSteppingBreakpoints();
        ClearSteppingBreakpoint clearSteppingBreakpoint = this.installBreakpointToRemoveSteppingInCurrentThread(context2);
        if (clearSteppingBreakpoint == null) {
            CoroutineBreakpointFacility $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CoroutineBreakpointFacility.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("No clear stepping breakpoint installed for context " + context2);
        }
        Project project = debugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        boolean useCoroutineIdFiltering = Registry.Companion.is("debugger.filter.breakpoints.by.coroutine.id");
        Method method = SafeUtilKt.safeMethod(resumedLocation);
        if (method == null) {
            return false;
        }
        Method method2 = method;
        if (debugProcess.getRequestsManager().getFilterThread() == null) {
            CoroutineBreakpointFacility $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CoroutineBreakpointFacility.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Coroutine filter should be calculated and set before breakpoint request created. In other case, this breakpoint may be hit while intermediate evaluations on other threads before the filter will be set.");
        }
        String $i$f$thisLogger = method2.declaringType().name();
        String string = method2.name();
        String string2 = method2.signature();
        StepIntoMethodBreakpoint breakpoint2 = new StepIntoMethodBreakpoint(project2, debugProcess, clearSteppingBreakpoint, nextLocationAfterResume, context2, $i$f$thisLogger, string, string2){
            final /* synthetic */ DebugProcessImpl $debugProcess;
            final /* synthetic */ ClearSteppingBreakpoint $clearSteppingBreakpoint;
            final /* synthetic */ Location $nextLocationAfterResume;
            final /* synthetic */ SuspendContextImpl $context;
            {
                this.$debugProcess = $debugProcess;
                this.$clearSteppingBreakpoint = $clearSteppingBreakpoint;
                this.$nextLocationAfterResume = $nextLocationAfterResume;
                this.$context = $context;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $project);
            }

            public boolean isRestoreBreakpoints() {
                return false;
            }

            protected boolean stopOnlyInBaseClass() {
                return true;
            }

            /*
             * WARNING - void declaration
             */
            public boolean processLocatableEvent(SuspendContextCommandImpl action2, LocatableEvent event) {
                SuspendContextImpl suspendContextImpl;
                block5: {
                    void $this$debug_u24default$iv;
                    Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                    installCoroutineResumedBreakpoint.breakpoint.1 $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(installCoroutineResumedBreakpoint.breakpoint.1.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    $this$thisLogger$iv = logger;
                    SuspendContextImpl suspendContextImpl2 = this.$context;
                    Throwable t$iv = null;
                    boolean $i$f$debug = false;
                    if ($this$debug_u24default$iv.isDebugEnabled()) {
                        void var11_9 = $this$debug_u24default$iv;
                        boolean bl = false;
                        var11_9.debug("Hit the resume breakpoint at " + suspendContextImpl2.getLocation(), t$iv);
                    }
                    boolean result2 = super.processLocatableEvent(action2, event);
                    if (result2) {
                        this.$debugProcess.getRequestsManager().deleteRequest((Requestor)this);
                    }
                    if (!result2) {
                        return false;
                    }
                    SuspendContextImpl suspendContextImpl3 = action2.getSuspendContext();
                    if (suspendContextImpl3 == null) {
                        return true;
                    }
                    suspendContextImpl = suspendContextImpl3;
                    ClearSteppingBreakpoint clearSteppingBreakpoint = this.$clearSteppingBreakpoint;
                    if (clearSteppingBreakpoint == null) break block5;
                    ClearSteppingBreakpoint it = clearSteppingBreakpoint;
                    boolean bl = false;
                    if (!it.getSteppingRemoved()) {
                        installCoroutineResumedBreakpoint.breakpoint.1 $this$thisLogger$iv2 = this;
                        boolean $i$f$thisLogger2 = false;
                        Logger logger2 = Logger.getInstance(installCoroutineResumedBreakpoint.breakpoint.1.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                        logger2.debug("Clear old stepping from resume breakpoint");
                        it.removeRequestAndStepping(suspendContextImpl);
                    }
                }
                return this.scheduleStepOverCommandForSuspendSwitch(suspendContextImpl, this.$nextLocationAfterResume);
            }

            private final boolean scheduleStepOverCommandForSuspendSwitch(SuspendContextImpl it, Location nextLocationAfterResume) {
                DebuggerSteppingHelper.INSTANCE.createStepOverCommandForSuspendSwitch(it, nextLocationAfterResume).prepareSteppingRequestsAndHints(it);
                return false;
            }
        };
        breakpoint2.setSuspendPolicy(context2.getSuspendPolicyFromRequestors());
        if (!useCoroutineIdFiltering) {
            CoroutineBreakpointFacilityKt.access$applyEmptyThreadFilter(debugProcess);
        }
        breakpoint2.createRequest(debugProcess);
        debugProcess.setSteppingBreakpoint((SteppingBreakpoint)breakpoint2);
        LightOrRealThreadInfo filterThread = debugProcess.getRequestsManager().getFilterThread();
        CoroutineBreakpointFacility $this$thisLogger$iv = this;
        boolean $i$f$thisLogger2 = false;
        Logger logger = Logger.getInstance(CoroutineBreakpointFacility.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        $this$thisLogger$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            void var15_17 = $this$debug_u24default$iv;
            boolean bl = false;
            var15_17.debug("Resume breakpoint for " + method2 + " in thread " + filterThread, t$iv);
        }
        return true;
    }

    private final ClearSteppingBreakpoint installBreakpointToRemoveSteppingInCurrentThread(SuspendContextImpl context2) {
        Object v8;
        Method probeResumeMethod;
        Object originalThread;
        block11: {
            Object v5;
            List<Method> methods;
            block10: {
                Object object = context2.getFrameProxy();
                if (object == null || (object = object.getClassLoader()) == null) {
                    return null;
                }
                Object classLoader = object;
                Object object2 = context2.getThread();
                if (object2 == null || (object2 = object2.getThreadReference()) == null) {
                    return null;
                }
                originalThread = object2;
                ReferenceType referenceType = context2.getDebugProcess().findLoadedClass((SuspendContext)context2, "kotlinx.coroutines.debug.internal.DebugProbesImpl", (ClassLoaderReference)classLoader);
                if (referenceType == null) {
                    return null;
                }
                ReferenceType debugProbesImpl = referenceType;
                List<Method> list2 = debugProbesImpl.methods();
                if (list2 == null) {
                    return null;
                }
                methods = list2;
                Iterable $this$singleOrNull$iv = methods;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    Method it = (Method)element$iv;
                    boolean bl = false;
                    String string = it.name();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"probeCoroutineResumed", (boolean)false, (int)2, null)) continue;
                    if (found$iv) {
                        v5 = null;
                        break block10;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v5 = !found$iv ? null : single$iv;
            }
            Method method = v5;
            if (method == null) {
                return null;
            }
            probeResumeMethod = method;
            Iterable $this$singleOrNull$iv = methods;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                Method it = (Method)element$iv;
                boolean bl = false;
                String string = it.name();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"probeCoroutineSuspended", (boolean)false, (int)2, null)) continue;
                if (found$iv) {
                    v8 = null;
                    break block11;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v8 = !found$iv ? null : single$iv;
        }
        Method method = v8;
        if (method == null) {
            return null;
        }
        Method probeSuspendedMethod = method;
        Project project = context2.getDebugProcess().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        ClearSteppingBreakpoint coroutineSuspendedBreakpoint = new ClearSteppingBreakpoint(project2, (ThreadReference)originalThread);
        this.installAdditionalBreakpoint(probeSuspendedMethod, coroutineSuspendedBreakpoint, context2);
        AdditionalProbeBreakpoint coroutineResumedBreakpoint2 = new AdditionalProbeBreakpoint(project2, coroutineSuspendedBreakpoint, (ThreadReference)originalThread){
            final /* synthetic */ ClearSteppingBreakpoint $coroutineSuspendedBreakpoint;
            final /* synthetic */ ThreadReference $originalThread;
            {
                this.$coroutineSuspendedBreakpoint = $coroutineSuspendedBreakpoint;
                this.$originalThread = $originalThread;
                super($project);
            }

            /*
             * WARNING - void declaration
             */
            public boolean processLocatableEvent(SuspendContextCommandImpl action2, LocatableEvent event) {
                void $this$debug_u24default$iv;
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                ClearSteppingBreakpoint clearSteppingBreakpoint = this.$coroutineSuspendedBreakpoint;
                int n = clearSteppingBreakpoint.getCounter();
                clearSteppingBreakpoint.setCounter(n + 1);
                installBreakpointToRemoveSteppingInCurrentThread.coroutineResumedBreakpoint.1 $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(installBreakpointToRemoveSteppingInCurrentThread.coroutineResumedBreakpoint.1.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                $this$thisLogger$iv = logger;
                ThreadReference threadReference = this.$originalThread;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    void var8_8 = $this$debug_u24default$iv;
                    boolean bl = false;
                    var8_8.debug("It seems we enter undispatched coroutine in " + threadReference, t$iv);
                }
                return false;
            }
        };
        this.installAdditionalBreakpoint(probeResumeMethod, coroutineResumedBreakpoint2, context2);
        coroutineSuspendedBreakpoint.setProbeResumeBreakpoint(coroutineResumedBreakpoint2);
        return coroutineSuspendedBreakpoint;
    }

    private final void installAdditionalBreakpoint(Method probeMethod, AdditionalProbeBreakpoint additionalRequestor, SuspendContextImpl context2) {
        Object object = context2.getThread();
        if (object == null || (object = object.getThreadReference()) == null) {
            return;
        }
        Object originalThread = object;
        Location locationForBP = probeMethod.locationOfCodeIndex(0L);
        additionalRequestor.setSuspendPolicy("SuspendThread");
        RequestManagerImpl requestsManager = context2.getDebugProcess().getRequestsManager();
        BreakpointRequest request = requestsManager.createBreakpointRequest((FilteredRequestor)additionalRequestor, locationForBP);
        request.addThreadFilter((ThreadReference)originalThread);
        requestsManager.enableRequest((EventRequest)request);
        context2.getDebugProcess().setSteppingBreakpoint((SteppingBreakpoint)additionalRequestor);
    }
}

