/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.sun.jdi.Location;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinInlineFilter;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinRequestHintKt;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinStepAction;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinSteppingCommandProviderKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u0016\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0014J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J>\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0014R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinRequestHint;", "Lcom/intellij/debugger/engine/RequestHint;", "stepThread", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "stepSize", "", "depth", "filter", "Lcom/intellij/debugger/engine/MethodFilter;", "parentHint", "<init>", "(Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;Lcom/intellij/debugger/engine/SuspendContextImpl;IILcom/intellij/debugger/engine/MethodFilter;Lcom/intellij/debugger/engine/RequestHint;)V", "myInlineFilter", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinInlineFilter;", "isTheSameFrame", "", "context", "getNextStepDepth", "doStep", "", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "size", "commandToken", "", "intellij.kotlin.jvm.debugger.core"})
public class KotlinRequestHint
extends RequestHint {
    @Nullable
    private final KotlinInlineFilter myInlineFilter;

    public KotlinRequestHint(@NotNull ThreadReferenceProxyImpl stepThread, @NotNull SuspendContextImpl suspendContext, int stepSize, int depth, @Nullable MethodFilter filter2, @Nullable RequestHint parentHint) {
        Intrinsics.checkNotNullParameter((Object)stepThread, (String)"stepThread");
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        super(stepThread, suspendContext, stepSize, depth, filter2, parentHint);
        this.myInlineFilter = KotlinSteppingCommandProviderKt.createKotlinInlineFilter(suspendContext);
    }

    protected boolean isTheSameFrame(@NotNull SuspendContextImpl context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return super.isTheSameFrame(context2) && (this.myInlineFilter == null || !this.myInlineFilter.isNestedInline(context2));
    }

    public int getNextStepDepth(@NotNull SuspendContextImpl context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (KotlinRequestHintKt.access$needTechnicalStepInto(context2)) {
            return 1;
        }
        return super.getNextStepDepth(context2);
    }

    protected void doStep(@NotNull DebugProcessImpl debugProcess, @Nullable SuspendContextImpl suspendContext, @Nullable ThreadReferenceProxyImpl stepThread, int size, int depth, @Nullable Object commandToken) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        if (depth == 3) {
            KotlinStepAction action2;
            Location location;
            StackFrameProxyImpl frameProxy;
            SuspendContextImpl suspendContextImpl = suspendContext;
            StackFrameProxyImpl stackFrameProxyImpl = frameProxy = suspendContextImpl != null ? suspendContextImpl.getFrameProxy() : null;
            Location location2 = location = stackFrameProxyImpl != null ? SafeUtilKt.safeLocation((StackFrameProxy)stackFrameProxyImpl) : null;
            if (location != null && !((action2 = KotlinSteppingCommandProviderKt.getStepOutAction(location, frameProxy)) instanceof KotlinStepAction.StepOut)) {
                DebugProcessImpl.StepCommand command2 = action2.createCommand(debugProcess, suspendContext, false);
                RequestHint requestHint = command2.getHint(suspendContext, stepThread, (RequestHint)this);
                Intrinsics.checkNotNull((Object)requestHint);
                RequestHint hint2 = requestHint;
                command2.step(suspendContext, stepThread, hint2, commandToken);
                return;
            }
        }
        super.doStep(debugProcess, suspendContext, stepThread, size, depth, commandToken);
    }
}

