/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint;
import com.intellij.debugger.ui.breakpoints.SteppingBreakpoint;
import com.intellij.openapi.project.Project;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinRequestHint;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a8\u0006\u0007"}, d2={"addBreakpointAtFirstDeclaredLocationInLambda", "", "hint", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinRequestHint;", "context", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "needTechnicalStepInto", "intellij.kotlin.jvm.debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinRequestHint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinRequestHint.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinRequestHintKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,320:1\n2469#2,14:321\n*S KotlinDebug\n*F\n+ 1 KotlinRequestHint.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinRequestHintKt\n*L\n273#1:321,14\n*E\n"})
public final class KotlinRequestHintKt {
    private static final boolean addBreakpointAtFirstDeclaredLocationInLambda(KotlinRequestHint hint2, SuspendContextImpl context2) {
        Object v3;
        Location location = context2.getLocation();
        if (location == null) {
            return false;
        }
        Location currentLocation = location;
        if (!DebuggerUtil.isInKotlinSources(currentLocation)) {
            return false;
        }
        Method method = SafeUtilKt.safeMethod(currentLocation);
        if (method == null) {
            return false;
        }
        Method method2 = method;
        String string = method2.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        if (!DebuggerUtils.INSTANCE.isGeneratedIrBackendLambdaMethodName(string)) {
            return false;
        }
        Iterable $this$minByOrNull$iv = SafeUtilKt.safeAllLineLocations(method2);
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v3 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v3 = minElem$iv;
            } else {
                Location it = (Location)minElem$iv;
                boolean bl = false;
                long minValue$iv = it.codeIndex();
                do {
                    Object e$iv = iterator$iv.next();
                    Location it2 = (Location)e$iv;
                    $i$a$-minByOrNull-KotlinRequestHintKt$addBreakpointAtFirstDeclaredLocationInLambda$firstDeclaredLocation$1 = false;
                    long v$iv = it2.codeIndex();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v3 = minElem$iv;
            }
        }
        Location location2 = v3;
        if (location2 == null) {
            return false;
        }
        Location firstDeclaredLocation = location2;
        if (currentLocation.codeIndex() >= firstDeclaredLocation.codeIndex()) {
            return false;
        }
        SourcePosition sourcePosition = context2.getDebugProcess().getPositionManager().getSourcePosition(firstDeclaredLocation);
        if (sourcePosition == null) {
            return false;
        }
        SourcePosition sourcePosition2 = sourcePosition;
        BreakpointStepMethodFilter filter2 = new BreakpointStepMethodFilter(firstDeclaredLocation, sourcePosition2){
            final /* synthetic */ Location $firstDeclaredLocation;
            final /* synthetic */ SourcePosition $sourcePosition;
            {
                this.$firstDeclaredLocation = $firstDeclaredLocation;
                this.$sourcePosition = $sourcePosition;
            }

            public boolean locationMatches(DebugProcessImpl process2, Location location) {
                return Intrinsics.areEqual((Object)location, (Object)this.$firstDeclaredLocation);
            }

            public SourcePosition getBreakpointPosition() {
                return this.$sourcePosition;
            }

            public Void getCallingExpressionLines() {
                return null;
            }

            public int getLastStatementLine() {
                return -1;
            }
        };
        StepIntoBreakpoint stepIntoBreakpoint = DebuggerManagerEx.getInstanceEx((Project)context2.getDebugProcess().getProject()).getBreakpointManager().addStepIntoBreakpoint(filter2);
        if (stepIntoBreakpoint == null) {
            return false;
        }
        StepIntoBreakpoint breakpoint2 = stepIntoBreakpoint;
        DebugProcessImpl.prepareAndSetSteppingBreakpoint((SuspendContextImpl)context2, (SteppingBreakpoint)((SteppingBreakpoint)breakpoint2), (RequestHint)hint2, (boolean)true);
        return true;
    }

    private static final boolean needTechnicalStepInto(SuspendContextImpl context2) {
        ReferenceType referenceType;
        ClassType classType;
        Location location = context2.getLocation();
        if (location == null) {
            return false;
        }
        Location location2 = location;
        Comparable<Location> comparable = context2.getLocation();
        if (Intrinsics.areEqual((Object)(comparable != null && (comparable = comparable.declaringType()) != null ? comparable.name() : null), (Object)"kotlinx.coroutines.BuildersKt")) {
            return true;
        }
        if (!DebuggerUtil.isInKotlinSources(location2)) {
            return false;
        }
        Method method = location2.method();
        if (Intrinsics.areEqual((Object)(method != null ? method.name() : null), (Object)"invoke") && Intrinsics.areEqual((Object)((classType = (referenceType = location2.declaringType()) instanceof ClassType ? (ClassType)referenceType : null) != null && (classType = classType.superclass()) != null ? classType.name() : null), (Object)"kotlin.coroutines.jvm.internal.SuspendLambda")) {
            return true;
        }
        if (DebuggerUtil.isInSuspendMethod(location2) && DebuggerUtil.isOnSuspendReturnOrReenter(location2) && !DebuggerUtil.hasUserCodeOnFirstLine(SafeUtilKt.safeMethod(location2))) {
            return true;
        }
        Method method2 = SafeUtilKt.safeMethod(location2);
        return method2 != null && DebuggerUtil.isInvokeSuspendMethod(method2) && SafeUtilKt.safeLineNumber(location2) < 0;
    }

    public static final /* synthetic */ boolean access$needTechnicalStepInto(SuspendContextImpl context2) {
        return KotlinRequestHintKt.needTechnicalStepInto(context2);
    }

    public static final /* synthetic */ boolean access$addBreakpointAtFirstDeclaredLocationInLambda(KotlinRequestHint hint2, SuspendContextImpl context2) {
        return KotlinRequestHintKt.addBreakpointAtFirstDeclaredLocationInLambda(hint2, context2);
    }
}

