/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.JvmSteppingCommandProvider;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.xdebugger.XSourcePosition;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.core.stepping.DebuggerSteppingHelper;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinSteppingCommandProviderKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\b\u0018\u00010\u0005R\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J2\u0010\r\u001a\b\u0018\u00010\u0005R\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\u0011\u001a\b\u0018\u00010\u0005R\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\r\u001a\u00060\u0005R\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\"\u0010\u0004\u001a\u00060\u0005R\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015J\u001c\u0010\u0016\u001a\b\u0018\u00010\u0005R\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018J \u0010\u0016\u001a\b\u0018\u00010\u0005R\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\u0016\u001a\b\u0018\u00010\u0005R\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/KotlinSteppingCommandProvider;", "Lcom/intellij/debugger/impl/JvmSteppingCommandProvider;", "<init>", "()V", "getStepOverCommand", "Lcom/intellij/debugger/engine/DebugProcessImpl$ResumeCommand;", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "ignoreBreakpoints", "", "stepSize", "", "getStepIntoCommand", "ignoreFilters", "smartStepFilter", "Lcom/intellij/debugger/engine/MethodFilter;", "getRunToCursorCommand", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "getStepOutCommand", "debugContext", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "intellij.kotlin.jvm.debugger.core"})
public final class KotlinSteppingCommandProvider
extends JvmSteppingCommandProvider {
    @Nullable
    public DebugProcessImpl.ResumeCommand getStepOverCommand(@Nullable SuspendContextImpl suspendContext, boolean ignoreBreakpoints, int stepSize) {
        if (suspendContext == null || suspendContext.isResumed()) {
            return null;
        }
        SourcePosition sourcePosition = KotlinSteppingCommandProviderKt.access$getSourcePosition(suspendContext);
        if (sourcePosition == null) {
            return null;
        }
        SourcePosition sourcePosition2 = sourcePosition;
        if (!(sourcePosition2.getFile() instanceof KtFile)) {
            return null;
        }
        return this.getStepOverCommand(suspendContext, ignoreBreakpoints, sourcePosition2);
    }

    @Nullable
    public DebugProcessImpl.ResumeCommand getStepIntoCommand(@Nullable SuspendContextImpl suspendContext, boolean ignoreFilters, @Nullable MethodFilter smartStepFilter, int stepSize) {
        if (suspendContext == null || suspendContext.isResumed()) {
            return null;
        }
        SourcePosition sourcePosition = KotlinSteppingCommandProviderKt.access$getSourcePosition(suspendContext);
        if (sourcePosition == null) {
            return null;
        }
        SourcePosition sourcePosition2 = sourcePosition;
        if (!(sourcePosition2.getFile() instanceof KtFile)) {
            return null;
        }
        return this.getStepIntoCommand(suspendContext, ignoreFilters, smartStepFilter);
    }

    @Nullable
    public DebugProcessImpl.ResumeCommand getRunToCursorCommand(@Nullable SuspendContextImpl suspendContext, @NotNull XSourcePosition position, boolean ignoreBreakpoints) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (suspendContext == null || suspendContext.isResumed()) {
            return null;
        }
        if (!Registry.Companion.is("debugger.filter.breakpoints.by.coroutine.id")) {
            return null;
        }
        return DebuggerSteppingHelper.INSTANCE.createRunToCursorCommand(suspendContext, position, ignoreBreakpoints);
    }

    @NotNull
    public final DebugProcessImpl.ResumeCommand getStepIntoCommand(@NotNull SuspendContextImpl suspendContext, boolean ignoreFilters, @Nullable MethodFilter smartStepFilter) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        return DebuggerSteppingHelper.INSTANCE.createStepIntoCommand(suspendContext, ignoreFilters, smartStepFilter);
    }

    @NotNull
    public final DebugProcessImpl.ResumeCommand getStepOverCommand(@NotNull SuspendContextImpl suspendContext, boolean ignoreBreakpoints, @NotNull SourcePosition sourcePosition) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkNotNullParameter((Object)sourcePosition, (String)"sourcePosition");
        return DebuggerSteppingHelper.INSTANCE.createStepOverCommand(suspendContext, ignoreBreakpoints, sourcePosition);
    }

    @Nullable
    public final DebugProcessImpl.ResumeCommand getStepOutCommand(@NotNull SuspendContextImpl suspendContext, @NotNull DebuggerContextImpl debugContext) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Intrinsics.checkNotNullParameter((Object)debugContext, (String)"debugContext");
        SourcePosition sourcePosition = debugContext.getSourcePosition();
        Intrinsics.checkNotNullExpressionValue((Object)sourcePosition, (String)"getSourcePosition(...)");
        return this.getStepOutCommand(suspendContext, sourcePosition);
    }

    @Nullable
    public DebugProcessImpl.ResumeCommand getStepOutCommand(@Nullable SuspendContextImpl suspendContext, int stepSize) {
        if (suspendContext == null || suspendContext.isResumed()) {
            return null;
        }
        SourcePosition sourcePosition = suspendContext.getDebugProcess().getDebuggerContext().getSourcePosition();
        if (sourcePosition == null) {
            return null;
        }
        SourcePosition sourcePosition2 = sourcePosition;
        if (!(sourcePosition2.getFile() instanceof KtFile)) {
            return null;
        }
        return this.getStepOutCommand(suspendContext, sourcePosition2);
    }

    private final DebugProcessImpl.ResumeCommand getStepOutCommand(SuspendContextImpl suspendContext, SourcePosition sourcePosition) {
        if (sourcePosition.getLine() < 0) {
            return null;
        }
        return DebuggerSteppingHelper.INSTANCE.createStepOutCommand(suspendContext, true);
    }
}

