/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine;

import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.kotlin.idea.debugger.coroutine.CoroutineDebuggerMode;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013H\u0002J$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00192\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0018\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineAgentConnector;", "", "<init>", "()V", "KOTLIN_STDLIB", "", "KOTLINX_COROUTINES_DEBUG_PROBES_IMPL_FQN", "MINIMAL_SUPPORTED_COROUTINES_VERSION", "Lorg/apache/maven/artifact/versioning/DefaultArtifactVersion;", "KOTLINX_COROUTINES_CORE", "KOTLINX_COROUTINES_CORE_JVM_JAR_REGEX", "Lkotlin/text/Regex;", "getKOTLINX_COROUTINES_CORE_JVM_JAR_REGEX", "()Lkotlin/text/Regex;", "attachCoroutineAgent", "", "project", "Lcom/intellij/openapi/project/Project;", "configuration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "findKotlinxCoroutinesCoreJar", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineAgentConnector$KotlinxCoroutinesSearchResult;", "getKotlinxCoroutinesJarsFromClasspath", "", "determineCoreVersionMode", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineDebuggerMode;", "version", "initializeCoroutineAgent", "jarPath", "KotlinxCoroutinesSearchResult", "intellij.kotlin.jvm.debugger.coroutines"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nCoroutineAgentConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineAgentConnector.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineAgentConnector\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1484#2,14:110\n10574#3:124\n11007#3,5:125\n1586#4:130\n1661#4,3:131\n777#4:134\n873#4,2:135\n1915#4,2:137\n*S KotlinDebug\n*F\n+ 1 CoroutineAgentConnector.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineAgentConnector\n*L\n45#1:110,14\n69#1:124\n69#1:125,5\n77#1:130\n77#1:131,3\n92#1:134\n92#1:135,2\n92#1:137,2\n*E\n"})
public final class CoroutineAgentConnector {
    @NotNull
    public static final CoroutineAgentConnector INSTANCE = new CoroutineAgentConnector();
    @NotNull
    private static final String KOTLIN_STDLIB = "kotlin-stdlib";
    @NotNull
    private static final String KOTLINX_COROUTINES_DEBUG_PROBES_IMPL_FQN = "kotlinx.coroutines.debug.internal.DebugProbesImpl";
    @NotNull
    private static final DefaultArtifactVersion MINIMAL_SUPPORTED_COROUTINES_VERSION = new DefaultArtifactVersion("1.3.7-255");
    @NotNull
    private static final String KOTLINX_COROUTINES_CORE = "kotlinx-coroutines-core";
    @VisibleForTesting
    @NotNull
    private static final Regex KOTLINX_COROUTINES_CORE_JVM_JAR_REGEX = new Regex(".+kotlinx-coroutines-core(-jvm)?-(\\d[\\w.\\-]+)?\\.jar");

    private CoroutineAgentConnector() {
    }

    @NotNull
    public final Regex getKOTLINX_COROUTINES_CORE_JVM_JAR_REGEX() {
        return KOTLINX_COROUTINES_CORE_JVM_JAR_REGEX;
    }

    public final boolean attachCoroutineAgent(@NotNull Project project, @Nullable RunConfigurationBase<?> configuration2, @NotNull JavaParameters params) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        KotlinxCoroutinesSearchResult searchResult = this.findKotlinxCoroutinesCoreJar(project, configuration2);
        if (searchResult.getDebuggerMode() == CoroutineDebuggerMode.VERSION_1_3_8_AND_UP && searchResult.getJarPath() != null) {
            return this.initializeCoroutineAgent(params, searchResult.getJarPath());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinxCoroutinesSearchResult findKotlinxCoroutinesCoreJar(Project project, RunConfigurationBase<?> configuration2) {
        Object v0;
        void $this$maxByOrNull$iv;
        List<String> jarPaths = this.getKotlinxCoroutinesJarsFromClasspath(project, configuration2);
        Sequence sequence = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)jarPaths), CoroutineAgentConnector::findKotlinxCoroutinesCoreJar$lambda$0);
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                MatchResult it = (MatchResult)maxElem$iv;
                boolean bl = false;
                Comparable maxValue$iv = (Comparable)new DefaultArtifactVersion((String)it.getGroupValues().get(2));
                do {
                    Object e$iv = iterator$iv.next();
                    MatchResult it2 = (MatchResult)e$iv;
                    $i$a$-maxByOrNull-CoroutineAgentConnector$findKotlinxCoroutinesCoreJar$newestKotlinxCoroutinesJar$2 = false;
                    Comparable v$iv = (Comparable)new DefaultArtifactVersion((String)it2.getGroupValues().get(2));
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        MatchResult newestKotlinxCoroutinesJar = v0;
        if (newestKotlinxCoroutinesJar == null || newestKotlinxCoroutinesJar.getGroupValues().size() < 3) {
            return new KotlinxCoroutinesSearchResult(null, CoroutineDebuggerMode.DISABLED);
        }
        return new KotlinxCoroutinesSearchResult(newestKotlinxCoroutinesJar.getValue(), this.determineCoreVersionMode((String)newestKotlinxCoroutinesJar.getGroupValues().get(2)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getKotlinxCoroutinesJarsFromClasspath(Project project, RunConfigurationBase<?> configuration2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$flatMapTo$iv$iv;
        if (!(configuration2 instanceof ModuleBasedConfiguration)) {
            return CollectionsKt.emptyList();
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        boolean includeTests = configuration2 instanceof JavaTestConfigurationBase;
        Module[] moduleArray = ((ModuleBasedConfiguration)configuration2).getModules();
        Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"getModules(...)");
        Object $this$flatMap$iv = moduleArray;
        boolean $i$f$flatMap = false;
        Object[] objectArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (PsiClass element$iv$iv : $this$flatMapTo$iv$iv) {
            GlobalSearchScope moduleScope;
            Module module = (Module)element$iv$iv;
            boolean bl = false;
            Object[] objectArray2 = new GlobalSearchScope[]{GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)includeTests), module.getModuleRuntimeScope(includeTests)};
            Intrinsics.checkNotNullExpressionValue((Object)GlobalSearchScope.union((Collection)CollectionsKt.listOf((Object[])objectArray2)), (String)"union(...)");
            PsiClass[] psiClassArray = psiFacade.findClasses(KOTLINX_COROUTINES_DEBUG_PROBES_IMPL_FQN, moduleScope);
            Intrinsics.checkNotNullExpressionValue((Object)psiClassArray, (String)"findClasses(...)");
            Iterable list$iv$iv = ArraysKt.asList((Object[])psiClassArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiClass element$iv$iv;
            element$iv$iv = (PsiClass)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getContainingFile().getVirtualFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            collection.add(StringsKt.substringBeforeLast$default((String)string, (String)"!/", null, (int)2, null));
        }
        return (List)destination$iv$iv;
    }

    private final CoroutineDebuggerMode determineCoreVersionMode(String version) {
        return new DefaultArtifactVersion(version).compareTo((ArtifactVersion)MINIMAL_SUPPORTED_COROUTINES_VERSION) > 0 ? CoroutineDebuggerMode.VERSION_1_3_8_AND_UP : CoroutineDebuggerMode.DISABLED;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean initializeCoroutineAgent(JavaParameters params, String jarPath) {
        ParametersList parametersList = params.getVMParametersList();
        if (parametersList == null) {
            return false;
        }
        ParametersList vmParametersList = parametersList;
        vmParametersList.add("-javaagent:" + jarPath);
        if (params.isClasspathFile()) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            List list2 = params.getClassPath().getRootDirs();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getRootDirs(...)");
            Iterable $this$filter$iv = list2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                String string = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)KOTLIN_STDLIB, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                VirtualFileSystem fs;
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.getFileSystem(), (String)"getFileSystem(...)");
                if (fs instanceof ArchiveFileSystem) {
                    VirtualFile virtualFile = ((ArchiveFileSystem)fs).getLocalByEntry(it);
                    string = virtualFile != null ? virtualFile.getPath() : null;
                } else {
                    string = it.getPath();
                }
                String path2 = string;
                it.putUserData(JdkUtil.AGENT_RUNTIME_CLASSPATH, (Object)path2);
            }
        }
        return true;
    }

    private static final MatchResult findKotlinxCoroutinesCoreJar$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return KOTLINX_COROUTINES_CORE_JVM_JAR_REGEX.matchEntire((CharSequence)it);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineAgentConnector$KotlinxCoroutinesSearchResult;", "", "jarPath", "", "debuggerMode", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineDebuggerMode;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineDebuggerMode;)V", "getJarPath", "()Ljava/lang/String;", "getDebuggerMode", "()Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineDebuggerMode;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.kotlin.jvm.debugger.coroutines"})
    private static final class KotlinxCoroutinesSearchResult {
        @Nullable
        private final String jarPath;
        @NotNull
        private final CoroutineDebuggerMode debuggerMode;

        public KotlinxCoroutinesSearchResult(@Nullable String jarPath, @NotNull CoroutineDebuggerMode debuggerMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)debuggerMode), (String)"debuggerMode");
            this.jarPath = jarPath;
            this.debuggerMode = debuggerMode;
        }

        @Nullable
        public final String getJarPath() {
            return this.jarPath;
        }

        @NotNull
        public final CoroutineDebuggerMode getDebuggerMode() {
            return this.debuggerMode;
        }

        @Nullable
        public final String component1() {
            return this.jarPath;
        }

        @NotNull
        public final CoroutineDebuggerMode component2() {
            return this.debuggerMode;
        }

        @NotNull
        public final KotlinxCoroutinesSearchResult copy(@Nullable String jarPath, @NotNull CoroutineDebuggerMode debuggerMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)debuggerMode), (String)"debuggerMode");
            return new KotlinxCoroutinesSearchResult(jarPath, debuggerMode);
        }

        public static /* synthetic */ KotlinxCoroutinesSearchResult copy$default(KotlinxCoroutinesSearchResult kotlinxCoroutinesSearchResult, String string, CoroutineDebuggerMode coroutineDebuggerMode, int n, Object object) {
            if ((n & 1) != 0) {
                string = kotlinxCoroutinesSearchResult.jarPath;
            }
            if ((n & 2) != 0) {
                coroutineDebuggerMode = kotlinxCoroutinesSearchResult.debuggerMode;
            }
            return kotlinxCoroutinesSearchResult.copy(string, coroutineDebuggerMode);
        }

        @NotNull
        public String toString() {
            return "KotlinxCoroutinesSearchResult(jarPath=" + this.jarPath + ", debuggerMode=" + this.debuggerMode + ")";
        }

        public int hashCode() {
            int result2 = this.jarPath == null ? 0 : this.jarPath.hashCode();
            result2 = result2 * 31 + this.debuggerMode.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof KotlinxCoroutinesSearchResult)) {
                return false;
            }
            KotlinxCoroutinesSearchResult kotlinxCoroutinesSearchResult = (KotlinxCoroutinesSearchResult)other;
            if (!Intrinsics.areEqual((Object)this.jarPath, (Object)kotlinxCoroutinesSearchResult.jarPath)) {
                return false;
            }
            return this.debuggerMode == kotlinxCoroutinesSearchResult.debuggerMode;
        }
    }
}

