/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.sun.jdi.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.InlineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManager;
import org.jetbrains.kotlin.idea.debugger.base.util.AnalyseUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J0\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010\u001b\u001a\u00020\u0013*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u001c\u001a\u00020\u001d*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u001e\u001a\u00020\u001d*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u001f\u001a\u00020\u001d*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010!\u001a\u00020\u001d*\u00020\"2\u0006\u0010#\u001a\u00020\u000fH\u0002J\u0014\u0010$\u001a\u00020\u001d*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/KotlinVariableNameFinder;", "", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "<init>", "(Lcom/intellij/debugger/engine/DebugProcessImpl;)V", "getDebugProcess", "()Lcom/intellij/debugger/engine/DebugProcessImpl;", "findVisibleVariableNames", "", "", "location", "Lcom/sun/jdi/Location;", "findVisibleVariableNamesFrom", "element", "Lcom/intellij/psi/PsiElement;", "findVariableNames", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "boundaryElement", "blocksToVisit", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "findVariableNamesInParameterList", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "findExpressionToStartAnalysisFrom", "isCoroutineContextAvailable", "", "isCoroutineContextAvailableFromFunction", "isCoroutineContextAvailableFromLambda", "findEnclosingBlockExpression", "shouldBeFiltered", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "elementAtBreakpointPosition", "isInlined", "intellij.kotlin.jvm.debugger.coroutines"})
@SourceDebugExtension(value={"SMAP\nKotlinVariableNameFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinVariableNameFinder.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/KotlinVariableNameFinder\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n80#2:158\n67#2:174\n67#2:175\n66#2,2:177\n67#2:179\n261#3:159\n261#3:176\n1642#4,10:160\n1915#4:170\n1916#4:172\n1652#4:173\n1#5:171\n*S KotlinDebug\n*F\n+ 1 KotlinVariableNameFinder.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/KotlinVariableNameFinder\n*L\n36#1:158\n118#1:174\n124#1:175\n153#1:177,2\n49#1:179\n93#1:159\n136#1:176\n94#1:160,10\n94#1:170\n94#1:172\n94#1:173\n94#1:171\n*E\n"})
public final class KotlinVariableNameFinder {
    @NotNull
    private final DebugProcessImpl debugProcess;

    public KotlinVariableNameFinder(@NotNull DebugProcessImpl debugProcess) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        this.debugProcess = debugProcess;
    }

    @NotNull
    public final DebugProcessImpl getDebugProcess() {
        return this.debugProcess;
    }

    @RequiresReadLock
    @NotNull
    public final List<String> findVisibleVariableNames(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        SourcePosition sourcePosition = SafeUtilKt.safeGetSourcePosition((PositionManager)new KotlinPositionManager((DebugProcess)this.debugProcess), location);
        if (sourcePosition == null) {
            return CollectionsKt.emptyList();
        }
        SourcePosition sourcePosition2 = sourcePosition;
        ProgressManager.checkCanceled();
        PsiElement psiElement = sourcePosition2.getElementAt();
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement elementAt = psiElement;
        return this.findVisibleVariableNamesFrom(elementAt);
    }

    private final List<String> findVisibleVariableNamesFrom(PsiElement element) {
        KtBlockExpression ktBlockExpression = this.findEnclosingBlockExpression(element);
        if (ktBlockExpression == null) {
            return CollectionsKt.emptyList();
        }
        KtBlockExpression enclosingBlockExpression = ktBlockExpression;
        PsiElement $this$parentsOfType_u24default$iv = (PsiElement)enclosingBlockExpression;
        boolean withSelf$iv = true;
        boolean $i$f$parentsOfType = false;
        Sequence blockParents = PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType_u24default$iv, KtBlockExpression.class, (boolean)withSelf$iv);
        if (SequencesKt.none((Sequence)blockParents)) {
            return CollectionsKt.emptyList();
        }
        ProgressManager.checkCanceled();
        return AnalyseUtilsKt.runDumbAnalyze((KtElement)enclosingBlockExpression, CollectionsKt.emptyList(), arg_0 -> KotlinVariableNameFinder.findVisibleVariableNamesFrom$lambda$0(this, enclosingBlockExpression, element, blockParents, arg_0));
    }

    private final List<String> findVariableNames(KaSession $this$findVariableNames, KtExpression expression, PsiElement boundaryElement, Sequence<? extends KtBlockExpression> blocksToVisit) {
        List names = new ArrayList();
        expression.accept((PsiElementVisitor)new PsiRecursiveVisitor(blocksToVisit, boundaryElement, this, names){
            private boolean stopTraversal;
            final /* synthetic */ Sequence<KtBlockExpression> $blocksToVisit;
            final /* synthetic */ PsiElement $boundaryElement;
            final /* synthetic */ KotlinVariableNameFinder this$0;
            final /* synthetic */ List<String> $names;
            {
                this.$blocksToVisit = $blocksToVisit;
                this.$boundaryElement = $boundaryElement;
                this.this$0 = $receiver;
                this.$names = $names;
            }

            public final boolean getStopTraversal() {
                return this.stopTraversal;
            }

            public final void setStopTraversal(boolean bl) {
                this.stopTraversal = bl;
            }

            public void visitBlockExpression(KtBlockExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                if (SequencesKt.contains(this.$blocksToVisit, (Object)expression)) {
                    expression.acceptChildren((PsiElementVisitor)this);
                }
            }

            public void visitKtElement(KtElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                ProgressManager.checkCanceled();
                if (this.stopTraversal) {
                    return;
                }
                if (PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)element)) >= PsiUtilsKt.getStartOffset((PsiElement)this.$boundaryElement)) {
                    this.stopTraversal = true;
                    return;
                }
                if (element instanceof KtVariableDeclaration && !KotlinVariableNameFinder.access$shouldBeFiltered(this.this$0, (KtDeclaration)element, this.$boundaryElement)) {
                    String string = ((KtVariableDeclaration)element).getName();
                    if (string != null) {
                        String string2 = string;
                        List<String> list2 = this.$names;
                        String it = string2;
                        boolean bl = false;
                        list2.add(it);
                    }
                }
                element.acceptChildren((PsiElementVisitor)this);
            }
        });
        return names;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> findVariableNamesInParameterList(KtFunction function) {
        void $this$mapNotNullTo$iv$iv;
        PsiElement $this$getChildOfType$iv = (PsiElement)function;
        boolean $i$f$getChildOfType22 = false;
        KtParameterList ktParameterList = (KtParameterList)PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KtParameterList.class);
        if (ktParameterList == null) {
            return CollectionsKt.emptyList();
        }
        KtParameterList parameterList = ktParameterList;
        List list2 = parameterList.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getParameters(...)");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$getChildOfType22 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            KtParameter it = (KtParameter)element$iv$iv;
            boolean bl2 = false;
            if (it.getName() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final KtExpression findExpressionToStartAnalysisFrom(KaSession $this$findExpressionToStartAnalysisFrom, KtExpression expression) {
        KtExpression lastSeenBlockExpression = expression;
        for (PsiElement parent : PsiTreeUtilKt.parents((PsiElement)((PsiElement)expression), (boolean)true)) {
            PsiElement psiElement = parent;
            if (psiElement instanceof KtNamedFunction) {
                return (KtExpression)parent;
            }
            if (!(psiElement instanceof KtBlockExpression)) continue;
            if (!this.isInlined($this$findExpressionToStartAnalysisFrom, (KtBlockExpression)parent) && !(((KtBlockExpression)parent).getParent() instanceof KtWhenEntry)) {
                return (KtExpression)parent;
            }
            lastSeenBlockExpression = (KtExpression)parent;
        }
        return lastSeenBlockExpression;
    }

    private final boolean isCoroutineContextAvailable(KaSession $this$isCoroutineContextAvailable, KtExpression expression) {
        return this.isCoroutineContextAvailableFromFunction($this$isCoroutineContextAvailable, expression) || this.isCoroutineContextAvailableFromLambda($this$isCoroutineContextAvailable, expression);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCoroutineContextAvailableFromFunction(KaSession $this$isCoroutineContextAvailableFromFunction, KtExpression expression) {
        void $this$parentOfType$iv;
        PsiElement psiElement = (PsiElement)expression;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        KtFunction ktFunction = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtFunction.class, (boolean)false);
        if (ktFunction == null) {
            return false;
        }
        KtFunction functionParent = ktFunction;
        KaDeclarationSymbol kaDeclarationSymbol = $this$isCoroutineContextAvailableFromFunction.getSymbol((KtDeclaration)functionParent);
        KaNamedFunctionSymbol kaNamedFunctionSymbol = kaDeclarationSymbol instanceof KaNamedFunctionSymbol ? (KaNamedFunctionSymbol)kaDeclarationSymbol : null;
        if (kaNamedFunctionSymbol == null) {
            return false;
        }
        KaNamedFunctionSymbol symbol = kaNamedFunctionSymbol;
        return symbol.isSuspend();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCoroutineContextAvailableFromLambda(KaSession $this$isCoroutineContextAvailableFromLambda, KtExpression expression) {
        void $this$parentOfType$iv;
        PsiElement psiElement = (PsiElement)expression;
        boolean withSelf$iv22 = true;
        boolean $i$f$parentOfType = false;
        KtFunctionLiteral ktFunctionLiteral = (KtFunctionLiteral)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtFunctionLiteral.class, (boolean)false);
        if (ktFunctionLiteral == null) {
            return false;
        }
        KtFunctionLiteral literalParent = ktFunctionLiteral;
        KtExpression withSelf$iv22 = KtPsiUtil.getParentCallIfPresent((KtExpression)((KtExpression)literalParent));
        KtCallExpression ktCallExpression = withSelf$iv22 instanceof KtCallExpression ? (KtCallExpression)withSelf$iv22 : null;
        if (ktCallExpression == null) {
            return false;
        }
        KtCallExpression parentCall = ktCallExpression;
        KaLifetimeOwner kaLifetimeOwner = $this$isCoroutineContextAvailableFromLambda.resolveToCall((KtElement)parentCall);
        if (kaLifetimeOwner == null || (kaLifetimeOwner = KaCallInfoKt.singleFunctionCallOrNull((KaCallInfo)kaLifetimeOwner)) == null) {
            return false;
        }
        KaLifetimeOwner call = kaLifetimeOwner;
        KtValueArgument ktValueArgument = KotlinPsiUtils.getContainingValueArgument(parentCall, expression);
        if (ktValueArgument == null) {
            return false;
        }
        KtValueArgument valueArgument = ktValueArgument;
        KaLifetimeOwner kaLifetimeOwner2 = call.getArgumentMapping().get(valueArgument.getArgumentExpression());
        if (kaLifetimeOwner2 == null || (kaLifetimeOwner2 = (KaValueParameterSymbol)kaLifetimeOwner2.getSymbol()) == null) {
            return false;
        }
        KaLifetimeOwner argumentSymbol = kaLifetimeOwner2;
        return $this$isCoroutineContextAvailableFromLambda.isSuspendFunctionType(((KaCallableSymbol)argumentSymbol).getReturnType());
    }

    private final KtBlockExpression findEnclosingBlockExpression(PsiElement element) {
        for (PsiElement parent : PsiTreeUtilKt.parents((PsiElement)element, (boolean)false)) {
            PsiElement psiElement = parent;
            if (psiElement instanceof KtFunction || psiElement instanceof KtWhenEntry || psiElement instanceof KtLambdaExpression) {
                PsiElement $this$getChildOfType$iv = parent;
                boolean $i$f$getChildOfType = false;
                return (KtBlockExpression)PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KtBlockExpression.class);
            }
            if (!(psiElement instanceof KtBlockExpression)) continue;
            return (KtBlockExpression)parent;
        }
        return null;
    }

    private final boolean shouldBeFiltered(KtDeclaration $this$shouldBeFiltered, PsiElement elementAtBreakpointPosition) {
        return $this$shouldBeFiltered.getParent() instanceof KtWhenExpression ? !SequencesKt.contains((Sequence)PsiTreeUtilKt.parents((PsiElement)elementAtBreakpointPosition, (boolean)false), (Object)$this$shouldBeFiltered.getParent()) : false;
    }

    private final boolean isInlined(KaSession $this$isInlined, KtBlockExpression expression) {
        PsiElement $this$parentOfType_u24default$iv = (PsiElement)expression;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        KtFunction ktFunction = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtFunction.class, (boolean)true);
        if (ktFunction == null) {
            return false;
        }
        KtFunction parentFunction = ktFunction;
        return InlineUtilsKt.isInlinedArgument$default($this$isInlined, parentFunction, false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List findVisibleVariableNamesFrom$lambda$0(KotlinVariableNameFinder this$0, KtBlockExpression $enclosingBlockExpression, PsiElement $element, Sequence $blockParents, KaSession $this$f) {
        void $this$parentOfType$iv;
        Intrinsics.checkNotNullParameter((Object)$this$f, (String)"$this$f");
        KtExpression expressionToStartAnalysisFrom = this$0.findExpressionToStartAnalysisFrom($this$f, (KtExpression)$enclosingBlockExpression);
        if (!this$0.isCoroutineContextAvailable($this$f, expressionToStartAnalysisFrom)) {
            return CollectionsKt.emptyList();
        }
        ProgressManager.checkCanceled();
        PsiElement psiElement = (PsiElement)expressionToStartAnalysisFrom;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        KtFunction ktFunction = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtFunction.class, (boolean)false);
        if (ktFunction == null) {
            return CollectionsKt.emptyList();
        }
        KtFunction parentFunction = ktFunction;
        List<String> namesInParameterList = this$0.findVariableNamesInParameterList(parentFunction);
        List<String> namesVisibleInExpression = this$0.findVariableNames($this$f, expressionToStartAnalysisFrom, $element, (Sequence<? extends KtBlockExpression>)$blockParents);
        return CollectionsKt.plus((Collection)namesVisibleInExpression, (Iterable)namesInParameterList);
    }

    public static final /* synthetic */ boolean access$shouldBeFiltered(KotlinVariableNameFinder $this, KtDeclaration $receiver, PsiElement elementAtBreakpointPosition) {
        return $this.shouldBeFiltered($receiver, elementAtBreakpointPosition);
    }
}

