/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.util;

import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.frame.XNamedValue;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.DefaultExecutionContext;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutinePreflightFrame;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStacksInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CreationCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.RunningCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.SuspendExitMode;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.ContinuationHolderKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineStackFrameProxysKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/util/CoroutineFrameBuilder;", "", "<init>", "()V", "Companion", "intellij.kotlin.jvm.debugger.coroutines"})
public final class CoroutineFrameBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ReadOnlyProperty<Object, Logger> log$delegate = ProvidersKt.getLogger();
    private static final int PRE_FETCH_FRAME_COUNT = 5;

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001%B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001f\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J(\u0010\u0018\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001a0\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001f\u0010!\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\"J\u001a\u0010#\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020 0\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/util/CoroutineFrameBuilder$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "PRE_FETCH_FRAME_COUNT", "", "build", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/util/CoroutineFrameBuilder$Companion$CoroutineFrameItemLists;", "coroutine", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "buildStackFrameForActive", "preflightFrame", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutinePreflightFrame;", "withPreFrames", "", "build$intellij_kotlin_jvm_debugger_coroutines", "restoredStackTrace", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "Lcom/intellij/xdebugger/frame/XNamedValue;", "buildRealStackFrameItem", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/RunningCoroutineStackFrameItem;", "frame", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "coroutineExitFrame", "coroutineExitFrame$intellij_kotlin_jvm_debugger_coroutines", "lookupContinuation", "theFollowingFrames", "CoroutineFrameItemLists", "intellij.kotlin.jvm.debugger.coroutines"})
    @SourceDebugExtension(value={"SMAP\nCoroutineFrameBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineFrameBuilder.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/util/CoroutineFrameBuilder$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1642#2,10:166\n1915#2:176\n1916#2:178\n1652#2:179\n759#2,10:180\n742#2,4:190\n746#2,5:195\n1#3:177\n1#3:194\n*S KotlinDebug\n*F\n+ 1 CoroutineFrameBuilder.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/util/CoroutineFrameBuilder$Companion\n*L\n70#1:166,10\n70#1:176\n70#1:178\n70#1:179\n84#1:180,10\n95#1:190,4\n95#1:195,5\n70#1:177\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return (Logger)log$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        @Nullable
        public final CoroutineFrameItemLists build(@NotNull CoroutineInfoData coroutine, @NotNull SuspendContextImpl suspendContext) {
            Intrinsics.checkNotNullParameter((Object)coroutine, (String)"coroutine");
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            DebuggerManagerThreadImpl.Companion.assertIsManagerThread();
            return coroutine.isRunning() ? this.buildStackFrameForActive(coroutine, suspendContext) : (coroutine.isSuspended() ? new CoroutineFrameItemLists(coroutine.getContinuationStackFrames(), coroutine.getCreationStackFrames()) : null);
        }

        private final CoroutineFrameItemLists buildStackFrameForActive(CoroutineInfoData coroutine, SuspendContextImpl suspendContext) {
            ThreadReference threadReference = coroutine.getLastObservedThread();
            if (threadReference == null) {
                return null;
            }
            ThreadReference activeThread = threadReference;
            List coroutineStackFrameList = new ArrayList();
            ThreadReferenceProxyImpl threadReferenceProxyImpl = new ThreadReferenceProxyImpl(suspendContext.getVirtualMachineProxy(), activeThread);
            List list2 = threadReferenceProxyImpl.forceFrames();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"forceFrames(...)");
            List realFrames = list2;
            for (StackFrameProxyImpl runningStackFrameProxy : realFrames) {
                RunningCoroutineStackFrameItem it;
                Intrinsics.checkNotNull((Object)runningStackFrameProxy);
                CoroutinePreflightFrame preflightStackFrame = this.coroutineExitFrame$intellij_kotlin_jvm_debugger_coroutines(runningStackFrameProxy, suspendContext);
                if (preflightStackFrame != null) {
                    StackFrameProxyImpl stackFrameProxyImpl = preflightStackFrame.getStackFrameProxy();
                    Intrinsics.checkNotNullExpressionValue((Object)stackFrameProxyImpl, (String)"getStackFrameProxy(...)");
                    RunningCoroutineStackFrameItem runningCoroutineStackFrameItem = this.buildRealStackFrameItem(stackFrameProxyImpl);
                    if (runningCoroutineStackFrameItem != null) {
                        it = runningCoroutineStackFrameItem;
                        boolean bl = false;
                        coroutineStackFrameList.add(it);
                    }
                    CoroutineFrameItemLists coroutineFrameLists = org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineFrameBuilder$Companion.build$intellij_kotlin_jvm_debugger_coroutines$default(this, preflightStackFrame, false, 2, null);
                    coroutineStackFrameList.addAll((Collection)coroutineFrameLists.getFrames());
                    return new CoroutineFrameItemLists(coroutineStackFrameList, coroutine.getCreationStackFrames());
                }
                if (this.buildRealStackFrameItem(runningStackFrameProxy) == null) continue;
                boolean bl = false;
                coroutineStackFrameList.add(it);
            }
            return new CoroutineFrameItemLists(coroutineStackFrameList, coroutine.getCreationStackFrames());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final CoroutineFrameItemLists build$intellij_kotlin_jvm_debugger_coroutines(@NotNull CoroutinePreflightFrame preflightFrame, boolean withPreFrames) {
            Intrinsics.checkNotNullParameter((Object)((Object)preflightFrame), (String)"preflightFrame");
            List stackFrames = new ArrayList();
            List restoredStackTrace = (List)this.restoredStackTrace(preflightFrame).component1();
            stackFrames.addAll(restoredStackTrace);
            if (withPreFrames) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Iterable iterable = preflightFrame.getThreadPreCoroutineFrames();
                List list2 = stackFrames;
                boolean $i$f$mapNotNull = false;
                void var7_8 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    RunningCoroutineStackFrameItem it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    StackFrameProxyImpl p0 = (StackFrameProxyImpl)element$iv$iv;
                    boolean bl2 = false;
                    if (this.buildRealStackFrameItem(p0) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list2.addAll((List)destination$iv$iv);
            }
            return new CoroutineFrameItemLists(stackFrames, preflightFrame.getCoroutineStacksInfoData().getCreationStackFrames());
        }

        public static /* synthetic */ CoroutineFrameItemLists build$intellij_kotlin_jvm_debugger_coroutines$default(Companion companion, CoroutinePreflightFrame coroutinePreflightFrame, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.build$intellij_kotlin_jvm_debugger_coroutines(coroutinePreflightFrame, bl);
        }

        private final Pair<List<CoroutineStackFrameItem>, List<XNamedValue>> restoredStackTrace(CoroutinePreflightFrame preflightFrame) {
            List list2;
            CoroutineStackFrameItem it;
            Location preflightFrameLocation = preflightFrame.getStackFrameProxy().location();
            List<CoroutineStackFrameItem> coroutineStackFrame = preflightFrame.getCoroutineStacksInfoData().getContinuationStackFrames();
            StackFrameProxyImpl stackFrameProxyImpl = (StackFrameProxyImpl)CollectionsKt.firstOrNull(preflightFrame.getThreadPreCoroutineFrames());
            Location preCoroutineTopFrameLocation = stackFrameProxyImpl != null ? stackFrameProxyImpl.location() : null;
            List variablesRemovedFromTopRestoredFrame = new ArrayList();
            Iterable $this$dropWhile$iv = coroutineStackFrame;
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                if (yielding$iv) {
                    list$iv.add(item$iv);
                    continue;
                }
                it = (CoroutineStackFrameItem)((Object)item$iv);
                boolean bl = false;
                boolean isFilteredFromTop = CoroutineUtilsKt.isFilterFromTop(it.getLocation(), preflightFrameLocation);
                if (isFilteredFromTop) {
                    variablesRemovedFromTopRestoredFrame.addAll((Collection)it.getSpilledVariables());
                }
                if (isFilteredFromTop) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            List stripTopStackTrace = list$iv;
            List variablesRemovedFromBottomRestoredFrame = new ArrayList();
            if (preCoroutineTopFrameLocation == null) {
                list2 = stripTopStackTrace;
            } else {
                List $this$dropLastWhile$iv = stripTopStackTrace;
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        boolean bl;
                        it = (CoroutineStackFrameItem)((Object)iterator$iv.previous());
                        boolean bl2 = false;
                        boolean $this$restoredStackTrace_u24lambda_u241_u240 = bl = CoroutineUtilsKt.isFilterFromBottom(it.getLocation(), preCoroutineTopFrameLocation);
                        boolean bl3 = false;
                        variablesRemovedFromBottomRestoredFrame.addAll((Collection)it.getSpilledVariables());
                        if (bl) continue;
                        list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list2 = CollectionsKt.emptyList();
                }
            }
            List restoredFrames = list2;
            return new Pair((Object)restoredFrames, (Object)variablesRemovedFromBottomRestoredFrame);
        }

        private final RunningCoroutineStackFrameItem buildRealStackFrameItem(StackFrameProxyImpl frame) {
            Location location = frame.location();
            if (location == null) {
                return null;
            }
            Location location2 = location;
            return !CoroutineUtilsKt.safeCoroutineExitPointLineNumber(location2) ? new RunningCoroutineStackFrameItem(CoroutineStackFrameProxysKt.safeSkipCoroutineStackFrameProxy(frame), location2, null, 4, null) : null;
        }

        @Nullable
        public final CoroutinePreflightFrame coroutineExitFrame$intellij_kotlin_jvm_debugger_coroutines(@NotNull StackFrameProxyImpl frame, @NotNull SuspendContextImpl suspendContext) {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            return this.lookupContinuation(suspendContext, frame);
        }

        @ApiStatus.Internal
        @VisibleForTesting
        @Nullable
        public final CoroutinePreflightFrame lookupContinuation(@NotNull SuspendContextImpl suspendContext, @NotNull StackFrameProxyImpl frame) {
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            DebuggerManagerThreadImpl.Companion.assertIsManagerThread();
            SuspendExitMode mode = CoroutineUtilsKt.getSuspendExitMode(frame);
            if (!mode.isCoroutineFound()) {
                return null;
            }
            ObjectReference objectReference = CoroutineUtilsKt.extractContinuation(frame);
            if (objectReference == null) {
                return null;
            }
            ObjectReference continuation2 = objectReference;
            if (!CoroutineUtilsKt.threadAndContextSupportsEvaluation(suspendContext, frame)) {
                return null;
            }
            List<StackFrameProxyImpl> theFollowingFrames = this.theFollowingFrames(frame);
            DefaultExecutionContext context2 = new DefaultExecutionContext(suspendContext, frame);
            CoroutineStacksInfoData coroutineStacksInfoData = ContinuationHolderKt.fetchCoroutineStacksInfoData(context2, continuation2);
            if (coroutineStacksInfoData == null) {
                return null;
            }
            CoroutineStacksInfoData coroutineStacksInfo = coroutineStacksInfoData;
            return new CoroutinePreflightFrame(coroutineStacksInfo, frame, theFollowingFrames, coroutineStacksInfo.getTopFrameVariables());
        }

        private final List<StackFrameProxyImpl> theFollowingFrames(StackFrameProxyImpl frame) {
            List list2 = frame.threadProxy().frames();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"frames(...)");
            List frames = list2;
            int indexOfCurrentFrame = frames.indexOf(frame);
            if (indexOfCurrentFrame < 0) {
                this.getLog().error("Frame isn't found on the thread stack.");
                return CollectionsKt.emptyList();
            }
            int indexOfGetCoroutineSuspended = CoroutineUtilsKt.hasGetCoroutineSuspended(frames);
            if (indexOfGetCoroutineSuspended < 0 && frames.size() > indexOfCurrentFrame + 1) {
                return SequencesKt.toList((Sequence)SequencesKt.dropWhile((Sequence)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)frames), (int)(indexOfCurrentFrame + 1)), Companion::theFollowingFrames$lambda$0));
            }
            return CollectionsKt.emptyList();
        }

        private static final boolean theFollowingFrames$lambda$0(StackFrameProxyImpl it) {
            Intrinsics.checkNotNull((Object)it);
            return CoroutineUtilsKt.getSuspendExitMode(it) != SuspendExitMode.NONE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/util/CoroutineFrameBuilder$Companion$CoroutineFrameItemLists;", "", "frames", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "creationFrames", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CreationCoroutineStackFrameItem;", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getFrames", "()Ljava/util/List;", "getCreationFrames", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.kotlin.jvm.debugger.coroutines"})
        public static final class CoroutineFrameItemLists {
            @NotNull
            private final List<CoroutineStackFrameItem> frames;
            @NotNull
            private final List<CreationCoroutineStackFrameItem> creationFrames;

            public CoroutineFrameItemLists(@NotNull List<? extends CoroutineStackFrameItem> frames, @NotNull List<CreationCoroutineStackFrameItem> creationFrames) {
                Intrinsics.checkNotNullParameter(frames, (String)"frames");
                Intrinsics.checkNotNullParameter(creationFrames, (String)"creationFrames");
                this.frames = frames;
                this.creationFrames = creationFrames;
            }

            @NotNull
            public final List<CoroutineStackFrameItem> getFrames() {
                return this.frames;
            }

            @NotNull
            public final List<CreationCoroutineStackFrameItem> getCreationFrames() {
                return this.creationFrames;
            }

            @NotNull
            public final List<CoroutineStackFrameItem> component1() {
                return this.frames;
            }

            @NotNull
            public final List<CreationCoroutineStackFrameItem> component2() {
                return this.creationFrames;
            }

            @NotNull
            public final CoroutineFrameItemLists copy(@NotNull List<? extends CoroutineStackFrameItem> frames, @NotNull List<CreationCoroutineStackFrameItem> creationFrames) {
                Intrinsics.checkNotNullParameter(frames, (String)"frames");
                Intrinsics.checkNotNullParameter(creationFrames, (String)"creationFrames");
                return new CoroutineFrameItemLists(frames, creationFrames);
            }

            public static /* synthetic */ CoroutineFrameItemLists copy$default(CoroutineFrameItemLists coroutineFrameItemLists, List list2, List list3, int n, Object object) {
                if ((n & 1) != 0) {
                    list2 = coroutineFrameItemLists.frames;
                }
                if ((n & 2) != 0) {
                    list3 = coroutineFrameItemLists.creationFrames;
                }
                return coroutineFrameItemLists.copy(list2, list3);
            }

            @NotNull
            public String toString() {
                return "CoroutineFrameItemLists(frames=" + this.frames + ", creationFrames=" + this.creationFrames + ")";
            }

            public int hashCode() {
                int result2 = ((Object)this.frames).hashCode();
                result2 = result2 * 31 + ((Object)this.creationFrames).hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CoroutineFrameItemLists)) {
                    return false;
                }
                CoroutineFrameItemLists coroutineFrameItemLists = (CoroutineFrameItemLists)other;
                if (!Intrinsics.areEqual(this.frames, coroutineFrameItemLists.frames)) {
                    return false;
                }
                return Intrinsics.areEqual(this.creationFrames, coroutineFrameItemLists.creationFrames);
            }
        }
    }
}

