/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.view;

import com.intellij.debugger.actions.ThreadDumpAction;
import com.intellij.icons.AllIcons;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.unscramble.DumpItem;
import com.intellij.unscramble.IconsCache;
import com.intellij.unscramble.MergeableDumpItem;
import com.intellij.unscramble.MergeableToken;
import com.sun.jdi.Location;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.KotlinDebuggerCoroutinesBundle;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.State;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpItem;", "Lcom/intellij/unscramble/MergeableDumpItem;", "info", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;)V", "name", "", "getName", "()Ljava/lang/String;", "stateDesc", "getStateDesc", "iconToolTip", "getIconToolTip", "dispatcher", "lastObservedStackTrace", "stackTrace", "getStackTrace", "interestLevel", "", "getInterestLevel", "()I", "isDeadLocked", "", "()Z", "awaitingDumpItems", "", "Lcom/intellij/unscramble/DumpItem;", "getAwaitingDumpItems", "()Ljava/util/Set;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "attributes", "Lcom/intellij/ui/SimpleTextAttributes;", "getAttributes", "()Lcom/intellij/ui/SimpleTextAttributes;", "mergeableToken", "Lcom/intellij/unscramble/MergeableToken;", "getMergeableToken", "()Lcom/intellij/unscramble/MergeableToken;", "CoroutinesMergeableToken", "intellij.kotlin.jvm.debugger.coroutines"})
@SourceDebugExtension(value={"SMAP\nCoroutinesDumpAsyncProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutinesDumpAsyncProvider.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpItem\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,130:1\n1123#2,3:131\n*S KotlinDebug\n*F\n+ 1 CoroutinesDumpAsyncProvider.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpItem\n*L\n80#1:131,3\n*E\n"})
final class CoroutineDumpItem
implements MergeableDumpItem {
    @NotNull
    private final String name;
    @NotNull
    private final String stateDesc;
    @Nullable
    private final String dispatcher;
    @NotNull
    private final String lastObservedStackTrace;
    @NotNull
    private final String stackTrace;
    private final int interestLevel;
    @NotNull
    private final Icon icon;
    @NotNull
    private final SimpleTextAttributes attributes;

    /*
     * WARNING - void declaration
     */
    public CoroutineDumpItem(@NotNull CoroutineInfoData info2) {
        int n;
        void $this$stackTrace_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        this.name = info2.getName() + ":" + info2.getId();
        String string = info2.getState().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        this.stateDesc = " (" + string + ")";
        this.dispatcher = info2.getDispatcher();
        this.lastObservedStackTrace = CollectionsKt.joinToString$default((Iterable)info2.getLastObservedStackTrace(), (CharSequence)"\n\t", (CharSequence)"\t", null, (int)0, null, CoroutineDumpItem::lastObservedStackTrace$lambda$0, (int)28, null);
        Object object = new StringBuilder();
        StringBuilder stringBuilder = object;
        CoroutineDumpItem coroutineDumpItem = this;
        boolean bl = false;
        $this$stackTrace_u24lambda_u240.append(info2.getCoroutineDescriptor()).append('\n');
        $this$stackTrace_u24lambda_u240.append(this.lastObservedStackTrace).append('\n');
        if (!((Collection)info2.getAsyncStackTrace()).isEmpty()) {
            $this$stackTrace_u24lambda_u240.append("\t--------- Async Stack Trace ---------").append('\n');
            $this$stackTrace_u24lambda_u240.append(CollectionsKt.joinToString$default((Iterable)info2.getAsyncStackTrace(), (CharSequence)"\n\t", (CharSequence)"\t", null, (int)0, null, CoroutineDumpItem::stackTrace$lambda$0$0, (int)28, null)).append('\n');
        }
        coroutineDumpItem.stackTrace = ((StringBuilder)object).toString();
        CoroutineDumpItem coroutineDumpItem2 = this;
        if (((CharSequence)this.getStackTrace()).length() == 0) {
            n = -10;
        } else {
            void $this$count$iv;
            object = this.getStackTrace();
            coroutineDumpItem = coroutineDumpItem2;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int j = 0; j < $this$count$iv.length(); ++j) {
                char element$iv;
                char it = element$iv = $this$count$iv.charAt(j);
                boolean bl2 = false;
                if (!(it == '\n')) continue;
                ++count$iv;
            }
            int n2 = count$iv;
            coroutineDumpItem2 = coroutineDumpItem;
            n = n2;
        }
        coroutineDumpItem2.interestLevel = n;
        object = switch (WhenMappings.$EnumSwitchMapping$0[info2.getState().ordinal()]) {
            case 1 -> AllIcons.Debugger.ThreadFrozen;
            case 2 -> AllIcons.Debugger.ThreadRunning;
            case 3, 4 -> AllIcons.Debugger.ThreadGroup;
            default -> throw new NoWhenBranchMatchedException();
        };
        Intrinsics.checkNotNull((Object)object);
        this.icon = IconsCache.INSTANCE.getIconWithVirtualOverlay((Icon)object);
        this.attributes = switch (WhenMappings.$EnumSwitchMapping$0[info2.getState().ordinal()]) {
            case 1 -> DumpItem.SLEEPING_ATTRIBUTES;
            case 2 -> DumpItem.RUNNING_ATTRIBUTES;
            case 3, 4 -> DumpItem.UNINTERESTING_ATTRIBUTES;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getStateDesc() {
        return this.stateDesc;
    }

    @NotNull
    public String getIconToolTip() {
        return KotlinDebuggerCoroutinesBundle.message("dump.item.coroutine.tooltip", new Object[0]);
    }

    @NotNull
    public String getStackTrace() {
        return this.stackTrace;
    }

    public int getInterestLevel() {
        return this.interestLevel;
    }

    public boolean isDeadLocked() {
        return false;
    }

    @NotNull
    public Set<DumpItem> getAwaitingDumpItems() {
        return SetsKt.emptySet();
    }

    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @NotNull
    public SimpleTextAttributes getAttributes() {
        return this.attributes;
    }

    @NotNull
    public MergeableToken getMergeableToken() {
        return new CoroutinesMergeableToken();
    }

    private static final CharSequence lastObservedStackTrace$lambda$0(Location it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ThreadDumpAction.Companion.renderLocation(it);
    }

    private static final CharSequence stackTrace$lambda$0$0(Location it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ThreadDumpAction.Companion.renderLocation(it);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0082\u0004J\n\u0010\u000e\u001a\u00020\u000fH\u0096\u0080\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpItem$CoroutinesMergeableToken;", "Lcom/intellij/unscramble/MergeableToken;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpItem;)V", "comparableStackTrace", "", "item", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpItem;", "getItem", "()Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineDumpItem;", "equals", "", "other", "", "hashCode", "", "intellij.kotlin.jvm.debugger.coroutines"})
    private final class CoroutinesMergeableToken
    implements MergeableToken {
        @NotNull
        private final String comparableStackTrace;

        public CoroutinesMergeableToken() {
            this.comparableStackTrace = StringsKt.substringAfter$default((String)CoroutineDumpItem.this.getStackTrace(), (String)"\n", null, (int)2, null);
        }

        @NotNull
        public CoroutineDumpItem getItem() {
            return CoroutineDumpItem.this;
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof CoroutinesMergeableToken)) {
                return false;
            }
            CoroutineDumpItem otherItem = ((CoroutinesMergeableToken)other).getItem();
            if (!Intrinsics.areEqual((Object)CoroutineDumpItem.this.getStateDesc(), (Object)otherItem.getStateDesc())) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)CoroutineDumpItem.this.dispatcher, (Object)otherItem.dispatcher)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.comparableStackTrace, (Object)((CoroutinesMergeableToken)other).comparableStackTrace);
        }

        public int hashCode() {
            Object[] objectArray = new Object[]{CoroutineDumpItem.this.getStateDesc(), CoroutineDumpItem.this.dispatcher, this.comparableStackTrace};
            return Objects.hash(objectArray);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.SUSPENDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.RUNNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.CREATED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.UNKNOWN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

