/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.view;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.SingleAlarm;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreePanel;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeRestorer;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.KotlinDebuggerCoroutinesBundle;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoCache;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CreationCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineDebugProbesProxy;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineFrameBuilder;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CreateContentParams;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CreateContentParamsProvider;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.XDebugSessionListenerProvider;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.CoroutineSelectedNodeListener;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.CoroutineViewDebugSessionListener;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.CoroutineViewKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.SimpleColoredTextIcon;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.SimpleColoredTextIconPresentationRenderer;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0000\u0018\u0000 :2\u00020\u00012\u00020\u00022\u00020\u0003:\u000e:;<=>?@ABCDEFGB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ\u0006\u0010!\u001a\u00020\u001fJ\u0006\u0010\"\u001a\u00020\u000fJ\u000e\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020\u001fH\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\n\u0012\u0006\b\u0000\u0012\u00020/0.H\u0002J\b\u00100\u001a\u000201H\u0002J\u0018\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020\u001f2\u0006\u00108\u001a\u000209H\u0002R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0010R\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/util/XDebugSessionListenerProvider;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/util/CreateContentParamsProvider;", "project", "Lcom/intellij/openapi/project/Project;", "javaDebugProcess", "Lcom/intellij/debugger/engine/JavaDebugProcess;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/debugger/engine/JavaDebugProcess;)V", "alarm", "Lcom/intellij/util/SingleAlarm;", "getAlarm", "()Lcom/intellij/util/SingleAlarm;", "isLiveUpdateEnabled", "", "()Z", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "Lorg/jetbrains/annotations/NotNull;", "renderer", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIconPresentationRenderer;", "mainPanel", "Ljavax/swing/JPanel;", "treeState", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTreeState;", "restorer", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTreeRestorer;", "panel", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTreePanel;", "saveState", "", "resetRoot", "collapseCoroutineHierarchyNode", "isShowing", "renewRoot", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "dispose", "debugSessionListener", "Lcom/intellij/xdebugger/XDebugSessionListener;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "createContentParams", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/util/CreateContentParams;", "createRenderer", "Lcom/intellij/ui/SimpleListCellRenderer;", "", "createToolbar", "Lcom/intellij/openapi/actionSystem/impl/ActionToolbarImpl;", "applyRenderer", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "presentation", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIcon;", "installClickAndKeyListeners", "tree", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTree;", "Companion", "EmptyNode", "XCoroutinesRootNode", "CoroutineTopGroupContainer", "RootCoroutineContainer", "DispatchersContainer", "DispatcherContainer", "CoroutineContainer", "InfoNode", "ErrorNode", "FramesContainer", "CreationFramesContainer", "CoroutineFrameValue", "RendererContainer", "intellij.kotlin.jvm.debugger.coroutines"})
public final class CoroutineView
implements Disposable,
XDebugSessionListenerProvider,
CreateContentParamsProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SingleAlarm alarm;
    private final boolean isLiveUpdateEnabled;
    @NotNull
    private final DebugProcessImpl debugProcess;
    @NotNull
    private final SimpleColoredTextIconPresentationRenderer renderer;
    @NotNull
    private final JPanel mainPanel;
    @Nullable
    private XDebuggerTreeState treeState;
    @Nullable
    private XDebuggerTreeRestorer restorer;
    @NotNull
    private final XDebuggerTreePanel panel;
    private static final int VIEW_CLEAR_DELAY_MS = 100;
    @NotNull
    private static final String EMPTY_DISPATCHER_NAME = KotlinDebuggerCoroutinesBundle.message("coroutine.view.dispatcher.empty", new Object[0]);
    @NotNull
    private static final ReadOnlyProperty<Object, Logger> log$delegate = ProvidersKt.getLogger();

    public CoroutineView(@NotNull Project project, @NotNull JavaDebugProcess javaDebugProcess) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)javaDebugProcess, (String)"javaDebugProcess");
        this.alarm = new SingleAlarm(() -> CoroutineView.alarm$lambda$0(this), 100, (Disposable)this);
        this.isLiveUpdateEnabled = Registry.Companion.is("coroutine.panel.live.update");
        DebugProcessImpl debugProcessImpl = javaDebugProcess.getDebuggerSession().getProcess();
        Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"getProcess(...)");
        this.debugProcess = debugProcessImpl;
        this.renderer = new SimpleColoredTextIconPresentationRenderer();
        this.mainPanel = new JPanel(new BorderLayout());
        this.panel = new XDebuggerTreePanel(project, javaDebugProcess.getEditorsProvider(), (Disposable)this, null, "Kotlin.XDebugger.Actions", null);
        ComboBox combobox2 = new ComboBox();
        combobox2.setRenderer((ListCellRenderer)this.createRenderer());
        combobox2.addItem(null);
        ActionToolbarImpl toolbar = this.createToolbar();
        Wrapper threadsPanel = new Wrapper();
        threadsPanel.setBorder((Border)new CustomLineBorder(0, 0, 1, 0));
        threadsPanel.add((Component)toolbar.getComponent(), (Object)"East");
        threadsPanel.add((Component)combobox2, (Object)"Center");
        this.mainPanel.add((Component)this.panel.getMainPanel(), "Center");
        XDebuggerTree xDebuggerTree = this.panel.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)xDebuggerTree, (String)"getTree(...)");
        this.installClickAndKeyListeners(xDebuggerTree);
    }

    @NotNull
    public final SingleAlarm getAlarm() {
        return this.alarm;
    }

    public final boolean isLiveUpdateEnabled() {
        return this.isLiveUpdateEnabled;
    }

    public final void saveState() {
        if (!this.isLiveUpdateEnabled) {
            return;
        }
        DebuggerUIUtil.invokeLater(() -> CoroutineView.saveState$lambda$0(this));
    }

    public final void resetRoot() {
        DebuggerUIUtil.invokeLater(() -> CoroutineView.resetRoot$lambda$0(this));
    }

    public final void collapseCoroutineHierarchyNode() {
        if (this.isLiveUpdateEnabled) {
            return;
        }
        DebuggerUIUtil.invokeLater(() -> CoroutineView.collapseCoroutineHierarchyNode$lambda$0(this));
    }

    public final boolean isShowing() {
        return this.mainPanel.isShowing();
    }

    public final void renewRoot(@NotNull SuspendContextImpl suspendContext) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        this.panel.getTree().setRoot((XDebuggerTreeNode)new XCoroutinesRootNode(suspendContext), false);
        if (this.treeState != null) {
            XDebuggerTreeRestorer xDebuggerTreeRestorer = this.restorer;
            if (xDebuggerTreeRestorer != null) {
                xDebuggerTreeRestorer.dispose();
            }
            XDebuggerTreeState xDebuggerTreeState = this.treeState;
            this.restorer = xDebuggerTreeState != null ? xDebuggerTreeState.restoreState(this.panel.getTree()) : null;
        }
    }

    public void dispose() {
        if (this.restorer != null) {
            XDebuggerTreeRestorer xDebuggerTreeRestorer = this.restorer;
            if (xDebuggerTreeRestorer != null) {
                xDebuggerTreeRestorer.dispose();
            }
            this.restorer = null;
        }
    }

    @Override
    @NotNull
    public XDebugSessionListener debugSessionListener(@NotNull XDebugSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return new CoroutineViewDebugSessionListener(session2, this);
    }

    @Override
    @NotNull
    public CreateContentParams createContentParams() {
        JComponent jComponent = this.mainPanel;
        String string = KotlinDebuggerCoroutinesBundle.message("coroutine.view.title", new Object[0]);
        XDebuggerTree xDebuggerTree = this.panel.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)xDebuggerTree, (String)"getTree(...)");
        return new CreateContentParams("XCoroutineThreadsContent", jComponent, string, null, (JComponent)xDebuggerTree);
    }

    private final SimpleListCellRenderer<? super String> createRenderer() {
        SimpleListCellRenderer simpleListCellRenderer = SimpleListCellRenderer.create((arg_0, arg_1, arg_2) -> CoroutineView.createRenderer$lambda$1(CoroutineView::createRenderer$lambda$0, arg_0, arg_1, arg_2));
        Intrinsics.checkNotNullExpressionValue((Object)simpleListCellRenderer, (String)"create(...)");
        return simpleListCellRenderer;
    }

    private final ActionToolbarImpl createToolbar() {
        DefaultActionGroup framesGroup = new DefaultActionGroup();
        AnAction[] anActionArray = new AnAction[]{ActionManager.getInstance().getAction("XDebugger.Frames.TopToolbar")};
        framesGroup.addAll(anActionArray);
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("DebuggerToolbar", (ActionGroup)framesGroup, true);
        Intrinsics.checkNotNull((Object)actionToolbar, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.impl.ActionToolbarImpl");
        ActionToolbarImpl toolbar = (ActionToolbarImpl)actionToolbar;
        toolbar.setReservePlaceAutoPopupIcon(false);
        return toolbar;
    }

    private final void applyRenderer(XValueNode node, SimpleColoredTextIcon presentation) {
        node.setPresentation(presentation.getIcon(), presentation.valuePresentation(), presentation.getHasChildren());
    }

    private final void installClickAndKeyListeners(XDebuggerTree tree2) {
        new CoroutineSelectedNodeListener(this.debugProcess, tree2).install();
    }

    private static final void alarm$lambda$0(CoroutineView this$0) {
        this$0.resetRoot();
    }

    private static final void saveState$lambda$0(CoroutineView this$0) {
        if (!(this$0.panel.getTree().getRoot() instanceof EmptyNode)) {
            this$0.treeState = XDebuggerTreeState.saveState((XDebuggerTree)this$0.panel.getTree());
        }
    }

    private static final void resetRoot$lambda$0(CoroutineView this$0) {
        this$0.panel.getTree().setRoot((XDebuggerTreeNode)this$0.new EmptyNode(), false);
    }

    private static final void collapseCoroutineHierarchyNode$lambda$0(CoroutineView this$0) {
        block2: {
            XDebuggerTreeNode xDebuggerTreeNode = this$0.panel.getTree().getRoot();
            if (xDebuggerTreeNode == null) break block2;
            XDebuggerTreeNode treeRoot = xDebuggerTreeNode;
            boolean bl = false;
            List list2 = treeRoot.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildren(...)");
            TreeNode treeNode = (TreeNode)CollectionsKt.firstOrNull((List)list2);
            if (treeNode == null) {
                return;
            }
            TreeNode rootNode = treeNode;
            TreePath pathToRootNode = new TreePath(this$0.panel.getTree().getTreeModel().getPathToRoot(rootNode));
            XValueNodeImpl xValueNodeImpl = rootNode instanceof XValueNodeImpl ? (XValueNodeImpl)rootNode : null;
            if (Intrinsics.areEqual((Object)(xValueNodeImpl != null ? xValueNodeImpl.getName() : null), (Object)KotlinDebuggerCoroutinesBundle.message("coroutine.view.node.jobs", new Object[0])) && !this$0.panel.getTree().isCollapsed(pathToRootNode)) {
                this$0.panel.getTree().collapsePath(pathToRootNode);
            }
        }
    }

    private static final Unit createRenderer$lambda$0(JBLabel label2, String value, int index2) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        if (value != null) {
            label2.setText(value);
        } else if (index2 >= 0) {
            label2.setText(KotlinDebuggerCoroutinesBundle.message("coroutine.dump.threads.loading", new Object[0]));
        }
        return Unit.INSTANCE;
    }

    private static final void createRenderer$lambda$1(Function3 $tmp0, JBLabel p0, Object p1, int p2) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        $tmp0.invoke((Object)p0, p1, (Object)p2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$Companion;", "", "<init>", "()V", "VIEW_CLEAR_DELAY_MS", "", "EMPTY_DISPATCHER_NAME", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "intellij.kotlin.jvm.debugger.coroutines"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return (Logger)log$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002BU\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f\u0012\u001a\u0010\r\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\f0\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$CoroutineContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RendererContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "rootJob", "", "rootCoroutineInfo", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "isCurrent", "", "childCoroutines", "", "parentJobToChildCoroutines", "", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Lcom/intellij/debugger/engine/SuspendContextImpl;Ljava/lang/String;Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;ZLjava/util/List;Ljava/util/Map;)V", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "intellij.kotlin.jvm.debugger.coroutines"})
    @SourceDebugExtension(value={"SMAP\nCoroutineView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineView.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$CoroutineContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,396:1\n1915#2,2:397\n*S KotlinDebug\n*F\n+ 1 CoroutineView.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$CoroutineContainer\n*L\n289#1:397,2\n*E\n"})
    public final class CoroutineContainer
    extends RendererContainer {
        @NotNull
        private final SuspendContextImpl suspendContext;
        @Nullable
        private final CoroutineInfoData rootCoroutineInfo;
        @NotNull
        private final List<CoroutineInfoData> childCoroutines;
        @NotNull
        private final Map<String, List<CoroutineInfoData>> parentJobToChildCoroutines;

        public CoroutineContainer(@Nullable SuspendContextImpl suspendContext, @Nullable String rootJob, CoroutineInfoData rootCoroutineInfo, @NotNull boolean isCurrent, @NotNull List<? extends CoroutineInfoData> childCoroutines, Map<String, ? extends List<? extends CoroutineInfoData>> parentJobToChildCoroutines) {
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            Intrinsics.checkNotNullParameter(childCoroutines, (String)"childCoroutines");
            Intrinsics.checkNotNullParameter(parentJobToChildCoroutines, (String)"parentJobToChildCoroutines");
            SimpleColoredTextIconPresentationRenderer simpleColoredTextIconPresentationRenderer = CoroutineView.this.renderer;
            Object object = rootCoroutineInfo;
            if ((object == null || (object = ((CoroutineInfoData)object).getCoroutineDescriptor()) == null) && (object = rootJob) == null) {
                object = "UNKNOWN_JOB";
            }
            super(simpleColoredTextIconPresentationRenderer.renderThreadGroup((String)object, isCurrent));
            this.suspendContext = suspendContext;
            this.rootCoroutineInfo = rootCoroutineInfo;
            this.childCoroutines = childCoroutines;
            this.parentJobToChildCoroutines = parentJobToChildCoroutines;
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            CoroutineViewKt.access$invokeInSuspendContext(this.suspendContext, arg_0 -> CoroutineContainer.computeChildren$lambda$0(this, CoroutineView.this, node, arg_0));
        }

        private static final Unit computeChildren$lambda$0(CoroutineContainer this$0, CoroutineView this$1, XCompositeNode $node, SuspendContextImpl suspendContext) {
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            XValueChildrenList children = new XValueChildrenList();
            if (this$0.rootCoroutineInfo != null) {
                children.add((XNamedValue)this$1.new FramesContainer(this$0.rootCoroutineInfo, suspendContext));
            }
            Iterable $this$forEach$iv = this$0.childCoroutines;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CoroutineInfoData childCoroutine = (CoroutineInfoData)element$iv;
                boolean bl = false;
                List childCoroutines = this$0.parentJobToChildCoroutines.get(childCoroutine.getJob());
                String string = childCoroutine.getJob();
                boolean bl2 = childCoroutine.isRunningOnCurrentThread((SuspendContext)suspendContext);
                List list2 = childCoroutines;
                if (list2 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                children.add((XNamedValue)this$1.new CoroutineContainer(suspendContext, string, childCoroutine, bl2, list2, this$0.parentJobToChildCoroutines));
            }
            if (children.size() > 0) {
                $node.addChildren(children, true);
            } else {
                $node.addChildren(XValueChildrenList.singleton((XNamedValue)this$1.new InfoNode("coroutine.view.fetching.not_found")), true);
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$CoroutineFrameValue;", "Lcom/intellij/xdebugger/frame/XNamedValue;", "frameItem", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;)V", "getFrameItem", "()Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "computePresentation", "", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "intellij.kotlin.jvm.debugger.coroutines"})
    public final class CoroutineFrameValue
    extends XNamedValue {
        @NotNull
        private final CoroutineStackFrameItem frameItem;

        public CoroutineFrameValue(CoroutineStackFrameItem frameItem) {
            Intrinsics.checkNotNullParameter((Object)((Object)frameItem), (String)"frameItem");
            super(frameItem.uniqueId());
            this.frameItem = frameItem;
        }

        @NotNull
        public final CoroutineStackFrameItem getFrameItem() {
            return this.frameItem;
        }

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            CoroutineView.this.applyRenderer(node, CoroutineView.this.renderer.render(this.frameItem.getLocation()));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$CoroutineTopGroupContainer;", "Lcom/intellij/xdebugger/frame/XValueContainer;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Lcom/intellij/debugger/engine/SuspendContextImpl;)V", "getSuspendContext", "()Lcom/intellij/debugger/engine/SuspendContextImpl;", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "intellij.kotlin.jvm.debugger.coroutines"})
    public final class CoroutineTopGroupContainer
    extends XValueContainer {
        @NotNull
        private final SuspendContextImpl suspendContext;

        public CoroutineTopGroupContainer(SuspendContextImpl suspendContext) {
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            this.suspendContext = suspendContext;
        }

        @NotNull
        public final SuspendContextImpl getSuspendContext() {
            return this.suspendContext;
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            node.setAlreadySorted(true);
            if (this.suspendContext.getSuspendPolicy() != 2) {
                node.addChildren(XValueChildrenList.singleton((XNamedValue)new ErrorNode("to.enable.information.breakpoint.suspend.policy.should.be.set.to.all.threads")), true);
                return;
            }
            XValueChildrenList children = new XValueChildrenList();
            if (Registry.Companion.is("coroutine.panel.show.jobs.hierarchy")) {
                children.add((XNamedValue)new RootCoroutineContainer(this.suspendContext));
            } else {
                children.add((XNamedValue)new DispatchersContainer(this.suspendContext));
            }
            node.addChildren(children, true);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$CreationFramesContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RendererContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "creationFrames", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CreationCoroutineStackFrameItem;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Ljava/util/List;)V", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "intellij.kotlin.jvm.debugger.coroutines"})
    @SourceDebugExtension(value={"SMAP\nCoroutineView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineView.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$CreationFramesContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,396:1\n1915#2,2:397\n*S KotlinDebug\n*F\n+ 1 CoroutineView.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$CreationFramesContainer\n*L\n344#1:397,2\n*E\n"})
    public final class CreationFramesContainer
    extends RendererContainer {
        @NotNull
        private final List<CreationCoroutineStackFrameItem> creationFrames;

        public CreationFramesContainer(List<CreationCoroutineStackFrameItem> creationFrames) {
            Intrinsics.checkNotNullParameter(creationFrames, (String)"creationFrames");
            super(CoroutineView.this.renderer.renderCreationNode());
            this.creationFrames = creationFrames;
        }

        /*
         * WARNING - void declaration
         */
        public void computeChildren(@NotNull XCompositeNode node) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            node.setAlreadySorted(true);
            XValueChildrenList children = new XValueChildrenList();
            Iterable iterable = this.creationFrames;
            CoroutineView coroutineView = CoroutineView.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CreationCoroutineStackFrameItem it = (CreationCoroutineStackFrameItem)((Object)element$iv);
                boolean bl = false;
                children.add((XNamedValue)coroutineView.new CoroutineFrameValue(it));
            }
            node.addChildren(children, true);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$DispatcherContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RendererContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "dispatcherName", "", "isCurrent", "", "coroutines", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Lcom/intellij/debugger/engine/SuspendContextImpl;Ljava/lang/String;ZLjava/util/List;)V", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "intellij.kotlin.jvm.debugger.coroutines"})
    @SourceDebugExtension(value={"SMAP\nCoroutineView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineView.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$DispatcherContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,396:1\n1915#2,2:397\n*S KotlinDebug\n*F\n+ 1 CoroutineView.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$DispatcherContainer\n*L\n262#1:397,2\n*E\n"})
    public final class DispatcherContainer
    extends RendererContainer {
        @NotNull
        private final SuspendContextImpl suspendContext;
        @Nullable
        private final List<CoroutineInfoData> coroutines;

        public DispatcherContainer(@NotNull SuspendContextImpl suspendContext, String dispatcherName, @Nullable boolean isCurrent, List<? extends CoroutineInfoData> coroutines) {
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            Intrinsics.checkNotNullParameter((Object)dispatcherName, (String)"dispatcherName");
            super(CoroutineView.this.renderer.renderThreadGroup(dispatcherName, isCurrent));
            this.suspendContext = suspendContext;
            this.coroutines = coroutines;
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            CoroutineViewKt.access$invokeInSuspendContext(this.suspendContext, arg_0 -> DispatcherContainer.computeChildren$lambda$0(this, node, CoroutineView.this, arg_0));
        }

        private static final Unit computeChildren$lambda$0(DispatcherContainer this$0, XCompositeNode $node, CoroutineView this$1, SuspendContextImpl suspendContext) {
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            XValueChildrenList children = new XValueChildrenList();
            List<CoroutineInfoData> list2 = this$0.coroutines;
            if (list2 != null) {
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CoroutineInfoData it = (CoroutineInfoData)element$iv;
                    boolean bl = false;
                    children.add((XNamedValue)this$1.new CoroutineContainer(suspendContext, it.getJob(), it, it.isRunningOnCurrentThread((SuspendContext)suspendContext), CollectionsKt.emptyList(), MapsKt.emptyMap()));
                }
            }
            if (children.size() > 0) {
                $node.addChildren(children, true);
            } else {
                $node.addChildren(XValueChildrenList.singleton((XNamedValue)this$1.new InfoNode("coroutine.view.fetching.not_found")), true);
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$DispatchersContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RendererContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Lcom/intellij/debugger/engine/SuspendContextImpl;)V", "getSuspendContext", "()Lcom/intellij/debugger/engine/SuspendContextImpl;", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "intellij.kotlin.jvm.debugger.coroutines"})
    @SourceDebugExtension(value={"SMAP\nCoroutineView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineView.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$DispatchersContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,396:1\n1512#2:397\n1538#2,3:398\n1541#2,3:408\n1807#2,3:411\n383#3,7:401\n*S KotlinDebug\n*F\n+ 1 CoroutineView.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$DispatchersContainer\n*L\n236#1:397\n236#1:398,3\n236#1:408,3\n240#1:411,3\n236#1:401,7\n*E\n"})
    public final class DispatchersContainer
    extends RendererContainer {
        @NotNull
        private final SuspendContextImpl suspendContext;

        public DispatchersContainer(SuspendContextImpl suspendContext) {
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            super(CoroutineView.this.renderer.renderNoIconNode(KotlinDebuggerCoroutinesBundle.message("coroutine.view.node.dispatchers", new Object[0])));
            this.suspendContext = suspendContext;
        }

        @NotNull
        public final SuspendContextImpl getSuspendContext() {
            return this.suspendContext;
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            CoroutineViewKt.access$invokeInSuspendContext(this.suspendContext, arg_0 -> DispatchersContainer.computeChildren$lambda$0(node, CoroutineView.this, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit computeChildren$lambda$0(XCompositeNode $node, CoroutineView this$0, SuspendContextImpl suspendContext) {
            void $this$groupByTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            CoroutineInfoCache coroutineCache = new CoroutineDebugProbesProxy(suspendContext).dumpCoroutines();
            if (!coroutineCache.isOk()) {
                $node.addChildren(XValueChildrenList.singleton((XNamedValue)this$0.new ErrorNode("coroutine.view.fetching.error")), true);
                return Unit.INSTANCE;
            }
            XValueChildrenList children = new XValueChildrenList();
            Iterable $this$groupBy$iv = coroutineCache.getCache();
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                void $this$getOrPut$iv$iv$iv;
                CoroutineInfoData it = (CoroutineInfoData)element$iv$iv;
                boolean bl = false;
                String key$iv$iv = it.getDispatcher();
                Map map2 = destination$iv$iv;
                String key$iv$iv$iv = key$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map groups = destination$iv$iv;
            for (String dispatcher : groups.keySet()) {
                String string;
                boolean isCurrent;
                List coroutines;
                block13: {
                    List list2 = coroutines = (List)groups.get(dispatcher);
                    if (list2 != null) {
                        Iterable $this$any$iv = list2;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            v2 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                CoroutineInfoData it = (CoroutineInfoData)element$iv;
                                boolean bl = false;
                                if (!it.isRunningOnCurrentThread((SuspendContext)suspendContext)) continue;
                                v2 = true;
                                break block13;
                            }
                            v2 = false;
                        }
                    } else {
                        v2 = isCurrent = false;
                    }
                }
                if ((string = dispatcher) == null) {
                    string = EMPTY_DISPATCHER_NAME;
                }
                children.add((XNamedValue)this$0.new DispatcherContainer(suspendContext, string, isCurrent, coroutines));
            }
            if (children.size() > 0) {
                $node.addChildren(children, true);
            } else {
                $node.addChildren(XValueChildrenList.singleton((XNamedValue)this$0.new InfoNode("coroutine.view.fetching.not_found")), true);
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$EmptyNode;", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueContainerNode;", "Lcom/intellij/xdebugger/frame/XValueContainer;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;)V", "intellij.kotlin.jvm.debugger.coroutines"})
    public final class EmptyNode
    extends XValueContainerNode<XValueContainer> {
        public EmptyNode() {
            super(CoroutineView.this.panel.getTree(), null, true, new XValueContainer(){});
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$ErrorNode;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RendererContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "error", "", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Ljava/lang/String;)V", "getError", "()Ljava/lang/String;", "intellij.kotlin.jvm.debugger.coroutines"})
    public final class ErrorNode
    extends RendererContainer {
        @NotNull
        private final String error;

        public ErrorNode(String error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            super(CoroutineView.this.renderer.renderErrorNode(error));
            this.error = error;
        }

        @NotNull
        public final String getError() {
            return this.error;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$FramesContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RendererContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "infoData", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;Lcom/intellij/debugger/engine/SuspendContextImpl;)V", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "intellij.kotlin.jvm.debugger.coroutines"})
    @SourceDebugExtension(value={"SMAP\nCoroutineView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineView.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$FramesContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,396:1\n1915#2,2:397\n*S KotlinDebug\n*F\n+ 1 CoroutineView.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$FramesContainer\n*L\n325#1:397,2\n*E\n"})
    public final class FramesContainer
    extends RendererContainer {
        @NotNull
        private final CoroutineInfoData infoData;
        @NotNull
        private final SuspendContextImpl suspendContext;

        public FramesContainer(@NotNull CoroutineInfoData infoData, SuspendContextImpl suspendContext) {
            Intrinsics.checkNotNullParameter((Object)infoData, (String)"infoData");
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            super(CoroutineView.this.renderer.renderNoIconNode("Stacktrace"));
            this.infoData = infoData;
            this.suspendContext = suspendContext;
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            node.setAlreadySorted(true);
            CoroutineViewKt.access$invokeInSuspendContext(this.suspendContext, arg_0 -> FramesContainer.computeChildren$lambda$0(this, CoroutineView.this, node, arg_0));
        }

        private static final Unit computeChildren$lambda$0(FramesContainer this$0, CoroutineView this$1, XCompositeNode $node, SuspendContextImpl suspendContext) {
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            XValueChildrenList children = new XValueChildrenList();
            CoroutineFrameBuilder.Companion.CoroutineFrameItemLists doubleFrameList = CoroutineFrameBuilder.Companion.build(this$0.infoData, suspendContext);
            Object object = doubleFrameList;
            if (object != null && (object = ((CoroutineFrameBuilder.Companion.CoroutineFrameItemLists)object).getFrames()) != null) {
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CoroutineStackFrameItem it = (CoroutineStackFrameItem)((Object)element$iv);
                    boolean bl = false;
                    children.add((XNamedValue)this$1.new CoroutineFrameValue(it));
                }
            }
            CoroutineFrameBuilder.Companion.CoroutineFrameItemLists coroutineFrameItemLists = doubleFrameList;
            List<CreationCoroutineStackFrameItem> creationFrames = coroutineFrameItemLists != null ? coroutineFrameItemLists.getCreationFrames() : null;
            Collection collection = creationFrames;
            if (!(collection == null || collection.isEmpty())) {
                children.add((XNamedValue)this$1.new CreationFramesContainer(creationFrames));
            }
            $node.addChildren(children, true);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$InfoNode;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RendererContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "error", "", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Ljava/lang/String;)V", "getError", "()Ljava/lang/String;", "intellij.kotlin.jvm.debugger.coroutines"})
    public final class InfoNode
    extends RendererContainer {
        @NotNull
        private final String error;

        public InfoNode(String error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            super(CoroutineView.this.renderer.renderInfoNode(error));
            this.error = error;
        }

        @NotNull
        public final String getError() {
            return this.error;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0096\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RendererContainer;", "Lcom/intellij/xdebugger/frame/XNamedValue;", "presentation", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIcon;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIcon;)V", "getPresentation", "()Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIcon;", "computePresentation", "", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "intellij.kotlin.jvm.debugger.coroutines"})
    public class RendererContainer
    extends XNamedValue {
        @NotNull
        private final SimpleColoredTextIcon presentation;

        public RendererContainer(SimpleColoredTextIcon presentation) {
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            super(presentation.simpleString());
            this.presentation = presentation;
        }

        @NotNull
        public final SimpleColoredTextIcon getPresentation() {
            return this.presentation;
        }

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            CoroutineView.this.applyRenderer(node, this.presentation);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RootCoroutineContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RendererContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Lcom/intellij/debugger/engine/SuspendContextImpl;)V", "getSuspendContext", "()Lcom/intellij/debugger/engine/SuspendContextImpl;", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "intellij.kotlin.jvm.debugger.coroutines"})
    @SourceDebugExtension(value={"SMAP\nCoroutineView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineView.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RootCoroutineContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,396:1\n1512#2:397\n1538#2,3:398\n1541#2,3:408\n1220#2,2:411\n1249#2,4:413\n777#2:417\n873#2,2:418\n1642#2,10:420\n1915#2:430\n1916#2:432\n1652#2:433\n383#3,7:401\n1#4:431\n*S KotlinDebug\n*F\n+ 1 CoroutineView.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$RootCoroutineContainer\n*L\n184#1:397\n184#1:398,3\n184#1:408,3\n185#1:411,2\n185#1:413,4\n186#1:417\n186#1:418,2\n186#1:420,10\n186#1:430\n186#1:432\n186#1:433\n184#1:401,7\n186#1:431\n*E\n"})
    public final class RootCoroutineContainer
    extends RendererContainer {
        @NotNull
        private final SuspendContextImpl suspendContext;

        public RootCoroutineContainer(SuspendContextImpl suspendContext) {
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            super(CoroutineView.this.renderer.renderNoIconNode(KotlinDebuggerCoroutinesBundle.message("coroutine.view.node.jobs", new Object[0])));
            this.suspendContext = suspendContext;
        }

        @NotNull
        public final SuspendContextImpl getSuspendContext() {
            return this.suspendContext;
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            CoroutineViewKt.access$invokeInSuspendContext(this.suspendContext, arg_0 -> RootCoroutineContainer.computeChildren$lambda$0(node, CoroutineView.this, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit computeChildren$lambda$0(XCompositeNode $node, CoroutineView this$0, SuspendContextImpl suspendContext) {
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            CoroutineDebugProbesProxy coroutineDebugProxy = new CoroutineDebugProbesProxy(suspendContext);
            CoroutineInfoCache coroutineCache = coroutineDebugProxy.dumpCoroutines();
            if (!coroutineCache.isOk()) {
                $node.addChildren(XValueChildrenList.singleton((XNamedValue)this$0.new ErrorNode("coroutine.view.fetching.error")), true);
                return Unit.INSTANCE;
            }
            XValueChildrenList coroutines = new XValueChildrenList();
            List<CoroutineInfoData> cache2 = coroutineCache.getCache();
            boolean isHierarchyBuilt = coroutineDebugProxy.fetchAndSetJobsAndParentsForCoroutines(cache2);
            if (isHierarchyBuilt) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                void $this$filterTo$iv$iv;
                CoroutineInfoData it;
                Iterable $this$associateByTo$iv$iv;
                Object key$iv$iv;
                void $this$groupByTo$iv$iv;
                Iterable $this$groupBy$iv = cache2;
                boolean $i$f$groupBy = false;
                Iterable iterable = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo22 = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object;
                    void $this$getOrPut$iv$iv$iv;
                    CoroutineInfoData it2 = (CoroutineInfoData)element$iv$iv;
                    boolean bl = false;
                    key$iv$iv = it2.getParentJob();
                    Map map2 = destination$iv$iv;
                    String key$iv$iv$iv = key$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    Iterator list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                Map parentJobToChildCoroutineInfos = destination$iv$iv;
                Iterable $this$associateBy$iv = cache2;
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable $i$f$groupByTo22 = $this$associateBy$iv;
                Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    key$iv$iv = (CoroutineInfoData)element$iv$iv;
                    Map map3 = destination$iv$iv2;
                    boolean bl = false;
                    map3.put(it.getJob(), element$iv$iv);
                }
                Map jobToCoroutineInfo = destination$iv$iv2;
                Iterable $this$filter$iv = cache2;
                boolean $i$f$filter = false;
                $this$associateByTo$iv$iv = $this$filter$iv;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (CoroutineInfoData)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getParentJob() == null)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv2;
                boolean $i$f$mapNotNull = false;
                $this$filterTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    CoroutineInfoData it3 = (CoroutineInfoData)element$iv$iv;
                    boolean bl3 = false;
                    if (it3.getJob() == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                List rootJobs = (List)destination$iv$iv2;
                for (String rootJob : rootJobs) {
                    CoroutineInfoData rootCoroutine;
                    CoroutineInfoData coroutineInfoData = rootCoroutine = (CoroutineInfoData)jobToCoroutineInfo.get(rootJob);
                    boolean bl = coroutineInfoData != null ? coroutineInfoData.isRunningOnCurrentThread((SuspendContext)suspendContext) : false;
                    List list2 = (List)parentJobToChildCoroutineInfos.get(rootJob);
                    if (list2 == null) {
                        list2 = CollectionsKt.emptyList();
                    }
                    coroutines.add((XNamedValue)this$0.new CoroutineContainer(suspendContext, rootJob, rootCoroutine, bl, list2, parentJobToChildCoroutineInfos));
                }
            } else {
                for (CoroutineInfoData coroutine : cache2) {
                    coroutines.add((XNamedValue)this$0.new CoroutineContainer(suspendContext, coroutine.getJob(), coroutine, coroutine.isRunningOnCurrentThread((SuspendContext)suspendContext), CollectionsKt.emptyList(), MapsKt.emptyMap()));
                }
            }
            if (coroutines.size() > 0) {
                $node.addChildren(coroutines, true);
            } else {
                $node.addChildren(XValueChildrenList.singleton((XNamedValue)this$0.new InfoNode("coroutine.view.fetching.not_found")), true);
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00030\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$XCoroutinesRootNode;", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueContainerNode;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView$CoroutineTopGroupContainer;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;Lcom/intellij/debugger/engine/SuspendContextImpl;)V", "intellij.kotlin.jvm.debugger.coroutines"})
    public final class XCoroutinesRootNode
    extends XValueContainerNode<CoroutineTopGroupContainer> {
        public XCoroutinesRootNode(SuspendContextImpl suspendContext) {
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            super(CoroutineView.this.panel.getTree(), null, false, (XValueContainer)new CoroutineTopGroupContainer(suspendContext));
        }
    }
}

