/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.view;

import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.ThreadsViewSettings;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.coroutine.KotlinDebuggerCoroutinesBundle;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.SimpleColoredTextIcon;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.SimpleColoredTextIconKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\rJ\u0016\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\rJ\u000e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIconPresentationRenderer;", "", "<init>", "()V", "settings", "Lcom/intellij/debugger/settings/ThreadsViewSettings;", "render", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIcon;", "infoData", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "isCurrent", "", "textToHideFromContext", "", "location", "Lcom/sun/jdi/Location;", "renderCreationNode", "renderErrorNode", "error", "renderInfoNode", "text", "renderThreadGroup", "groupName", "renderExpandHover", "renderNoIconNode", "Companion", "intellij.kotlin.jvm.debugger.coroutines"})
public final class SimpleColoredTextIconPresentationRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ThreadsViewSettings settings;
    @NotNull
    private static final ReadOnlyProperty<Object, Logger> log$delegate = ProvidersKt.getLogger();

    public SimpleColoredTextIconPresentationRenderer() {
        ThreadsViewSettings threadsViewSettings = ThreadsViewSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)threadsViewSettings, (String)"getInstance(...)");
        this.settings = threadsViewSettings;
    }

    @NotNull
    public final SimpleColoredTextIcon render(@NotNull CoroutineInfoData infoData, boolean isCurrent, @NotNull String textToHideFromContext) {
        Intrinsics.checkNotNullParameter((Object)infoData, (String)"infoData");
        Intrinsics.checkNotNullParameter((Object)textToHideFromContext, (String)"textToHideFromContext");
        ThreadReference thread = infoData.getLastObservedThread();
        Object object = thread;
        if (object == null || (object = object.name()) == null || (object = StringsKt.substringBefore$default((String)object, (String)(" @" + infoData.getName()), null, (int)2, null)) == null) {
            object = "";
        }
        Object name2 = object;
        ThreadReference threadReference = thread;
        String threadState = threadReference != null ? DebuggerUtilsEx.getThreadStatusText((int)threadReference.status()) : "";
        Icon icon2 = SimpleColoredTextIconKt.fromState(infoData.getState(), isCurrent);
        SimpleColoredTextIcon label2 = new SimpleColoredTextIcon(icon2, !infoData.isCreated());
        label2.append$intellij_kotlin_jvm_debugger_coroutines("\"");
        label2.appendValue$intellij_kotlin_jvm_debugger_coroutines(infoData.getCoroutineDescriptor());
        label2.append$intellij_kotlin_jvm_debugger_coroutines("\": " + infoData.getState());
        if (((CharSequence)name2).length() > 0) {
            label2.append$intellij_kotlin_jvm_debugger_coroutines(" on thread \"");
            label2.appendValue$intellij_kotlin_jvm_debugger_coroutines((String)name2);
            label2.append$intellij_kotlin_jvm_debugger_coroutines("\": " + threadState);
        }
        return label2;
    }

    @NotNull
    public final SimpleColoredTextIcon render(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        SimpleColoredTextIcon label2 = new SimpleColoredTextIcon(null, false);
        DebuggerUIUtil.getColorScheme(null);
        if (location.method() != null) {
            String myName = location.method().name();
            String methodDisplay = this.settings.SHOW_ARGUMENTS_TYPES ? DebuggerUtilsEx.methodNameWithArguments((Method)location.method()) : myName;
            Intrinsics.checkNotNull((Object)methodDisplay);
            label2.appendValue$intellij_kotlin_jvm_debugger_coroutines(methodDisplay);
        }
        if (this.settings.SHOW_LINE_NUMBER) {
            label2.append$intellij_kotlin_jvm_debugger_coroutines(":");
            label2.append$intellij_kotlin_jvm_debugger_coroutines("" + DebuggerUtilsEx.getLineNumber((Location)location, (boolean)false));
        }
        if (this.settings.SHOW_CLASS_NAME) {
            Object refType;
            try {
                ReferenceType referenceType = location.declaringType();
                Intrinsics.checkNotNullExpressionValue((Object)referenceType, (String)"declaringType(...)");
                refType = referenceType;
                refType = refType.name();
            }
            catch (InternalError e) {
                refType = e.toString();
            }
            String name2 = refType;
            if (name2 != null) {
                label2.append$intellij_kotlin_jvm_debugger_coroutines(", ");
                int dotIndex = StringsKt.lastIndexOf$default((CharSequence)name2, (char)'.', (int)0, (boolean)false, (int)6, null);
                if (dotIndex < 0) {
                    label2.append$intellij_kotlin_jvm_debugger_coroutines(name2);
                } else {
                    String string = name2.substring(dotIndex + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    label2.append$intellij_kotlin_jvm_debugger_coroutines(string);
                    if (this.settings.SHOW_PACKAGE_NAME) {
                        String string2 = name2.substring(0, dotIndex);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        label2.append$intellij_kotlin_jvm_debugger_coroutines(" (" + string2 + ")");
                    }
                }
            }
        }
        if (this.settings.SHOW_SOURCE_NAME) {
            String sourceName;
            label2.append$intellij_kotlin_jvm_debugger_coroutines(", ");
            String string = sourceName = DebuggerUtilsEx.getSourceName((Location)location, arg_0 -> SimpleColoredTextIconPresentationRenderer.render$lambda$1(arg_0 -> SimpleColoredTextIconPresentationRenderer.render$lambda$0(location, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)string);
            label2.append$intellij_kotlin_jvm_debugger_coroutines(string);
        }
        return label2;
    }

    @NotNull
    public final SimpleColoredTextIcon renderCreationNode() {
        return new SimpleColoredTextIcon(AllIcons.Debugger.Frame, true, KotlinDebuggerCoroutinesBundle.message("coroutine.dump.creation.trace", new Object[0]));
    }

    @NotNull
    public final SimpleColoredTextIcon renderErrorNode(@NotNull String error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        return new SimpleColoredTextIcon(AllIcons.Actions.Lightning, false, KotlinDebuggerCoroutinesBundle.message(error, new Object[0]));
    }

    @NotNull
    public final SimpleColoredTextIcon renderInfoNode(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new SimpleColoredTextIcon(AllIcons.General.Information, false, KotlinDebuggerCoroutinesBundle.message(text, new Object[0]));
    }

    @NotNull
    public final SimpleColoredTextIcon renderThreadGroup(@NotNull String groupName, boolean isCurrent) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        return new SimpleColoredTextIcon(isCurrent ? AllIcons.Debugger.ThreadGroupCurrent : AllIcons.Debugger.ThreadGroup, true, groupName);
    }

    @NotNull
    public final SimpleColoredTextIcon renderExpandHover(@NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        return new SimpleColoredTextIcon(AllIcons.Ide.Notification.ExpandHover, true, groupName);
    }

    @NotNull
    public final SimpleColoredTextIcon renderNoIconNode(@NotNull String groupName) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        return new SimpleColoredTextIcon(null, true, groupName);
    }

    private static final String render$lambda$0(Location $location, Throwable e) {
        String[] stringArray = new String[]{$location.toString()};
        Companion.getLog().error("Error while trying to resolve sourceName for location", e, stringArray);
        return "Unknown Source";
    }

    private static final String render$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/SimpleColoredTextIconPresentationRenderer$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "intellij.kotlin.jvm.debugger.coroutines"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return (Logger)log$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

