/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.Value;
import org.jetbrains.eval4j.jdi.JdiValuesKt;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluatorResolutionUtilsKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinRuntimeTypeEvaluatorBase;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B)\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinRuntimeTypeEvaluator;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinRuntimeTypeEvaluatorBase;", "Lorg/jetbrains/kotlin/types/KotlinType;", "editor", "Lcom/intellij/openapi/editor/Editor;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/psi/KtExpression;Lcom/intellij/debugger/impl/DebuggerContextImpl;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "getCastableRuntimeType", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "value", "Lcom/sun/jdi/Value;", "kotlin.jvm-debugger.evaluation.k1"})
public abstract class KotlinRuntimeTypeEvaluator
extends KotlinRuntimeTypeEvaluatorBase<KotlinType> {
    public KotlinRuntimeTypeEvaluator(@Nullable Editor editor, @NotNull KtExpression expression, @NotNull DebuggerContextImpl context2, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        super(editor, (PsiElement)expression, context2, indicator);
    }

    @Override
    @Nullable
    protected KotlinType getCastableRuntimeType(@NotNull GlobalSearchScope scope, @NotNull com.sun.jdi.Value value) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Value myValue = JdiValuesKt.asValue(value);
        ClassDescriptor psiClass = EvaluatorResolutionUtilsKt.getClassDescriptor$default(myValue.getAsmType(), scope, false, null, 6, null);
        if (psiClass != null) {
            return (KotlinType)psiClass.getDefaultType();
        }
        com.sun.jdi.Type type2 = value.type();
        if (type2 instanceof ClassType) {
            ClassType superclass = ((ClassType)type2).superclass();
            if (superclass != null && !Intrinsics.areEqual((Object)"java.lang.Object", (Object)superclass.name())) {
                Type type3 = Type.getType((String)superclass.signature());
                Intrinsics.checkNotNullExpressionValue((Object)type3, (String)"getType(...)");
                psiClass = EvaluatorResolutionUtilsKt.getClassDescriptor$default(type3, scope, false, null, 6, null);
                if (psiClass != null) {
                    return (KotlinType)psiClass.getDefaultType();
                }
            }
            for (InterfaceType interfaceType : ((ClassType)type2).interfaces()) {
                Type type4 = Type.getType((String)interfaceType.signature());
                Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"getType(...)");
                psiClass = EvaluatorResolutionUtilsKt.getClassDescriptor$default(type4, scope, false, null, 6, null);
                if (psiClass == null) continue;
                return (KotlinType)psiClass.getDefaultType();
            }
        }
        return null;
    }
}

