/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.EditorEvaluationCommand;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.Value;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilder;
import org.jetbrains.kotlin.psi.KtBlockCodeFragment;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B)\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0017\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00018\u0000H$\u00a2\u0006\u0002\u0010\u0013J\u001f\u0010\u0014\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H$\u00a2\u0006\u0002\u0010\u0019J\u0017\u0010\u001a\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001b\u001a\u00020\u001cH\u0014\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinRuntimeTypeEvaluatorBase;", "T", "Lcom/intellij/debugger/ui/EditorEvaluationCommand;", "editor", "Lcom/intellij/openapi/editor/Editor;", "expression", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/debugger/impl/DebuggerContextImpl;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiElement;Lcom/intellij/debugger/impl/DebuggerContextImpl;Lcom/intellij/openapi/progress/ProgressIndicator;)V", "threadAction", "", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "typeCalculationFinished", "type", "(Ljava/lang/Object;)V", "getCastableRuntimeType", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "value", "Lcom/sun/jdi/Value;", "(Lcom/intellij/psi/search/GlobalSearchScope;Lcom/sun/jdi/Value;)Ljava/lang/Object;", "evaluate", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "(Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;)Ljava/lang/Object;", "kotlin.jvm-debugger.evaluation"})
@ApiStatus.Internal
public abstract class KotlinRuntimeTypeEvaluatorBase<T>
extends EditorEvaluationCommand<T> {
    public KotlinRuntimeTypeEvaluatorBase(@Nullable Editor editor, @NotNull PsiElement expression, @NotNull DebuggerContextImpl context2, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        super(editor, expression, context2, indicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadAction(@NotNull SuspendContextImpl suspendContext) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Object type2 = null;
        try {
            type2 = this.evaluate();
        }
        catch (ProcessCanceledException ignored) {
            throw ignored;
        }
        catch (EvaluateException evaluateException) {
        }
        finally {
            this.typeCalculationFinished(type2);
        }
    }

    protected abstract void typeCalculationFinished(@Nullable T var1);

    @Nullable
    protected abstract T getCastableRuntimeType(@NotNull GlobalSearchScope var1, @NotNull Value var2);

    @Nullable
    protected T evaluate(@NotNull EvaluationContextImpl evaluationContext) {
        Intrinsics.checkNotNullParameter((Object)evaluationContext, (String)"evaluationContext");
        Project project = evaluationContext.getProject();
        KtBlockCodeFragment codeFragment = (KtBlockCodeFragment)ActionsKt.runReadAction(() -> KotlinRuntimeTypeEvaluatorBase.evaluate$lambda$0(this));
        ExpressionEvaluator evaluator = (ExpressionEvaluator)DebuggerInvocationUtil.commitAndRunReadAction((Project)project, () -> KotlinRuntimeTypeEvaluatorBase.evaluate$lambda$1(codeFragment, evaluationContext));
        Value value = evaluator.evaluate((EvaluationContext)evaluationContext);
        if (value != null) {
            GlobalSearchScope globalSearchScope = evaluationContext.getDebugProcess().getSearchScope();
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getSearchScope(...)");
            GlobalSearchScope scope = globalSearchScope;
            return (T)ActionsKt.runReadAction(() -> KotlinRuntimeTypeEvaluatorBase.evaluate$lambda$2(this, scope, value));
        }
        EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((String)JavaDebuggerBundle.message((String)"evaluation.error.surrounded.expression.null", (Object[])new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)((Object)evaluateException), (String)"createEvaluateException(...)");
        throw (Throwable)evaluateException;
    }

    private static final KtBlockCodeFragment evaluate$lambda$0(KotlinRuntimeTypeEvaluatorBase this$0) {
        Project project = this$0.myElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
        String string = this$0.myElement.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return ktPsiFactory.createBlockCodeFragment(string, this$0.myElement.getContainingFile().getContext());
    }

    private static final ExpressionEvaluator evaluate$lambda$1(KtBlockCodeFragment $codeFragment, EvaluationContextImpl $evaluationContext) {
        return KotlinEvaluatorBuilder.INSTANCE.build((PsiElement)$codeFragment, ContextUtil.getSourcePosition((StackFrameContext)((StackFrameContext)$evaluationContext)));
    }

    private static final Object evaluate$lambda$2(KotlinRuntimeTypeEvaluatorBase this$0, GlobalSearchScope $scope, Value $value) {
        return this$0.getCastableRuntimeType($scope, $value);
    }
}

