/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedClassSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.api.types.KaUsualClassType;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinCodeFragmentWrapper;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluationBundle;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompilationStats;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockCodeFragment;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinValueClassToStringWrapper;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinCodeFragmentWrapper;", "stats", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompilationStats;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompilationStats;)V", "getStats", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompilationStats;", "transformIfNeeded", "", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "replaceExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "newExpressionText", "", "extractExpressionWithText", "Lkotlin/Pair;", "Companion", "kotlin.jvm-debugger.evaluation"})
@SourceDebugExtension(value={"SMAP\nkotlinExpressionWrappers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 kotlinExpressionWrappers.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/KotlinValueClassToStringWrapper\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n*L\n1#1,79:1\n30#2,2:80\n36#3,15:82\n*S KotlinDebug\n*F\n+ 1 kotlinExpressionWrappers.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/KotlinValueClassToStringWrapper\n*L\n32#1:80,2\n32#1:82,15\n*E\n"})
public final class KotlinValueClassToStringWrapper
implements KotlinCodeFragmentWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CodeFragmentCompilationStats stats;
    @NotNull
    private static final Logger LOG;

    public KotlinValueClassToStringWrapper(@NotNull CodeFragmentCompilationStats stats) {
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        this.stats = stats;
    }

    @NotNull
    public final CodeFragmentCompilationStats getStats() {
        return this.stats;
    }

    @Override
    public void transformIfNeeded(@NotNull KtCodeFragment codeFragment) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        Pair<KtExpression, String> pair = this.extractExpressionWithText(codeFragment);
        if (pair == null) {
            return;
        }
        Pair<KtExpression, String> pair2 = pair;
        KtExpression expression = (KtExpression)pair2.component1();
        String expressionText = (String)pair2.component2();
        Object object = this.stats.startAndMeasureAnalysisUnderReadAction-IoAF18A(() -> KotlinValueClassToStringWrapper.transformIfNeeded$lambda$0(expression));
        Boolean needsWrapping = (Boolean)(Result.isFailure-impl((Object)object) ? null : object);
        if (!Intrinsics.areEqual((Object)needsWrapping, (Object)true)) {
            return;
        }
        this.replaceExpression(expression, "(" + expressionText + ") as Any?");
    }

    private final void replaceExpression(KtExpression expression, String newExpressionText) {
        KtExpression newExpression2 = (KtExpression)ActionsKt.runReadAction(() -> KotlinValueClassToStringWrapper.replaceExpression$lambda$0(expression, newExpressionText));
        ActionsKt.invokeAndWaitIfNeeded$default(null, () -> KotlinValueClassToStringWrapper.replaceExpression$lambda$1(expression, newExpression2), (int)1, null);
    }

    private final Pair<KtExpression, String> extractExpressionWithText(KtCodeFragment codeFragment) {
        return (Pair)ActionsKt.runReadAction(() -> KotlinValueClassToStringWrapper.extractExpressionWithText$lambda$0(codeFragment));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final boolean transformIfNeeded$lambda$0(KtExpression $expression) {
        boolean bl;
        void this_$iv$iv;
        KtElement useSiteElement$iv = (KtElement)$expression;
        boolean $i$f$analyze = false;
        Project project = useSiteElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
        KtElement useSiteElement$iv$iv = useSiteElement$iv;
        boolean $i$f$analyze2 = false;
        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        try {
            boolean bl2;
            Object lock$iv$iv;
            Object object = lock$iv$iv = new Object();
            synchronized (object) {
                KaNamedClassSymbol ktNamedClassOrObjectSymbol;
                KaUsualClassType ktUsualClassType;
                boolean bl3 = false;
                KaSession $this$transformIfNeeded_u24lambda_u240_u240 = analysisSession$iv$iv;
                boolean bl4 = false;
                KaType kaType = $this$transformIfNeeded_u24lambda_u240_u240.getExpressionType($expression);
                KaUsualClassType kaUsualClassType = ktUsualClassType = kaType instanceof KaUsualClassType ? (KaUsualClassType)kaType : null;
                KaClassLikeSymbol kaClassLikeSymbol = kaUsualClassType != null ? kaUsualClassType.getSymbol() : null;
                KaNamedClassSymbol kaNamedClassSymbol = ktNamedClassOrObjectSymbol = kaClassLikeSymbol instanceof KaNamedClassSymbol ? (KaNamedClassSymbol)kaClassLikeSymbol : null;
                bl2 = kaNamedClassSymbol != null ? kaNamedClassSymbol.isInline() : false;
            }
            bl = bl2;
        }
        catch (Throwable throwable$iv$iv) {
            this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
            throw new KotlinNothingValueException();
        }
        finally {
            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
        }
        return bl;
    }

    private static final Unit replaceExpression$lambda$1$0(KtExpression $expression, KtExpression $newExpression) {
        $expression.replace((PsiElement)$newExpression);
        return Unit.INSTANCE;
    }

    private static final KtExpression replaceExpression$lambda$0(KtExpression $expression, String $newExpressionText) {
        Project project = $expression.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new KtPsiFactory(project, false, 2, null).createExpression($newExpressionText);
    }

    private static final Unit replaceExpression$lambda$1(KtExpression $expression, KtExpression $newExpression) {
        Project project = $expression.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ApplicationUtilsKt.executeWriteCommand(project, KotlinDebuggerEvaluationBundle.message("wrap.expression", new Object[0]), (Function0<Unit>)((Function0)() -> KotlinValueClassToStringWrapper.replaceExpression$lambda$1$0($expression, $newExpression)));
        return Unit.INSTANCE;
    }

    private static final Pair extractExpressionWithText$lambda$0(KtCodeFragment $codeFragment) {
        KtExpression ktExpression;
        KtCodeFragment ktCodeFragment = $codeFragment;
        if (ktCodeFragment instanceof KtExpressionCodeFragment) {
            ktExpression = ((KtExpressionCodeFragment)$codeFragment).getContentElement();
        } else if (ktCodeFragment instanceof KtBlockCodeFragment) {
            List list2 = ((KtBlockCodeFragment)$codeFragment).getContentElement().getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
            ktExpression = (KtExpression)CollectionsKt.lastOrNull((List)list2);
        } else {
            LOG.error("Invalid code fragment type: " + $codeFragment.getClass());
            ktExpression = null;
        }
        KtExpression expression = ktExpression;
        return expression == null ? null : new Pair((Object)expression, (Object)expression.getText());
    }

    static {
        Logger logger = Logger.getInstance(KotlinValueClassToStringWrapper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinValueClassToStringWrapper$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm-debugger.evaluation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

