/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.classLoading;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0014\u0010\u0015\u001a\u00020\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004J\n\u0010\u0019\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "", "className", "", "relativeFileName", "bytes", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;[B)V", "getClassName", "()Ljava/lang/String;", "getRelativeFileName", "getBytes", "()[B", "isMainClass", "", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "kotlin.jvm-debugger.evaluation"})
public final class ClassToLoad {
    @NotNull
    private final String className;
    @NotNull
    private final String relativeFileName;
    @NotNull
    private final byte[] bytes;

    public ClassToLoad(@NotNull String className, @NotNull String relativeFileName, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)relativeFileName, (String)"relativeFileName");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.className = className;
        this.relativeFileName = relativeFileName;
        this.bytes = bytes;
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    @NotNull
    public final String getRelativeFileName() {
        return this.relativeFileName;
    }

    @NotNull
    public final byte[] getBytes() {
        return this.bytes;
    }

    public final boolean isMainClass() {
        return Intrinsics.areEqual((Object)this.className, (Object)"Generated_for_debugger_class");
    }

    @NotNull
    public final String component1() {
        return this.className;
    }

    @NotNull
    public final String component2() {
        return this.relativeFileName;
    }

    @NotNull
    public final byte[] component3() {
        return this.bytes;
    }

    @NotNull
    public final ClassToLoad copy(@NotNull String className, @NotNull String relativeFileName, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)relativeFileName, (String)"relativeFileName");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return new ClassToLoad(className, relativeFileName, bytes);
    }

    public static /* synthetic */ ClassToLoad copy$default(ClassToLoad classToLoad, String string, String string2, byte[] byArray, int n, Object object) {
        if ((n & 1) != 0) {
            string = classToLoad.className;
        }
        if ((n & 2) != 0) {
            string2 = classToLoad.relativeFileName;
        }
        if ((n & 4) != 0) {
            byArray = classToLoad.bytes;
        }
        return classToLoad.copy(string, string2, byArray);
    }

    @NotNull
    public String toString() {
        return "ClassToLoad(className=" + this.className + ", relativeFileName=" + this.relativeFileName + ", bytes=" + Arrays.toString(this.bytes) + ")";
    }

    public int hashCode() {
        int result2 = this.className.hashCode();
        result2 = result2 * 31 + this.relativeFileName.hashCode();
        result2 = result2 * 31 + Arrays.hashCode(this.bytes);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ClassToLoad)) {
            return false;
        }
        ClassToLoad classToLoad = (ClassToLoad)other;
        if (!Intrinsics.areEqual((Object)this.className, (Object)classToLoad.className)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.relativeFileName, (Object)classToLoad.relativeFileName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.bytes, (Object)classToLoad.bytes);
    }
}

