/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilation;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.extensions.IrGenerationExtension;
import org.jetbrains.kotlin.backend.jvm.JvmIrCodegenFactory;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeysKt;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassConstructorDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ClassDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCodegenException;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompilerKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompilingStrategy;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompilationResult;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.EvaluatorMemberScopeForMethod;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.EvaluatorModuleDescriptor;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.IRFragmentCompilerCodegen;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.K1CodeFragmentParameterInfo;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.SmartCodeFragmentParameter;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockCodeFragment;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.scripting.compiler.plugin.extensions.ScriptLoweringExtension;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.types.ErasureProjectionComputer;
import org.jetbrains.kotlin.types.ErasureTypeAttributes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeAttributes;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeParameterUpperBoundEraser;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUsage;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J4\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J.\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002JD\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompiler;", "", "executionContext", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/ExecutionContext;)V", "compile", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompilationResult;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "filesToCompile", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "compilingStrategy", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompilingStrategy;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "doCompile", "getReturnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "defaultReturnType", "Lorg/jetbrains/kotlin/types/SimpleType;", "createDescriptorsForCodeFragment", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "declaration", "className", "Lorg/jetbrains/kotlin/name/Name;", "methodName", "parameterInfo", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/K1CodeFragmentParameterInfo;", "returnType", "packageFragmentDescriptor", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "GeneratedClassFilterForCodeFragment", "kotlin.jvm-debugger.evaluation.k1"})
@SourceDebugExtension(value={"SMAP\nCodeFragmentCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeFragmentCompiler.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompiler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,307:1\n1807#2,3:308\n1596#2:311\n1629#2,4:312\n1586#2:317\n1661#2,3:318\n1#3:316\n*S KotlinDebug\n*F\n+ 1 CodeFragmentCompiler.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompiler\n*L\n93#1:308,3\n178#1:311\n178#1:312,4\n163#1:317\n163#1:318,3\n*E\n"})
public final class CodeFragmentCompiler {
    @NotNull
    private final ExecutionContext executionContext;

    public CodeFragmentCompiler(@NotNull ExecutionContext executionContext) {
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        this.executionContext = executionContext;
    }

    @NotNull
    public final CompilationResult compile(@NotNull KtCodeFragment codeFragment, @NotNull List<? extends KtFile> filesToCompile, @NotNull CodeFragmentCompilingStrategy compilingStrategy, @NotNull BindingContext bindingContext, @NotNull ModuleDescriptor moduleDescriptor) {
        Object result2;
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkNotNullParameter(filesToCompile, (String)"filesToCompile");
        Intrinsics.checkNotNullParameter((Object)compilingStrategy, (String)"compilingStrategy");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        Object object = result2 = compilingStrategy.getStats$kotlin_jvm_debugger_evaluation_k1().startAndMeasureCompilationUnderReadAction-IoAF18A(() -> CodeFragmentCompiler.compile$lambda$0(this, codeFragment, filesToCompile, bindingContext, moduleDescriptor));
        ResultKt.throwOnFailure((Object)object);
        return (CompilationResult)object;
    }

    private final CompilationResult doCompile(KtCodeFragment codeFragment, List<? extends KtFile> filesToCompile, BindingContext bindingContext, ModuleDescriptor moduleDescriptor) {
        CompilerConfiguration compilerConfiguration;
        if (!(codeFragment instanceof KtBlockCodeFragment || codeFragment instanceof KtExpressionCodeFragment)) {
            boolean $i$a$-require-CodeFragmentCompiler$doCompile$22 = false;
            String $i$a$-require-CodeFragmentCompiler$doCompile$22 = "Unsupported code fragment type: " + codeFragment;
            throw new IllegalArgumentException($i$a$-require-CodeFragmentCompiler$doCompile$22.toString());
        }
        Project project = codeFragment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        ResolutionFacade resolutionFacade = CodeFragmentCompilerKt.getResolutionFacadeForCodeFragment(codeFragment);
        ResolveSession resolveSession = resolutionFacade.getFrontendService(ResolveSession.class);
        EvaluatorModuleDescriptor moduleDescriptorWrapper = new EvaluatorModuleDescriptor(codeFragment, moduleDescriptor, filesToCompile, resolveSession);
        SimpleType simpleType = moduleDescriptor.getBuiltIns().getUnitType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getUnitType(...)");
        SimpleType defaultReturnType = simpleType;
        KotlinType returnType = this.getReturnType(codeFragment, bindingContext, defaultReturnType);
        IRFragmentCompilerCodegen fragmentCompilerBackend = new IRFragmentCompilerCodegen();
        CompilerConfiguration $this$doCompile_u24lambda_u241 = compilerConfiguration = new CompilerConfiguration();
        boolean bl = false;
        CommonConfigurationKeysKt.setLanguageVersionSettings((CompilerConfiguration)$this$doCompile_u24lambda_u241, (LanguageVersionSettings)LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)codeFragment));
        JVMConfigurationKeysKt.setDoNotClearBindingContext((CompilerConfiguration)$this$doCompile_u24lambda_u241, (boolean)true);
        CompilerConfiguration compilerConfiguration2 = compilerConfiguration;
        K1CodeFragmentParameterInfo parameterInfo = fragmentCompilerBackend.computeFragmentParameters(this.executionContext, codeFragment, bindingContext);
        Name name2 = Name.identifier((String)"Generated_for_debugger_class");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        Name name3 = Name.identifier((String)"generated_for_debugger_fun");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        Pair<ClassDescriptor, FunctionDescriptor> pair = this.createDescriptorsForCodeFragment(codeFragment, name2, name3, parameterInfo, returnType, (PackageFragmentDescriptor)moduleDescriptorWrapper.getPackageFragmentForEvaluator());
        ClassDescriptor classDescriptor = (ClassDescriptor)pair.component1();
        FunctionDescriptor methodDescriptor = (FunctionDescriptor)pair.component2();
        JvmIrCodegenFactory codegenFactory2 = fragmentCompilerBackend.codegenFactory(bindingContext, compilerConfiguration2, classDescriptor, methodDescriptor, parameterInfo);
        GenerationState generationState = new GenerationState(project2, (ModuleDescriptor)moduleDescriptorWrapper, compilerConfiguration2, null, (GenerationState.GenerateClassFilter)new GeneratedClassFilterForCodeFragment(codeFragment), null, null, null, false, null, null, 2024, null);
        try {
            boolean bl2;
            block8: {
                Iterable $this$any$iv = filesToCompile;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KtFile it = (KtFile)element$iv;
                        boolean bl3 = false;
                        if (!it.isScript()) continue;
                        bl2 = true;
                        break block8;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                IrGenerationExtension.Companion.registerExtension(project2, (Object)new ScriptLoweringExtension());
            }
            codegenFactory2.convertAndGenerate((Collection)filesToCompile, generationState, bindingContext);
            return fragmentCompilerBackend.extractResult(parameterInfo, generationState);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodeFragmentCodegenException(e);
        }
    }

    private final KotlinType getReturnType(KtCodeFragment codeFragment, BindingContext bindingContext, SimpleType defaultReturnType) {
        KotlinType kotlinType;
        KtCodeFragment ktCodeFragment = codeFragment;
        if (ktCodeFragment instanceof KtExpressionCodeFragment) {
            KotlinTypeInfo typeInfo = (KotlinTypeInfo)bindingContext.get((ReadOnlySlice)BindingContext.EXPRESSION_TYPE_INFO, (Object)((KtExpressionCodeFragment)codeFragment).getContentElement());
            kotlinType = typeInfo;
            if (kotlinType == null || (kotlinType = kotlinType.getType()) == null) {
                kotlinType = (KotlinType)defaultReturnType;
            }
        } else if (ktCodeFragment instanceof KtBlockCodeFragment) {
            KtBlockExpression blockExpression = ((KtBlockCodeFragment)codeFragment).getContentElement();
            List list2 = blockExpression.getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
            KtExpression ktExpression = (KtExpression)CollectionsKt.lastOrNull((List)list2);
            if (ktExpression == null) {
                return (KotlinType)defaultReturnType;
            }
            KtExpression lastStatement = ktExpression;
            KotlinTypeInfo typeInfo = (KotlinTypeInfo)bindingContext.get((ReadOnlySlice)BindingContext.EXPRESSION_TYPE_INFO, (Object)lastStatement);
            kotlinType = typeInfo;
            if (kotlinType == null || (kotlinType = kotlinType.getType()) == null) {
                kotlinType = (KotlinType)defaultReturnType;
            }
        } else {
            kotlinType = (KotlinType)defaultReturnType;
        }
        return kotlinType;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<ClassDescriptor, FunctionDescriptor> createDescriptorsForCodeFragment(KtCodeFragment declaration, Name className, Name methodName, K1CodeFragmentParameterInfo parameterInfo, KotlinType returnType, PackageFragmentDescriptor packageFragmentDescriptor) {
        void $this$mapIndexedTo$iv$iv;
        ClassDescriptorImpl classDescriptor = new ClassDescriptorImpl((DeclarationDescriptor)packageFragmentDescriptor, className, Modality.FINAL, ClassKind.OBJECT, (Collection)CollectionsKt.emptyList(), (SourceElement)new KotlinSourceElement((KtElement)declaration), false, LockBasedStorageManager.NO_LOCKS);
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = SimpleFunctionDescriptorImpl.create((DeclarationDescriptor)((DeclarationDescriptor)classDescriptor), (Annotations)Annotations.Companion.getEMPTY(), (Name)methodName, (CallableMemberDescriptor.Kind)CallableMemberDescriptor.Kind.SYNTHESIZED, (SourceElement)classDescriptor.getSource());
        Intrinsics.checkNotNullExpressionValue((Object)simpleFunctionDescriptorImpl, (String)"create(...)");
        SimpleFunctionDescriptorImpl methodDescriptor = simpleFunctionDescriptorImpl;
        TypeParameterUpperBoundEraser typeParameterUpperBoundEraser = new TypeParameterUpperBoundEraser(new ErasureProjectionComputer(), null, 2, null);
        ErasureTypeAttributes erasureTypeAttributes = new ErasureTypeAttributes(TypeUsage.COMMON, null, null, 6, null);
        Iterable $this$mapIndexed$iv = parameterInfo.getSmartParameters();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void parameter;
            void index2;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            SmartCodeFragmentParameter smartCodeFragmentParameter = (SmartCodeFragmentParameter)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CallableDescriptor callableDescriptor = (CallableDescriptor)methodDescriptor;
            Annotations annotations2 = Annotations.Companion.getEMPTY();
            Name name2 = Name.identifier((String)("p" + (int)index2));
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            KotlinType kotlinType = CodeFragmentCompiler.createDescriptorsForCodeFragment$erase(typeParameterUpperBoundEraser, erasureTypeAttributes, parameter.getTargetType());
            SourceElement sourceElement = SourceElement.NO_SOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"NO_SOURCE");
            collection.add(new ValueParameterDescriptorImpl(callableDescriptor, null, (int)index2, annotations2, name2, kotlinType, false, false, false, null, sourceElement));
        }
        List parameters2 = (List)destination$iv$iv;
        methodDescriptor.initialize(null, classDescriptor.getThisAsReceiverParameter(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), parameters2, CodeFragmentCompiler.createDescriptorsForCodeFragment$erase(typeParameterUpperBoundEraser, erasureTypeAttributes, returnType), Modality.FINAL, DescriptorVisibilities.PUBLIC);
        EvaluatorMemberScopeForMethod memberScope2 = new EvaluatorMemberScopeForMethod((SimpleFunctionDescriptor)methodDescriptor);
        ClassConstructorDescriptorImpl classConstructorDescriptorImpl = ClassConstructorDescriptorImpl.create((ClassDescriptor)((ClassDescriptor)classDescriptor), (Annotations)Annotations.Companion.getEMPTY(), (boolean)true, (SourceElement)classDescriptor.getSource());
        Intrinsics.checkNotNullExpressionValue((Object)classConstructorDescriptorImpl, (String)"create(...)");
        ClassConstructorDescriptorImpl constructor = classConstructorDescriptorImpl;
        classDescriptor.initialize((MemberScope)memberScope2, SetsKt.setOf((Object)constructor), (ClassConstructorDescriptor)constructor);
        return new Pair((Object)classDescriptor, (Object)methodDescriptor);
    }

    private static final CompilationResult compile$lambda$0(CodeFragmentCompiler this$0, KtCodeFragment $codeFragment, List $filesToCompile, BindingContext $bindingContext, ModuleDescriptor $moduleDescriptor) {
        return this$0.doCompile($codeFragment, $filesToCompile, $bindingContext, $moduleDescriptor);
    }

    private static final KotlinType createDescriptorsForCodeFragment$upperBoundIfTypeParameter(TypeParameterUpperBoundEraser typeParameterUpperBoundEraser, ErasureTypeAttributes erasureTypeAttributes, KotlinType type2) {
        KotlinType kotlinType;
        TypeParameterDescriptor typeParameterDescriptor = TypeUtils.getTypeParameterDescriptorOrNull((KotlinType)type2);
        if (typeParameterDescriptor != null) {
            TypeParameterDescriptor it = typeParameterDescriptor;
            boolean bl = false;
            kotlinType = typeParameterUpperBoundEraser.getErasedUpperBound(it, erasureTypeAttributes);
        } else {
            kotlinType = null;
        }
        return kotlinType;
    }

    /*
     * WARNING - void declaration
     */
    private static final KotlinType createDescriptorsForCodeFragment$eraseTypeArguments(TypeParameterUpperBoundEraser typeParameterUpperBoundEraser, ErasureTypeAttributes erasureTypeAttributes, KotlinType type2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = type2.getArguments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TypeProjection typeProjection;
            KotlinType erasedType;
            void it;
            TypeProjection typeProjection2 = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            KotlinType kotlinType = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            KotlinType kotlinType2 = CodeFragmentCompiler.createDescriptorsForCodeFragment$upperBoundIfTypeParameter(typeParameterUpperBoundEraser, erasureTypeAttributes, kotlinType);
            if (kotlinType2 == null) {
                KotlinType kotlinType3 = it.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType3, (String)"getType(...)");
                kotlinType2 = erasedType = CodeFragmentCompiler.createDescriptorsForCodeFragment$eraseTypeArguments(typeParameterUpperBoundEraser, erasureTypeAttributes, kotlinType3);
            }
            if (it.isStarProjection()) {
                typeProjection = it;
            } else {
                TypeProjection typeProjection3 = it.replaceType(erasedType);
                typeProjection = typeProjection3;
                Intrinsics.checkNotNullExpressionValue((Object)typeProjection3, (String)"replaceType(...)");
            }
            collection.add(typeProjection);
        }
        List erasedArguments = (List)destination$iv$iv;
        return (KotlinType)KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope((TypeAttributes)type2.getAttributes(), (TypeConstructor)type2.getConstructor(), (List)erasedArguments, (boolean)type2.isMarkedNullable(), (MemberScope)type2.getMemberScope());
    }

    private static final KotlinType createDescriptorsForCodeFragment$erase(TypeParameterUpperBoundEraser typeParameterUpperBoundEraser, ErasureTypeAttributes erasureTypeAttributes, KotlinType type2) {
        KotlinType kotlinType = CodeFragmentCompiler.createDescriptorsForCodeFragment$upperBoundIfTypeParameter(typeParameterUpperBoundEraser, erasureTypeAttributes, type2);
        if (kotlinType == null) {
            kotlinType = CodeFragmentCompiler.createDescriptorsForCodeFragment$eraseTypeArguments(typeParameterUpperBoundEraser, erasureTypeAttributes, type2);
        }
        return kotlinType;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompiler$GeneratedClassFilterForCodeFragment;", "Lorg/jetbrains/kotlin/codegen/state/GenerationState$GenerateClassFilter;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtCodeFragment;)V", "shouldGeneratePackagePart", "", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "shouldGenerateClass", "processingClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "kotlin.jvm-debugger.evaluation.k1"})
    private static final class GeneratedClassFilterForCodeFragment
    extends GenerationState.GenerateClassFilter {
        @NotNull
        private final KtCodeFragment codeFragment;

        public GeneratedClassFilterForCodeFragment(@NotNull KtCodeFragment codeFragment) {
            Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
            this.codeFragment = codeFragment;
        }

        public boolean shouldGeneratePackagePart(@NotNull KtFile ktFile2) {
            Intrinsics.checkNotNullParameter((Object)ktFile2, (String)"ktFile");
            return Intrinsics.areEqual((Object)ktFile2, (Object)this.codeFragment);
        }

        public boolean shouldGenerateClass(@NotNull KtClassOrObject processingClassOrObject) {
            Intrinsics.checkNotNullParameter((Object)processingClassOrObject, (String)"processingClassOrObject");
            return Intrinsics.areEqual((Object)processingClassOrObject.getContainingFile(), (Object)this.codeFragment);
        }
    }
}

