/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilation;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.evaluate.CompilerType;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameter;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameterInfo;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompiledCodeFragmentData;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J\u0015\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\fH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u000eH\u00c6\u0003JM\u0010 \u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0014\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010$\u001a\u00020%H\u00d6\u0081\u0004J\n\u0010&\u001a\u00020\nH\u00d6\u0081\u0004R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompilationResult;", "", "classes", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "parameterInfo", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameterInfo;", "localFunctionSuffixes", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameter$Dumb;", "", "mainMethodSignature", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledCodeFragmentData$MethodSignature;", "compilerType", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/CompilerType;", "<init>", "(Ljava/util/List;Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameterInfo;Ljava/util/Map;Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledCodeFragmentData$MethodSignature;Lorg/jetbrains/kotlin/idea/debugger/evaluate/CompilerType;)V", "getClasses", "()Ljava/util/List;", "getParameterInfo", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentParameterInfo;", "getLocalFunctionSuffixes", "()Ljava/util/Map;", "getMainMethodSignature", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledCodeFragmentData$MethodSignature;", "getCompilerType", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/CompilerType;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin.jvm-debugger.evaluation"})
public final class CompilationResult {
    @NotNull
    private final List<ClassToLoad> classes;
    @NotNull
    private final CodeFragmentParameterInfo parameterInfo;
    @NotNull
    private final Map<CodeFragmentParameter.Dumb, String> localFunctionSuffixes;
    @NotNull
    private final CompiledCodeFragmentData.MethodSignature mainMethodSignature;
    @NotNull
    private final CompilerType compilerType;

    public CompilationResult(@NotNull List<ClassToLoad> classes, @NotNull CodeFragmentParameterInfo parameterInfo, @NotNull Map<CodeFragmentParameter.Dumb, String> localFunctionSuffixes, @NotNull CompiledCodeFragmentData.MethodSignature mainMethodSignature, @NotNull CompilerType compilerType) {
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        Intrinsics.checkNotNullParameter((Object)parameterInfo, (String)"parameterInfo");
        Intrinsics.checkNotNullParameter(localFunctionSuffixes, (String)"localFunctionSuffixes");
        Intrinsics.checkNotNullParameter((Object)mainMethodSignature, (String)"mainMethodSignature");
        Intrinsics.checkNotNullParameter((Object)((Object)compilerType), (String)"compilerType");
        this.classes = classes;
        this.parameterInfo = parameterInfo;
        this.localFunctionSuffixes = localFunctionSuffixes;
        this.mainMethodSignature = mainMethodSignature;
        this.compilerType = compilerType;
    }

    @NotNull
    public final List<ClassToLoad> getClasses() {
        return this.classes;
    }

    @NotNull
    public final CodeFragmentParameterInfo getParameterInfo() {
        return this.parameterInfo;
    }

    @NotNull
    public final Map<CodeFragmentParameter.Dumb, String> getLocalFunctionSuffixes() {
        return this.localFunctionSuffixes;
    }

    @NotNull
    public final CompiledCodeFragmentData.MethodSignature getMainMethodSignature() {
        return this.mainMethodSignature;
    }

    @NotNull
    public final CompilerType getCompilerType() {
        return this.compilerType;
    }

    @NotNull
    public final List<ClassToLoad> component1() {
        return this.classes;
    }

    @NotNull
    public final CodeFragmentParameterInfo component2() {
        return this.parameterInfo;
    }

    @NotNull
    public final Map<CodeFragmentParameter.Dumb, String> component3() {
        return this.localFunctionSuffixes;
    }

    @NotNull
    public final CompiledCodeFragmentData.MethodSignature component4() {
        return this.mainMethodSignature;
    }

    @NotNull
    public final CompilerType component5() {
        return this.compilerType;
    }

    @NotNull
    public final CompilationResult copy(@NotNull List<ClassToLoad> classes, @NotNull CodeFragmentParameterInfo parameterInfo, @NotNull Map<CodeFragmentParameter.Dumb, String> localFunctionSuffixes, @NotNull CompiledCodeFragmentData.MethodSignature mainMethodSignature, @NotNull CompilerType compilerType) {
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        Intrinsics.checkNotNullParameter((Object)parameterInfo, (String)"parameterInfo");
        Intrinsics.checkNotNullParameter(localFunctionSuffixes, (String)"localFunctionSuffixes");
        Intrinsics.checkNotNullParameter((Object)mainMethodSignature, (String)"mainMethodSignature");
        Intrinsics.checkNotNullParameter((Object)((Object)compilerType), (String)"compilerType");
        return new CompilationResult(classes, parameterInfo, localFunctionSuffixes, mainMethodSignature, compilerType);
    }

    public static /* synthetic */ CompilationResult copy$default(CompilationResult compilationResult, List list2, CodeFragmentParameterInfo codeFragmentParameterInfo, Map map2, CompiledCodeFragmentData.MethodSignature methodSignature, CompilerType compilerType, int n, Object object) {
        if ((n & 1) != 0) {
            list2 = compilationResult.classes;
        }
        if ((n & 2) != 0) {
            codeFragmentParameterInfo = compilationResult.parameterInfo;
        }
        if ((n & 4) != 0) {
            map2 = compilationResult.localFunctionSuffixes;
        }
        if ((n & 8) != 0) {
            methodSignature = compilationResult.mainMethodSignature;
        }
        if ((n & 0x10) != 0) {
            compilerType = compilationResult.compilerType;
        }
        return compilationResult.copy(list2, codeFragmentParameterInfo, map2, methodSignature, compilerType);
    }

    @NotNull
    public String toString() {
        return "CompilationResult(classes=" + this.classes + ", parameterInfo=" + this.parameterInfo + ", localFunctionSuffixes=" + this.localFunctionSuffixes + ", mainMethodSignature=" + this.mainMethodSignature + ", compilerType=" + this.compilerType + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.classes).hashCode();
        result2 = result2 * 31 + this.parameterInfo.hashCode();
        result2 = result2 * 31 + ((Object)this.localFunctionSuffixes).hashCode();
        result2 = result2 * 31 + this.mainMethodSignature.hashCode();
        result2 = result2 * 31 + this.compilerType.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CompilationResult)) {
            return false;
        }
        CompilationResult compilationResult = (CompilationResult)other;
        if (!Intrinsics.areEqual(this.classes, compilationResult.classes)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.parameterInfo, (Object)compilationResult.parameterInfo)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.localFunctionSuffixes, compilationResult.localFunctionSuffixes)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.mainMethodSignature, (Object)compilationResult.mainMethodSignature)) {
            return false;
        }
        return this.compilerType == compilationResult.compilerType;
    }
}

