/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilation;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaExperimentalApi;
import org.jetbrains.kotlin.analysis.api.components.KaCompiledFile;
import org.jetbrains.kotlin.idea.debugger.base.util.JvmNameUtilsKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoadKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompiledCodeFragmentData;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0007\"\u001e\u0010\u0004\u001a\u00020\u0005*\u00020\u00068@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"getMethodSignature", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledCodeFragmentData$MethodSignature;", "fragmentClass", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "internalClassName", "", "Lorg/jetbrains/kotlin/analysis/api/components/KaCompiledFile;", "getInternalClassName$annotations", "(Lorg/jetbrains/kotlin/analysis/api/components/KaCompiledFile;)V", "getInternalClassName", "(Lorg/jetbrains/kotlin/analysis/api/components/KaCompiledFile;)Ljava/lang/String;", "computeInternalClassName", "path", "kotlin.jvm-debugger.evaluation"})
public final class CompilerUtilsKt {
    @NotNull
    public static final CompiledCodeFragmentData.MethodSignature getMethodSignature(@NotNull ClassToLoad fragmentClass) {
        Intrinsics.checkNotNullParameter((Object)fragmentClass, (String)"fragmentClass");
        List parameters2 = new ArrayList();
        Ref.ObjectRef returnType = new Ref.ObjectRef();
        new ClassReader(fragmentClass.getBytes()).accept(new ClassVisitor((Ref.ObjectRef<Type>)returnType, parameters2){
            final /* synthetic */ Ref.ObjectRef<Type> $returnType;
            final /* synthetic */ List<Type> $parameters;
            {
                this.$returnType = $returnType;
                this.$parameters = $parameters;
                super(458752);
            }

            /*
             * WARNING - void declaration
             */
            public MethodVisitor visitMethod(int access, String name2, String descriptor2, String signature, String[] exceptions) {
                if (name2 != null && ClassToLoadKt.isEvaluationEntryPoint(name2)) {
                    void $this$forEach$iv;
                    Type[] typeArray = Type.getArgumentTypes((String)descriptor2);
                    Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"getArgumentTypes(...)");
                    Object[] objectArray = typeArray;
                    List<Type> list2 = this.$parameters;
                    boolean $i$f$forEach = false;
                    for (void element$iv : $this$forEach$iv) {
                        Type it = (Type)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        list2.add(it);
                    }
                    this.$returnType.element = Type.getReturnType((String)descriptor2);
                }
                return null;
            }
        }, 1);
        Object object = returnType.element;
        Intrinsics.checkNotNull((Object)object);
        return new CompiledCodeFragmentData.MethodSignature(parameters2, (Type)object);
    }

    @NotNull
    public static final String getInternalClassName(@NotNull KaCompiledFile $this$internalClassName) {
        Intrinsics.checkNotNullParameter((Object)$this$internalClassName, (String)"<this>");
        return CompilerUtilsKt.computeInternalClassName($this$internalClassName.getPath());
    }

    @KaExperimentalApi
    public static /* synthetic */ void getInternalClassName$annotations(KaCompiledFile kaCompiledFile) {
    }

    @ApiStatus.Internal
    @NotNull
    public static final String computeInternalClassName(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        if (!StringsKt.endsWith((String)path2, (String)".class", (boolean)true)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return JvmNameUtilsKt.internalNameToFqn(StringsKt.dropLast((String)path2, (int)6));
    }
}

