/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilation;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.AdditionalContextElement;
import com.intellij.debugger.engine.evaluation.AdditionalContextProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.SimpleMemberScope;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.PackageFragmentDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.idea.core.util.CodeFragmentUtilsKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.EvaluatorResolutionUtilsKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.DebugForeignPropertyModuleDescriptor;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.ForeignPropertyDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/DebugForeignPropertyDescriptorProvider;", "", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtCodeFragment;Lcom/intellij/debugger/engine/DebugProcessImpl;)V", "getCodeFragment", "()Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "getDebugProcess", "()Lcom/intellij/debugger/engine/DebugProcessImpl;", "moduleDescriptor", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/DebugForeignPropertyModuleDescriptor;", "supplyDebugForeignProperties", "", "createForeignPropertyDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "containingDeclaration", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "createForeignPropertyDescriptor", "name", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "convertType", "signature", "asmType", "Lorg/jetbrains/org/objectweb/asm/Type;", "convertReferenceType", "kotlin.jvm-debugger.evaluation.k1"})
@SourceDebugExtension(value={"SMAP\nDebugForeignPropertyDescriptorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugForeignPropertyDescriptorProvider.kt\norg/jetbrains/kotlin/idea/debugger/evaluate/compilation/DebugForeignPropertyDescriptorProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n1#2:199\n*E\n"})
public final class DebugForeignPropertyDescriptorProvider {
    @NotNull
    private final KtCodeFragment codeFragment;
    @NotNull
    private final DebugProcessImpl debugProcess;
    @NotNull
    private final DebugForeignPropertyModuleDescriptor moduleDescriptor;

    public DebugForeignPropertyDescriptorProvider(@NotNull KtCodeFragment codeFragment, @NotNull DebugProcessImpl debugProcess) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        this.codeFragment = codeFragment;
        this.debugProcess = debugProcess;
        this.moduleDescriptor = DebugForeignPropertyModuleDescriptor.INSTANCE;
    }

    @NotNull
    public final KtCodeFragment getCodeFragment() {
        return this.codeFragment;
    }

    @NotNull
    public final DebugProcessImpl getDebugProcess() {
        return this.debugProcess;
    }

    public final void supplyDebugForeignProperties() {
        DebugForeignPropertyModuleDescriptor debugForeignPropertyModuleDescriptor = this.moduleDescriptor;
        FqName fqName2 = FqName.ROOT;
        var packageFragment2 = new PackageFragmentDescriptorImpl(this, debugForeignPropertyModuleDescriptor, fqName2){
            private final List<PropertyDescriptor> properties;
            {
                this.properties = DebugForeignPropertyDescriptorProvider.access$createForeignPropertyDescriptors($receiver, (PackageFragmentDescriptor)this);
            }

            public final List<PropertyDescriptor> getProperties() {
                return this.properties;
            }

            public SimpleMemberScope getMemberScope() {
                return new SimpleMemberScope(this.properties);
            }
        };
        CodeFragmentUtilsKt.setExternalDescriptors(this.codeFragment, packageFragment2.getProperties());
    }

    private final List<PropertyDescriptor> createForeignPropertyDescriptors(PackageFragmentDescriptor containingDeclaration) {
        List result2 = new ArrayList();
        Project project = this.codeFragment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        List additionalContextElements = AdditionalContextProvider.Companion.getAllAdditionalContextElements(project, this.codeFragment.getContext());
        for (AdditionalContextElement additionalContextElement : additionalContextElements) {
            String name2 = additionalContextElement.component1();
            String signature = additionalContextElement.component2();
            KotlinType kotlinType = this.convertType(signature);
            ((Collection)result2).add(this.createForeignPropertyDescriptor(name2, kotlinType, containingDeclaration));
        }
        return result2;
    }

    private final PropertyDescriptor createForeignPropertyDescriptor(String name2, KotlinType type2, PackageFragmentDescriptor containingDeclaration) {
        PropertyGetterDescriptorImpl propertyGetterDescriptorImpl;
        ForeignPropertyDescriptor propertyDescriptor = new ForeignPropertyDescriptor((DeclarationDescriptor)containingDeclaration, name2);
        propertyDescriptor.setType(type2, CollectionsKt.emptyList(), null, null, CollectionsKt.emptyList());
        PropertyGetterDescriptorImpl $this$createForeignPropertyDescriptor_u24lambda_u240 = propertyGetterDescriptorImpl = new PropertyGetterDescriptorImpl((PropertyDescriptor)propertyDescriptor, Annotations.Companion.getEMPTY(), Modality.FINAL, DescriptorVisibilities.PUBLIC, false, false, false, CallableMemberDescriptor.Kind.SYNTHESIZED, null, SourceElement.NO_SOURCE);
        boolean bl = false;
        $this$createForeignPropertyDescriptor_u24lambda_u240.initialize(type2);
        PropertyGetterDescriptorImpl getterDescriptor = propertyGetterDescriptorImpl;
        propertyDescriptor.initialize(getterDescriptor, null);
        return (PropertyDescriptor)propertyDescriptor;
    }

    private final KotlinType convertType(String signature) {
        Type type2 = Type.getType((String)signature);
        Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"getType(...)");
        return this.convertType(type2);
    }

    private final KotlinType convertType(Type asmType) {
        KotlinBuiltIns builtIns = this.moduleDescriptor.getBuiltIns();
        return switch (asmType.getSort()) {
            case 0 -> {
                SimpleType v0 = builtIns.getUnitType();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getUnitType(...)");
                yield (KotlinType)v0;
            }
            case 7 -> {
                SimpleType v2 = builtIns.getLongType();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getLongType(...)");
                yield (KotlinType)v2;
            }
            case 8 -> {
                SimpleType v3 = builtIns.getDoubleType();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getDoubleType(...)");
                yield (KotlinType)v3;
            }
            case 2 -> {
                SimpleType v4 = builtIns.getCharType();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getCharType(...)");
                yield (KotlinType)v4;
            }
            case 6 -> {
                SimpleType v5 = builtIns.getFloatType();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getFloatType(...)");
                yield (KotlinType)v5;
            }
            case 3 -> {
                SimpleType v6 = builtIns.getByteType();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getByteType(...)");
                yield (KotlinType)v6;
            }
            case 5 -> {
                SimpleType v7 = builtIns.getIntType();
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getIntType(...)");
                yield (KotlinType)v7;
            }
            case 1 -> {
                SimpleType v8 = builtIns.getBooleanType();
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"getBooleanType(...)");
                yield (KotlinType)v8;
            }
            case 4 -> {
                SimpleType v9 = builtIns.getShortType();
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getShortType(...)");
                yield (KotlinType)v9;
            }
            case 9 -> {
                SimpleType v10 = switch (asmType.getElementType().getSort()) {
                    case 0 -> builtIns.getArrayType(Variance.INVARIANT, (KotlinType)builtIns.getUnitType());
                    case 7 -> builtIns.getPrimitiveArrayKotlinType(PrimitiveType.LONG);
                    case 8 -> builtIns.getPrimitiveArrayKotlinType(PrimitiveType.DOUBLE);
                    case 2 -> builtIns.getPrimitiveArrayKotlinType(PrimitiveType.CHAR);
                    case 6 -> builtIns.getPrimitiveArrayKotlinType(PrimitiveType.FLOAT);
                    case 3 -> builtIns.getPrimitiveArrayKotlinType(PrimitiveType.BYTE);
                    case 5 -> builtIns.getPrimitiveArrayKotlinType(PrimitiveType.INT);
                    case 1 -> builtIns.getPrimitiveArrayKotlinType(PrimitiveType.BOOLEAN);
                    case 4 -> builtIns.getPrimitiveArrayKotlinType(PrimitiveType.SHORT);
                    default -> {
                        Type v11 = asmType.getElementType();
                        Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"getElementType(...)");
                        yield builtIns.getArrayType(Variance.INVARIANT, this.convertReferenceType(v11));
                    }
                };
                SimpleType var3_3 = v10;
                Intrinsics.checkNotNull((Object)var3_3);
                yield (KotlinType)var3_3;
            }
            case 10 -> this.convertReferenceType(asmType);
            default -> {
                SimpleType v12 = builtIns.getAnyType();
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"getAnyType(...)");
                yield (KotlinType)v12;
            }
        };
    }

    private final KotlinType convertReferenceType(Type asmType) {
        if (!(asmType.getSort() == 10)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Project project = this.codeFragment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        ClassDescriptor classDescriptor = EvaluatorResolutionUtilsKt.getClassDescriptor$default(asmType, globalSearchScope, false, null, 4, null);
        if (classDescriptor == null) {
            SimpleType simpleType = this.moduleDescriptor.getBuiltIns().getNullableAnyType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getNullableAnyType(...)");
            return (KotlinType)simpleType;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        SimpleType simpleType = classDescriptor2.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
        return (KotlinType)simpleType;
    }

    public static final /* synthetic */ List access$createForeignPropertyDescriptors(DebugForeignPropertyDescriptorProvider $this, PackageFragmentDescriptor containingDeclaration) {
        return $this.createForeignPropertyDescriptors(containingDeclaration);
    }
}

