/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilation;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScopeImpl;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J\u0013\u0010\u0013\u001a\r\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\u00150\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/EvaluatorMemberScopeForMethod;", "Lorg/jetbrains/kotlin/resolve/scopes/MemberScopeImpl;", "methodDescriptor", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "<init>", "(Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;)V", "getContributedFunctions", "", "name", "Lorg/jetbrains/kotlin/name/Name;", "location", "Lorg/jetbrains/kotlin/incremental/components/LookupLocation;", "getContributedDescriptors", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "kindFilter", "Lorg/jetbrains/kotlin/resolve/scopes/DescriptorKindFilter;", "nameFilter", "Lkotlin/Function1;", "", "getFunctionNames", "", "Lkotlin/jvm/internal/EnhancedNullability;", "printScopeStructure", "", "p", "Lorg/jetbrains/kotlin/utils/Printer;", "kotlin.jvm-debugger.evaluation.k1"})
final class EvaluatorMemberScopeForMethod
extends MemberScopeImpl {
    @NotNull
    private final SimpleFunctionDescriptor methodDescriptor;

    public EvaluatorMemberScopeForMethod(@NotNull SimpleFunctionDescriptor methodDescriptor) {
        Intrinsics.checkNotNullParameter((Object)methodDescriptor, (String)"methodDescriptor");
        this.methodDescriptor = methodDescriptor;
    }

    @NotNull
    public Collection<SimpleFunctionDescriptor> getContributedFunctions(@NotNull Name name2, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return Intrinsics.areEqual((Object)name2, (Object)this.methodDescriptor.getName()) ? (Collection)CollectionsKt.listOf((Object)this.methodDescriptor) : (Collection)CollectionsKt.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter2) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)kindFilter, (String)"kindFilter");
        Intrinsics.checkNotNullParameter(nameFilter2, (String)"nameFilter");
        if (kindFilter.accepts((DeclarationDescriptor)this.methodDescriptor)) {
            Name name2 = this.methodDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
            if (((Boolean)nameFilter2.invoke((Object)name2)).booleanValue()) {
                collection = CollectionsKt.listOf((Object)this.methodDescriptor);
                return collection;
            }
        }
        collection = CollectionsKt.emptyList();
        return collection;
    }

    @NotNull
    public Set<Name> getFunctionNames() {
        return SetsKt.setOf((Object)this.methodDescriptor.getName());
    }

    public void printScopeStructure(@NotNull Printer p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Object[] objectArray = new Object[]{((Object)((Object)this)).getClass().getSimpleName()};
        p.println(objectArray);
    }
}

