/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilation;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.ReflectionCallMethodVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/ReflectionCallClassPatcher;", "", "<init>", "()V", "newValue", "", "isEnabled", "()Z", "setEnabled", "(Z)V", "patch", "", "bytes", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "kotlin.jvm-debugger.evaluation"})
public final class ReflectionCallClassPatcher {
    @NotNull
    public static final ReflectionCallClassPatcher INSTANCE = new ReflectionCallClassPatcher();

    private ReflectionCallClassPatcher() {
    }

    public final boolean isEnabled() {
        return Registry.Companion.is("kotlin.debugger.evaluator.enable.reflection.patching");
    }

    public final void setEnabled(boolean newValue) {
        Registry.Companion.get("kotlin.debugger.evaluator.enable.reflection.patching").setValue(newValue);
    }

    @RequiresReadLock
    @NotNull
    public final byte[] patch(@NotNull byte[] bytes, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        ClassReader reader = new ClassReader(bytes);
        ClassWriter writer = new ClassWriter(reader, 1);
        reader.accept(new ClassVisitor(writer, project, scope){
            final /* synthetic */ Project $project;
            final /* synthetic */ GlobalSearchScope $scope;
            {
                this.$project = $project;
                this.$scope = $scope;
                super(589824, (ClassVisitor)$writer);
            }

            public MethodVisitor visitMethod(int access, String name2, String descriptor2, String signature, String[] exceptions) {
                ProgressManager.checkCanceled();
                MethodVisitor delegate = super.visitMethod(access, name2, descriptor2, signature, exceptions);
                Intrinsics.checkNotNull((Object)delegate);
                return new ReflectionCallMethodVisitor(this.$project, this.$scope, delegate);
            }
        }, 0);
        byte[] byArray = writer.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }
}

