/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.sequence.psi.collections;

import com.intellij.debugger.streams.core.psi.ChainTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.UtilsKt;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.KotlinPsiUtil;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.KotlinPsiUtilKt;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.collections.CollectionChainTransformer;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.impl.KotlinChainBuilderBase;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\b\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/collections/KotlinCollectionChainBuilder;", "Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/KotlinChainBuilderBase;", "<init>", "()V", "isCollectionTransformationCall", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "existenceChecker", "Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/KotlinChainBuilderBase$ExistenceChecker;", "getExistenceChecker", "()Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/KotlinChainBuilderBase$ExistenceChecker;", "createChainsBuilder", "Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/KotlinChainBuilderBase$ChainBuilder;", "isTypeSuitable", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "Companion", "kotlin.jvm-debugger.sequence.k1"})
@SourceDebugExtension(value={"SMAP\nKotlinCollectionChainBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCollectionChainBuilder.kt\norg/jetbrains/kotlin/idea/debugger/sequence/psi/collections/KotlinCollectionChainBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1807#2,3:77\n*S KotlinDebug\n*F\n+ 1 KotlinCollectionChainBuilder.kt\norg/jetbrains/kotlin/idea/debugger/sequence/psi/collections/KotlinCollectionChainBuilder\n*L\n27#1:77,3\n*E\n"})
public final class KotlinCollectionChainBuilder
extends KotlinChainBuilderBase {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinChainBuilderBase.ExistenceChecker existenceChecker = new KotlinChainBuilderBase.ExistenceChecker(this){
        final /* synthetic */ KotlinCollectionChainBuilder this$0;
        {
            this.this$0 = $receiver;
        }

        public void visitCallExpression(KtCallExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (this.isFound()) {
                return;
            }
            if (KotlinCollectionChainBuilder.access$isCollectionTransformationCall(this.this$0, expression)) {
                this.fireElementFound();
            } else {
                super.visitCallExpression(expression);
            }
        }
    };
    @NotNull
    private static final Set<String> SUPPORTED_RECEIVERS;

    public KotlinCollectionChainBuilder() {
        super((ChainTransformer<KtCallExpression>)((ChainTransformer)new CollectionChainTransformer()));
    }

    private final boolean isCollectionTransformationCall(KtCallExpression expression) {
        boolean bl;
        block5: {
            KotlinType kotlinType = UtilsKt.receiverType(expression);
            if (kotlinType == null) {
                return false;
            }
            KotlinType receiverType = kotlinType;
            if (this.isTypeSuitable(receiverType)) {
                return true;
            }
            Iterable $this$any$iv = TypeUtilsKt.supertypes((KotlinType)receiverType);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    if (!this.isTypeSuitable(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    protected KotlinChainBuilderBase.ExistenceChecker getExistenceChecker() {
        return this.existenceChecker;
    }

    @Override
    @NotNull
    protected KotlinChainBuilderBase.ChainBuilder createChainsBuilder() {
        return new KotlinChainBuilderBase.ChainBuilder(this){
            private final Map<KtCallExpression, KtCallExpression> previousCalls;
            private final Set<KtCallExpression> visitedCalls;
            final /* synthetic */ KotlinCollectionChainBuilder this$0;
            {
                this.this$0 = $receiver;
                this.previousCalls = new LinkedHashMap<K, V>();
                this.visitedCalls = new LinkedHashSet<E>();
            }

            public void visitCallExpression(KtCallExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                super.visitCallExpression(expression);
                if (KotlinCollectionChainBuilder.access$isCollectionTransformationCall(this.this$0, expression)) {
                    this.visitedCalls.add(expression);
                    KtCallExpression previous = KotlinPsiUtilKt.previousCall(expression);
                    if (previous != null && KotlinCollectionChainBuilder.access$isCollectionTransformationCall(this.this$0, previous)) {
                        this.previousCalls.put(expression, previous);
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            public List<List<KtCallExpression>> chains() {
                void $this$mapTo$iv$iv;
                KtCallExpression it;
                Iterable $this$filterTo$iv$iv;
                Set notLastCalls = CollectionsKt.toSet((Iterable)this.previousCalls.values());
                Iterable $this$filter$iv = this.visitedCalls;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (KtCallExpression)element$iv$iv;
                    boolean bl = false;
                    if (!(!notLastCalls.contains(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (KtCallExpression)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(this.buildPsiChain(it));
                }
                return (List)destination$iv$iv;
            }

            private final List<KtCallExpression> buildPsiChain(KtCallExpression expression) {
                List result2 = new ArrayList<E>();
                KtCallExpression current = expression;
                while (current != null) {
                    result2.add(current);
                    current = this.previousCalls.get(current);
                }
                CollectionsKt.reverse((List)result2);
                return result2;
            }
        };
    }

    private final boolean isTypeSuitable(KotlinType type2) {
        return SUPPORTED_RECEIVERS.contains(KotlinPsiUtil.INSTANCE.getTypeWithoutTypeParameters(type2));
    }

    public static final /* synthetic */ boolean access$isCollectionTransformationCall(KotlinCollectionChainBuilder $this, KtCallExpression expression) {
        return $this.isCollectionTransformationCall(expression);
    }

    static {
        Object[] objectArray = new String[]{"kotlin.collections.Iterable", "kotlin.CharSequence", "kotlin.Array", "kotlin.BooleanArray", "kotlin.ByteArray", "kotlin.ShortArray", "kotlin.CharArray", "kotlin.IntArray", "kotlin.LongArray", "kotlin.DoubleArray", "kotlin.FloatArray"};
        SUPPORTED_RECEIVERS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/collections/KotlinCollectionChainBuilder$Companion;", "", "<init>", "()V", "SUPPORTED_RECEIVERS", "", "", "getSUPPORTED_RECEIVERS", "()Ljava/util/Set;", "kotlin.jvm-debugger.sequence.k1"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getSUPPORTED_RECEIVERS() {
            return SUPPORTED_RECEIVERS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

