/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.sequence.psi.impl;

import com.intellij.debugger.streams.core.psi.ChainTransformer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.KotlinPsiUtilKt;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.StreamCallChecker;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.impl.KotlinChainBuilderBase;
import org.jetbrains.kotlin.psi.KtCallExpression;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0002\u000f\u0010B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/TerminatedChainBuilder;", "Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/KotlinChainBuilderBase;", "transformer", "Lcom/intellij/debugger/streams/core/psi/ChainTransformer;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "callChecker", "Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/StreamCallChecker;", "<init>", "(Lcom/intellij/debugger/streams/core/psi/ChainTransformer;Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/StreamCallChecker;)V", "existenceChecker", "Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/KotlinChainBuilderBase$ExistenceChecker;", "getExistenceChecker", "()Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/KotlinChainBuilderBase$ExistenceChecker;", "createChainsBuilder", "Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/KotlinChainBuilderBase$ChainBuilder;", "MyExistenceChecker", "MyBuilderVisitor", "kotlin.jvm-debugger.sequence.k1"})
public class TerminatedChainBuilder
extends KotlinChainBuilderBase {
    @NotNull
    private final StreamCallChecker callChecker;
    @NotNull
    private final KotlinChainBuilderBase.ExistenceChecker existenceChecker;

    public TerminatedChainBuilder(@NotNull ChainTransformer<KtCallExpression> transformer2, @NotNull StreamCallChecker callChecker) {
        Intrinsics.checkNotNullParameter(transformer2, (String)"transformer");
        Intrinsics.checkNotNullParameter((Object)callChecker, (String)"callChecker");
        super(transformer2);
        this.callChecker = callChecker;
        this.existenceChecker = new MyExistenceChecker();
    }

    @Override
    @NotNull
    protected KotlinChainBuilderBase.ExistenceChecker getExistenceChecker() {
        return this.existenceChecker;
    }

    @Override
    @NotNull
    protected KotlinChainBuilderBase.ChainBuilder createChainsBuilder() {
        return new MyBuilderVisitor();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0014\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000e0\u000eH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/TerminatedChainBuilder$MyBuilderVisitor;", "Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/KotlinChainBuilderBase$ChainBuilder;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/TerminatedChainBuilder;)V", "myTerminationCalls", "", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "myPreviousCalls", "", "visitCallExpression", "", "expression", "updateCallTree", "chains", "", "kotlin.jvm-debugger.sequence.k1"})
    private final class MyBuilderVisitor
    extends KotlinChainBuilderBase.ChainBuilder {
        @NotNull
        private final Set<KtCallExpression> myTerminationCalls = new LinkedHashSet();
        @NotNull
        private final Map<KtCallExpression, KtCallExpression> myPreviousCalls = new LinkedHashMap();

        public void visitCallExpression(@NotNull KtCallExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            super.visitCallExpression(expression);
            if (!this.myPreviousCalls.containsKey(expression) && TerminatedChainBuilder.this.callChecker.isStreamCall(expression)) {
                this.updateCallTree(expression);
            }
        }

        private final void updateCallTree(KtCallExpression expression) {
            KtCallExpression parentCall;
            if (TerminatedChainBuilder.this.callChecker.isTerminationCall(expression)) {
                this.myTerminationCalls.add(expression);
            }
            if ((parentCall = KotlinPsiUtilKt.previousCall(expression)) != null && TerminatedChainBuilder.this.callChecker.isStreamCall(parentCall)) {
                this.myPreviousCalls.put(expression, parentCall);
                this.updateCallTree(parentCall);
            }
        }

        @Override
        @NotNull
        public List<List<KtCallExpression>> chains() {
            ArrayList chains = new ArrayList();
            for (KtCallExpression terminationCall : this.myTerminationCalls) {
                ArrayList<KtCallExpression> chain = new ArrayList<KtCallExpression>();
                KtCallExpression current = terminationCall;
                while (current != null && TerminatedChainBuilder.this.callChecker.isStreamCall(current)) {
                    chain.add(current);
                    current = this.myPreviousCalls.get(current);
                }
                CollectionsKt.reverse((List)chain);
                chains.add(chain);
            }
            return chains;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/TerminatedChainBuilder$MyExistenceChecker;", "Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/KotlinChainBuilderBase$ExistenceChecker;", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/TerminatedChainBuilder;)V", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "kotlin.jvm-debugger.sequence.k1"})
    private final class MyExistenceChecker
    extends KotlinChainBuilderBase.ExistenceChecker {
        public void visitCallExpression(@NotNull KtCallExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (TerminatedChainBuilder.this.callChecker.isTerminationCall(expression)) {
                this.fireElementFound();
            } else {
                super.visitCallExpression(expression);
            }
        }
    }
}

