/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.sequence.trace.dsl;

import com.intellij.debugger.streams.core.trace.dsl.CodeBlock;
import com.intellij.debugger.streams.core.trace.dsl.Convertable;
import com.intellij.debugger.streams.core.trace.dsl.Expression;
import com.intellij.debugger.streams.core.trace.dsl.Lambda;
import com.intellij.debugger.streams.core.trace.dsl.impl.TextExpression;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J)\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0010\"\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/trace/dsl/KotlinLambda;", "Lcom/intellij/debugger/streams/core/trace/dsl/Lambda;", "variableName", "", "body", "Lcom/intellij/debugger/streams/core/trace/dsl/CodeBlock;", "<init>", "(Ljava/lang/String;Lcom/intellij/debugger/streams/core/trace/dsl/CodeBlock;)V", "getVariableName", "()Ljava/lang/String;", "getBody", "()Lcom/intellij/debugger/streams/core/trace/dsl/CodeBlock;", "call", "Lcom/intellij/debugger/streams/core/trace/dsl/Expression;", "callName", "args", "", "(Ljava/lang/String;[Lcom/intellij/debugger/streams/core/trace/dsl/Expression;)Lcom/intellij/debugger/streams/core/trace/dsl/Expression;", "toCode", "indent", "", "kotlin.jvm-debugger.sequence.k1"})
public final class KotlinLambda
implements Lambda {
    @NotNull
    private final String variableName;
    @NotNull
    private final CodeBlock body;

    public KotlinLambda(@NotNull String variableName, @NotNull CodeBlock body2) {
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        this.variableName = variableName;
        this.body = body2;
    }

    @NotNull
    public String getVariableName() {
        return this.variableName;
    }

    @NotNull
    public CodeBlock getBody() {
        return this.body;
    }

    @NotNull
    public Expression call(@NotNull String callName, Expression ... args) {
        Intrinsics.checkNotNullParameter((Object)callName, (String)"callName");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return new TextExpression("(" + Convertable.toCode$default((Convertable)((Convertable)this), (int)0, (int)1, null) + ")").call(callName, Arrays.copyOf(args, args.length));
    }

    @NotNull
    public String toCode(int indent) {
        return this.withIndent("{ " + this.getVariableName() + " ->\n", indent) + this.getBody().toCode(indent + 1) + "}";
    }
}

