/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.sequence.trace.impl.interpret;

import com.intellij.debugger.streams.core.trace.ArrayReference;
import com.intellij.debugger.streams.core.trace.BooleanValue;
import com.intellij.debugger.streams.core.trace.CallTraceInterpreter;
import com.intellij.debugger.streams.core.trace.IntegerValue;
import com.intellij.debugger.streams.core.trace.TraceElement;
import com.intellij.debugger.streams.core.trace.TraceInfo;
import com.intellij.debugger.streams.core.trace.Value;
import com.intellij.debugger.streams.core.trace.impl.TraceElementImpl;
import com.intellij.debugger.streams.core.trace.impl.interpret.ValuesOrderInfo;
import com.intellij.debugger.streams.core.trace.impl.interpret.ex.UnexpectedValueTypeException;
import com.intellij.debugger.streams.core.wrapper.StreamCall;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.sequence.trace.impl.interpret.InterpreterUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J0\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u001c\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/trace/impl/interpret/FilterTraceInterpreter;", "Lcom/intellij/debugger/streams/core/trace/CallTraceInterpreter;", "predicateValueToAccept", "", "<init>", "(Z)V", "resolve", "Lcom/intellij/debugger/streams/core/trace/TraceInfo;", "call", "Lcom/intellij/debugger/streams/core/wrapper/StreamCall;", "value", "Lcom/intellij/debugger/streams/core/trace/Value;", "resolveValuesBefore", "", "", "Lcom/intellij/debugger/streams/core/trace/TraceElement;", "map", "resolveValuesAfter", "before", "filteringMap", "extractPredicateValues", "kotlin.jvm-debugger.sequence.k1"})
public final class FilterTraceInterpreter
implements CallTraceInterpreter {
    private final boolean predicateValueToAccept;

    public FilterTraceInterpreter(boolean predicateValueToAccept) {
        this.predicateValueToAccept = predicateValueToAccept;
    }

    @NotNull
    public TraceInfo resolve(@NotNull StreamCall call, @NotNull Value value) {
        Value filteringMap;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(value instanceof ArrayReference)) {
            throw new UnexpectedValueTypeException("array reference excepted, but actual: " + value.typeName());
        }
        Value value2 = ((ArrayReference)value).getValue(0);
        Intrinsics.checkNotNull((Object)value2);
        Map<Integer, TraceElement> before = this.resolveValuesBefore(value2);
        Value value3 = filteringMap = ((ArrayReference)value).getValue(1);
        Intrinsics.checkNotNull((Object)value3);
        Map<Integer, TraceElement> after = this.resolveValuesAfter(before, value3);
        return (TraceInfo)new ValuesOrderInfo(call, before, after);
    }

    private final Map<Integer, TraceElement> resolveValuesBefore(Value map2) {
        InterpreterUtil.MapRepresentation mapRepresentation = InterpreterUtil.INSTANCE.extractMap(map2);
        ArrayReference keys = mapRepresentation.component1();
        ArrayReference objects = mapRepresentation.component2();
        List result2 = new ArrayList();
        int n = keys.length();
        for (int i2 = 0; i2 < n; ++i2) {
            Value time = keys.getValue(i2);
            Value value = objects.getValue(i2);
            if (!(time instanceof IntegerValue)) {
                throw new UnexpectedValueTypeException("time should be represented by integer value");
            }
            result2.add(new TraceElementImpl(((IntegerValue)time).value(), value));
        }
        return InterpreterUtil.INSTANCE.createIndexByTime(result2);
    }

    private final Map<Integer, TraceElement> resolveValuesAfter(Map<Integer, ? extends TraceElement> before, Value filteringMap) {
        Map<Integer, Boolean> predicateValues = this.extractPredicateValues(filteringMap);
        LinkedHashMap result2 = new LinkedHashMap();
        for (Map.Entry<Integer, ? extends TraceElement> entry : before.entrySet()) {
            int beforeTime = ((Number)entry.getKey()).intValue();
            TraceElement element = entry.getValue();
            Boolean predicateValue = predicateValues.get(beforeTime);
            if (!Intrinsics.areEqual((Object)predicateValue, (Object)this.predicateValueToAccept)) continue;
            ((Map)result2).put(beforeTime + 1, new TraceElementImpl(beforeTime + 1, element.getValue()));
        }
        return result2;
    }

    private final Map<Integer, Boolean> extractPredicateValues(Value filteringMap) {
        InterpreterUtil.MapRepresentation mapRepresentation = InterpreterUtil.INSTANCE.extractMap(filteringMap);
        ArrayReference keys = mapRepresentation.component1();
        ArrayReference values2 = mapRepresentation.component2();
        Map result2 = new LinkedHashMap();
        int n = keys.length();
        for (int i2 = 0; i2 < n; ++i2) {
            Value time = keys.getValue(i2);
            Value value = values2.getValue(i2);
            if (!(time instanceof IntegerValue)) {
                throw new UnexpectedValueTypeException("time should be represented by integer value");
            }
            if (!(value instanceof BooleanValue)) {
                throw new UnexpectedValueTypeException("predicate value should be represented by boolean value");
            }
            result2.put(((IntegerValue)time).value(), ((BooleanValue)value).value());
        }
        return result2;
    }
}

