/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.NamedMethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Range;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.idea.debugger.base.util.AnalyseUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.CallableMemberInfo;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodFilterKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.PsiUtilsKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\r\u001a\u00020\u0006H\u0016J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0014\u0010\u001c\u001a\u00020\u000f*\u00020\u001f2\u0006\u0010 \u001a\u00020\u001eH\u0002J\u0010\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u001a\u0010$\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinMethodFilter;", "Lcom/intellij/debugger/engine/NamedMethodFilter;", "element", "Lcom/intellij/psi/PsiElement;", "lines", "Lcom/intellij/util/Range;", "", "methodInfo", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/CallableMemberInfo;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/Range;Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/CallableMemberInfo;)V", "elementPtr", "Lcom/intellij/psi/SmartPsiElementPointer;", "getSkipCount", "locationMatches", "", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "onReached", "context", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "hint", "Lcom/intellij/debugger/engine/RequestHint;", "isIntrinsicEqualsMatch", "declarationMatches", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "currentDeclaration", "getCallingExpressionLines", "getMethodName", "", "nameMatches", "intellij.kotlin.jvm.debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinMethodFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMethodFilter.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinMethodFilter\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,203:1\n540#2:204\n525#2,6:205\n193#3,3:211\n*S KotlinDebug\n*F\n+ 1 KotlinMethodFilter.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinMethodFilter\n*L\n136#1:204\n136#1:205,6\n137#1:211,3\n*E\n"})
public class KotlinMethodFilter
implements NamedMethodFilter {
    @Nullable
    private final Range<Integer> lines;
    @NotNull
    private final CallableMemberInfo methodInfo;
    @Nullable
    private final SmartPsiElementPointer<PsiElement> elementPtr;

    public KotlinMethodFilter(@Nullable PsiElement element, @Nullable Range<Integer> lines, @NotNull CallableMemberInfo methodInfo) {
        Intrinsics.checkNotNullParameter((Object)methodInfo, (String)"methodInfo");
        this.lines = lines;
        this.methodInfo = methodInfo;
        PsiElement psiElement = element;
        this.elementPtr = psiElement != null ? SmartPointersKt.createSmartPointer((PsiElement)psiElement) : null;
    }

    public int getSkipCount() {
        return this.methodInfo.getOrdinal();
    }

    public boolean locationMatches(@NotNull DebugProcessImpl process2, @NotNull Location location, @Nullable StackFrameProxyImpl frameProxy) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        if (this.isIntrinsicEqualsMatch(location)) {
            return true;
        }
        if (!this.nameMatches(location, frameProxy)) {
            return false;
        }
        Object object = ReadAction.nonBlocking(() -> KotlinMethodFilter.locationMatches$lambda$0(this, process2, location)).executeSynchronously();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executeSynchronously(...)");
        return (Boolean)object;
    }

    public int onReached(@NotNull SuspendContextImpl context2, @NotNull RequestHint hint2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)hint2, (String)"hint");
        Location location = context2.getLocation();
        if (location != null && this.isIntrinsicEqualsMatch(location)) {
            return 1;
        }
        return super.onReached(context2, hint2);
    }

    public boolean locationMatches(@NotNull DebugProcessImpl process2, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return this.locationMatches(process2, location, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isIntrinsicEqualsMatch(Location location) {
        if (!Intrinsics.areEqual((Object)this.methodInfo.getName(), (Object)"equals")) return false;
        Method method = SafeUtilKt.safeMethod(location);
        if (method == null) return false;
        if (!KotlinMethodFilterKt.access$isIntrinsicEquals(method)) return false;
        return true;
    }

    public final boolean declarationMatches(@NotNull DebugProcessImpl process2, @NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        CompoundPositionManager compoundPositionManager = process2.getPositionManager();
        Intrinsics.checkNotNullExpressionValue((Object)compoundPositionManager, (String)"getPositionManager(...)");
        KtDeclaration ktDeclaration = KotlinMethodFilterKt.getCurrentDeclaration((PositionManager)compoundPositionManager, location);
        if (ktDeclaration == null) {
            return false;
        }
        KtDeclaration currentDeclaration = ktDeclaration;
        return AnalyseUtilsKt.runDumbAnalyze((KtElement)currentDeclaration, true, arg_0 -> KotlinMethodFilter.declarationMatches$lambda$0(this, currentDeclaration, arg_0));
    }

    public final boolean declarationMatches(@NotNull KtDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return AnalyseUtilsKt.runDumbAnalyze((KtElement)declaration, true, arg_0 -> KotlinMethodFilter.declarationMatches$lambda$1(this, declaration, arg_0));
    }

    private final boolean declarationMatches(KaSession $this$declarationMatches, KtDeclaration currentDeclaration) {
        KaDeclarationSymbol currentSymbol = $this$declarationMatches.getSymbol(currentDeclaration);
        if (!(currentSymbol instanceof KaCallableSymbol) && !(currentSymbol instanceof KaClassSymbol)) {
            return false;
        }
        if (this.methodInfo.isInvoke()) {
            return true;
        }
        PsiElement psiElement = this.elementPtr;
        if (psiElement == null || (psiElement = psiElement.getElement()) == null) {
            return true;
        }
        PsiElement element = psiElement;
        if (!(element instanceof KtDeclaration)) {
            return false;
        }
        if (PsiUtilsKt.areElementsEquivalent((KtDeclaration)element, currentDeclaration)) {
            return true;
        }
        if (!(currentSymbol instanceof KaCallableSymbol)) {
            return false;
        }
        for (KaCallableSymbol overriddenSymbol : $this$declarationMatches.getAllOverriddenSymbols((KaCallableSymbol)currentSymbol)) {
            KtDeclaration overriddenDeclaration;
            PsiElement psiElement2 = overriddenSymbol.getPsi();
            KtDeclaration ktDeclaration = psiElement2 instanceof KtDeclaration ? (KtDeclaration)psiElement2 : null;
            if (ktDeclaration == null || !PsiUtilsKt.areElementsEquivalent((KtDeclaration)element, overriddenDeclaration = ktDeclaration)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return this.lines;
    }

    @NotNull
    public String getMethodName() {
        return this.methodInfo.getName();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean nameMatches(Location location, StackFrameProxyImpl frameProxy) {
        boolean bl;
        void $this$any$iv;
        void $this$filterTo$iv$iv;
        Map $this$filter$iv;
        Method method = SafeUtilKt.safeMethod(location);
        if (method == null) {
            return false;
        }
        Method method2 = method;
        String targetMethodName = this.getMethodName();
        String string = method2.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        String actualMethodName = DebuggerUtils.INSTANCE.trimMethodNameMangling(string);
        boolean isGeneratedLambda = DebuggerUtils.INSTANCE.isGeneratedIrBackendLambdaMethodName(actualMethodName);
        if (Intrinsics.areEqual((Object)actualMethodName, (Object)targetMethodName)) return true;
        if (Intrinsics.areEqual((Object)actualMethodName, (Object)(targetMethodName + "$default"))) return true;
        if (isGeneratedLambda) {
            if (Intrinsics.areEqual((Object)KotlinMethodFilterKt.access$getMethodNameInCallerFrame(frameProxy), (Object)targetMethodName)) return true;
        }
        Map<LocalVariable, ClosedRange<Location>> map2 = DebuggerUtil.getInlineFunctionAndArgumentVariablesToBordersMap(method2);
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator3 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator3.next();
            boolean bl2 = false;
            if (!((ClosedRange)it.getValue()).contains((Comparable)location)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$any = false;
        if ($this$any$iv.isEmpty()) {
            bl = false;
        } else {
            iterator2 = $this$any$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator2.next();
                boolean bl3 = false;
                if (!KotlinMethodFilterKt.access$isInlinedFromFunction((LocalVariable)it.getKey(), this.methodInfo)) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        if (isGeneratedLambda) return false;
        if (!KotlinMethodFilterKt.methodNameMatches(this.methodInfo, actualMethodName)) return false;
        return true;
    }

    private static final Boolean locationMatches$lambda$0(KotlinMethodFilter this$0, DebugProcessImpl $process, Location $location) {
        return this$0.declarationMatches($process, $location);
    }

    private static final boolean declarationMatches$lambda$0(KotlinMethodFilter this$0, KtDeclaration $currentDeclaration, KaSession $this$runDumbAnalyze) {
        Intrinsics.checkNotNullParameter((Object)$this$runDumbAnalyze, (String)"$this$runDumbAnalyze");
        return this$0.declarationMatches($this$runDumbAnalyze, $currentDeclaration);
    }

    private static final boolean declarationMatches$lambda$1(KotlinMethodFilter this$0, KtDeclaration $declaration, KaSession $this$runDumbAnalyze) {
        Intrinsics.checkNotNullParameter((Object)$this$runDumbAnalyze, (String)"$this$runDumbAnalyze");
        return this$0.declarationMatches($this$runDumbAnalyze, $declaration);
    }
}

