/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.psi.PsiElement;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineScopeUtilsKt;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.JvmNameUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtils;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.CallableMemberInfo;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinSmartStepTargetFiltererKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0018\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0014\u0010\u000e\u001a\u00020\u0001*\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0014\u0010\u0010\u001a\u0004\u0018\u00010\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u00a8\u0006\u0013"}, d2={"isIntrinsicEquals", "", "Lcom/sun/jdi/Method;", "getCurrentDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "positionManager", "Lcom/intellij/debugger/PositionManager;", "location", "Lcom/sun/jdi/Location;", "methodNameMatches", "methodInfo", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/CallableMemberInfo;", "name", "", "isInlinedFromFunction", "Lcom/sun/jdi/LocalVariable;", "getMethodNameInCallerFrame", "frameProxy", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "intellij.kotlin.jvm.debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinMethodFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMethodFilter.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinMethodFilterKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,203:1\n777#2:204\n873#2,2:205\n296#2,2:207\n296#2,2:209\n*S KotlinDebug\n*F\n+ 1 KotlinMethodFilter.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinMethodFilterKt\n*L\n157#1:204\n157#1:205,2\n163#1:207,2\n165#1:209,2\n*E\n"})
public final class KotlinMethodFilterKt {
    private static final boolean isIntrinsicEquals(Method $this$isIntrinsicEquals) {
        String string = $this$isIntrinsicEquals.declaringType().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        String string2 = JvmNameUtilsKt.fqnToInternalName(string);
        String string3 = $this$isIntrinsicEquals.name();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name(...)");
        String string4 = $this$isIntrinsicEquals.signature();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"signature(...)");
        return KotlinSmartStepTargetFiltererKt.isIntrinsicEquals(string2, string3, string4);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final KtDeclaration getCurrentDeclaration(@NotNull PositionManager positionManager, @NotNull Location location) {
        Class[] classArray;
        Intrinsics.checkNotNullParameter((Object)positionManager, (String)"positionManager");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        SourcePosition sourcePosition = positionManager.getSourcePosition(location);
        Object elementAt = sourcePosition != null ? sourcePosition.getElementAt() : null;
        PsiElement psiElement = elementAt;
        if (psiElement == null || (psiElement = (KtDeclaration)PsiUtilsKt.getParentOfTypesAndPredicate((PsiElement)psiElement, (boolean)false, (Class[])(classArray = new Class[]{KtDeclaration.class}), KotlinMethodFilterKt::getCurrentDeclaration$lambda$0)) == null) {
            return null;
        }
        PsiElement declaration = psiElement;
        if (declaration instanceof KtProperty) {
            void $this$filterTo$iv$iv;
            int currentLine = DebuggerUtilsEx.getLineNumber((Location)location, (boolean)true);
            List list2 = ((KtProperty)declaration).getAccessors();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAccessors(...)");
            Iterable $this$filter$iv = list2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtPropertyAccessor it = (KtPropertyAccessor)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!(PsiLinesUtilsKt.getLineNumber$default((PsiElement)it, false, 1, null) == currentLine)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List accessorsOnLine = (List)destination$iv$iv;
            if (!((Collection)accessorsOnLine).isEmpty()) {
                String methodName;
                if (accessorsOnLine.size() == 1) {
                    return (KtDeclaration)CollectionsKt.single((List)accessorsOnLine);
                }
                Method method = SafeUtilKt.safeMethod(location);
                String string = methodName = method != null ? method.name() : null;
                if (methodName != null) {
                    KtDeclaration ktDeclaration;
                    if (JvmAbi.isSetterName((String)methodName)) {
                        Object v5;
                        block10: {
                            Iterable $this$firstOrNull$iv = accessorsOnLine;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                it = (KtPropertyAccessor)element$iv;
                                boolean bl = false;
                                if (!it.isSetter()) continue;
                                v5 = element$iv;
                                break block10;
                            }
                            v5 = null;
                        }
                        ktDeclaration = v5;
                    } else {
                        Object v7;
                        block11: {
                            Iterable $this$firstOrNull$iv = accessorsOnLine;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv : $this$firstOrNull$iv) {
                                it = (KtPropertyAccessor)element$iv;
                                boolean bl = false;
                                if (!it.isGetter()) continue;
                                v7 = element$iv;
                                break block11;
                            }
                            v7 = null;
                        }
                        ktDeclaration = v7;
                    }
                    return ktDeclaration;
                }
            }
        }
        return declaration;
    }

    public static final boolean methodNameMatches(@NotNull CallableMemberInfo methodInfo, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)methodInfo, (String)"methodInfo");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (Intrinsics.areEqual((Object)methodInfo.getName(), (Object)name2)) {
            return true;
        }
        if (methodInfo.isInternalMethod() || methodInfo.isLocal()) {
            return DebuggerUtil.nameMatchesUpToDollar(name2, methodInfo.getName());
        }
        return false;
    }

    private static final boolean isInlinedFromFunction(LocalVariable $this$isInlinedFromFunction, CallableMemberInfo methodInfo) {
        boolean bl;
        String string = $this$isInlinedFromFunction.name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        String variableName = DebuggerUtils.INSTANCE.trimMethodNameMangling(InlineScopeUtilsKt.dropInlineScopeInfo((String)string));
        if (DebuggerUtil.isInlineFunctionMarkerVariableName(variableName)) {
            String inlineMethodName = StringsKt.substringAfter$default((String)variableName, (String)"$i$f$", null, (int)2, null);
            bl = KotlinMethodFilterKt.methodNameMatches(methodInfo, inlineMethodName);
        } else {
            bl = DebuggerUtil.isInlineLambdaMarkerVariableName(variableName) ? methodInfo.isInvoke() : false;
        }
        return bl;
    }

    private static final String getMethodNameInCallerFrame(StackFrameProxyImpl frameProxy) {
        StackFrameProxyImpl stackFrameProxyImpl = frameProxy;
        if (stackFrameProxyImpl == null || (stackFrameProxyImpl = stackFrameProxyImpl.threadProxy()) == null) {
            return null;
        }
        StackFrameProxyImpl threadProxy = stackFrameProxyImpl;
        int callerFrameIndex = frameProxy.getFrameIndex() + 1;
        if (callerFrameIndex >= threadProxy.frameCount()) {
            return null;
        }
        StackFrameProxyImpl callerFrame = threadProxy.frame(callerFrameIndex);
        Object object = callerFrame;
        return object != null && (object = SafeUtilKt.safeLocation((StackFrameProxy)object)) != null && (object = SafeUtilKt.safeMethod((Location)object)) != null ? object.name() : null;
    }

    private static final boolean getCurrentDeclaration$lambda$0(KtDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (!(it instanceof KtProperty) || !((KtProperty)it).isLocal()) && !(it instanceof KtDestructuringDeclaration);
    }

    public static final /* synthetic */ boolean access$isIntrinsicEquals(Method $receiver) {
        return KotlinMethodFilterKt.isIntrinsicEquals($receiver);
    }

    public static final /* synthetic */ String access$getMethodNameInCallerFrame(StackFrameProxyImpl frameProxy) {
        return KotlinMethodFilterKt.getMethodNameInCallerFrame(frameProxy);
    }

    public static final /* synthetic */ boolean access$isInlinedFromFunction(LocalVariable $receiver, CallableMemberInfo methodInfo) {
        return KotlinMethodFilterKt.isInlinedFromFunction($receiver, methodInfo);
    }
}

