/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.engine.MethodFilter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Range;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.debugger.base.util.AnalyseUtilsKt;
import org.jetbrains.kotlin.idea.debugger.core.JvmNameUtilKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.CallableMemberInfo;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodReferenceFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodSmartStepTargetKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinSmartStepTarget;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\bH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinMethodReferenceSmartStepTarget;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinSmartStepTarget;", "lines", "Lcom/intellij/util/Range;", "", "highlightElement", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "label", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "methodInfo", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/CallableMemberInfo;", "<init>", "(Lcom/intellij/util/Range;Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;Ljava/lang/String;Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/CallableMemberInfo;)V", "declarationPtr", "Lcom/intellij/psi/SmartPsiElementPointer;", "createMethodFilter", "Lcom/intellij/debugger/engine/MethodFilter;", "getIcon", "Ljavax/swing/Icon;", "getClassName", "intellij.kotlin.jvm.debugger.core"})
public final class KotlinMethodReferenceSmartStepTarget
extends KotlinSmartStepTarget {
    @NotNull
    private final CallableMemberInfo methodInfo;
    @NotNull
    private final SmartPsiElementPointer<KtDeclarationWithBody> declarationPtr;

    public KotlinMethodReferenceSmartStepTarget(@NotNull Range<Integer> lines, @NotNull KtCallableReferenceExpression highlightElement, @NotNull String label2, @NotNull KtDeclarationWithBody declaration, @NotNull CallableMemberInfo methodInfo) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)highlightElement, (String)"highlightElement");
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)methodInfo, (String)"methodInfo");
        super(label2, (PsiElement)highlightElement, true, lines);
        this.methodInfo = methodInfo;
        this.declarationPtr = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)declaration));
    }

    @Override
    @NotNull
    public MethodFilter createMethodFilter() {
        KtDeclarationWithBody declaration = KotlinMethodSmartStepTargetKt.getElementInReadAction(this.declarationPtr);
        return (MethodFilter)new KotlinMethodReferenceFilter(declaration, (Range<Integer>)this.getCallingExpressionLines(), this.methodInfo);
    }

    @Nullable
    public Icon getIcon() {
        return KotlinIcons.FUNCTION;
    }

    @Nullable
    public String getClassName() {
        KtDeclarationWithBody ktDeclarationWithBody = KotlinMethodSmartStepTargetKt.getElementInReadAction(this.declarationPtr);
        if (ktDeclarationWithBody == null) {
            return null;
        }
        KtDeclarationWithBody declaration = ktDeclarationWithBody;
        return AnalyseUtilsKt.runDumbAnalyze((KtElement)declaration, null, arg_0 -> KotlinMethodReferenceSmartStepTarget.getClassName$lambda$0(declaration, arg_0));
    }

    private static final String getClassName$lambda$0(KtDeclarationWithBody $declaration, KaSession $this$runDumbAnalyze) {
        Intrinsics.checkNotNullParameter((Object)$this$runDumbAnalyze, (String)"$this$runDumbAnalyze");
        return JvmNameUtilKt.getClassName($this$runDumbAnalyze, (KtDeclaration)$declaration);
    }
}

