/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorFileSwapper;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtDecompiledFile;
import org.jetbrains.kotlin.psi.KotlinDeclarationNavigationPolicy;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u000eH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinEditorFileSwapper;", "Lcom/intellij/openapi/fileEditor/impl/EditorFileSwapper;", "<init>", "()V", "getFileToSwapTo", "Lkotlin/Pair;", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "project", "Lcom/intellij/openapi/project/Project;", "composite", "Lcom/intellij/openapi/fileEditor/impl/EditorComposite;", "getSourcesLocation", "psiFile", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/file/KtDecompiledFile;", "getCursorPosition", "originalOffset", "decompiledFile", "intellij.kotlin.ide"})
@SourceDebugExtension(value={"SMAP\nKotlinEditorFileSwapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinEditorFileSwapper.kt\norg/jetbrains/kotlin/idea/editor/KotlinEditorFileSwapper\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,63:1\n50#2:64\n50#2:65\n*S KotlinDebug\n*F\n+ 1 KotlinEditorFileSwapper.kt\norg/jetbrains/kotlin/idea/editor/KotlinEditorFileSwapper\n*L\n37#1:64\n52#1:65\n*E\n"})
public final class KotlinEditorFileSwapper
implements EditorFileSwapper {
    @Nullable
    public Pair<VirtualFile, Integer> getFileToSwapTo(@NotNull Project project, @NotNull EditorComposite composite) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)composite, (String)"composite");
        VirtualFile file = composite.getFile();
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        if (!(psiFile2 instanceof KtDecompiledFile)) {
            return null;
        }
        VirtualFile virtualFile = this.getSourcesLocation((KtDecompiledFile)psiFile2);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile location = virtualFile;
        TextEditorImpl oldEditor = EditorFileSwapper.findSinglePsiAwareEditor((List)composite.getAllEditors());
        if (oldEditor != null) {
            int offset = oldEditor.getEditor().getCaretModel().getOffset();
            offset = this.getCursorPosition(offset, (KtDecompiledFile)psiFile2);
            pair = new Pair((Object)location, (Object)offset);
        } else {
            pair = new Pair((Object)location, (Object)0);
        }
        return pair;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final VirtualFile getSourcesLocation(KtDecompiledFile psiFile) {
        KtDeclaration ktDeclaration = (KtDeclaration)CollectionsKt.firstOrNull((List)psiFile.getDeclarations());
        if (ktDeclaration == null) return null;
        KtDeclaration it = ktDeclaration;
        boolean bl = false;
        boolean $i$f$serviceOrNull = false;
        Application application = ApplicationManager.getApplication();
        KotlinDeclarationNavigationPolicy kotlinDeclarationNavigationPolicy = (KotlinDeclarationNavigationPolicy)(application != null ? application.getService(KotlinDeclarationNavigationPolicy.class) : null);
        KotlinDeclarationNavigationPolicy kotlinDeclarationNavigationPolicy2 = kotlinDeclarationNavigationPolicy;
        if (kotlinDeclarationNavigationPolicy == null) return null;
        if ((kotlinDeclarationNavigationPolicy2 = kotlinDeclarationNavigationPolicy2.getNavigationElement(it)) == null) {
            return null;
        }
        KotlinDeclarationNavigationPolicy element = kotlinDeclarationNavigationPolicy2;
        if (Intrinsics.areEqual((Object)it, (Object)element)) return null;
        PsiFile sourceFile = element.getContainingFile();
        if (!sourceFile.isValid()) return null;
        return sourceFile.getVirtualFile();
    }

    private final int getCursorPosition(int originalOffset, KtDecompiledFile decompiledFile) {
        KtElement declarationInSources;
        KtDeclaration declaration;
        PsiElement psiElement = decompiledFile.getNavigationElement().findElementAt(originalOffset);
        if (psiElement == null) {
            return 0;
        }
        PsiElement cursor = psiElement;
        KtDeclaration ktDeclaration = declaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)cursor, KtDeclaration.class, (boolean)false);
        if (ktDeclaration != null) {
            KtDeclaration it = ktDeclaration;
            boolean bl = false;
            boolean $i$f$serviceOrNull = false;
            Application application = ApplicationManager.getApplication();
            KotlinDeclarationNavigationPolicy kotlinDeclarationNavigationPolicy = (KotlinDeclarationNavigationPolicy)(application != null ? application.getService(KotlinDeclarationNavigationPolicy.class) : null);
            v4 = kotlinDeclarationNavigationPolicy != null ? kotlinDeclarationNavigationPolicy.getNavigationElement(it) : null;
        } else {
            v4 = declarationInSources = null;
        }
        if (declaration != null && declarationInSources != null && declaration instanceof PsiNameIdentifierOwner) {
            PsiElement psiElement2 = ((PsiNameIdentifierOwner)declaration).getNameIdentifier();
            boolean bl = psiElement2 != null && (psiElement2 = psiElement2.getTextRange()) != null ? psiElement2.getEndOffset() == originalOffset : false;
            if (bl && declarationInSources instanceof PsiNameIdentifierOwner) {
                PsiElement psiElement3 = ((PsiNameIdentifierOwner)declaration).getNameIdentifier();
                return ((PsiElement)declarationInSources).getTextOffset() + (psiElement3 != null ? psiElement3.getTextLength() : 0);
            }
        }
        KtElement ktElement = declarationInSources;
        return ktElement != null ? ktElement.getTextOffset() : 0;
    }
}

